/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.TutoringService.RequestHandler;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Monitor
extends Thread
implements ExitableServer {
    public static final int MONITOR_PORT = 1503;
    public static final long TIMEOUT = 60000L;
    static final DateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    public static ArrayList<Socket> monitorList = new ArrayList();
    static XMLOutputter outputter;
    private static final String REMOTE_HOST = "127.0.0.1";
    private HashMap<String, RequestHandler> requestHandlers = new HashMap();
    private int commPort = 1503;
    ServerSocket commSocket = null;
    private volatile boolean nowExiting = false;

    public Monitor(int commPort) {
        this.debug("Monitor (int,LauncherServer)");
        this.commPort = commPort;
    }

    private void debug(String aMessage) {
        CTATBase.debug("Monitor", aMessage);
    }

    @Override
    public void run() {
        this.debug("run ()");
        try {
            this.commSocket = new ServerSocket();
            this.commSocket.setReuseAddress(true);
            InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName("0.0.0.0"), this.commPort);
            this.commSocket.bind(sa);
            while (!this.nowExiting) {
                try {
                    Socket cs = this.commSocket.accept();
                    MonitorRequestConsumer ctc = new MonitorRequestConsumer(cs);
                    ctc.start();
                }
                catch (SocketException se) {
                    if (trace.getDebugCode("ls")) {
                        trace.out("ls", "run(): nowExiting " + this.nowExiting + "; accept() threw " + se + ", cause " + se.getCause());
                    }
                    se.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SocketException se) {
            se.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addRequestHandler(String name, RequestHandler handler) {
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "Monitor.addRequestHandler(" + name + ", " + handler + ")");
        }
        this.requestHandlers.put(name, handler);
    }

    public static String request(String msg) throws Exception {
        return Monitor.request(msg, 1503, 0L);
    }

    public static String request(String msg, int port, long delayAfterResponse) throws Exception {
        return Monitor.request(msg, REMOTE_HOST, port, delayAfterResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String msg, String remoteHost, int port, long delayAfterResponse) throws Exception {
        String response = null;
        try {
            SocketReader socketReader;
            Socket sock = new Socket();
            InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName(remoteHost), port);
            sock.connect(sa, 2000);
            SocketReader socketReader2 = socketReader = new SocketReader(sock);
            synchronized (socketReader2) {
                socketReader.start();
                while (socketReader.getInputStream() == null) {
                    try {
                        socketReader.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            PrintStream ps = new PrintStream(sock.getOutputStream());
            ps.print(msg);
            ps.print('\u0000');
            ps.flush();
            if (trace.getDebugCode("monitor")) {
                trace.out("monitor", "request() sent to port " + port + ": " + msg);
            }
            long now = System.currentTimeMillis();
            long then = now + 60000L;
            while (now < then) {
                try {
                    socketReader.join(then - now);
                    now = System.currentTimeMillis();
                    if (then > now) break;
                    trace.err("Monitor.request(\"" + msg + "\") timeout awaiting response " + 60000L + " ms");
                    break;
                }
                catch (InterruptedException ie) {
                    if (trace.getDebugCode("monitor")) {
                        trace.out("monitor", "request() exception awaiting reader quit: " + ie + "; cause " + ie.getCause());
                    }
                    now = System.currentTimeMillis();
                }
            }
            response = socketReader.getResponse();
            if (trace.getDebugCode("monitor")) {
                trace.out("monitor", "request() delay " + delayAfterResponse + ", received: " + response);
            }
            if (delayAfterResponse > 0L) {
                Utils.sleep(delayAfterResponse);
            }
        }
        catch (IOException ioe) {
            throw new Exception("Error trying to send \"" + msg + "\" to monitor port " + port, ioe);
        }
        return response;
    }

    @Override
    public synchronized boolean isExiting() {
        return this.nowExiting;
    }

    @Override
    public synchronized boolean startExiting() {
        boolean result = this.nowExiting;
        this.nowExiting = true;
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "Monitor.startExiting() previous nowExiting " + result + ", server socket to close " + this.commSocket);
        }
        try {
            this.commSocket.close();
            this.commSocket = null;
        }
        catch (Exception e) {
            trace.errStack("LauncherServer.startExiting() error closing server socket " + e + ";\n  cause " + e.getCause(), e);
        }
        return result;
    }

    public static void main(String[] args) {
        String remoteHost = REMOTE_HOST;
        int port = 1503;
        long timeToWait = 0L;
        int i = 0;
        block13: for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            char option = args[i].charAt(1);
            switch (option) {
                case 'H': 
                case 'h': {
                    try {
                        if (++i >= args.length) {
                            throw new IllegalArgumentException("missing host name");
                        }
                        InetAddress.getByName(args[i]);
                        remoteHost = args[i];
                    }
                    catch (Exception e) {
                        Monitor.usageExit("Error on -h option: " + (e.getMessage() == null ? "bad hostname" : e.getMessage()) + ".");
                    }
                    continue block13;
                }
                case 'P': 
                case 'p': {
                    try {
                        if (++i >= args.length) {
                            throw new IllegalArgumentException("missing port number");
                        }
                        port = Integer.parseInt(args[i]);
                    }
                    catch (Exception e) {
                        Monitor.usageExit("Error on -p option: " + (e.getMessage() == null ? "bad number" : e.getMessage()) + ".");
                    }
                    continue block13;
                }
                case 'T': 
                case 't': {
                    try {
                        if (++i >= args.length) {
                            throw new IllegalArgumentException("missing time");
                        }
                        timeToWait = Long.parseLong(args[i]);
                    }
                    catch (Exception e) {
                        Monitor.usageExit("Error on -t option: " + (e.getMessage() == null ? "bad number" : e.getMessage()) + ".");
                    }
                    continue block13;
                }
                default: {
                    Monitor.usageExit("Unknown option -" + option + ".");
                }
            }
        }
        if (i >= args.length) {
            Monitor.usageExit("Missing request (e.g. \"<service cmd=\"shutdown\"/>\").");
        }
        String req = args[i];
        try {
            String resp = Monitor.request(args[i], remoteHost, port, timeToWait);
            System.out.printf("%8s: %s\n%8s: %s\n%8s: %s\n", "sent", req, "received", resp, "time", new Date());
            System.exit(0);
        }
        catch (Exception e) {
            trace.errStack(e.getMessage() + "; cause: " + e.getCause(), e);
            System.exit(1);
        }
    }

    private static int usageExit(String errMsg) {
        String clsName = new Monitor(-1).getClass().getName();
        if (errMsg != null) {
            System.out.printf("%s ", errMsg);
        }
        System.out.println("Usage:\n  java -cp ... " + clsName + " [-h host] [-p port] [-t timeToWait] request\nwhere--\n  host       is the Tutoring Service host to connect to (default " + REMOTE_HOST + ");\n  port       is the port to send to (default " + 1503 + ");\n  timeToWait is the delay to wait after the response, in ms (default " + 0 + ");\n  request    is the XML request to send (e.g. \"<service cmd=\"shutdown\"/>\").\n");
        System.exit(2);
        return 2;
    }

    static {
        dateFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        outputter = new XMLOutputter(Format.getCompactFormat().setOmitDeclaration(true).setLineSeparator("\r\n").setIndent("  "));
    }

    static class SocketReader
    extends Thread {
        Socket sock;
        BufferedInputStream inputStream = null;
        String response;

        SocketReader(Socket sock) {
            this.sock = sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuilder sb = new StringBuilder();
            try {
                int c;
                SocketReader socketReader = this;
                synchronized (socketReader) {
                    this.inputStream = new BufferedInputStream(this.sock.getInputStream());
                    this.notify();
                }
                while ((c = this.inputStream.read()) > 0) {
                    sb.append((char)c);
                }
            }
            catch (IOException ioe) {
                trace.errStack("Error receiving monitor response \"" + sb + "\" from socket " + this.sock, ioe);
            }
            finally {
                this.response = sb.toString();
                try {
                    this.sock.close();
                }
                catch (Exception exception) {}
            }
        }

        String getResponse() {
            return this.response;
        }

        synchronized InputStream getInputStream() {
            return this.inputStream;
        }
    }

    private class MonitorRequestConsumer
    extends Thread {
        private Socket cSock;

        public MonitorRequestConsumer(Socket sock) {
            this.debug("MonitorRequestConsumer (Socket)");
            this.cSock = sock;
        }

        private void debug(String aMessage) {
            CTATBase.debug("MonitorRequestConsumer", aMessage);
        }

        @Override
        public void run() {
            this.debug("run ()");
            try {
                boolean keepalive = this.handleRequest(this.cSock);
                if (!keepalive) {
                    this.cSock.close();
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe.getStackTrace());
                try {
                    if (this.cSock != null) {
                        this.cSock.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleRequest(Socket cSock) {
            this.debug("handleRequest (" + cSock + ")");
            boolean keepalive = false;
            BufferedReader in = null;
            PrintWriter out = null;
            Element root = null;
            Element resp = null;
            RequestHandler handler = null;
            try {
                in = new BufferedReader(new InputStreamReader(cSock.getInputStream(), "UTF-8"));
                String request = SocketProxy.readToEom(in, 0);
                if (trace.getDebugCode("monitor")) {
                    trace.out("monitor", "MonitorRequestConsumer.handleRequest()>" + request + "<");
                }
                if (SocketProxy.handlePolicyFileRequest(request, cSock)) {
                    return false;
                }
                out = new PrintWriter(new OutputStreamWriter(cSock.getOutputStream()));
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((Reader)new StringReader(request));
                root = doc.getRootElement();
                keepalive = Boolean.parseBoolean(root.getAttributeValue("keepalive"));
                handler = (RequestHandler)Monitor.this.requestHandlers.get(root.getName());
                if (keepalive) {
                    handler = handler.clone();
                    monitorList.add(cSock);
                }
                if (handler == null) {
                    throw new IllegalArgumentException("no handler for \"" + root.getName() + "\"; handlers: " + Monitor.this.requestHandlers.keySet());
                }
                resp = handler.handleRequest(root);
                if (trace.getDebugCode("monitor")) {
                    trace.out("monitor", "MonitorRequestConsumer resp |" + outputter.outputString(resp) + "|");
                }
            }
            catch (Throwable t) {
                trace.errStack("Monitor: error handling request " + (root == null ? "(null)" : root.getName()), t);
                resp = new Element("error");
                resp.setAttribute("exception", t.getClass().getName());
                resp.addContent(t.getMessage());
            }
            try {
                this.debug("outputting information");
                if (keepalive) {
                    for (int i = 0; i < monitorList.size(); ++i) {
                        Socket sock = monitorList.get(i);
                        this.debug(sock + " is one the monitorList");
                        if (!sock.isConnected()) continue;
                        this.debug(sock + " is connected");
                        PrintWriter mlOut = new PrintWriter(new OutputStreamWriter(sock.getOutputStream()));
                        outputter.output(resp, (Writer)mlOut);
                        mlOut.write(0);
                        mlOut.flush();
                    }
                } else {
                    outputter.output(resp, (Writer)out);
                    out.write(0);
                    out.flush();
                }
            }
            catch (Throwable t) {
                trace.errStack("Monitor: error writing socket to reply to request " + (root == null ? "(null)" : root.getName()), t);
            }
            finally {
                if (!keepalive) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException i) {}
                    }
                    if (out != null) {
                        out.close();
                    }
                } else {
                    handler.setSocketIO(cSock, in, out);
                    new Thread(handler).start();
                }
            }
            return keepalive;
        }
    }
}

