/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.pact.TutoringService.RequestHandler;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public class ServiceRequest
extends RequestHandler {
    private TSLauncherServer ls;
    static final String SHUTDOWN_TIME = "shutdownTime";
    public static final String NAME = "service";

    public ServiceRequest(TSLauncherServer ls) {
        this.ls = ls;
    }

    @Override
    protected ServiceRequest clone() throws CloneNotSupportedException {
        this.debug("clone ()");
        return (ServiceRequest)super.clone();
    }

    @Override
    public Element handleRequest(Element req) {
        this.debug("handleRequest (" + req + ")");
        Element resp = new Element(NAME);
        String cmd = req.getAttributeValue("cmd");
        if ("status".equalsIgnoreCase(cmd)) {
            resp.addContent((Content)this.createVersionElement());
            resp.addContent((Content)this.createSessions(false));
            resp.addContent((Content)this.createMemoryElement());
            resp.addContent((Content)this.createLoggingElement());
        } else if ("detail".equalsIgnoreCase(cmd)) {
            resp.addContent((Content)this.createSessions(true));
        } else if ("all".equalsIgnoreCase(cmd)) {
            resp.addContent((Content)this.createVersionElement());
            resp.addContent((Content)this.createMemoryElement());
            resp.addContent((Content)this.createLoggingElement());
            resp.addContent((Content)this.createSessions(true));
        } else if ("shutdown".equalsIgnoreCase(cmd)) {
            resp.setAttribute(SHUTDOWN_TIME, new Date().toString());
            Thread shutdown = new Thread(){

                @Override
                public void run() {
                    Utils.sleep(500L);
                    ServiceRequest.this.ls.shutdown();
                }
            };
            shutdown.start();
        } else if ("trace".equalsIgnoreCase(cmd)) {
            resp.addContent((Content)this.setTraceCodes(req));
        } else {
            resp.setAttribute("result", "error: unknown cmd " + cmd);
        }
        return resp;
    }

    private Element setTraceCodes(Element req) {
        Element traces = new Element("trace");
        List codes = req.getChildren("code");
        for (Element code : codes) {
            String traceCode = code.getTextTrim();
            trace.addDebugCode(traceCode);
        }
        for (String traceCode : trace.getDebugCodes()) {
            Element code = new Element("code");
            code.setText(traceCode);
            traces.addContent((Content)code);
        }
        return traces;
    }

    private Element createVersionElement() {
        this.debug("createVersionElement ()");
        Element version = new Element("version");
        version.setAttribute("releaseName", VersionInformation.RELEASE_NAME);
        version.setAttribute("versionNumber", VersionInformation.VERSION_NUMBER);
        version.setAttribute("buildDate", VersionInformation.BUILD_DATE);
        return version;
    }

    private Element createMemoryElement() {
        this.debug("createMemoryElement ()");
        Element memory = new Element("memory");
        memory.setAttribute("total", Long.toString(Runtime.getRuntime().totalMemory()));
        memory.setAttribute("max", Long.toString(Runtime.getRuntime().maxMemory()));
        memory.setAttribute("free", Long.toString(Runtime.getRuntime().freeMemory()));
        return memory;
    }

    private Element createLoggingElement() {
        this.debug("createLoggingElement ()");
        Element logging = new Element("logging");
        Map<String, String> logInfo = this.ls.getSummaryLogInfo().toAttributes();
        for (String key : logInfo.keySet()) {
            logging.setAttribute(key, logInfo.get(key));
        }
        return logging;
    }

    private Element createSessions(boolean wantDetails) {
        this.debug("createSessions (LauncherServer,boolean)");
        Set<String> sessionKeys = this.ls.getSessionKeys();
        Element sessions = new Element("sessions");
        int nSessions = sessionKeys.size();
        sessions.setAttribute("count", Integer.toString(nSessions));
        if (trace.getDebugCode("ls")) {
            trace.outNT("ls", "ServiceRequest.handleRequest() count " + nSessions);
        }
        if (!wantDetails) {
            return sessions;
        }
        for (String guid : sessionKeys) {
            Element sessElt = this.ls.generateSessionElement(guid);
            if (sessElt == null) continue;
            sessions.addContent((Content)sessElt);
        }
        return sessions;
    }
}

