/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.pact.TutoringService.Monitor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class TransactionInfo {
    private static final DateFormat externalDateFmt = Monitor.dateFmt;
    private static final DateFormat dateFmt = new SimpleDateFormat("HH:mm:ss.SSS");
    private int transactionCount = 0;
    private int transactionCompletedCount = 0;
    private int problemCount = 0;
    private int problemCompletedCount = 0;
    private Single first = null;
    private Single latest = null;
    private Single longest = null;
    private long totalDuration = 0L;

    public int getProblemCount() {
        return this.problemCount;
    }

    public synchronized Single create() {
        this.latest = new Single();
        ++this.transactionCount;
        this.updateAfterTransaction(this.latest);
        return this.latest;
    }

    private synchronized void updateAfterTransaction(Single current) {
        if (this.first == null) {
            this.first = this.longest = current;
        }
        if (current.duration >= 0L) {
            this.totalDuration += current.duration;
            ++this.transactionCompletedCount;
            if (this.longest.duration < current.duration) {
                this.longest = current;
            }
        }
    }

    public Map<String, String> toAttributes() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("totalTransactionMs", Long.toString(this.totalDuration));
        result.put("transactionCount", Integer.toString(this.transactionCount));
        result.put("firstTransactionTime", this.first == null ? "" : externalDateFmt.format(this.first.startTime));
        result.put("longestTransactionMs", this.longest == null ? "0" : Long.toString(this.longest.duration));
        result.put("longestTransactionStartTime", this.longest == null ? "" : externalDateFmt.format(this.longest.startTime));
        return result;
    }

    public Map<String, String> toAttributesRaw() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("totalTransactionMs", Long.toString(this.totalDuration));
        result.put("transactionCount", Integer.toString(this.transactionCount));
        result.put("firstTransactionTime", this.first == null ? "" : String.format("%d", this.first.startTime.getTime()));
        result.put("longestTransactionMs", this.longest == null ? "0" : Long.toString(this.longest.duration));
        result.put("longestTransactionStartTime", this.longest == null ? "" : String.format("%d", this.longest.startTime.getTime()));
        return result;
    }

    public synchronized void update(Object info) {
        if (info instanceof Boolean && ((Boolean)info).booleanValue()) {
            ++this.problemCompletedCount;
        } else {
            ++this.problemCount;
        }
    }

    public Single getFirst() {
        return this.first;
    }

    public Single getLatest() {
        return this.latest;
    }

    public Single getLongest() {
        return this.longest;
    }

    public int getTransactionCount() {
        return this.transactionCount;
    }

    public int getTransactionCompletedCount() {
        return this.transactionCompletedCount;
    }

    public int getProblemCompletedCount() {
        return this.problemCompletedCount;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public class Single {
        private static final String TAG = "Transaction";
        private static final String START_TIME = "startTime";
        private static final String DURATION = "duration";
        private Date startTime = new Date();
        private long duration = -1L;

        public Date getStartTime() {
            return this.startTime;
        }

        public long getDuration() {
            if (this.duration < 0L) {
                return System.currentTimeMillis() - this.startTime.getTime();
            }
            return this.duration;
        }

        public long setEndTime() {
            this.duration = System.currentTimeMillis() - this.startTime.getTime();
            TransactionInfo.this.updateAfterTransaction(this);
            return this.duration;
        }

        public Map<String, String> toAttributes() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            result.put(START_TIME, externalDateFmt.format(this.startTime));
            result.put(DURATION, Long.toString(this.duration));
            return result;
        }

        public void update(Object info) {
            if (info instanceof Boolean && ((Boolean)info).booleanValue()) {
                this.setEndTime();
            }
        }
    }
}

