/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.pact.ctat.MessageObject;
import javax.swing.JComponent;

public class ComponentDescription {
    private static final Object COMPONENT_DESCRIPTION = "ComponentDescription";
    private static final char VISIBLE = 'v';
    private static final char X_POSITION = 'x';
    private static final char Y_POSITION = 'y';
    private static final String FIELD_DELIMITER = ",";
    private static final String LABEL_DELIMITER = "=";
    private final JComponent component;

    public ComponentDescription(JComponent component) {
        this.component = component;
    }

    public void serializeGraphicalProperties(MessageObject messageObject) {
        messageObject.setProperty((String)COMPONENT_DESCRIPTION, this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('v').append(LABEL_DELIMITER).append(this.component.isVisible());
        sb.append(FIELD_DELIMITER);
        sb.append('x').append(LABEL_DELIMITER).append(this.component.getX());
        sb.append(FIELD_DELIMITER);
        sb.append('y').append(LABEL_DELIMITER).append(this.component.getY());
        return sb.toString();
    }

    private void execute(String s) {
        String[] fields = s.split(FIELD_DELIMITER);
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].length() < 1 + LABEL_DELIMITER.length() + 1) continue;
            char label = fields[i].charAt(0);
            String value = fields[i].substring(1 + LABEL_DELIMITER.length());
            switch (label) {
                case 'v': {
                    this.component.setVisible(Boolean.valueOf(value));
                }
            }
        }
    }

    public void executeGraphicalProperties(MessageObject messageobject) {
        Object propertyValues = messageobject.getProperty((String)COMPONENT_DESCRIPTION);
        if (propertyValues != null) {
            this.execute((String)propertyValues);
        }
    }
}

