/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.pact.Log.TutorActionLog;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.trace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public class EventLogger
implements ActionListener {
    private LoggingSupport loggingSupport;
    private static final String PACT_CTAT_EVENT = "PACT_CTAT_EVENT";

    public EventLogger(LoggingSupport loggingSupport) {
        this.loggingSupport = loggingSupport;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt == null || evt.getID() != 1001) {
            return;
        }
        if (this.loggingSupport == null) {
            return;
        }
        if (trace.getDebugCode("mps")) {
            trace.out("mps", "ActionEvent id " + evt.getID() + ", cmd " + evt.getActionCommand());
        }
        if (evt.getActionCommand().equalsIgnoreCase("CLEAR") || evt.getActionCommand().equalsIgnoreCase("STOP")) {
            this.loggingSupport.authorActionLog("JESS_CONSOLE", evt.getActionCommand(), "", "", (Object)"");
        }
    }

    public boolean log(boolean authorAction, String toolname, String actionType, String argument, String result, String result2) {
        if (this.loggingSupport == null) {
            return true;
        }
        if (authorAction) {
            return this.loggingSupport.authorActionLog(toolname, actionType, argument, result, (Object)result2);
        }
        return this.loggingSupport.programActionLog(toolname, actionType, argument, result, result2);
    }

    private boolean logIt(ActionLog logEntry) {
        if (this.loggingSupport != null) {
            return this.loggingSupport.oliLog(logEntry);
        }
        return false;
    }

    private ActionLog createLogEntry(String messageType, String[] names, Object[] values) {
        TutorActionLog logEntry = new TutorActionLog("message");
        logEntry.setSourceId(PACT_CTAT_EVENT);
        if (messageType != null) {
            logEntry.addMsgProperty("MessageType", messageType);
        }
        if (names != null && values != null) {
            int n = Math.min(names.length, values.length);
            for (int i = 0; i < n; ++i) {
                if (names[i] == null) continue;
                if (values[i] instanceof List) {
                    logEntry.addMsgProperty(names[i], (List)values[i]);
                    continue;
                }
                if (values[i] != null) {
                    logEntry.addMsgProperty(names[i], values[i].toString());
                    continue;
                }
                logEntry.addMsgProperty(names[i], "(null)");
            }
        }
        return logEntry;
    }

    public LoggingSupport getLoggingSupport() {
        return this.loggingSupport;
    }
}

