/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.oli.log.client.AsyncStreamLogger;
import edu.cmu.oli.log.client.DiskLogger;
import edu.cmu.oli.log.client.SessionLog;
import edu.cmu.oli.log.client.StreamLogger;
import edu.cmu.pact.Log.DataShopMessageObject;
import edu.cmu.pact.Log.LogConsole;
import edu.cmu.pact.Log.TutorActionLogV4;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.OLIMessageConverters;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pslc.logging.ContextMessage;
import edu.cmu.pslc.logging.LogContext;
import edu.cmu.pslc.logging.Message;
import edu.cmu.pslc.logging.OliDatabaseLogger;
import edu.cmu.pslc.logging.OliDiskLogger;
import edu.cmu.pslc.logging.ToolMessage;
import edu.cmu.pslc.logging.TutorMessage;
import edu.cmu.pslc.logging.element.ConditionElement;
import edu.cmu.pslc.logging.element.DatasetElement;
import edu.cmu.pslc.logging.element.LevelElement;
import edu.cmu.pslc.logging.element.MetaElement;
import edu.cmu.pslc.logging.element.ProblemElement;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class Logger
implements AsyncStreamLogger.Listener,
LogContext,
PropertyChangeListener {
    private static final List<String> DataShopMsgTypes = Arrays.asList("tool_message", "tutor_message", "context_message", "message");
    public static final String ENABLE_AUTHOR_LOGGING = "enableAuthorLogging";
    public String lastLogFile;
    protected String userID = "";
    protected String diskLogFile = null;
    protected boolean enableAuthorLog = false;
    protected boolean enableLog = true;
    protected String logFileDir;
    protected StreamLogger streamLogger;
    private DiskLogger diskLogger;
    public static final String LOG_SERVICE_URL_PROPERTY = "log_service_url";
    public static final String DISK_LOG_DIR_PROPERTY = "log_to_disk_directory";
    public static final String STUDENT_NAME_PROPERTY = "user_guid";
    public static final String SESSION_ID_PROPERTY = "session_id";
    public static final String AUTH_TOKEN_PROPERTY = "auth_token";
    public static final String SOURCE_ID_PROPERTY = "source_id";
    public static final String PROBLEM_NAME_PROPERTY = "problem_name";
    public static final String PROBLEM_TUTOR_FLAG_PROPERTY = "problem_tutorflag";
    public static final String PROBLEM_OTHER_FLAG_PROPERTY = "problem_otherproblemflag";
    public static final String PROBLEM_CONTEXT_PROPERTY = "problem_context";
    public static final String CONTEXT_MSG_ID_PROPERTY = "context_message_id";
    public static final String QUESTION_FILE_PROPERTY = "question_file";
    public static final String STUDENT_INTERFACE_PROPERTY = "student_interface";
    public static final String SCHOOL_NAME_PROPERTY = "school_name";
    public static final String COURSE_NAME_PROPERTY = "course_name";
    public static final String UNIT_NAME_PROPERTY = "unit_name";
    public static final String SECTION_NAME_PROPERTY = "section_name";
    private static final int MAX_INSTRUCTORS = 11;
    private static final int MAX_CONDITIONS = 11;
    private static final int MAX_LEVELS = 12;
    private static final int MAX_CUSTOM_PROPERTIES = 11;
    private boolean loggedSessionAlready = false;
    private OLIMessageConverters oLIMessageConverters = null;
    private static DateFormat dateFmt = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private MetaElement metaElement;
    private String authToken = null;
    private static final String INFO_TYPE = "tutor_message.dtd";
    public static final String DEFAULT_SOURCE_ID = "PACT_CTAT";
    private String sourceId = "PACT_CTAT";
    private String problemName = "UndefinedProblem";
    private String questionFile = null;
    private String schoolName = null;
    private String datasetName = "UndefinedCourse";
    private TSLauncherServer server;
    private volatile ContextMessage contextMessage;
    private String contextMessageName;
    private String contextMessageId;
    private String[] experimentalConditions;
    private String problemTutorFlag;
    private String problemOtherFlag;
    private String problemContext;
    private ArrayList instructors;
    private ArrayList conditionNames;
    private ArrayList conditionTypes;
    private ArrayList conditionDescriptions;
    private ArrayList levelNames;
    private ArrayList levelTypes;
    private ArrayList customNames;
    private ArrayList customValues;
    private ToolMessage lastToolMessage;
    private String className;
    private String classPeriod;
    private String classDescription;
    private LogConsole logConsole = null;
    private static final DateFormat ctxMsgDateFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    public static final String DATASET_NAME_PROPERTY = "dataset_name";
    public static final String INSTRUCTOR_NAME_PROPERTY = "instructor_name";
    public static final String STUDY_CONDITION_NAME = "study_condition_name";
    public static final String STUDY_CONDITION_TYPE = "study_condition_type";
    public static final String STUDY_CONDITION_DESCRIPTION = "study_condition_description";
    public static final String DATASET_LEVEL_NAME = "dataset_level_name";
    public static final String DATASET_LEVEL_TYPE = "dataset_level_type";
    public static final String CLASS_NAME_PROPERTY = "class_name";
    public static final String CLASS_PERIOD_PROPERTY = "period_name";
    public static final String CLASS_DESCRIPTION_PROPERTY = "class_description";
    public static final String CUSTOM_FIELD_VALUE = "custom_field_value";
    public static final String CUSTOM_FIELD_NAME = "custom_field_name";

    public void resetLogger() {
        if (trace.getDebugCode("log")) {
            trace.out("log", "RESET LOGGER logFileDir " + this.logFileDir);
        }
        this.startDiskLogging(this.logFileDir);
    }

    public void changeOLILoggingURL(String loggingURL) {
        if (loggingURL == null || loggingURL.length() < 1) {
            this.streamLogger = null;
        } else {
            this.startOLILogging(loggingURL);
        }
    }

    public void changeDiskLoggingDir(String logFileDir) {
        if (trace.getDebugCode("log")) {
            trace.out("log", "disk logger = " + this.diskLogger);
        }
        if (logFileDir == null || logFileDir.length() < 1) {
            this.setDiskLogger(null);
        } else {
            this.startDiskLogging(logFileDir);
        }
    }

    private void handleLogError(Throwable logEx, String logDest, String preferenceName) {
        if (logEx != null) {
            logEx.printStackTrace();
        }
        String displayMsg = "Error trying to log to " + logDest + ".";
        if (logEx != null) {
            displayMsg = displayMsg + " Details:\n" + logEx.toString();
        }
        Utils.showExceptionOccuredDialog(null, displayMsg, "Warning");
    }

    public boolean oliLog(MessageObject o, boolean tutorToTool) {
        if (trace.getDebugCode("log")) {
            trace.out("log", "oliLog(MessageObject,tutorToTool bool): enableLog=" + this.enableLog + ", tutorToTool " + tutorToTool + ", mo" + o.toString());
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "oliLog isAssociatedRules " + this.isAssociatedRules(o));
        }
        if (this.logConsole != null && this.isAssociatedRules(o)) {
            this.logConsole.sendMsgToLogConsole(o);
        }
        return this.oliLog(o, tutorToTool, new String[]{null});
    }

    private boolean isAssociatedRules(MessageObject message) {
        if (message.getMessageType().equals("AssociatedRules")) {
            if (trace.getDebugCode("log")) {
                trace.out("log", "is associated rules");
            }
            return true;
        }
        return false;
    }

    public boolean oliLog(MessageObject o, boolean tutorToTool, String ... custom) {
        if (trace.getDebugCode("log")) {
            trace.out("log", "oliLog(MessageObject, tutorToTool, Strings): enableLog=" + this.enableLog + ", tutorToTool " + tutorToTool + ", mo=" + o.toString());
        }
        if (o.isLoggingSuppressed()) {
            return false;
        }
        if (!this.useOLILogging() && !this.diskLoggingSetup()) {
            return false;
        }
        TutorActionLogV4 alog = this.messageObjectToTutorActionLog(o, tutorToTool);
        if (alog == null) {
            return false;
        }
        Message m = alog.getMsg();
        if (custom != null) {
            if (m instanceof ToolMessage) {
                ToolMessage tm = (ToolMessage)m;
                for (int i = 1; i < custom.length; i += 2) {
                    tm.addCustomField(custom[i - 1], custom[i]);
                }
                this.addOriginalIds(alog.getTransactionId(), this.getStudentName(), (Message)tm);
                this.addOriginalTime(o, tm);
            } else if (m instanceof TutorMessage) {
                TutorMessage tm = (TutorMessage)m;
                for (int i = 1; i < custom.length; i += 2) {
                    tm.addCustomField(custom[i - 1], custom[i]);
                }
                this.addOriginalIds(alog.getTransactionId(), this.getStudentName(), (Message)tm);
            }
        }
        return this.oliLog(alog);
    }

    protected void addOriginalIds(String transactionId, String studentId, Message tm) {
    }

    protected void addOriginalTime(MessageObject o, ToolMessage tm) {
    }

    TutorActionLogV4 messageObjectToTutorActionLog(MessageObject o, boolean tutorToTool) {
        TutorActionLogV4 result = null;
        try {
            DataShopMessageObject mo = new DataShopMessageObject(o, tutorToTool, this);
            result = mo.getLogMsg();
        }
        catch (Exception e) {
            trace.errStack("logging msg:\n  " + o, e);
        }
        return result;
    }

    public static MessageObject actionLogToMessageObject(String msgXML, boolean tutorToTool) {
        try {
            Element element2 = Logger.elementForString(msgXML);
        }
        catch (Exception e) {
            trace.errStack("converting msgXML:\n  " + msgXML, e);
        }
        return null;
    }

    private static Element getMessageElement(Element elt) {
        if (elt == null) {
            return null;
        }
        if (DataShopMsgTypes.contains(elt.getName())) {
            return elt;
        }
        Element child = Logger.tutorRelatedMessageSequence(elt);
        if (child == null) {
            return null;
        }
        if (DataShopMsgTypes.contains(child.getName())) {
            return child;
        }
        for (String eltName : DataShopMsgTypes) {
            Element grandchild = child.getChild(eltName);
            if (grandchild == null) continue;
            return grandchild;
        }
        return null;
    }

    private static Element tutorRelatedMessageSequence(Element elt) {
        if (trace.getDebugCode("log")) {
            trace.out("log", "elt " + (elt == null ? "null" : elt.getName() + ", date " + elt.getAttributeValue("date_time")));
        }
        if (elt == null) {
            return null;
        }
        if ("log_session_start".equals(elt.getName())) {
            return null;
        }
        if ("tutor_related_message_sequence".equals(elt.getName())) {
            return elt;
        }
        if (DataShopMsgTypes.contains(elt.getName())) {
            return elt;
        }
        if (!"log_action".equals(elt.getName())) {
            return null;
        }
        return elt.getChild("tutor_related_message_sequence");
    }

    private static Element elementForString(String eltStr) {
        try {
            return new SAXBuilder().build((Reader)new StringReader(eltStr)).getRootElement();
        }
        catch (Exception e) {
            System.err.println("Error parsing " + eltStr + "\ne");
            e.printStackTrace(System.err);
            return null;
        }
    }

    public boolean oliLog(ActionLog alog) {
        if (trace.getDebugCode("log")) {
            trace.printStack("log", "oliLog(ActionLog): enableLog=" + this.enableLog + ", action log = " + alog);
        }
        if (!this.enableLog) {
            return false;
        }
        if (alog == null) {
            return false;
        }
        alog.setUserGuid("x");
        alog.setSessionId(this.getServer().getLogger().getSessionId());
        alog.setAuthToken(this.getAuthToken());
        if (trace.getDebugCode("log")) {
            trace.out("log", "oliLog(ActionLog) after setting more data:" + alog);
        }
        return this.oliLogInternal(alog);
    }

    protected synchronized boolean oliLogInternal(ActionLog alog) {
        boolean doStrm = this.useOLILogging();
        boolean doDisk = this.diskLoggingSetup();
        Boolean strmResult = Boolean.FALSE;
        Boolean diskResult = Boolean.FALSE;
        if (alog == null) {
            return false;
        }
        trace.out("logtime", "alog's time stamp" + alog.getTimeStamp());
        this.logSessionLog(doStrm ? this.streamLogger : null, doDisk ? this.getDiskLogger() : null);
        try {
            if (doStrm && this.streamLogger != null && !(strmResult = this.streamLogger.logActionLog(alog)).booleanValue()) {
                this.handleLogError(this.streamLogger.getLastError(), this.streamLogger.getURL().toString(), "Use OLI Logging");
            }
        }
        catch (Exception e) {
            this.handleLogError(e, this.streamLogger.getURL().toString(), "Use OLI Logging");
        }
        try {
            if (doDisk && this.getDiskLogger() != null && !(diskResult = this.getDiskLogger().logActionLog(alog)).booleanValue()) {
                this.handleLogError(this.getDiskLogger().getLastError(), this.diskLogFile, "Use Disk Logging");
            }
        }
        catch (Exception e) {
            this.handleLogError(e, this.diskLogFile, "Use Disk Logging");
        }
        return strmResult != false || diskResult != false;
    }

    protected DiskLogger getDiskLogger() {
        return this.diskLogger;
    }

    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }

    public static void main(String[] args) {
        String studentName;
        if (args.length < 1) {
            studentName = "fred";
        } else {
            if (args[0].charAt(0) == '-') {
                System.out.printf("Usage: %s [studentName]\nwhere--\n  studentName defaults to fred.\n", Logger.class.getSimpleName());
                return;
            }
            studentName = args[0];
        }
        Logger logger = new Logger(studentName, null);
        logger.startDiskLogging(studentName);
    }

    public Logger(String studentName, TSLauncherServer server) {
        int i;
        this.server = server;
        if (this.server != null && this.server.getProperties() != null) {
            this.server.getProperties().addPropertyChangeListener(this);
        }
        trace.out("log", "student name = " + studentName);
        if (studentName == null) {
            studentName = this.getServerProperty(STUDENT_NAME_PROPERTY);
        }
        trace.out("log", "student name = " + studentName);
        if (studentName == null || studentName.length() < 1) {
            try {
                studentName = System.getProperty("user.name");
            }
            catch (Exception e) {
                trace.err("Unable to access system propertie user.name: " + e.getMessage());
            }
            if (studentName == null || studentName.length() < 1) {
                studentName = "unknown";
            }
        }
        this.createMetaElement(studentName, this.getServerProperty(SESSION_ID_PROPERTY));
        this.contextMessageName = "START_TUTOR";
        this.contextMessage = ContextMessage.create((String)this.contextMessageName, (MetaElement)this.metaElement);
        if (this.contextMessageId != null && this.contextMessageId.length() > 0) {
            this.contextMessage.setContextMessageId(this.contextMessageId);
        }
        trace.out("log", "Create logger: student name = " + studentName);
        this.instructors = new ArrayList();
        for (i = 0; i < 11; ++i) {
            this.instructors.add(null);
        }
        this.customNames = new ArrayList();
        for (i = 0; i < 11; ++i) {
            this.customNames.add(null);
        }
        this.customValues = new ArrayList();
        for (i = 0; i < 11; ++i) {
            this.customValues.add(null);
        }
        this.conditionNames = new ArrayList();
        for (i = 0; i < 11; ++i) {
            this.conditionNames.add(null);
        }
        this.conditionTypes = new ArrayList();
        for (i = 0; i < 11; ++i) {
            this.conditionTypes.add(null);
        }
        this.conditionDescriptions = new ArrayList();
        for (i = 0; i < 11; ++i) {
            this.conditionDescriptions.add(null);
        }
        this.levelNames = new ArrayList();
        for (i = 0; i < 12; ++i) {
            this.levelNames.add(null);
        }
        this.levelTypes = new ArrayList();
        for (i = 0; i < 12; ++i) {
            this.levelTypes.add(null);
        }
        this.authToken = this.getServerProperty(AUTH_TOKEN_PROPERTY);
        this.setSourceId(this.getServerProperty(SOURCE_ID_PROPERTY));
        this.setProblemName(this.getServerProperty(PROBLEM_NAME_PROPERTY));
        this.questionFile = this.getServerProperty(QUESTION_FILE_PROPERTY);
        this.setSchoolName(this.getServerProperty(SCHOOL_NAME_PROPERTY));
        this.setClassName(this.getServerProperty(CLASS_NAME_PROPERTY));
        this.setClassPeriod(this.getServerProperty(CLASS_PERIOD_PROPERTY));
        this.setClassDescription(this.getServerProperty(CLASS_DESCRIPTION_PROPERTY));
        this.setCourseName(this.getServerProperty(COURSE_NAME_PROPERTY));
        if (this.server != null) {
            this.setDatasetName(this.server.getPreferencesModel().getStringValue(DATASET_NAME_PROPERTY));
        }
        this.setDatasetName(this.getServerProperty(DATASET_NAME_PROPERTY));
        this.setUnitName(this.getServerProperty(UNIT_NAME_PROPERTY));
        this.setSectionName(this.getServerProperty(SECTION_NAME_PROPERTY));
    }

    private String getServerProperty(String property) {
        return this.getServer() == null ? null : (String)this.getServer().getProperties().getProperty(property);
    }

    public void setProblemName(String problemName) {
        if (trace.getDebugCode("log")) {
            trace.out("log", this.toString() + ".problemName was " + this.problemName + ", now " + problemName);
        }
        this.problemName = problemName;
        this.reviseContextMessage();
    }

    public Logger(TSLauncherServer server) {
        this(null, server);
    }

    public void setSessionId(String sessionId) {
        if (sessionId == null) {
            return;
        }
        this.createMetaElement(this.getStudentName(), sessionId);
        this.loggedSessionAlready = false;
    }

    public static String generateGUID() {
        UUID uid = UUID.randomUUID();
        return "L" + uid.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if (name.equalsIgnoreCase(AUTH_TOKEN_PROPERTY)) {
            this.authToken = (String)newValue;
        } else if (name.equalsIgnoreCase(SOURCE_ID_PROPERTY)) {
            this.setSourceId((String)newValue);
        } else if (name.equalsIgnoreCase(PROBLEM_NAME_PROPERTY)) {
            this.setProblemName((String)newValue);
        } else if (name.equalsIgnoreCase(PROBLEM_CONTEXT_PROPERTY)) {
            this.setProblemContext((String)newValue);
        } else if (name.equalsIgnoreCase(PROBLEM_TUTOR_FLAG_PROPERTY)) {
            this.setProblemTutorFlag((String)newValue);
        } else if (name.equalsIgnoreCase(QUESTION_FILE_PROPERTY)) {
            this.questionFile = (String)newValue;
        } else if (name.equalsIgnoreCase(SCHOOL_NAME_PROPERTY)) {
            this.setSchoolName((String)newValue);
        } else if (name.equalsIgnoreCase(CLASS_NAME_PROPERTY)) {
            this.setClassName((String)newValue);
        } else if (name.equalsIgnoreCase(INSTRUCTOR_NAME_PROPERTY)) {
            this.addInstructorName((String)newValue, 0);
        } else if (name.equalsIgnoreCase(COURSE_NAME_PROPERTY)) {
            this.setCourseName((String)newValue);
        } else if (name.equalsIgnoreCase(UNIT_NAME_PROPERTY)) {
            this.setUnitName((String)newValue);
        } else if (name.equalsIgnoreCase(SECTION_NAME_PROPERTY)) {
            this.setSectionName((String)newValue);
        } else if (name.equalsIgnoreCase(SESSION_ID_PROPERTY)) {
            this.setSessionId((String)newValue);
        } else if (name.equalsIgnoreCase(DATASET_NAME_PROPERTY)) {
            this.setDatasetName((String)newValue);
        } else if (name.toLowerCase().startsWith(DATASET_LEVEL_NAME)) {
            try {
                int index = Math.min(0, Integer.parseInt(name.substring(DATASET_LEVEL_NAME.length())) - 1);
                this.addDatasetLevelName((String)newValue, index);
            }
            catch (Exception e) {
                trace.out("log", "Exception converting suffix to integer from name \"" + name + "\": " + e);
                this.addDatasetLevelName((String)newValue, 0);
            }
        } else if (name.toLowerCase().startsWith(DATASET_LEVEL_TYPE)) {
            try {
                int index = Math.min(0, Integer.parseInt(name.substring(DATASET_LEVEL_TYPE.length())) - 1);
                this.addDatasetLevelType((String)newValue, index);
            }
            catch (Exception e) {
                trace.out("log", "Exception converting suffix to integer from name \"" + name + "\": " + e);
                this.addDatasetLevelType((String)newValue, 0);
            }
        } else if (name.toLowerCase().startsWith(STUDY_CONDITION_NAME)) {
            try {
                int index = Math.min(0, Integer.parseInt(name.substring(STUDY_CONDITION_NAME.length())) - 1);
                this.addStudyConditionName((String)newValue, index);
            }
            catch (Exception e) {
                trace.out("log", "Exception converting suffix to integer from name \"" + name + "\": " + e);
                this.addStudyConditionName((String)newValue, 0);
            }
        } else if (name.toLowerCase().startsWith(STUDY_CONDITION_TYPE)) {
            try {
                int index = Math.min(0, Integer.parseInt(name.substring(STUDY_CONDITION_TYPE.length())) - 1);
                this.addStudyConditionType((String)newValue, index);
            }
            catch (Exception e) {
                trace.out("log", "Exception converting suffix to integer from name \"" + name + "\": " + e);
                this.addStudyConditionType((String)newValue, 0);
            }
        } else {
            return;
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "Changed " + name + " from " + evt.getOldValue() + " to " + newValue);
        }
    }

    @Override
    public void notifyError(String errorDescription) {
        System.err.println("Logger: Error from AsyncStreamLogger: " + errorDescription);
    }

    public String[] getExperimentalConditions() {
        return this.experimentalConditions;
    }

    public void setExperimentalConditions(String experimentalConditions) {
        String[] split = experimentalConditions.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        this.setExperimentalConditions(split);
    }

    public void setExperimentalConditions(String[] experimentalConditions) {
        this.experimentalConditions = experimentalConditions;
        this.reviseContextMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logSessionLog(StreamLogger log, DiskLogger dLog) {
        if (this.loggedSessionAlready) {
            return false;
        }
        Logger logger = this;
        synchronized (logger) {
            if (this.loggedSessionAlready) {
                return false;
            }
            boolean result = false;
            SessionLog slog = new SessionLog();
            String username = this.getServerProperty(STUDENT_NAME_PROPERTY);
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "to log session log; user_guid is " + username + ", studentName is " + this.getStudentName() + "\n\tlog Streamlogger is " + log + "\n\tdLog DiskLogger is " + dLog);
            }
            if (username == null || username.length() < 1) {
                username = this.getStudentName();
            }
            slog.setUserGuid(username);
            slog.setSessionId(this.getSessionId());
            slog.setAuthToken(this.getAuthToken());
            if (log != null) {
                try {
                    Boolean strmResult = log.logSessionLog(slog);
                    result = result || strmResult != false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (dLog != null) {
                try {
                    Boolean diskResult = dLog.logSessionLog(slog);
                    result = result || diskResult != false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.loggedSessionAlready = result;
            return result;
        }
    }

    public String getDefaultFilename() {
        return this.getStudentName() + "_" + dateFmt.format(new Date()) + ".log";
    }

    @Override
    public String getStudentName() {
        return this.metaElement.getUserId();
    }

    synchronized void setStudentName(String studentName) {
        boolean nameChanged;
        if (trace.getDebugCode("log")) {
            trace.out("log", "old studentName " + this.getStudentName() + ", new studentName" + studentName);
        }
        if (studentName == null) {
            return;
        }
        boolean bl = nameChanged = !studentName.equals(this.getStudentName());
        if (nameChanged) {
            this.createMetaElement(studentName, this.getSessionId());
            this.loggedSessionAlready = false;
        }
    }

    synchronized void setAnonymizedStudentName(String studentName) {
        boolean nameChanged;
        if (trace.getDebugCode("log")) {
            trace.out("log", "old studentName " + this.getStudentName() + ", new studentName" + studentName);
        }
        if (studentName == null) {
            return;
        }
        boolean bl = nameChanged = !studentName.equals(this.getStudentName());
        if (nameChanged) {
            this.createMetaElement(studentName, this.getSessionId(), true);
            this.loggedSessionAlready = false;
        }
    }

    private void createMetaElement(String studentName, String sessionId) {
        this.createMetaElement(studentName, sessionId, false);
    }

    private void createMetaElement(String studentName, String sessionId, boolean anonFlag) {
        String now = ctxMsgDateFmt.format(new Date());
        int tzIndex = now.lastIndexOf(32);
        String tz = now.substring(tzIndex + 1);
        if (sessionId == null || sessionId.length() < 1) {
            sessionId = Logger.generateGUID();
        }
        this.metaElement = new MetaElement(studentName, Boolean.valueOf(anonFlag), sessionId, now.substring(0, tzIndex), tz);
        this.reviseContextMessage();
    }

    private void reviseContextMessage() {
        this.contextMessage = null;
    }

    public void setContextMessageId(String newCMId) {
        this.contextMessageId = newCMId;
        this.reviseContextMessage();
    }

    @Override
    public String getSessionId() {
        if (this.metaElement == null) {
            return null;
        }
        return this.metaElement.getSessionId();
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    @Override
    public String getInfoType() {
        return INFO_TYPE;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId == null || sourceId.length() < 1 ? DEFAULT_SOURCE_ID : sourceId;
    }

    @Override
    public String getProblemName() {
        if (trace.getDebugCode("pm")) {
            trace.out("pm", this.toString() + ".problemName is " + this.problemName);
        }
        return this.problemName;
    }

    public String getProblemContext() {
        if (this.problemContext != null && this.problemContext.length() > 0) {
            return this.problemContext;
        }
        return this.getProblemName();
    }

    @Override
    public String getQuestionFile() {
        return this.questionFile;
    }

    @Override
    public String getSchoolName() {
        return this.schoolName;
    }

    public void setSchoolName(String schoolName) {
        this.schoolName = schoolName;
        this.reviseContextMessage();
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setCourseName(String courseName) {
        this.setDatasetName(courseName);
    }

    @Override
    public String getCourseName() {
        return this.getDatasetName();
    }

    public void setDatasetName(String datasetName) {
        if (datasetName != null && datasetName.length() > 0 && !datasetName.equalsIgnoreCase(this.datasetName)) {
            this.datasetName = datasetName;
            this.reviseContextMessage();
        }
    }

    @Override
    public String getUnitName() {
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "Logger " + this + ".getUnitName " + this.getDatasetLevelName(0));
        }
        return this.getDatasetLevelName(0);
    }

    public void setUnitName(String unitName) {
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "Logger " + this + ".setUnitName old " + this.getDatasetLevelName(0) + ", new " + unitName);
        }
        this.addDatasetLevelName(unitName, 0);
        this.addDatasetLevelType("Unit", 0);
    }

    @Override
    public String getSectionName() {
        return this.getDatasetLevelName(1);
    }

    public void setSectionName(String sectionName) {
        this.addDatasetLevelName(sectionName, 1);
        this.addDatasetLevelType("Section", 1);
    }

    public String getAttemptId() {
        return this.getContextMessageId();
    }

    public String getContextMessageId() {
        return this.contextMessageId;
    }

    OLIMessageConverters getOLIMessageConverters() {
        return this.oLIMessageConverters;
    }

    void setOLIMessageConverters(OLIMessageConverters messageConverters) {
        this.oLIMessageConverters = messageConverters;
    }

    @Override
    public ContextMessage getContextMessage() {
        return this.getContextMessage(null);
    }

    @Override
    public synchronized ContextMessage getContextMessage(String contextMessageName) {
        int i;
        ContextMessage result = this.contextMessage;
        if (!(result == null || contextMessageName != null && contextMessageName.equalsIgnoreCase(this.contextMessageName))) {
            return result;
        }
        result = contextMessageName != null && contextMessageName.length() > 0 ? ContextMessage.create((String)contextMessageName, (MetaElement)this.metaElement) : ContextMessage.createStartProblem((MetaElement)this.metaElement);
        result.setSource(this.getSourceId());
        result.setSchool(this.getSchoolName());
        result.setClassDescription(this.getClassDescription());
        result.setClassName(this.getClassName());
        result.setPeriod(this.getClassPeriod());
        for (int i2 = 0; i2 < this.instructors.size(); ++i2) {
            if (this.getInstructorName(i2) == null) continue;
            result.addInstructor(this.getInstructorName(i2));
        }
        ProblemElement problemElt = new ProblemElement(this.getProblemTutorFlag(), this.getProblemOtherFlag(), this.getProblemName(), this.getProblemContext());
        LevelElement levelElt = null;
        for (i = this.levelNames.size() - 2; i >= 0; --i) {
            if (this.getDatasetLevelName(i) == null) continue;
            levelElt = levelElt == null ? new LevelElement(this.getDatasetLevelType(i), this.getDatasetLevelName(i), problemElt) : new LevelElement(this.getDatasetLevelType(i), this.getDatasetLevelName(i), levelElt);
        }
        if (levelElt == null) {
            levelElt = new LevelElement("Course", this.getCourseName(), problemElt);
        }
        result.setDataset(new DatasetElement(this.getCourseName(), levelElt));
        if (this.experimentalConditions != null) {
            for (i = 0; i < this.experimentalConditions.length; ++i) {
                result.addCondition(new ConditionElement(this.experimentalConditions[i]));
            }
        } else {
            for (i = 0; i < this.conditionNames.size(); ++i) {
                if (this.getStudyConditionName(i) == null) continue;
                result.addCondition(new ConditionElement(this.getStudyConditionName(i), this.getStudyConditionType(i), this.getStudyConditionDescription(i)));
            }
        }
        for (i = 0; i < this.customNames.size(); ++i) {
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "Custom Names[" + i + "]=" + this.getCustomFieldName(i));
            }
            if (this.getCustomFieldName(i) == null) continue;
            result.addCustomField(this.getCustomFieldName(i), this.getCustomFieldValue(i));
        }
        if (this.contextMessageId != null && this.contextMessageId.length() > 0) {
            result.setContextMessageId(this.contextMessageId);
        }
        this.contextMessage = result;
        return result;
    }

    public void setProblemContext(String problemContext) {
        this.problemContext = problemContext;
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "Setting problemContext to " + problemContext);
        }
        this.reviseContextMessage();
    }

    @Override
    public void resetAttemptId() {
        this.setContextMessageId(null);
    }

    @Override
    public void setLastToolMessage(ToolMessage msg) {
        this.lastToolMessage = msg;
    }

    @Override
    public ToolMessage getLastToolMessage() {
        return this.lastToolMessage;
    }

    public void addInstructorName(String value, int index) {
        if (this.getInstructorName(index) != null) {
            for (int i = 0; i < this.instructors.size(); ++i) {
                this.instructors.set(index, null);
            }
        }
        this.instructors.set(index, value);
        this.reviseContextMessage();
    }

    public String getInstructorName(int index) {
        return (String)this.instructors.get(index);
    }

    public void addStudyConditionName(String value, int index) {
        if (this.getStudyConditionName(index) != null) {
            for (int i = 0; i < this.conditionNames.size(); ++i) {
                this.conditionNames.set(index, null);
            }
        }
        this.conditionNames.set(index, value);
        this.reviseContextMessage();
    }

    public void setStudyConditionNames(String conditionNames) {
        if (conditionNames == null) {
            return;
        }
        String[] split = conditionNames.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
            this.addStudyConditionName(split[i], i);
        }
    }

    public String getStudyConditionName(int index) {
        return (String)this.conditionNames.get(index);
    }

    public void addStudyConditionType(String value, int index) {
        if (this.getStudyConditionType(index) != null) {
            for (int i = 0; i < this.conditionTypes.size(); ++i) {
                this.conditionTypes.set(index, null);
            }
        }
        this.conditionTypes.set(index, value);
        this.reviseContextMessage();
    }

    public void setStudyConditionTypes(String conditionTypes) {
        if (conditionTypes == null) {
            return;
        }
        String[] split = conditionTypes.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
            this.addStudyConditionType(split[i], i);
        }
    }

    public String getStudyConditionType(int index) {
        return (String)this.conditionTypes.get(index);
    }

    public void addStudyConditionDescription(String value, int index) {
        if (this.getStudyConditionDescription(index) != null) {
            for (int i = 0; i < this.conditionDescriptions.size(); ++i) {
                this.conditionDescriptions.set(index, null);
            }
        }
        this.conditionDescriptions.add(index, value);
        this.reviseContextMessage();
    }

    public void setStudyConditionDescriptions(String conditionDescriptions) {
        if (conditionDescriptions == null) {
            return;
        }
        String[] split = conditionDescriptions.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
            this.addStudyConditionDescription(split[i], i);
        }
    }

    public String getStudyConditionDescription(int index) {
        return (String)this.conditionDescriptions.get(index);
    }

    public void addDatasetLevelName(String value, int index) {
        for (int i = this.levelNames.size(); i <= index + 1; ++i) {
            this.levelNames.add(null);
        }
        this.levelNames.set(index + 1, value);
        this.reviseContextMessage();
    }

    public String getDatasetLevelName(int index) {
        return (String)this.levelNames.get(index);
    }

    public void addDatasetLevelType(String value, int index) {
        for (int i = this.levelTypes.size(); i <= index + 1; ++i) {
            this.levelTypes.add(null);
        }
        this.levelTypes.set(index + 1, value);
        this.reviseContextMessage();
    }

    public String getDatasetLevelType(int index) {
        return (String)this.levelTypes.get(index);
    }

    public void setClassName(String className) {
        if (className != null && className.length() > 0 && !className.equalsIgnoreCase(this.className)) {
            this.className = className;
            this.reviseContextMessage();
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassPeriod(String classPeriod) {
        if (classPeriod != null && classPeriod.length() > 0 && !classPeriod.equalsIgnoreCase(this.classPeriod)) {
            this.classPeriod = classPeriod;
            this.reviseContextMessage();
        }
    }

    public String getClassPeriod() {
        return this.classPeriod;
    }

    public void setClassDescription(String classDescription) {
        if (classDescription != null && classDescription.length() > 0 && !classDescription.equalsIgnoreCase(this.classDescription)) {
            this.classDescription = classDescription;
            this.reviseContextMessage();
        }
    }

    public String getClassDescription() {
        return this.classDescription;
    }

    public void addCustomFieldValue(String value, int index) {
        if (this.getCustomFieldValue(index) != null) {
            for (int i = 0; i < this.customValues.size(); ++i) {
                this.customValues.set(index, null);
            }
        }
        this.customValues.set(index, value);
        this.reviseContextMessage();
    }

    public String getCustomFieldValue(int index) {
        return (String)this.customValues.get(index);
    }

    public void addCustomFieldName(String value, int index) {
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "Adding Custom Field Name: " + value + " at index " + index);
        }
        if (this.getCustomFieldName(index) != null) {
            for (int i = 0; i < this.customNames.size(); ++i) {
                this.customNames.set(index, null);
            }
        }
        this.customNames.set(index, value);
        this.reviseContextMessage();
    }

    public String getCustomFieldName(int index) {
        return (String)this.customNames.get(index);
    }

    private void setSessionChanged() {
        this.loggedSessionAlready = false;
    }

    public String getProblemTutorFlag() {
        return this.problemTutorFlag;
    }

    public void setProblemTutorFlag(String problemTutorFlag) {
        this.problemTutorFlag = problemTutorFlag;
    }

    public String getProblemOtherFlag() {
        return this.problemOtherFlag;
    }

    public void setProblemOtherFlag(String problemOtherFlag) {
        this.problemOtherFlag = problemOtherFlag;
    }

    @Override
    public boolean logIt(String dsMsg, Date timeStamp) {
        String encoding = "UTF-8";
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Logging it with a Message obj+++++++++++++++" + dsMsg.toString());
        }
        if (this.getServer() == null || this.getServer().getLoggingSupport() == null) {
            return false;
        }
        StreamLogger sLogger = this.getOLILogger();
        DiskLogger dLogger = this.getUpdatedDiskLogger();
        Boolean sLogResult = new Boolean(sLogger == null);
        Boolean dLogResult = new Boolean(dLogger == null);
        if (sLogResult.booleanValue() && dLogResult.booleanValue()) {
            return false;
        }
        ActionLog aLog = this.createActionLog(dsMsg, timeStamp);
        if (sLogger != null) {
            sLogResult = sLogger.logActionLog(aLog);
        }
        if (dLogger != null) {
            dLogResult = dLogger.logActionLog(aLog);
        }
        return sLogResult != null && sLogResult != false && dLogResult != null && dLogResult != false;
    }

    private ActionLog createActionLog(String dsMsg, Date timeStamp) {
        ActionLog actionLog = new ActionLog();
        actionLog.setTimeStamp(timeStamp);
        actionLog.setInfo(dsMsg);
        if (this.getContextMessage() != null) {
            actionLog.setUserGuid(this.getContextMessage().getUserId());
            actionLog.setSessionId(this.getContextMessage().getSessionId());
            actionLog.setTimezone(this.getContextMessage().getTimeZone());
        } else {
            actionLog.setUserGuid(this.getStudentName());
            actionLog.setSessionId(this.getSessionId());
            actionLog.setTimezone(TimeZone.getDefault().toString());
        }
        actionLog.setSourceId(this.getSourceId());
        actionLog.setInfoType(this.getInfoType());
        return actionLog;
    }

    @Override
    public boolean logIt(Message dsMsg, Date timeStamp) {
        OliDatabaseLogger odl;
        String encoding = "UTF-8";
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Logging it with a Message obj+++++++++++++++" + dsMsg.toString());
        }
        StreamLogger sLogger = this.getOLILogger();
        DiskLogger dLogger = this.getUpdatedDiskLogger();
        boolean result = true;
        if (sLogger != null) {
            odl = new OliDatabaseLogger(sLogger, "UTF-8");
            result &= odl.log(dsMsg, timeStamp);
        }
        if (dLogger != null) {
            odl = new OliDiskLogger(dLogger, "UTF-8");
            result &= odl.log(dsMsg, timeStamp);
        }
        return result;
    }

    public StreamLogger getOLILogger() {
        if (this.useOLILogging()) {
            return this.streamLogger;
        }
        return null;
    }

    public DiskLogger getSubstituteDiskLogger() {
        return this.diskLogger;
    }

    public void setSubstituteDiskLogger(DiskLogger logger) {
        this.diskLogger = logger;
    }

    public DiskLogger getUpdatedDiskLogger() {
        if (this.diskLoggingSetup()) {
            return this.diskLogger;
        }
        return null;
    }

    protected void setDiskLogger(DiskLogger diskLogger) {
        this.diskLogger = diskLogger;
    }

    @Override
    public String getLogServiceURL() {
        if (this.getServer() != null && this.getOLILogger() != null) {
            return this.getOLILogger().getURL().toString();
        }
        return null;
    }

    public boolean diskLoggingSetup() {
        Boolean v = this.getUseDiskLogPreference();
        if (v == null) {
            return false;
        }
        PreferencesModel pm = this.getServer().getPreferencesModel();
        if (v.booleanValue() && this.diskLogger == null) {
            String logFileDir = pm.getStringValue("Disk Logging Directory");
            this.startDiskLogging(logFileDir, true);
        } else if (!v.booleanValue() && this.diskLogger != null) {
            this.setDiskLogger(null);
        }
        return v;
    }

    @Override
    public String getUserId() {
        return null;
    }

    @Override
    public String isLogToDiskTrue() {
        Boolean v = this.getUseDiskLogPreference();
        if (v == null) {
            return Boolean.FALSE.toString();
        }
        return v.toString();
    }

    private Boolean getUseDiskLogPreference() {
        PreferencesModel pm = this.getServer().getPreferencesModel();
        if (pm == null) {
            return null;
        }
        return pm.getBooleanValue("Use Disk Logging");
    }

    protected boolean useOLILogging() {
        PreferencesModel pm = this.getServer().getPreferencesModel();
        Boolean v = pm.getBooleanValue("Use OLI Logging");
        if (v == null) {
            return false;
        }
        if (v.booleanValue() && this.streamLogger == null) {
            String loggingURL = pm.getStringValue("OLI Logging URL");
            this.startOLILogging(loggingURL);
        } else if (!v.booleanValue() && this.streamLogger != null) {
            this.streamLogger = null;
        }
        return v;
    }

    protected synchronized void startOLILogging(String loggingURL) {
        try {
            this.streamLogger = new StreamLogger();
            this.streamLogger.setURL(loggingURL);
            this.setSessionChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected synchronized void startDiskLogging(String logFileDir) {
        this.startDiskLogging(logFileDir, false);
    }

    protected synchronized void startDiskLogging(String logFileDir, boolean aboutToWrite) {
        this.logFileDir = logFileDir;
        if (!aboutToWrite) {
            return;
        }
        if (trace.getDebugCode("log")) {
            trace.printStack("log", "START DISK LOGGING");
        }
        try {
            this.setDiskLogger(new DiskLogger());
            if (logFileDir == null || logFileDir.length() < 1) {
                logFileDir = ".";
            } else {
                File dir = new File(logFileDir);
                if (!dir.isDirectory() && !dir.mkdirs()) {
                    Utils.showExceptionOccuredDialog(null, "Cannot create directory " + logFileDir + ": to log to current directory instead", "Warning");
                    logFileDir = ".";
                }
            }
            this.setSessionChanged();
            this.diskLogFile = logFileDir + File.separator + this.getDefaultFilename();
            this.diskLogger.setOutfile(this.diskLogFile);
            this.lastLogFile = this.diskLogFile;
            trace.out("diskLogger = " + this.diskLogger + ", logFileDir " + logFileDir + ", diskLogFile " + this.diskLogFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String isLogToRemoteServerTrue() {
        if (this.getServer() != null && this.useOLILogging()) {
            return "true";
        }
        return "false";
    }

    protected TSLauncherServer getServer() {
        return this.server;
    }

    public void setLogConsole(LogConsole logConsole) {
        this.logConsole = logConsole;
    }
}

