/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.pact.Log.AuthorAction;
import edu.cmu.pact.Log.ProgramAction;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.Logger;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class LoggingSupport
extends Logger
implements PropertyChangeListener {
    private TSLauncherServer server;
    protected String tutorSessionID = "none" + DateFormat.getDateTimeInstance(3, 1).format(new Date());

    public LoggingSupport(TSLauncherServer server) {
        super(server);
        if (server != null) {
            server.setLogger(this);
        }
        this.server = server;
        try {
            if (this.getServer() != null) {
                this.setLoggingUserID(this.getServer().getLogger().getStudentName(), false);
            }
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
    }

    public void setEnableAuthorLog(boolean enableAuthorLog) {
        this.enableAuthorLog = enableAuthorLog;
    }

    public boolean authorActionLog(String toolName, String actionType, String argument, String result, Object resultDetails) {
        if (!this.enableAuthorLog) {
            return true;
        }
        AuthorAction authorAction = new AuthorAction(actionType, argument, result, resultDetails);
        authorAction.setSourceId(toolName);
        return this.oliLog(authorAction);
    }

    public boolean authorActionLog(Class tool, String actionType, String argument, String result, Object resultDetails) {
        return this.authorActionLog(tool.toString(), actionType, argument, result, resultDetails);
    }

    public boolean authorActionLog(AbstractCtatWindow tool, String actionType, String argument, String result, Object resultDetails) {
        return this.authorActionLog(tool.getName() + " " + tool.getTitle(), actionType, argument, result, resultDetails);
    }

    public boolean authorActionLog(String result, Object resultDetails) {
        return this.authorActionLog("", "", "", result, resultDetails);
    }

    public boolean authorActionLog(String tool, String actionType, String argument) {
        return this.authorActionLog(tool, actionType, argument, "", null);
    }

    public boolean authorActionLog(Class tool, String actionType, String argument) {
        return this.authorActionLog(tool, actionType, argument, "", null);
    }

    public boolean authorActionLog(AbstractCtatWindow tool, String actionType, String argument) {
        return this.authorActionLog(tool, actionType, argument, "", null);
    }

    public boolean programActionLog(String toolName, String actionType, String argument, String result, String result2) {
        if (!this.enableAuthorLog) {
            return true;
        }
        ProgramAction programAction = new ProgramAction(actionType, argument, result, result2);
        programAction.setSourceId(toolName);
        return this.oliLog(programAction);
    }

    public void saveFileToAuthorLog(String problemFullName, String actionType) {
        try {
            File file = new File(problemFullName);
            FileReader fr = new FileReader(file);
            char[] fileText = new char[(int)file.length()];
            fr.read(fileText);
            this.authorActionLog("BEHAVIOR_RECORDER", actionType, problemFullName, new String(fileText), (Object)"");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setLoggingUserID(String _userID, boolean restartLogging) {
        if (_userID == null) {
            this.userID = "";
            return;
        }
        restartLogging = restartLogging && !this.userID.equalsIgnoreCase(_userID) && _userID.length() > 0;
        this.userID = _userID;
        if (restartLogging) {
            this.setDiskLogger(null);
        }
    }

    public void setTutorSessionID(String tutorSessionID) {
        this.tutorSessionID = tutorSessionID;
    }

    public String getTutorSessionID() {
        return this.tutorSessionID;
    }

    @Override
    public void setStudentName(String studentName) {
        this.setStudentName(studentName, true);
    }

    public void setStudentName(String studentName, boolean restartLogger) {
        trace.out("log", "set student name: " + studentName);
        super.setStudentName(studentName);
        if (restartLogger) {
            this.setLoggingUserID(studentName, true);
        }
    }

    @Override
    public void setAnonymizedStudentName(String studentName) {
        trace.out("log", "set student name: " + studentName);
        super.setAnonymizedStudentName(studentName);
        this.setLoggingUserID(studentName, true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (trace.getDebugCode("log")) {
            trace.out("log", "propertyChange(" + evt + ")");
        }
        String name = evt.getPropertyName();
        String oldValue = (String)evt.getOldValue();
        String newValue = (String)evt.getNewValue();
        super.propertyChange(evt);
        if ("log_to_disk_directory".equalsIgnoreCase(name)) {
            this.changeDiskLoggingDir(newValue);
        } else if ("auth_token".equalsIgnoreCase(name)) {
            this.setAuthToken(newValue);
        } else if ("session_id".equalsIgnoreCase(name)) {
            this.setSessionId(newValue);
        } else if ("log_service_url".equalsIgnoreCase(name)) {
            this.changeOLILoggingURL(newValue);
        } else if ("Use OLI Logging".equalsIgnoreCase(name)) {
            this.loggingPreferenceOnOff(name, newValue);
        } else if ("Disk Logging Directory".equalsIgnoreCase(name)) {
            this.changeDiskLoggingDir(newValue);
        } else if ("Use Disk Logging".equalsIgnoreCase(name)) {
            this.loggingPreferenceOnOff(name, newValue);
        } else if ("user_guid".equalsIgnoreCase(name)) {
            this.setStudentName(newValue);
        } else if ("school_name".equalsIgnoreCase(name)) {
            this.setSchoolName(newValue);
        } else if ("course_name".equalsIgnoreCase(name)) {
            this.setCourseName(newValue);
        } else if ("unit_name".equalsIgnoreCase(name)) {
            this.setUnitName(newValue);
        } else if ("section_name".equalsIgnoreCase(name)) {
            this.setSectionName(newValue);
        } else if ("enableAuthorLogging".equalsIgnoreCase(name)) {
            this.setEnableAuthorLog(Boolean.parseBoolean(newValue));
        } else if ("study_condition_name".equalsIgnoreCase(name)) {
            this.setStudyConditionNames(newValue);
        }
    }

    private void loggingPreferenceOnOff(String name, String newValue) {
        Boolean nv = Boolean.parseBoolean(newValue);
        if ("Use OLI Logging".equalsIgnoreCase(name)) {
            this.getServer().getPreferencesModel().setBooleanValue("Use OLI Logging", nv);
        } else if ("Use Disk Logging".equalsIgnoreCase(name)) {
            this.getServer().getPreferencesModel().setBooleanValue("Use Disk Logging", nv);
        } else {
            return;
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", name + " now " + (nv != null && nv != false));
        }
    }
}

