/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.old_pact.dormin.MessageObject;
import edu.cmu.old_pact.dormin.MissingParameterException;
import edu.cmu.pact.Log.TutorActionLog;
import edu.cmu.pact.Utilities.OLIMessageObject;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pslc.logging.LogContext;
import edu.cmu.pslc.logging.ToolMessage;
import edu.cmu.pslc.logging.element.EventElement;
import edu.cmu.pslc.logging.element.UiEventElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class OLIMessageConverters {
    private static final String CONV_TO_DELIMITER = "=>";
    public static final String OTHER_MSG_CONV = "OtherMsgConv";
    private final Map mapNative2OLI;
    private final Map mapOLI2Native;
    private final Conv hintConv;
    private final Conv otherMsgConv;

    OLIMessageConverters(Conv otherMsgConv, Conv hintConv, Map mapNative2OLI, Map mapOLI2Native) {
        this.otherMsgConv = otherMsgConv;
        this.hintConv = hintConv;
        this.mapNative2OLI = mapNative2OLI;
        this.mapOLI2Native = mapOLI2Native;
    }

    Map getMapNative2OLI() {
        return this.mapNative2OLI;
    }

    Map getMapOLI2Native() {
        return this.mapOLI2Native;
    }

    Conv getHintConv() {
        return this.hintConv;
    }

    Conv getOtherMsgConv() {
        return this.otherMsgConv;
    }

    protected void initConvMaps(Conv[] conv) {
        this.getMapOLI2Native().put(this.getHintConv().getSemanticEvt().toUpperCase(), this.getHintConv());
        for (int i = 0; i < conv.length; ++i) {
            if (conv[i].getActionEvaluation() == null) {
                this.getMapOLI2Native().put(conv[i].getSemanticEvt().toUpperCase(), conv[i]);
            } else {
                String key = conv[i].getSemanticEvt() + " " + conv[i].getActionEvaluation();
                this.getMapOLI2Native().put(key.toUpperCase(), conv[i]);
            }
            this.getMapNative2OLI().put(conv[i].getCommMsgType().toLowerCase(), conv[i]);
        }
    }

    Conv getNative2OLIConverter(MessageObject mo) {
        String[] ci;
        String convInstructions = mo.getConvertInstructions();
        String messageType = mo.getMessageTypeProperty();
        if (convInstructions != null && (ci = convInstructions.split(CONV_TO_DELIMITER, 2)).length > 1 && ci[0].equalsIgnoreCase(messageType) && ci[1].contains(OTHER_MSG_CONV)) {
            return this.getOtherMsgConv();
        }
        if (messageType == null) {
            return null;
        }
        String key = messageType.toLowerCase();
        Conv result = (Conv)this.getMapNative2OLI().get(key);
        if (result == null) {
            if (trace.getDebugCode("mo")) {
                trace.out("mo", "no OLI mapping for native message type " + messageType);
            }
            result = this.getOtherMsgConv();
        }
        return result;
    }

    public static void setConvertInstructions(MessageObject mo, String messageType, String msgConv) {
        mo.setConvertInstructions(messageType + CONV_TO_DELIMITER + msgConv);
    }

    static abstract class StartProblemConv
    extends Conv {
        protected static final String PROBLEM_NAME = "ProblemName";

        StartProblemConv(String semanticEvt, String actionEvaluation, String commMsgType, LogContext logger) {
            super(semanticEvt, actionEvaluation, commMsgType, null, null, logger);
        }

        @Override
        protected abstract TutorActionLog native2OLI(Vector var1, Vector var2, MessageObject var3, boolean var4, LogContext var5);

        @Override
        protected void OLI2Native(TutorActionLog logMsg, OLIMessageObject mo) {
            super.OLI2Native(logMsg, mo);
            String localProblemName = logMsg.getProblemName();
            mo.setProblemName(localProblemName);
            OLIMessageObject.setProperty(mo, PROBLEM_NAME, localProblemName);
            String s = null;
            s = logMsg.getSchoolName();
            if (null != s) {
                OLIMessageObject.setProperty(mo, "SchoolName", s);
            }
            if (null != (s = logMsg.getCourseName())) {
                OLIMessageObject.setProperty(mo, "CourseName", s);
            }
            if (null != (s = logMsg.getUnitName())) {
                OLIMessageObject.setProperty(mo, "UnitName", s);
            }
            if (null != (s = logMsg.getSectionName())) {
                OLIMessageObject.setProperty(mo, "SectionName", s);
            }
        }
    }

    static class OtherMsgConv
    extends Conv {
        OtherMsgConv(LogContext logger) {
            super("unused1", "unused2", "unused3", null, null, logger);
            trace.printStack();
        }

        @Override
        protected void OLI2Native(TutorActionLog logMsg, OLIMessageObject mo) {
            Iterator it = logMsg.msgPropertiesIterator();
            if (it.hasNext()) {
                Vector<String> pNames = new Vector<String>();
                Vector<Object> pValues = new Vector<Object>();
                do {
                    TutorActionLog.MsgProperty property = (TutorActionLog.MsgProperty)it.next();
                    String name = property.getName();
                    Object value = null;
                    if ("verb".equalsIgnoreCase(name)) {
                        mo.setVerb(property.getStringValue());
                        continue;
                    }
                    value = property.isList() ? new Vector(property.getList()) : property.getStringValue();
                    pNames.add(name);
                    pValues.add(value);
                } while (it.hasNext());
                mo.addParameter("PROPERTYNAMES", pNames);
                mo.addParameter("PROPERTYVALUES", pValues);
            }
        }

        @Override
        protected TutorActionLog native2OLI(Vector propertyNames, Vector propertyValues, MessageObject mo, boolean tutorToTool, LogContext logger) {
            TutorActionLog result = new TutorActionLog("message");
            result.setAttemptId(logger.getContextMessage().getContextMessageId());
            this.populateProperties(propertyNames, propertyValues, mo, result);
            return result;
        }
    }

    static class HintConv
    extends Conv {
        HintConv(String semanticEvt, String actionEvaluation, String commMsgType, LogContext logger) {
            super(semanticEvt, actionEvaluation, commMsgType, "HintsMessage", null, logger);
        }

        static boolean isHintMsg(MessageObject mo) {
            String selection0 = (String)OLIMessageObject.getPropertyElement(mo, "Selection", 0);
            if ("help".equalsIgnoreCase(selection0)) {
                return true;
            }
            if ("hint".equalsIgnoreCase(selection0)) {
                return true;
            }
            if ("NextHintButton".equalsIgnoreCase(selection0)) {
                return true;
            }
            return "PreviousHintButton".equalsIgnoreCase(selection0);
        }

        static boolean isUIEventMsg(MessageObject mo) {
            String selection = (String)OLIMessageObject.getPropertyValue(mo, "MessageType");
            return "Glossary".equalsIgnoreCase(selection) || "CognitiveLoad".equalsIgnoreCase(selection);
        }

        @Override
        protected TutorActionLog native2OLI(Vector propertyNames, Vector propertyValues, MessageObject mo, boolean tutorToTool, LogContext logger) {
            TutorActionLog result = null;
            result = tutorToTool ? new TutorActionLog("tutor_message") : new TutorActionLog("tool_message");
            result.setProblemName(logger.getProblemName());
            result.setAttemptId(logger.getContextMessage().getContextMessageId());
            this.setSemanticEvtId(result.addSemanticEvent(this.getSemanticEvt(), mo.getSemanticEventId(), mo.getLinkedSemanticEventId()));
            this.createEventDesc(propertyNames, propertyValues, result);
            this.populateHintElements(propertyNames, propertyValues, result);
            return result;
        }

        @Override
        protected void OLI2Native(TutorActionLog logMsg, OLIMessageObject mo) {
            if (this.getSemanticEvt().equals("HINT_REQUEST")) {
                this.createPropertyList(logMsg, mo);
                OLIMessageObject.setProperty(mo, "MessageType", "InterfaceAction");
                String action0 = (String)OLIMessageObject.getPropertyElement(mo, "Action", 0);
                if (!"ButtonPressed".equalsIgnoreCase(action0)) {
                    OLIMessageObject.insertPropertyElement(mo, "Action", 0, "ButtonPressed");
                    OLIMessageObject.insertPropertyElement(mo, "Selection", 0, "Hint");
                    OLIMessageObject.insertPropertyElement(mo, "Input", 0, "-1");
                }
                return;
            }
            super.OLI2Native(logMsg, mo);
        }
    }

    static abstract class Conv {
        protected static final String SKILLS_PNAME = "Skills";
        protected static final String RULES_PNAME = "Rules";
        protected static final String INDICATOR_PNAME = "Indicator";
        protected static final String LoadBRD_PNAME = "BRDFilePath";
        private final String semanticEvt;
        private String semanticEvtId = "";
        private String actionEvaluation;
        private final String commMsgType;
        private String advicePname;
        private Boolean tutorToToolRestriction = null;

        protected Conv(String semanticEvt, String actionEvaluation, String commMsgType, String advicePname, Boolean tutorToToolRestriction, LogContext logger) {
            this.semanticEvt = semanticEvt;
            this.setActionEvaluation(actionEvaluation);
            this.commMsgType = commMsgType;
            this.setAdvicePname(advicePname);
            this.setTutorToToolRestriction(tutorToToolRestriction);
        }

        protected abstract TutorActionLog native2OLI(Vector var1, Vector var2, MessageObject var3, boolean var4, LogContext var5);

        protected void populateProperties(Vector propertyNames, Vector propertyValues, MessageObject mo, TutorActionLog result) {
            String verb = mo.getVerb();
            if (verb != null && verb.length() > 0) {
                result.addMsgProperty("verb", verb);
            }
            if (trace.getDebugCode("mo")) {
                trace.out("mo", "propertyNames.size() " + propertyNames.size());
            }
            for (int i = 0; i < propertyNames.size(); ++i) {
                String value;
                String name = (String)propertyNames.get(i);
                String string = value = i < propertyValues.size() ? propertyValues.get(i) : "";
                if (value instanceof List) {
                    result.addMsgProperty(name, (List)((Object)value));
                    continue;
                }
                result.addMsgProperty(name, value.toString());
            }
        }

        protected void populateHintElements(Vector propertyNames, Vector propertyValues, TutorActionLog result) {
            int nAdvices = this.createTutorAdvices(propertyNames, propertyValues, result);
            Integer totalHints = (Integer)OLIMessageObject.getValue(propertyNames, propertyValues, "TotalHintsAvailable");
            Integer currentHintNumber = (Integer)OLIMessageObject.getValue(propertyNames, propertyValues, "CurrentHintNumber");
            if (trace.getDebugCode("mo")) {
                trace.out("mo", "no. advices " + nAdvices + ", totalHints " + totalHints + ", currentHintNo " + currentHintNumber + ", actionEvaluation " + this.getActionEvaluation());
            }
            result.addActionEvaluation(this.getActionEvaluation(), currentHintNumber != null ? currentHintNumber : 1, totalHints != null ? totalHints : nAdvices);
            this.createSkills(propertyNames, propertyValues, result);
        }

        protected void OLI2Native(TutorActionLog logMsg, OLIMessageObject mo) {
            if (this.getSemanticEvt().equals("HINT_REQUEST")) {
                OLIMessageObject.getConvs().getHintConv().OLI2Native(logMsg, mo);
                return;
            }
            this.createPropertyList(logMsg, mo);
        }

        protected void createPropertyList(TutorActionLog logMsg, OLIMessageObject mo) {
            Iterator it;
            Vector<Object> pValues;
            Vector<String> pNames;
            boolean toAddParams = false;
            try {
                pNames = (Vector<String>)mo.getParameter("PROPERTYNAMES");
                pValues = (Vector<Object>)mo.getParameter("PROPERTYVALUES");
            }
            catch (MissingParameterException mpe) {
                pNames = new Vector<String>();
                pValues = new Vector<Object>();
                toAddParams = true;
            }
            mo.setProblemName(logMsg.getProblemName());
            String tid = logMsg.getTransactionId();
            if (tid != null && tid.length() > 0) {
                mo.setTransactionId(tid);
                pNames.add("transaction_id");
                pValues.add(tid);
            }
            if ((it = logMsg.eventDescriptorsIterator()).hasNext()) {
                Vector selections = new Vector();
                Vector actions = new Vector();
                Vector inputs = new Vector();
                do {
                    TutorActionLog.EventDescriptor ed = (TutorActionLog.EventDescriptor)it.next();
                    selections.addAll(OLIMessageObject.makeStringVector(ed.getSelections()));
                    actions.addAll(OLIMessageObject.makeStringVector(ed.getActions()));
                    inputs.addAll(OLIMessageObject.makeStringVector(ed.getInputs()));
                } while (it.hasNext());
                pNames.add("Selection");
                pValues.add(selections);
                pNames.add("Action");
                pValues.add(actions);
                pNames.add("Input");
                pValues.add(inputs);
            }
            it = logMsg.tutorAdvicesIterator();
            if (this.getAdvicePname() != null && it.hasNext()) {
                Serializable advices;
                if (this.getSemanticEvt() != null && this.getSemanticEvt().toLowerCase().contains("hint")) {
                    advices = new Vector();
                    do {
                        ((Vector)advices).add(it.next());
                    } while (it.hasNext());
                    pNames.add(this.getAdvicePname());
                    pValues.add(advices);
                } else {
                    advices = new StringBuffer((String)it.next());
                    while (it.hasNext()) {
                        ((StringBuffer)advices).append(' ').append(it.next());
                    }
                    pNames.add(this.getAdvicePname());
                    pValues.add(((StringBuffer)advices).toString());
                }
            }
            if ((it = logMsg.skillsIterator()).hasNext()) {
                Vector<String> ruleNames = new Vector<String>();
                do {
                    TutorActionLog.Skill skill = (TutorActionLog.Skill)it.next();
                    ruleNames.add(skill.text);
                } while (it.hasNext());
                pNames.add(RULES_PNAME);
                pValues.add(ruleNames);
            }
            boolean messageTypeSet = false;
            it = logMsg.msgPropertiesIterator();
            while (it.hasNext()) {
                TutorActionLog.MsgProperty mp = (TutorActionLog.MsgProperty)it.next();
                String name = mp.getName();
                if ("MessageType".equalsIgnoreCase(name)) {
                    messageTypeSet = true;
                }
                pNames.add(name);
                pValues.add(mp.isList() ? new Vector(mp.getList()) : mp.getStringValue());
            }
            if (!messageTypeSet) {
                pNames.add("MessageType");
                pValues.add(this.getCommMsgType());
            }
            if (toAddParams) {
                mo.addParameter("PROPERTYNAMES", pNames);
                mo.addParameter("PROPERTYVALUES", pValues);
            }
        }

        protected int createSkills(Vector propertyNames, Vector propertyValues, TutorActionLog logMsg) {
            int result = 0;
            Vector rules = (Vector)OLIMessageObject.getValue(propertyNames, propertyValues, RULES_PNAME);
            if (rules != null) {
                Iterator it = rules.iterator();
                while (it.hasNext()) {
                    logMsg.addSkill((String)it.next());
                    ++result;
                }
            }
            return result;
        }

        protected int createTutorAdvices(Vector propertyNames, Vector propertyValues, TutorActionLog logMsg) {
            int totalHints = 0;
            if (this.getAdvicePname() == null) {
                return totalHints;
            }
            Object v = OLIMessageObject.getValue(propertyNames, propertyValues, this.getAdvicePname());
            if (v instanceof Vector) {
                Vector advices = (Vector)v;
                Iterator it = advices.iterator();
                while (it.hasNext()) {
                    logMsg.addTutorAdvice((String)it.next());
                    ++totalHints;
                }
            } else if (v instanceof String) {
                logMsg.addTutorAdvice((String)v);
                ++totalHints;
            }
            return totalHints;
        }

        protected void setAsUIEvent(ToolMessage msg, String id) {
            msg.setEventElement((EventElement)new UiEventElement(id, this.getSemanticEvt()));
        }

        protected void createEventDesc(Vector propertyNames, Vector propertyValues, TutorActionLog logMsg) {
            Vector inputs;
            Vector actions;
            Iterator sit = null;
            Iterator ait = null;
            Iterator iit = null;
            int n = 0;
            Vector selections = (Vector)OLIMessageObject.getValue(propertyNames, propertyValues, "Selection");
            if (selections != null) {
                sit = selections.iterator();
                n = Math.max(n, selections.size());
            }
            if ((actions = (Vector)OLIMessageObject.getValue(propertyNames, propertyValues, "Action")) != null) {
                ait = actions.iterator();
                n = Math.max(n, actions.size());
            }
            if ((inputs = (Vector)OLIMessageObject.getValue(propertyNames, propertyValues, "Input")) != null) {
                iit = inputs.iterator();
                n = Math.max(n, inputs.size());
            }
            for (int i = 0; i < n; ++i) {
                String ac = ait != null && ait.hasNext() ? (String)ait.next() : "";
                String se = sit != null && sit.hasNext() ? (String)sit.next() : "";
                String in = iit != null && iit.hasNext() ? (String)iit.next() : "";
                logMsg.addEventDescriptor(this.getSemanticEvtId(), ac, se, in);
            }
        }

        protected void setActionEvaluation(String actionEvaluation) {
            this.actionEvaluation = actionEvaluation;
        }

        protected String getActionEvaluation() {
            return this.actionEvaluation;
        }

        protected void setAdvicePname(String advicePname) {
            this.advicePname = advicePname;
        }

        protected String getAdvicePname() {
            return this.advicePname;
        }

        protected String getCommMsgType() {
            return this.commMsgType;
        }

        protected String getSemanticEvt() {
            return this.semanticEvt;
        }

        protected void setSemanticEvtId(String semanticEvtId) {
            this.semanticEvtId = semanticEvtId;
        }

        protected String getSemanticEvtId() {
            return this.semanticEvtId;
        }

        protected void setTutorToToolRestriction(Boolean tutorToToolRestriction) {
            this.tutorToToolRestriction = tutorToToolRestriction;
        }

        protected Boolean getTutorToToolRestriction() {
            return this.tutorToToolRestriction;
        }
    }
}

