/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.old_pact.dormin.DorminException;
import edu.cmu.old_pact.dormin.MessageObject;
import edu.cmu.old_pact.dormin.MissingParameterException;
import edu.cmu.old_pact.dormin.ObjectProxy;
import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Log.TutorActionLog;
import edu.cmu.pact.Log.TutorActionLogV4;
import edu.cmu.pact.Utilities.Logger;
import edu.cmu.pact.Utilities.OLIMessageConverters;
import edu.cmu.pact.Utilities.OLIMessageObjectV4;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pslc.logging.LogContext;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;

public class OLIMessageObject
extends MessageObject {
    public static final String PROPERTYNAMES = "PROPERTYNAMES";
    public static final String PROPERTYVALUES = "PROPERTYVALUES";
    public static final String INTERFACE_ACTION = "InterfaceAction";
    public static final String GLOSSARY = "Glossary";
    public static final String COGNITIVE_LOAD = "CognitiveLoad";
    private String problemName = "";
    protected LogContext logger;
    private TutorActionLog logMsg = null;
    private static OLIMessageConverters convs;
    private String originalElementString;

    public OLIMessageConverters.Conv getNative2OLIConverter(MessageObject mo) {
        return OLIMessageObject.getConvs().getNative2OLIConverter(mo);
    }

    public OLIMessageConverters.Conv getOLI2NativeConverter(String oli, String oliEval) {
        if (oli == null || OLIMessageObject.getConvs() == null) {
            return null;
        }
        String key = oli;
        if (oliEval != null) {
            key = key + " " + oliEval;
        }
        key = key.toUpperCase();
        OLIMessageConverters.Conv conv = (OLIMessageConverters.Conv)OLIMessageObject.getConvs().getMapOLI2Native().get(key);
        if (conv == null || conv.getCommMsgType() == null) {
            System.err.println("no native mapping for OLI event " + oli + ", actionEvaluation " + oliEval);
            conv = new ConvV2(oli.toUpperCase(), oliEval, oli, null, null, this.logger);
            OLIMessageObject.getConvs().getMapOLI2Native().put(key, conv);
        }
        return conv;
    }

    protected OLIMessageObject(TutorActionLog logMsg, ObjectProxy top, BR_Controller controller) {
        super(top);
        this.setLogMsg(logMsg);
        this.logger = controller == null ? null : controller.getLogger();
        this.setConvs(this.initConvs(this.logger));
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "creating message object: top proxy = " + top + ", logMsg\n" + (Object)((Object)logMsg));
        }
        this.init();
    }

    public static OLIMessageObject factory(String xmlStr, String dtdVersion, ObjectProxy top, BR_Controller controller) {
        Iterator it = OLIMessageObject.factoryIterator(new StringReader(xmlStr), dtdVersion, top, controller);
        return (OLIMessageObject)((Object)it.next());
    }

    public static Iterator factoryIterator(Reader rdr, String dtdVersion, ObjectProxy top, BR_Controller controller) {
        return new Factory(rdr, dtdVersion, top, controller);
    }

    protected OLIMessageObject(Element elt, ObjectProxy top, BR_Controller controller) {
        this(elt, top, (LogContext)(controller == null ? null : controller.getLogger()));
    }

    protected OLIMessageObject(Element elt, ObjectProxy top, LogContext logger) {
        super(top);
        try {
            this.setLogMsg(this.createTutorActionLog(elt));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setParsingException(new DorminException(e.toString()));
            return;
        }
        this.logger = logger;
        this.setConvs(this.initConvs(logger));
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "creating message object: element = " + elt + ", top proxy = " + top);
        }
        this.init();
    }

    protected TutorActionLog createTutorActionLog(Element elt) {
        return new TutorActionLog(elt, null);
    }

    public OLIMessageObject(MessageObject mo, boolean tutorToTool, BR_Controller controller) {
        this(mo, tutorToTool, (LogContext)controller.getLogger());
    }

    public OLIMessageObject(MessageObject mo, boolean tutorToTool, LogContext logger) {
        super(mo.toString(), mo.getTopProxy());
        this.logger = logger;
        this.setConvs(this.initConvs(logger));
        Vector propertyNames = null;
        Vector propertyValues = null;
        try {
            propertyNames = mo.extractListValue(PROPERTYNAMES);
            propertyValues = mo.extractListValue(PROPERTYVALUES);
        }
        catch (DorminException e) {
            e.printStackTrace();
            this.setParsingException(e);
            return;
        }
        this.setSemanticEventId(mo.getSemanticEventId());
        this.setLinkedSemanticEventId(mo.getLinkedSemanticEventId());
        OLIMessageConverters.Conv conv = this.getNative2OLIConverter(mo);
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "messageType " + mo.getMessageTypeProperty() + ", conv " + conv + ", linkedSemanticEventId " + mo.getLinkedSemanticEventId());
        }
        this.setLogMsg(conv.native2OLI(propertyNames, propertyValues, mo, tutorToTool, logger));
        this.setUserId(logger.getStudentName());
        this.setSessionId(logger.getSessionId());
        this.getLogMsg().setSourceId(logger.getSourceId());
    }

    protected OLIMessageObject(String xmlStr, String dtdVersion, ObjectProxy top, LogContext logger) {
        super(top);
        try {
            this.setLogMsg(TutorActionLog.factory(xmlStr, dtdVersion, null));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setParsingException(new DorminException(e.toString()));
            return;
        }
        this.logger = logger;
        this.setConvs(this.initConvs(logger));
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "creating message object: String " + xmlStr + "\n top proxy = " + top);
        }
        this.init();
    }

    private void init() {
        OLIMessageConverters.Conv conv = null;
        Iterator it = this.getLogMsg().semanticEventsIterator();
        if (it.hasNext()) {
            TutorActionLog.SemanticEvent se = (TutorActionLog.SemanticEvent)it.next();
            if (se != null) {
                this.setSemanticEventId(se.getId());
                this.setLinkedSemanticEventId(se.getLinkedEventId());
            }
            if ((it = this.getLogMsg().actionEvaluationsIterator()).hasNext()) {
                TutorActionLog.ActionEvaluation ae = (TutorActionLog.ActionEvaluation)it.next();
                conv = this.getOLI2NativeConverter(se.getName(), ae.getText());
            } else {
                conv = this.getOLI2NativeConverter(se.getName(), null);
            }
        } else {
            conv = OLIMessageObject.getConvs().getOtherMsgConv();
        }
        if (conv != null) {
            if (trace.getDebugCode("log")) {
                trace.out("log", "OLIMsgObj.init(): getLogMsg() " + (this.getLogMsg() == null ? "null" : ((Object)((Object)this.getLogMsg())).getClass()) + ", conv " + conv.getClass());
            }
            conv.OLI2Native(this.getLogMsg(), this);
        }
    }

    public ActionLog getLogObject() {
        if (this.getLogMsg() != null) {
            this.getLogMsg().setInfo(this.toXML());
        }
        return this.getLogMsg();
    }

    public String toXML() {
        if (this.getLogMsg() == null) {
            return "";
        }
        return this.getLogMsg().toString();
    }

    public String getProblemName() {
        return this.problemName;
    }

    void setProblemName(String newProblemName) {
        this.problemName = newProblemName;
    }

    public static Vector makeStringVector(List list) {
        Vector<String> result = new Vector<String>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            result.add(((TutorActionLog.TextIsString)it.next()).toString());
        }
        if (result.size() < 1) {
            result.add("");
        }
        return result;
    }

    public String getUserId() {
        return this.getLogMsg().getUserGuid();
    }

    public void setUserId(String userId) {
        this.getLogMsg().setUserGuid(userId);
    }

    public String getSessionId() {
        return this.getLogMsg().getSessionId();
    }

    public void setSessionId(String sessionId) {
        this.getLogMsg().setSessionId(sessionId);
    }

    public Date getTimeStamp() {
        return this.getLogMsg().getTimeStamp();
    }

    public void setTimeStamp(Date timeStamp) {
        this.getLogMsg().setTimeStamp(timeStamp);
    }

    public static String initialCapital(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        StringBuffer result = new StringBuffer(s.toLowerCase());
        result.replace(0, 1, s.substring(0, 1).toUpperCase());
        return s.toString();
    }

    public static Object getPropertyValue(MessageObject mo, String propertyName) {
        int pIndex = -1;
        Object propertyValue = null;
        try {
            Vector pNames = (Vector)mo.getParameter(PROPERTYNAMES);
            Vector pValues = (Vector)mo.getParameter(PROPERTYVALUES);
            pIndex = pNames.indexOf(propertyName);
            if (pIndex < 0) {
                return null;
            }
            return pValues.get(pIndex);
        }
        catch (MissingParameterException mpe) {
            RuntimeException re = new RuntimeException(((Object)((Object)mpe)).getClass().getName() + ": " + mpe.getMessage());
            re.setStackTrace(mpe.getStackTrace());
            throw re;
        }
        catch (ArrayIndexOutOfBoundsException obe) {
            RuntimeException re = new RuntimeException("Comm msg property list error: name index " + pIndex + " not in values list; " + obe.getMessage());
            re.setStackTrace(obe.getStackTrace());
            throw re;
        }
    }

    public static Object getPropertyElement(MessageObject mo, String propertyName, int index) {
        Object propertyValue = OLIMessageObject.getPropertyValue(mo, propertyName);
        if (!(propertyValue instanceof List)) {
            return null;
        }
        List v = (List)propertyValue;
        if (index < 0 || v.size() <= index) {
            return null;
        }
        return v.get(index);
    }

    public static void insertPropertyElement(MessageObject mo, String propertyName, int index, String elementValue) {
        Object propertyValue = OLIMessageObject.getPropertyValue(mo, propertyName);
        if (!(propertyValue instanceof List)) {
            return;
        }
        List v = (List)propertyValue;
        v.add(index, elementValue);
    }

    public static void setProperty(MessageObject mo, String propertyName, Object propertyValue) {
        int pIndex = -1;
        try {
            Vector pNames = (Vector)mo.getParameter(PROPERTYNAMES);
            Vector pValues = (Vector)mo.getParameter(PROPERTYVALUES);
            pIndex = pNames.indexOf(propertyName);
            if (pIndex < 0) {
                pNames.add(propertyName);
                pValues.add(propertyValue);
            } else {
                pValues.set(pIndex, propertyValue);
            }
        }
        catch (MissingParameterException mpe) {
            RuntimeException re = new RuntimeException(((Object)((Object)mpe)).getClass().getName() + ": " + mpe.getMessage());
            re.setStackTrace(mpe.getStackTrace());
            throw re;
        }
    }

    public static Object getValue(Vector propertyNames, Vector propertyValues, String propertyName) {
        int pos = OLIMessageObject.fieldPosition(propertyNames, propertyName);
        if (pos != -1) {
            return propertyValues.elementAt(pos);
        }
        return null;
    }

    public static int fieldPosition(Vector from, String fieldName) {
        int result = -1;
        int s = from.size();
        for (int i = 0; i < s; ++i) {
            if (!((String)from.elementAt(i)).equalsIgnoreCase(fieldName)) continue;
            return i;
        }
        return result;
    }

    public String getDefaultSessionID() {
        return this.logger.getSessionId();
    }

    public static String generateGUID() {
        return Logger.generateGUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OLIMessageConverters initConvs(LogContext logger) {
        if (logger == null) {
            return null;
        }
        LogContext logContext = logger;
        synchronized (logContext) {
            TutorActionLog msg = this.getLogMsg();
            if (OLIMessageObject.getConvs() == null) {
                this.setConvs(new ConvertersV2(logger));
            }
            return OLIMessageObject.getConvs();
        }
    }

    protected void setLogMsg(TutorActionLog logMsg) {
        this.logMsg = logMsg;
    }

    protected TutorActionLog getLogMsg() {
        return this.logMsg;
    }

    protected static OLIMessageConverters getConvs() {
        return convs;
    }

    protected void setConvs(OLIMessageConverters convs) {
        OLIMessageObject.convs = convs;
    }

    public void setOriginalElementString(String eltStr) {
        this.originalElementString = eltStr;
    }

    public String getOriginalElementString() {
        return this.originalElementString;
    }

    static class ConvertersV2
    extends OLIMessageConverters {
        ConvertersV2(LogContext logger) {
            super(new OLIMessageConverters.OtherMsgConv(logger), new OLIMessageConverters.HintConv("HINT_REQUEST", null, OLIMessageObject.INTERFACE_ACTION, logger), new HashMap(), new HashMap());
            Boolean F = Boolean.FALSE;
            Boolean T = Boolean.TRUE;
            OLIMessageConverters.Conv[] conv = new OLIMessageConverters.Conv[]{new ConvV2("ATTEMPT", null, OLIMessageObject.INTERFACE_ACTION, null, F, logger), new ConvV2("RESULT", "CORRECT", "CorrectAction", "SuccessMsg", T, logger), new ConvV2("RESULT", "INCORRECT", "IncorrectAction", "BuggyMsg", T, logger), new ConvV2("RESULT", "CORRECT", "SuccessMessage", "SuccessMsg", T, logger), new ConvV2("RESULT", "INCORRECT", "BuggyMessage", "BuggyMsg", T, logger), new ConvV2("RESULT", "INCORRECT", "NotDoneMessage", "Message", T, logger), new SkillsConvV2("RESULT", null, "AssociatedRules", logger), new StartProblemConvV2("START_TUTOR", null, "StartProblem", logger), new StartProblemConvV2("START_PROBLEM", null, "StartProblem", logger), new OLIMessageConverters.HintConv("HINT_MSG", "HINT", "ShowHintsMessage", logger), new LoadBRDConvV2("START_TUTOR", null, "LoadBRDFileSuccess", logger)};
            this.initConvMaps(conv);
        }
    }

    private static class Factory
    implements Iterator {
        private Iterator iterator;
        private ObjectProxy top;
        private BR_Controller controller;

        private Factory(Reader rdr, String dtdVersion, ObjectProxy top, BR_Controller controller) {
            this.top = top;
            this.controller = controller;
            this.iterator = TutorActionLog.factoryIterator(rdr, dtdVersion, null);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            TutorActionLog logMsg = (TutorActionLog)((Object)this.iterator.next());
            if (trace.getDebugCode("log")) {
                trace.out("log", "OLIMessageObject.Factory.next(): logMsg class " + ((Object)((Object)logMsg)).getClass());
            }
            if (logMsg instanceof TutorActionLogV4) {
                return new OLIMessageObjectV4(logMsg, this.top, this.controller);
            }
            return new OLIMessageObject(logMsg, this.top, this.controller);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove");
        }
    }

    static class ConvV2
    extends OLIMessageConverters.Conv {
        public ConvV2(String semanticEvt, String actionEvaluation, String commMsgType, String advicePname, Boolean tutorToToolRestriction, LogContext logger) {
            super(semanticEvt, actionEvaluation, commMsgType, advicePname, tutorToToolRestriction, logger);
        }

        protected TutorActionLog getTutorLogMessage() {
            return new TutorActionLog("tutor_message");
        }

        @Override
        protected TutorActionLog native2OLI(Vector propertyNames, Vector propertyValues, MessageObject mo, boolean tutorToTool, LogContext logger) {
            OLIMessageConverters convs = OLIMessageObject.getConvs();
            if (OLIMessageConverters.HintConv.isHintMsg(mo)) {
                return convs.getHintConv().native2OLI(propertyNames, propertyValues, mo, tutorToTool, logger);
            }
            if (this.getTutorToToolRestriction() != null && this.getTutorToToolRestriction() != tutorToTool) {
                return convs.getOtherMsgConv().native2OLI(propertyNames, propertyValues, mo, tutorToTool, logger);
            }
            TutorActionLog result = null;
            result = tutorToTool ? new TutorActionLog("tutor_message") : new TutorActionLog("tool_message");
            result.setProblemName(logger.getProblemName());
            result.setAttemptId(logger.getContextMessage().getContextMessageId());
            this.setSemanticEvtId(result.addSemanticEvent(this.getSemanticEvt(), mo.getSemanticEventId(), mo.getLinkedSemanticEventId()));
            if (this.getActionEvaluation() != null) {
                result.addActionEvaluation(this.getActionEvaluation());
            }
            this.createEventDesc(propertyNames, propertyValues, result);
            this.createTutorAdvices(propertyNames, propertyValues, result);
            this.createSkills(propertyNames, propertyValues, result);
            return result;
        }
    }

    static class LoadBRDConvV2
    extends ConvV2 {
        public LoadBRDConvV2(String semanticEvt, String actionEvaluation, String commMsgType, LogContext logger) {
            super(semanticEvt, actionEvaluation, commMsgType, null, null, logger);
        }

        @Override
        protected TutorActionLog native2OLI(Vector propertyNames, Vector propertyValues, MessageObject mo, boolean tutorToTool, LogContext logger) {
            TutorActionLog result = super.native2OLI(propertyNames, propertyValues, mo, tutorToTool, logger);
            result.setAttemptId(logger.getContextMessage().getContextMessageId());
            String localProblemName = (String)OLIMessageObject.getValue(propertyNames, propertyValues, "BRDFilePath");
            result.setProblemName(localProblemName);
            result.addEventDescriptor(this.getSemanticEvtId(), "", localProblemName, "");
            return result;
        }

        @Override
        protected void OLI2Native(TutorActionLog logMsg, OLIMessageObject mo) {
            super.OLI2Native(logMsg, mo);
            String localProblemName = logMsg.getSelectionText(0);
            mo.setProblemName(localProblemName);
            OLIMessageObject.setProperty(mo, "BRDFilePath", localProblemName);
        }
    }

    static class SkillsConvV2
    extends ConvV2 {
        SkillsConvV2(String semanticEvt, String actionEvaluation, String commMsgType, LogContext logger) {
            super(semanticEvt, actionEvaluation, commMsgType, null, null, logger);
        }

        @Override
        protected TutorActionLog native2OLI(Vector propertyNames, Vector propertyValues, MessageObject mo, boolean tutorToTool, LogContext logger) {
            TutorActionLog result = super.native2OLI(propertyNames, propertyValues, mo, tutorToTool, logger);
            String indicator = (String)OLIMessageObject.getValue(propertyNames, propertyValues, "Indicator");
            if (indicator != null) {
                result.addActionEvaluation(indicator.toUpperCase());
            }
            return result;
        }

        @Override
        protected void OLI2Native(TutorActionLog logMsg, OLIMessageObject mo) {
            TutorActionLog.ActionEvaluation ae;
            String indicator;
            super.OLI2Native(logMsg, mo);
            Iterator it = logMsg.actionEvaluationsIterator();
            if (it.hasNext() && (indicator = OLIMessageObject.initialCapital((ae = (TutorActionLog.ActionEvaluation)it.next()).getText())).length() > 0) {
                OLIMessageObject.setProperty(mo, "Indicator", indicator);
            }
            it = logMsg.skillsIterator();
            Vector<String> ruleNames = new Vector<String>();
            if (it.hasNext()) {
                do {
                    TutorActionLog.Skill skill = (TutorActionLog.Skill)it.next();
                    ruleNames.add(skill.text);
                } while (it.hasNext());
            }
            if (ruleNames.size() > 0) {
                mo.setProperty("Rules", ruleNames);
            }
        }
    }

    static class StartProblemConvV2
    extends OLIMessageConverters.StartProblemConv {
        StartProblemConvV2(String semanticEvt, String actionEvaluation, String commMsgType, LogContext logger) {
            super(semanticEvt, actionEvaluation, commMsgType, logger);
        }

        protected TutorActionLog createTutorActionLogInstance(LogContext logger) {
            logger.resetAttemptId();
            return new TutorActionLog("curriculum_message");
        }

        @Override
        protected TutorActionLog native2OLI(Vector propertyNames, Vector propertyValues, MessageObject mo, boolean tutorToTool, LogContext logger) {
            String section;
            String unit;
            String course;
            TutorActionLog result = this.createTutorActionLogInstance(logger);
            Object pnObj = OLIMessageObject.getValue(propertyNames, propertyValues, "ProblemName");
            String localProblemName = pnObj == null ? "null" : pnObj.toString();
            result.setProblemName(localProblemName);
            result.setAttemptId(logger.getContextMessage().getContextMessageId());
            String school = (String)OLIMessageObject.getValue(propertyNames, propertyValues, "SchoolName");
            if (school == null) {
                school = logger.getSchoolName();
            }
            if (school != null) {
                result.setSchoolName(school);
            }
            if ((course = (String)OLIMessageObject.getValue(propertyNames, propertyValues, "CourseName")) == null) {
                course = logger.getCourseName();
            }
            if (course != null) {
                result.setCourseName(course);
            }
            if ((unit = (String)OLIMessageObject.getValue(propertyNames, propertyValues, "UnitName")) == null) {
                unit = logger.getUnitName();
            }
            if (unit != null) {
                result.setUnitName(unit);
            }
            if ((section = (String)OLIMessageObject.getValue(propertyNames, propertyValues, "SectionName")) == null) {
                section = logger.getSectionName();
            }
            if (section != null) {
                result.setSectionName(section);
            }
            return result;
        }
    }
}

