/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.pact.Utilities.trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;

public class SocketReader {
    private static final int MAX_MSG_LEN = 0x300000;

    public static String readToEom(Reader rdr, int eom) throws IOException {
        int c;
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "entering readToEom...");
        }
        StringWriter result = new StringWriter(4096);
        int count = 0;
        while (count < 0x300000 && 0 <= (c = rdr.read())) {
            if (c == eom) {
                if (count > 0) break;
                trace.err("SocketReader.readToEom(" + eom + "): EOM without preceding msg ignored");
                continue;
            }
            ++count;
            if (c == 13 && trace.getDebugCode("sp")) {
                trace.out("sp", "CR return is found at offset " + count);
            }
            result.write(c);
        }
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "readToEom(" + eom + ") len " + count + ": " + result);
        }
        if (count >= 0x300000) {
            trace.err("SocketReader.readToEom(" + eom + ") count " + count + ": max buffer length reached");
        }
        return result.toString();
    }

    public static String readAll(Reader rdr) throws IOException {
        int len;
        StringWriter result = new StringWriter(4096);
        char[] cbuf = new char[4096];
        for (int totalLen = 0; totalLen < 0x300000 && 0 <= (len = rdr.read(cbuf, 0, cbuf.length)); totalLen += len) {
            result.write(cbuf, 0, len);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendString(String str, PrintWriter out, int eom) {
        if (out == null) {
            return;
        }
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            out.print(str);
            if (eom >= 0) {
                out.write(eom);
            }
            out.flush();
        }
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "SocketTP.sendString() success: sent to " + out);
        }
    }
}

