/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class Utils {
    private static AlertDialog alertDialog = null;
    public static final int DEFAULT_SERVER_PORT = 1500;
    public static final int DEFAULT_LAUNCHER_COMM_PORT = 1503;
    public static final String DEFAULT_CLIENT_HOST = "localhost";
    public static final int DEFAULT_CLIENT_PORT = 1501;
    public static final String INTERFACE_HOME_PROPERTY = "studentInterface.url";
    private static Pattern propRefPattern = Pattern.compile("\\$\\{[a-zA-Z_][a-zA-Z_0-9.]*\\}");
    private static final Pattern whiteSpace = Pattern.compile("\\s+");
    private static Utils instance = new Utils();
    private static FilesBeforeDirs filesBeforeDirs = new FilesBeforeDirs();
    private static boolean runtime = false;
    private static boolean suppressDialogs = false;
    private static final Pattern HasHtmlMarkup = Pattern.compile("(\\s*<?[^>]+?>)?\\s*<[hH][tT][mM][lL].*(</[hH][tT][mM][lL]>\\s*)");

    Utils() {
    }

    public static Set differenceOfSets(Set m, Set s) {
        HashSet d = new HashSet();
        for (Object elt : m) {
            System.out.println("elt " + elt + ", in s " + s.contains(elt));
            if (s.contains(elt)) continue;
            d.add(elt);
        }
        System.out.println("d " + ((Object)d).toString());
        return d;
    }

    public static String expandPropertyReferences(String s) {
        Matcher m = propRefPattern.matcher(s);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String propRef = m.group();
            String propName = propRef.substring(2, propRef.length() - 1);
            String propValue = System.getProperty(propName, "");
            m.appendReplacement(result, "");
            result.append(propValue);
        }
        m.appendTail(result);
        return result.toString();
    }

    public static URL getCodeBaseURL(Class cls) {
        try {
            String pkgName = cls.getPackage().getName();
            String path = pkgName.replace('.', '/');
            return Utils.getCodeBaseURL(path);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static URL getCodeBaseURL() {
        String pkgName = instance.getClass().getPackage().getName();
        String path = pkgName.replace('.', '/');
        return Utils.getCodeBaseURL(path);
    }

    public static URL getCodeBaseURL(String path) {
        URL url = instance.getClass().getResource("/" + path);
        if (trace.getDebugCode("util")) {
            trace.out("util", "url = " + url);
        }
        if (trace.getDebugCode("util")) {
            trace.out("util", "*******   path=" + path + ", url=" + (url == null ? "" : url.toExternalForm()) + ";");
        }
        if (url == null) {
            return null;
        }
        String urlStr = url.toExternalForm();
        int len = urlStr.lastIndexOf(path);
        if (len < 0) {
            return url;
        }
        try {
            return new URL(urlStr.substring(0, len));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
    }

    public static URL resolveToInterfaceHomeURL(String projectsStr) {
        String interfaceHome = System.getProperty(INTERFACE_HOME_PROPERTY);
        if (interfaceHome == null) {
            interfaceHome = "file:" + System.getProperty("user.dir");
        }
        StringBuffer urlStr = new StringBuffer(interfaceHome);
        if (!(interfaceHome.endsWith("/") || projectsStr != null && projectsStr.startsWith("/"))) {
            urlStr.append("/");
        }
        if (projectsStr != null) {
            urlStr.append(projectsStr);
        }
        if (trace.getDebugCode("util")) {
            trace.out("util", "projectsStr " + projectsStr + ", urlStr " + urlStr + " interface home = " + interfaceHome);
        }
        try {
            URL url = new URL(urlStr.toString());
            return url;
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
    }

    public static File resolveToInterfaceHomeFile(String path) {
        File file;
        trace.out("util", "resolveToInterfaceHomeFile path = " + path);
        if (path != null && path.length() > 0 && (file = new File(path)).isAbsolute()) {
            return file;
        }
        URL url = Utils.resolveToInterfaceHomeURL(path);
        if (trace.getDebugCode("util")) {
            trace.out("util", "path " + path + ", url " + url + ";");
        }
        if (url == null) {
            return null;
        }
        File file2 = Utils.getFileAsResource(url);
        return file2;
    }

    public static File getFileAsResource(String path, Object obj) {
        int be;
        if (path == null || path.length() < 1) {
            return null;
        }
        URL url = Utils.getURL(path, obj);
        if (url != null) {
            return Utils.getFileAsResource(url);
        }
        int bs = path.length();
        for (be = bs - 1; bs > 0 && be == (bs = path.lastIndexOf(47, be)); --be) {
        }
        if (bs < 0 || path.length() <= bs + 1 || be < bs) {
            return null;
        }
        String baseName = path.substring(bs + 1, be + 1);
        String parentPath = path.substring(0, bs + 1);
        File parent = Utils.getFileAsResource(parentPath, obj);
        if (parent == null) {
            return null;
        }
        File f = new File(parent, baseName);
        return f;
    }

    public static File getFileAsResource(URL url) {
        try {
            if (url == null) {
                return null;
            }
            String absolutePath = URLDecoder.decode(url.getFile(), "UTF-8");
            url = null;
            if (trace.getDebugCode("util")) {
                trace.out("util", "getFileAsResource absolutePath " + absolutePath);
            }
            if (absolutePath == null) {
                return null;
            }
            return new File(absolutePath);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL getFileInSamePackage(Object obj, String filename) {
        Class<?> cls = obj.getClass();
        String path = cls.getPackage().getName().replace('.', '/');
        String name = path + "/" + filename;
        URL result = Utils.getURL(name, obj);
        return result;
    }

    public static URL getURL(String path, Object obj) {
        String prefix = System.getProperty("java.vendor", "Sun").toLowerCase().contains("android") ? "/assets/" : "/";
        URL url = obj.getClass().getResource(prefix + path);
        if (trace.getDebugCode("util")) {
            trace.out("util", "getURL url " + url + ", path " + prefix + path);
        }
        return url;
    }

    public static void invokeBrowser(String url) {
        boolean isWinDowPlatform;
        String cmd = "";
        Runtime rt = Runtime.getRuntime();
        String os = System.getProperty("os.name");
        if (os == null) {
            return;
        }
        if (os.toUpperCase().startsWith("WINDOWS")) {
            isWinDowPlatform = true;
        } else if (os.toUpperCase().startsWith("MAC")) {
            isWinDowPlatform = false;
        } else {
            trace.err("Unsupported system platform " + os);
            return;
        }
        try {
            cmd = isWinDowPlatform ? "rundll32 url.dll,FileProtocolHandler " + url : "open " + url;
            if (trace.getDebugCode("util")) {
                trace.out("util", "to exec '" + cmd + "'");
            }
            rt.exec(cmd);
        }
        catch (IOException ex) {
            System.err.println("Could not invoke browser, command=" + cmd);
        }
    }

    public static void setNativeLookAndFeel() {
        String nativeLF = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDirectory(String path) {
        String dir = null;
        try {
            File file = new File(path);
            if (file.exists()) {
                dir = file.isDirectory() ? file.getPath() : (file.getParent() != null ? file.getParent() : ".");
            }
        }
        catch (Exception e) {
            trace.err("Error parsing path \"" + path + "\" as File: " + e);
            try {
                URI uri = new URI(path);
                uri = uri.normalize();
                if (uri.toString().endsWith("/")) {
                    StringBuffer sb = new StringBuffer(uri.toString());
                    do {
                        sb.deleteCharAt(sb.length() - 1);
                    } while (sb.length() > 1 && sb.charAt(sb.length() - 1) == '/');
                    dir = sb.toString();
                } else {
                    int lastSlash = uri.toString().lastIndexOf(47);
                    dir = lastSlash > 0 ? uri.toString().substring(0, lastSlash) : uri.toString();
                }
            }
            catch (Exception ee) {
                trace.err("Error parsing path \"+path+\" as URI: " + ee);
                ee.printStackTrace();
            }
        }
        return dir;
    }

    public static String getBaseName(String fullName) {
        return Utils.getBaseName(fullName, true);
    }

    public static String getBaseName(String fullName, boolean deleteExtension) {
        File file;
        try {
            URL url = new URL(fullName);
            file = Utils.getFileAsResource(url);
        }
        catch (Exception e) {
            file = null;
        }
        try {
            if (file == null) {
                file = new File(fullName);
            }
        }
        catch (Exception e) {
            trace.err("Utils.getBaseName(): Unable to create file object for " + fullName + ": " + e);
            return fullName;
        }
        String result = file.getName();
        int dot = result.lastIndexOf(46);
        if (deleteExtension && dot > 0) {
            result = result.substring(0, dot);
        }
        return result;
    }

    public static String getSimpleName(String fullClassName) {
        int dot = fullClassName.lastIndexOf(46);
        if (dot > 0) {
            return fullClassName.substring(dot + 1);
        }
        return fullClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyToTempFile(File inf) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        File result = null;
        try {
            if (inf == null) {
                throw new IOException("source file reference is null");
            }
            long infLength = inf.length();
            if (infLength > Integer.MAX_VALUE) {
                throw new IOException("source file " + inf.getName() + ", length " + infLength + ", exceeds max size for copying");
            }
            byte[] infBytes = new byte[(int)infLength];
            is = new FileInputStream(inf);
            is.read(infBytes);
            result = File.createTempFile(inf.getName(), ".tmp");
            os = new FileOutputStream(result);
            os.write(infBytes);
            File file = result;
            return file;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String cleanup(String s) {
        Matcher m = whiteSpace.matcher(s);
        return m.replaceAll(" ");
    }

    public static String replaceImg(String message) {
        StringBuffer messageBuffer = new StringBuffer(message);
        Pattern pattern = Pattern.compile("<\\s*img.*src\\s*=[^>]*");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            String imgPath = message.substring(matcher.start(), matcher.end());
            int start = matcher.start();
            pattern = Pattern.compile("\".*\"");
            matcher = pattern.matcher(imgPath);
            if (matcher.find()) {
                int imgStart = start + matcher.start();
                int end = imgStart + matcher.end();
                String tempStr = matcher.group();
                URL url = Utils.class.getResource(tempStr = tempStr.replaceAll("\"", ""));
                if (url != null) {
                    messageBuffer.replace(imgStart, end, url.toString());
                }
            }
        }
        return messageBuffer.toString();
    }

    public static long sleep(long ms) {
        if (ms < 1L) {
            return ms;
        }
        long now = System.currentTimeMillis();
        long then = now + ms;
        do {
            try {
                Thread.sleep(then - now);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((now = System.currentTimeMillis()) < then);
        return ms + now - then;
    }

    public static String upperCaseInitials(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s);
        boolean upperCaseNext = true;
        for (int i = 0; i < sb.length(); ++i) {
            if (upperCaseNext) {
                sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
                upperCaseNext = false;
            }
            if (Character.isLetterOrDigit(sb.charAt(i))) continue;
            upperCaseNext = true;
        }
        return sb.toString();
    }

    public static String listToHtmlTbl(Collection<Object> items, int nCols) {
        if (items.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<table border=\"0\" cellpadding=\"1\">");
        int i = 0;
        for (Object item : items) {
            if (item == null || item.toString().length() < 1) continue;
            if (i > 0) {
                sb.append(",</td>");
            }
            if (i % nCols == 0) {
                if (i > 0) {
                    sb.append("</tr>");
                }
                sb.append("<tr>");
            }
            sb.append("<td>&nbsp;").append(item.toString());
            ++i;
        }
        sb.append("</td>");
        while (i++ % nCols != 0) {
            sb.append("<td>&nbsp;</td>");
        }
        sb.append("</tr></table>");
        return sb.toString();
    }

    public static List<File> findFiles(File fi, FileFilter filter) {
        ArrayList<File> result = new ArrayList<File>();
        Utils.findFiles(fi, filter, result);
        return result;
    }

    private static void findFiles(File fi, FileFilter filter, List<File> result) {
        if (!fi.exists()) {
            return;
        }
        if (!fi.isDirectory()) {
            if (filter == null || filter.accept(fi)) {
                result.add(fi);
            }
            return;
        }
        File[] files = fi.listFiles();
        Arrays.sort(files, filesBeforeDirs);
        for (File cfi : files) {
            Utils.findFiles(cfi, filter, result);
        }
    }

    public static AlertDialog getAlertDialog() {
        return alertDialog;
    }

    public static void setAlertDialog(AlertDialog alertDialog) {
        Utils.alertDialog = alertDialog;
    }

    public static void showExceptionOccuredDialog(Exception e1, String message, String title) {
        Utils.showExceptionOccuredDialog(e1, message, title, 350, 200);
    }

    public static void showExceptionOccuredDialog(Exception e1, String message, String title, int width, int height) {
        if (Utils.isRuntime() || Utils.getSuppressDialogs()) {
            if (e1 != null) {
                trace.errStack("Utils.showExceptionOccurredDialog " + title + ":\n  " + message, e1);
            } else {
                trace.err("Utils.showExceptionOccurredDialog " + title + ":\n  " + message);
            }
            return;
        }
        if (trace.getDebugCode("android")) {
            trace.outNT("android", "showExceptionOccuredDialog(" + e1 + "," + message + "," + title + ") alertDialog " + alertDialog);
        }
        if (alertDialog != null) {
            alertDialog.showMessage(e1, message, title);
        } else {
            Utils.showExceptionInternal(e1, message, title, width, height);
        }
    }

    public static boolean isDirectoryReadable(String path, Object obj) {
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "MT.isDirectoryReadable(" + path + ")");
        }
        if (path == null || path.length() < 1) {
            return false;
        }
        File f = new File(path);
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "MT.isDirectoryReadable() file result " + f);
        }
        if (f != null && f.exists()) {
            return f.isDirectory() && f.canRead();
        }
        File result = Utils.getFileAsResource(path, obj);
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "MT.isDirectoryReadable() fileAsResource result " + result);
        }
        if (null != result && result.exists()) {
            return result.isDirectory() && result.canRead();
        }
        URL url = null;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        try {
            url = new URL(path);
            InputStream is = url.openStream();
            is.close();
            if (trace.getDebugCode("")) {
                trace.out("mt", "MT.isDirectoryReadable() URL result " + url);
            }
            return true;
        }
        catch (Exception e) {
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "MT.isDirectoryReadable() error reading \"" + path + "\" as URL: " + e + "; cause " + e.getCause());
            }
            try {
                url = Utils.getURL(path, obj);
                if (url == null) {
                    return false;
                }
                InputStream is = url.openStream();
                is.close();
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "MT.isDirectoryReadable() getURL result " + url);
                }
                return true;
            }
            catch (Exception e2) {
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "MT.isDirectoryReadable() error reading \"" + path + "\" as URL: " + e2 + "; cause " + e2.getCause());
                }
                return false;
            }
        }
    }

    private static void showExceptionInternal(Exception e1, String message, String title, int width, int height) {
        boolean html = false;
        String msgLC = message.toLowerCase();
        String endTag = "";
        if (msgLC.trim().startsWith("<html")) {
            html = true;
            int h = msgLC.lastIndexOf("</html>");
            if (h > 0) {
                endTag = message.substring(h);
                message = message.substring(0, h);
            }
        }
        JEditorPane msgLabel = new JEditorPane();
        msgLabel.setFont(new Font("", 0, 11));
        msgLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        msgLabel.setBackground(new Color(235, 235, 235));
        msgLabel.setEditable(false);
        msgLabel.setContentType(html ? "text/html" : "text/plain");
        if (e1 == null) {
            msgLabel.setText(message);
        } else {
            StringWriter s = new StringWriter();
            s.write(html ? "<br /><pre>Error: " : "\nError: ");
            PrintWriter p = new PrintWriter(s);
            e1.printStackTrace(p);
            if (html) {
                s.write("</pre>");
            }
            msgLabel.setText(message + s.toString() + endTag);
        }
        msgLabel.setPreferredSize(new Dimension(width, height));
        JScrollPane pane = new JScrollPane(msgLabel);
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "showExceptionOccurred text:\n  " + msgLabel.getText());
        }
        JOptionPane.showMessageDialog(null, pane, title, 2);
    }

    public static void setRuntime(boolean b) {
        if (trace.getDebugCode("util")) {
            trace.printStack("util", "Utils.setRuntime(" + b + "); old value " + runtime);
        }
        runtime = b;
    }

    public static boolean isRuntime() {
        return runtime;
    }

    public static void setSuppressDialogs(boolean newSuppressDialogs) {
        suppressDialogs = newSuppressDialogs;
    }

    public static boolean getSuppressDialogs() {
        return suppressDialogs;
    }

    public static String addHtmlComment(String str, String comment) {
        Matcher m;
        if (!comment.trim().startsWith("<!")) {
            comment = " <!-- " + comment + " --> ";
        }
        if ((m = HasHtmlMarkup.matcher(str)).matches()) {
            int insAt = m.start(2);
            return str.substring(0, insAt) + comment + str.substring(insAt);
        }
        return "<html>" + str + comment + "</html>";
    }

    public static String appendSlash(String path) {
        if (path.endsWith("/") || path.endsWith(File.separator)) {
            return path;
        }
        if (path.contains(File.separator)) {
            return path + File.separator;
        }
        return path + "/";
    }

    public static long crc(String str) {
        return Utils.crc(str, "UTF-8");
    }

    public static long crc(String str, String encoding) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            trace.err("Invalid character set name \"" + encoding + "\"; trying default: " + uee);
            try {
                bytes = str.getBytes("UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return crc32.getValue();
    }

    private static class FilesBeforeDirs
    implements Comparator<File> {
        private FilesBeforeDirs() {
        }

        @Override
        public int compare(File o1, File o2) {
            boolean d2;
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            boolean d1 = o1.isDirectory();
            if (d1 ^ (d2 = o2.isDirectory())) {
                return d1 ? 1 : -1;
            }
            return o1.compareTo(o2);
        }
    }

    public static interface AlertDialog {
        public void showMessage(Throwable var1, String var2, String var3);
    }
}

