/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.client;

import edu.cmu.pact.Utilities.MessageEvent;
import edu.cmu.pact.Utilities.MessageEventListener;
import edu.cmu.pact.Utilities.SocketReader;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

public class MessageConnection {
    public static final int DEFAULT_PORT = 1502;
    private int eom = 0;
    private Socket sock = null;
    private PrintWriter outStream = null;
    private BufferedReader inStream = null;
    private Thread socketReader = null;
    private Thread consumer = null;
    private boolean stopping = false;
    private LinkedList<MessageEvent> msgQueue = new LinkedList();
    private Object[] msgQueueLock = new Object[0];
    private Set<MessageEventListener> listeners = Collections.synchronizedSet(new LinkedHashSet());
    private String host = "localhost";
    private int port = 1501;

    synchronized void stopListener() {
        this.stopping = true;
        if (this.socketReader != null) {
            this.socketReader.interrupt();
        }
        if (this.consumer != null) {
            this.consumer.interrupt();
        }
    }

    private synchronized boolean isStopping() {
        return this.stopping;
    }

    public MessageConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void openConnection() {
        this.create2wayConnection(this.host, this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMessageEventListener(MessageEventListener listener) {
        if (listener == null) return;
        Object[] objectArray = this.msgQueueLock;
        synchronized (this.msgQueueLock) {
            this.listeners.add(listener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removeMessageEventListener(MessageEventListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private Socket create2wayConnection(String host, int clientPort) {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (host != null && host.length() > 0) {
                addr = InetAddress.getByName(host);
            }
            this.outStream = null;
            this.sock = new Socket(addr, clientPort);
            this.outStream = new PrintWriter(this.sock.getOutputStream(), false);
            this.consumer = new Thread(new MessageDeliverer());
            this.consumer.start();
            this.socketReader = new Thread(new SocketReaderForMessConn());
            this.socketReader.start();
            trace.out("Successfully connected");
            return this.sock;
        }
        catch (Exception e) {
            trace.err("Error connecting to host " + host + ", port " + clientPort + ": " + e + (e.getCause() == null ? "" : "; cause: " + e.getCause()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageEvent dequeue() {
        LinkedList<MessageEvent> linkedList = this.msgQueue;
        synchronized (linkedList) {
            while (this.msgQueue.isEmpty()) {
                try {
                    this.msgQueue.wait();
                }
                catch (InterruptedException ie) {
                    trace.printStack("sp", "MessageConnection.dequeue isStopping() " + this.isStopping() + ": " + ie);
                    break;
                }
            }
            trace.out("msg dequeued");
            try {
                return this.msgQueue.removeFirst();
            }
            catch (NoSuchElementException nsee) {
                if (!this.isStopping()) {
                    trace.err("Error dequeuing MessageEvent when not stopping: " + nsee + (nsee.getCause() == null ? "" : "; cause: " + nsee.getCause()));
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enqueue(MessageEvent msgEvt) {
        LinkedList<MessageEvent> linkedList = this.msgQueue;
        synchronized (linkedList) {
            trace.out("msg enqueued");
            this.msgQueue.addLast(msgEvt);
            int result = this.msgQueue.size();
            this.msgQueue.notifyAll();
            return result;
        }
    }

    void unfilteredSendString(String str) {
        try {
            trace.out("sp", "sendString() out=" + this.outStream + " str=\n " + str);
            if (this.outStream == null) {
                return;
            }
            this.outStream.println(str);
            if (this.eom >= 0) {
                this.outStream.write(this.eom);
            }
            this.outStream.flush();
        }
        catch (Exception e) {
            trace.err("Error sending \"" + (str.length() < 48 ? str : str.substring(0, 48)) + "\":\n " + e + (e.getCause() == null ? "" : ";\n cause: " + e.getCause()));
            e.printStackTrace();
        }
    }

    public void sendString(String str) {
        String tempstr = str.toLowerCase();
        if (tempstr.contains("<selection>done</selection>") || tempstr.contains("<selection>help</selection>") || tempstr.contains("<selection>hint</selection>")) {
            return;
        }
        this.unfilteredSendString(str);
    }

    public static void main(String[] args) {
        String host = null;
        int port = 1502;
        block4: for (int i = 0; i < args.length; ++i) {
            switch (i) {
                case 0: {
                    host = args[i];
                    continue block4;
                }
                case 1: {
                    port = Integer.parseInt(args[i]);
                }
            }
        }
        MessageConnection mc = new MessageConnection(host, port);
        mc.addMessageEventListener(new MessageEventListener(){

            @Override
            public void messageEventOccurred(MessageEvent msgEvt) {
                System.out.println(msgEvt);
            }
        });
        mc.openConnection();
    }

    class MessageDeliverer
    implements Runnable {
        MessageDeliverer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!MessageConnection.this.isStopping()) {
                MessageEvent msgEvt = MessageConnection.this.dequeue();
                if (msgEvt == null) continue;
                Object[] objectArray = MessageConnection.this.msgQueueLock;
                synchronized (objectArray) {
                    for (MessageEventListener listener : MessageConnection.this.listeners) {
                        listener.messageEventOccurred(msgEvt);
                    }
                }
            }
            MessageEvent stopMsg = new MessageEvent(this, false, "quit", null);
            for (MessageEventListener listener : MessageConnection.this.listeners) {
                listener.messageEventOccurred(stopMsg);
            }
        }
    }

    private class SocketReaderForMessConn
    implements Runnable {
        private SocketReaderForMessConn() {
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(MessageConnection.this.sock.getInputStream(), "UTF-8");
                MessageConnection.this.inStream = new BufferedReader(isr);
                while (!MessageConnection.this.isStopping()) {
                    String msg = MessageConnection.this.eom >= 0 ? SocketReader.readToEom(MessageConnection.this.inStream, MessageConnection.this.eom) : SocketReader.readAll(MessageConnection.this.inStream);
                    MessageEvent msgEvt = new MessageEvent(this, false, msg);
                    trace.out("SocketReader received a msg");
                    if (msg.length() < 1) break;
                    MessageConnection.this.enqueue(msgEvt);
                }
                if (MessageConnection.this.inStream != null) {
                    MessageConnection.this.inStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageConnection.this.socketReader = null;
                MessageConnection.this.stopListener();
            }
        }
    }
}

