/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.client;

import edu.cmu.pact.Log.LogFormatUtils;
import edu.cmu.pact.Utilities.MessageEvent;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.MessageConnection;
import edu.cmu.pact.client.ProblemAdvance;
import edu.cmu.pact.client.ProblemAdvancedListener;
import edu.cmu.pact.client.TutorMessageDisplay;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class TutorshopAdvance
implements ProblemAdvance {
    private MessageConnection msgConn;
    private String user_name;
    private String school_name;
    private String admit_code;
    private String curriculumServiceHost;
    private String tutorshopServlet;
    private int curriculumServicePort;
    private List<ProblemAdvancedListener> listeners = new LinkedList<ProblemAdvancedListener>();
    private String log_service = "";
    private static final String LOG_SERVICE_URL = "LOG_SERVICE_URL";
    private static final String LOG_TO_REMOTE_SERVER = "LOG_TO_REMOVE_SERVER";
    private static final String USER_GUID = "USER_GUID";
    private static final String PROBLEM_NAME = "PROBLEM_NAME";
    private static final String QUESTION_FILE = "QUESTION_FILE";
    private final String setPreferenceXMLwithNewlines = "<tutor_related message_sequence>\t<verb>NotePropertySet</verb>\r\n\t<properties>\r\n\t\t<MessageType>SetPreferences</MessageType>\r\n\t\t<log_service_url></log_service_url>\r\n\t\t<log_to_remote_server>false</log_to_remote_server>\r\n\t\t<user_guid>USER_GUID</user_guid>\r\n\t\t<problem_name>PROBLEM_NAME</problem_name>\r\n\t\t<question_file>QUESTION_FILE</question_file>\r\n\t\t<session_id>testTue4_24_07_01</session_id>\r\n\t\t<source_id>CTAT_Flash_TutoringService</source_id>\r\n\t\t<container_id>myContainer</container_id>\r\n\t\t<external_object_id>myExternalId</external_object_id>\r\n\t\t<ProblemName>PROBLEM_NAME</ProblemName>\r\n\t</properties>\r\n</message>";
    private final String setPreferenceXML = "<message><verb>NotePropertySet</verb><properties><MessageType>SetPreferences</MessageType><log_service_url>http://learnlab.web.cmu.edu/log/server</log_service_url><log_to_remote_server>false</log_to_remote_server><log_to_disk>false</log_to_disk><user_guid>myUniqueUserIdentifier</user_guid><problem_name>myGraphName</problem_name><question_file>ChemPT_3T_62_IU.brd</question_file><school_name>CMU</school_name><session_id>mySessionID</session_id><auth_token>myAuth_token</auth_token><source_id>PACT_CTAT_FLASH</source_id><container_id>myContainer</container_id><external_object_id>myExternalId</external_object_id><dataset_name>mySubjectMatter_Arithmetic</dataset_name><ProblemName>ChemPT_3T_62_IU.brd</ProblemName></properties></message>";
    private final String setPreferenceXMLreal = "<message><verb>NotePropertySet</verb><properties><MessageType>SetPreferences</MessageType><log_service_url></log_service_url><log_to_remote_server>false</log_to_remote_server><user_guid>USER_GUID</user_guid><problem_name>PROBLEM_NAME</problem_name><question_file>QUESTION_FILE</question_file><session_id>testTue4_24_07_01</session_id><source_id>CTAT_Flash_TutoringService</source_id><container_id>myContainer</container_id><external_object_id>myExternalId</external_object_id><ProblemName>PROBLEM_NAME</ProblemName></properties></message>";
    TutorMessageDisplay creator;

    public void setLogCreator(TutorMessageDisplay display) {
        this.creator = display;
    }

    public void setLoggingService(String loggingService) {
        this.log_service = loggingService;
    }

    public String getPreferences(String log_service_url, boolean log_to_remote_server, String user_guid, String problem_name, String question_file) {
        Vector<String> preferences = new Vector<String>();
        Vector<Object> values = new Vector<Object>();
        preferences.add("MessageType");
        values.add("SetPreferences");
        preferences.add("log_service_url");
        values.add(log_service_url);
        preferences.add("log_to_remote_server");
        values.add(log_to_remote_server);
        preferences.add("user_guid");
        values.add(user_guid);
        preferences.add("problem_name");
        values.add(problem_name);
        preferences.add("question_file");
        values.add(question_file);
        preferences.add("container_id");
        values.add("myContainer");
        preferences.add("external_object_id");
        values.add("myExternalID");
        return this.creator.createSetPreferenceRequest(preferences, values);
    }

    public void setUser(String user) {
        this.user_name = user;
    }

    public void setSchool(String school) {
        this.school_name = school;
    }

    public void setAdmitCode(String admit) {
        this.admit_code = admit;
    }

    public void setServletParams(String host, int port, String path) {
        this.curriculumServiceHost = host;
        this.curriculumServicePort = port;
        this.tutorshopServlet = path;
    }

    @Override
    public void addProblemAdvancedListener(ProblemAdvancedListener pal) {
        this.listeners.add(pal);
    }

    @Override
    public String advanceProblem() {
        URL url = null;
        try {
            String cmd = "doneNextData";
            String s = this.tutorshopServlet + "?user_guid=" + this.user_name + "&school_name=" + this.school_name + "&cmd=" + cmd + "&admit_code=" + this.admit_code;
            url = new URL("HTTP", this.curriculumServiceHost, this.curriculumServicePort, s);
            URLConnection conn = url.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String resp = br.readLine();
            String problemName = null;
            String brdFilename = null;
            int problemNameIndex = -1;
            int nextIndex = -1;
            problemNameIndex = resp.indexOf("problem_name=");
            if (problemNameIndex >= 0 && (nextIndex = resp.indexOf("&", problemNameIndex)) >= 0) {
                problemName = resp.substring(problemNameIndex + "problem_name=".length(), nextIndex);
            }
            int brdFilenameIndex = -1;
            nextIndex = -1;
            problemNameIndex = resp.indexOf("question_file=");
            if (problemNameIndex >= 0 && (nextIndex = resp.indexOf("&", problemNameIndex)) >= 0) {
                brdFilename = resp.substring(problemNameIndex + "question_file=".length(), nextIndex);
            }
            return problemName;
        }
        catch (MalformedURLException e) {
            trace.printStackWithStatement("Malformed URL in advancing problem: " + url);
        }
        catch (IOException ioe) {
            trace.printStackWithStatement("IOException in advancing problem: " + url);
        }
        return null;
    }

    @Override
    public void fireProblemAdvanced(String problemName) {
        for (ProblemAdvancedListener pal : this.listeners) {
            pal.ProblemAdvanced(problemName);
        }
    }

    private boolean isDoneMessage(String xmlStr) {
        xmlStr = LogFormatUtils.unescape(xmlStr);
        SAXBuilder builder = new SAXBuilder();
        StringReader rdr = new StringReader(xmlStr);
        Document doc = null;
        try {
            doc = builder.build((Reader)rdr);
        }
        catch (IOException ioe) {
            trace.out("Could not build document, IOException");
            return false;
        }
        catch (JDOMException je) {
            trace.out("Could not build document, JDOMException");
            return false;
        }
        Element root = doc.getRootElement();
        for (Element elt : root.getChildren()) {
            boolean doneMsgType = false;
            boolean doneS = false;
            boolean doneA = false;
            if (elt.getName().equals("message")) {
                for (Element property : elt.getChildren()) {
                    String propAttribNameVal = property.getAttributeValue("name");
                    if (propAttribNameVal == null) continue;
                    if (propAttribNameVal.equals("MessageType")) {
                        doneMsgType = property.getText().contains("CorrectAction");
                        continue;
                    }
                    if (propAttribNameVal.equals("Selection")) {
                        doneS = property.getChild("entry").getText().contains("done");
                        continue;
                    }
                    if (!propAttribNameVal.equals("Action")) continue;
                    doneA = property.getChild("entry").getText().contains("ButtonPressed");
                }
            }
            if (!doneMsgType || !doneS || !doneA) continue;
            return true;
        }
        return false;
    }

    @Override
    public void messageEventOccurred(MessageEvent me) {
        String xmlStr = me.getMessageAsString();
        if (!this.isDoneMessage(xmlStr)) {
            return;
        }
        String problemName = this.advanceProblem();
        trace.out("Advance problem returned:" + problemName);
        if (problemName == null) {
            return;
        }
        this.sendSetPreferences(problemName);
    }

    public void sendSetPreferences(String problemPath) {
        String preferences = this.getPreferences(this.log_service, false, this.user_name, problemPath, problemPath);
        if (this.msgConn != null) {
            this.msgConn.sendString(preferences);
        }
    }

    @Override
    public void setMessageConnection(MessageConnection msgConn) {
        this.msgConn = msgConn;
    }
}

