/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.CommException;
import edu.cmu.pact.ctat.Communicable;
import edu.cmu.pact.ctat.DataFormatException;
import edu.cmu.pact.ctat.ExternalObject;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MissingParameterException;
import edu.cmu.pact.ctat.MultiTarget;
import edu.cmu.pact.ctat.ObjectProxy;
import edu.cmu.pact.ctat.Target;
import java.util.Hashtable;
import java.util.Vector;

public class Communicator
extends ExternalObject
implements Communicable {
    ObjectProxy topProxy = null;
    protected String name;
    public static int messageNumber = 1;
    public static Hashtable allMessages = new Hashtable();
    public static boolean doSendError = true;

    public static void reset() {
        messageNumber = 1;
        allMessages = new Hashtable();
    }

    public Communicator() {
    }

    public Communicator(ObjectProxy top) {
        this.topProxy = top;
        this.name = this.topProxy.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ObjectProxy getTopObjectProxy() {
        return this.topProxy;
    }

    public static void addMessage(int index, MessageObject outEvent) {
        allMessages.put(Integer.valueOf(String.valueOf(index)), outEvent);
        trace.out("missmto", "Communicator.allMessages.size() = " + allMessages.size());
    }

    public static MessageObject getMessage(int index) {
        return (MessageObject)allMessages.get(Integer.valueOf(String.valueOf(index)));
    }

    public void setProxyObject(ObjectProxy top) {
        this.topProxy = top;
    }

    @Override
    public void addTarget(Target reply) {
        if (this.topProxy != null) {
            this.topProxy.addTarget(reply);
        }
    }

    @Override
    public MultiTarget getTarget() {
        if (this.topProxy != null) {
            return this.topProxy.getTarget();
        }
        return null;
    }

    public void sendErrorMessage(Exception e, MessageObject msgParsed, String moString) {
        MessageObject mo = MessageObject.create("sendErrorMessage");
        mo.setVerb("NoteError");
        int messageNum = -1;
        Integer parsedNum = (Integer)msgParsed.getProperty("MESSAGENUMBER");
        messageNum = parsedNum == null ? this.getMessageNumber(moString) : parsedNum.intValue();
        mo.setProperty("OBJECT", this.topProxy);
        mo.setProperty("InResponseTo", messageNum);
        String errorClass = e.getClass().getName();
        if (errorClass.toUpperCase().startsWith("COMM.")) {
            errorClass = errorClass.substring(7);
        }
        mo.setProperty("ErrorClass", errorClass);
        mo.setProperty("ErrorText", e.getMessage());
        if (doSendError) {
            this.topProxy.send(mo);
        } else if (MessageObject.showMessage) {
            System.out.println("ERROR " + mo.toString());
        }
    }

    protected boolean isIgnorable(MessageObject mo, String exceptionName) {
        Vector ignore = (Vector)mo.getProperty("IGNOREERRORCLASSES");
        if (ignore == null) {
            return false;
        }
        int s = ignore.size();
        if (s == 1 && ((String)ignore.elementAt(0)).equalsIgnoreCase("ALL")) {
            return true;
        }
        String inVector = "";
        for (int i = 0; i < s; ++i) {
            inVector = "COMM." + (String)ignore.elementAt(i);
            if (!inVector.equalsIgnoreCase(exceptionName)) continue;
            return true;
        }
        return false;
    }

    private int getMessageNumber(String moString) {
        int ind = moString.toUpperCase().indexOf("MESSAGENUMBER");
        if (ind == -1) {
            return -1;
        }
        ind = moString.indexOf(":", ind);
        ind = moString.indexOf(":", ind + 1) + 1;
        int end = moString.indexOf("&", ind);
        String numStr = moString.substring(ind, end);
        try {
            int toret = Integer.parseInt(numStr);
            return toret;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public void handleMessage(String inString) {
        System.out.println(inString);
    }

    @Override
    public void handleMessage(MessageObject inEvent) {
        try {
            Object objParam = inEvent.getProperty("OBJECT");
            String verb = inEvent.getVerb();
            trace.out("mt", "VERB = " + verb);
            if (objParam == null) {
                trace.err("Error: missing object parameter: " + inEvent.getPropertyNames());
                this.sendErrorMessage(new MissingParameterException("Object", (Vector)inEvent.getPropertyNames()), inEvent, inEvent.toString());
            } else if (verb == null) {
                trace.out(10, this, "Error: missing verb parameter");
                this.sendErrorMessage(new MissingParameterException("Verb", (Vector)inEvent.getPropertyNames()), inEvent, inEvent.toString());
            } else {
                trace.out("mt", "object to treat response (class " + objParam.getClass().getName() + ") is " + objParam);
                ((ObjectProxy)objParam).treatMessage(inEvent, verb);
            }
        }
        catch (MissingParameterException ex) {
            trace.out(5, this, "MissingParamterException e = " + ex);
            this.sendErrorMessage(new DataFormatException("Internal error (missing parameter) " + ex + " handling: " + inEvent.getParsedParameterString()), inEvent, inEvent.toString());
        }
        catch (CommException e) {
            trace.out(5, this, "Comm exception e = " + e);
            if (!this.isIgnorable(inEvent, e.getClass().getName())) {
                this.sendErrorMessage(e, inEvent, inEvent.toString());
            }
        }
        catch (Exception ex) {
            this.sendErrorMessage(new DataFormatException("Internal error " + ex + " handling: " + inEvent.getParsedParameterString()), inEvent, inEvent.toString());
            ex.printStackTrace();
        }
    }
}

