/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Log.DataShopMessageObject;
import edu.cmu.pact.Log.LogConsoleReplay;
import edu.cmu.pact.SocketProxy.SocketToolProxy;
import edu.cmu.pact.Utilities.LCLoggingSupport;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MessagePlayerEvent;
import edu.cmu.pact.ctat.MessagePlayerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import pact.CommWidgets.UniversalToolProxy;

public class MessagePlayer
implements Runnable {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final List<MessageObject> messageObjects;
    private final BR_Controller controller;
    private UniversalToolProxy forwardToClientProxy;
    private boolean clientAcceptsComm = true;
    private volatile boolean stopping = false;
    private HashSet listeners;
    private LogConsoleReplay lcr = null;
    private LCLoggingSupport logger = null;
    private static boolean logConsoleActive = false;

    public static boolean isLogConsoleActive() {
        return logConsoleActive;
    }

    public MessagePlayer(BR_Controller controller, List<MessageObject> messageObjects, boolean clientAcceptsComm, LogConsoleReplay lcr) {
        this.controller = controller;
        this.messageObjects = new ArrayList<MessageObject>(messageObjects);
        this.clientAcceptsComm = clientAcceptsComm;
        this.listeners = new HashSet();
        this.lcr = lcr;
        if (lcr != null) {
            this.pcs.addPropertyChangeListener(lcr);
        }
    }

    @Override
    public void run() {
        if (trace.getDebugCode("mp")) {
            trace.out("mp", "run Message Player; messageObjects = " + this.messageObjects);
        }
        int totalToSend = this.messageObjects.size();
        if (this.lcr != null) {
            logConsoleActive = true;
        }
        for (int i = 0; i < totalToSend && !this.isStopping(); ++i) {
            DataShopMessageObject mo = (DataShopMessageObject)this.messageObjects.get(i);
            this.forwardToClient(mo);
            if (this.logger != null) {
                Object time = mo.getProperty("Time");
                if (time != null) {
                    SimpleDateFormat dsTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
                    try {
                        this.logger.setTimeStamp(dsTimeFormat.parse(time.toString()));
                        this.logger.setTimeZone("UTC");
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                this.logger.oliLog(mo, false);
            }
            if (mo.getMessageType().equalsIgnoreCase("StartProblem")) continue;
            this.controller.handleCommMessage(mo);
            MessagePlayerEvent evt = new MessagePlayerEvent(this, mo);
            evt.setTotalCount(totalToSend);
            evt.setSentCount(i + 1);
            evt.setStopping(this.isStopping());
            this.fireMessagePlayerEvent(evt);
            if (this.lcr == null) continue;
            trace.out("replay", "event fired");
            PropertyChangeEvent replayevt = new PropertyChangeEvent(this, "transactions left", totalToSend - i, totalToSend - i - 1);
            this.pcs.firePropertyChange(replayevt);
        }
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "MP.run() returns");
        }
        logConsoleActive = false;
    }

    protected void forwardToClient(Object msg) {
        if (this.forwardToClientProxy == null) {
            return;
        }
        MessageObject mo = (MessageObject)msg;
        String msgType = mo.getMessageType();
        if (!"InterfaceAction".equalsIgnoreCase(msgType)) {
            return;
        }
        if (this.clientAcceptsComm) {
            this.forwardToClientProxy.handleMessage(mo);
        } else if (this.forwardToClientProxy instanceof SocketToolProxy && mo.getDataShopElementString() != null) {
            ((SocketToolProxy)this.forwardToClientProxy).sendXMLString(mo.getDataShopElementString());
        }
    }

    public UniversalToolProxy getForwardToClientProxy() {
        return this.forwardToClientProxy;
    }

    public void setForwardToClientProxy(UniversalToolProxy forwardToClientProxy) {
        this.forwardToClientProxy = forwardToClientProxy;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    public void addMessagePlayerListener(MessagePlayerListener l) {
        this.listeners.add(l);
    }

    public void removeMessagePlayerListener(MessagePlayerListener l) {
        this.listeners.remove(l);
    }

    public void fireMessagePlayerEvent(MessagePlayerEvent e) {
        for (MessagePlayerListener listener : this.listeners) {
            listener.messagePlayerEventOccurred(e);
        }
    }

    public void setLogger(LCLoggingSupport oli) {
        this.logger = oli;
    }
}

