/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Properties;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.View.BRPanel;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintWindowInterface;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.JGraphPanel;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.EventLogger;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.HintMessagesManager;
import edu.cmu.pact.client.HintMessagesManagerForClient;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.CtatModeModel;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.RuleActivationTree;
import edu.cmu.pact.miss.MissControllerExternal;
import edu.cmu.pslc.logging.LogContext;
import java.applet.Applet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import org.jdom.Element;
import pact.CommWidgets.JCommComboBox;
import pact.CommWidgets.JCommComposer;
import pact.CommWidgets.JCommTable;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.StudentInterfaceConnectionStatus;
import pact.CommWidgets.StudentInterfaceWrapper;
import pact.CommWidgets.UniversalToolProxy;
import pact.CommWidgets.WrapperSupport;

public class TutorController
extends CTATBase
implements CTAT_Controller {
    public static final String PROJECTS_DIRECTORY = "workspace";
    protected StudentInterfaceWrapper studentInterface = null;
    protected Hashtable<String, JCommWidget> commNameTable = new Hashtable();
    protected boolean startStateInterface;
    protected boolean startFindWidgetsForProblem;
    protected Vector<String> notFoundWidgetsForProblem;
    protected boolean toolTipsInitialized;
    protected UniversalToolProxy utp;
    public static final String NOT_DONE_MSG = "I'm sorry, but you are not done yet. Please continue working.";
    public static final String NOT_ALLOW_DONE_HINTS_MSG = "You can not get Done Hints now.";
    protected Set<Object> unmatchedComponents = new LinkedHashSet<Object>();
    protected HintMessagesManager hintMessagesManager;
    private TSLauncherServer tsLauncherServer;
    private static final String[] systemPropertiesToCheck = new String[]{"log_to_disk_directory", "auth_token", "session_id", "log_service_url", "user_guid", "school_name", "course_name", "unit_name", "section_name", "enableAuthorLogging", "study_condition_name", "question_file", "ProblemFileLocation", "ProblemFileURL", "BehaviorRecorderMode", "LoggingAuthToken", "LoggingSessionID", "LoggingUserID", "BehaviorRecorderVisible"};
    private Map<String, List<Element>> bundles = new HashMap<String, List<Element>>();

    public TutorController(TSLauncherServer tsLauncherServer) {
        this.tsLauncherServer = tsLauncherServer;
        this.setClassName("TutorController");
        this.debug("TutorController ()");
    }

    public TutorController(LogContext lc, StudentInterfaceWrapper studentInterface) {
        this.studentInterface = studentInterface;
        if (this.utp != null && !Utils.isRuntime()) {
            if (studentInterface == null) {
                this.utp.setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.Disconnected);
            } else {
                this.utp.setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.NewlyConnected);
            }
        }
        this.getTSLauncherServer().setLogger(lc);
    }

    @Override
    public PreferencesModel getPreferencesModel() {
        if (this.getTSLauncherServer() == null) {
            return null;
        }
        return this.getTSLauncherServer().getPreferencesModel();
    }

    public CTAT_Properties getProperties() {
        return this.getTSLauncherServer().getProperties();
    }

    public void loadControlFromSystemProperties() {
        if (this.inAppletMode()) {
            return;
        }
        for (String prop : systemPropertiesToCheck) {
            this.getProperties().setProperty(prop, System.getProperty(prop));
        }
    }

    public void saveTraversedPathFile() {
    }

    public boolean inAppletMode() {
        return false;
    }

    public HintMessagesManager getHintMessagesManager() {
        if (this.hintMessagesManager == null) {
            this.hintMessagesManager = new HintMessagesManagerForClient(this);
            if (this.studentInterface != null && this.studentInterface.getWrapperSupport() != null) {
                this.studentInterface.getWrapperSupport().setController(this);
            }
        }
        return this.hintMessagesManager;
    }

    public boolean shouldDisplayWarnings() {
        return false;
    }

    public void setStudentInterface(StudentInterfaceWrapper currentInterface) {
        this.studentInterface = currentInterface;
        if (this.utp != null && !Utils.isRuntime()) {
            this.utp.setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.NewlyConnected);
        }
    }

    public void addCtatModeListener(Object noOp) {
    }

    public MessageObject getOriginalStartStateNodeMessage(Vector selection, Vector action) {
        return null;
    }

    public void setStartStateModified(boolean noOp) {
    }

    @Override
    public LoggingSupport getLoggingSupport() {
        return null;
    }

    @Override
    public EventLogger getEventLogger() {
        return this.getTSLauncherServer().getEventLogger();
    }

    @Override
    public LogContext getLogger() {
        return this.getTSLauncherServer().getLogger();
    }

    @Override
    public AbstractCtatWindow getActiveWindow() {
        return null;
    }

    @Override
    public void handleCommMessage(MessageObject mo) {
    }

    public boolean isShowWidgetInfo() {
        return false;
    }

    public boolean isDemonstratingSolution() {
        return false;
    }

    public boolean isStartStateInterface() {
        return false;
    }

    public boolean isDefiningStartState() {
        return false;
    }

    public boolean isStartStateModified() {
        return false;
    }

    public void handleCommMessage_movedFromCommWidget(MessageObject mo) {
        Vector<String> propertyNames = null;
        Vector propertyValues = null;
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "msg to student interface:\n" + mo);
        }
        try {
            propertyNames = new Vector<String>(mo.getPropertyNames());
            propertyValues = new Vector(mo.getPropertyValues());
            String type = (String)MessageObject.getValue(propertyNames, propertyValues, "MessageType");
            if (trace.getDebugCode("dw")) {
                trace.out("dw", "property names = " + new ArrayList<String>(propertyNames));
            }
            if (trace.getDebugCode("dw")) {
                trace.out("dw", "property values = " + new ArrayList(propertyValues));
            }
            if (type.equalsIgnoreCase("ConfirmDone")) {
                this.doConfirmDone();
                return;
            }
            if (type.equalsIgnoreCase("ResetAction")) {
                this.doResetAction_movedFromCommWidget(propertyNames, propertyValues);
                return;
            }
            if (type.equalsIgnoreCase("InterfaceDescription")) {
                this.handleInterfaceDescriptionMessage_movedFromCommWidget(mo);
                return;
            }
            if (type.equalsIgnoreCase("InterfaceAction")) {
                this.doInterfaceAction_movedFromCommWidget(propertyNames, propertyValues);
                return;
            }
            if (type.equalsIgnoreCase("StartProblem")) {
                this.doStartProblem_movedFromCommWidget();
                return;
            }
            if (type.equalsIgnoreCase("StartStateEnd")) {
                this.doStartStateEnd_movedFromCommWidget();
                return;
            }
            if (type.equalsIgnoreCase("StartNewProblem")) {
                this.doStartNewProblem_movedFromCommWidget();
                return;
            }
            if (type.equalsIgnoreCase("CorrectAction")) {
                this.doCorrectAction_movedFromCommWidget(propertyNames, propertyValues);
                return;
            }
            if (type.equalsIgnoreCase("IncorrectAction")) {
                this.doIncorrectAction_movedFromCommWidget(propertyNames, propertyValues);
                return;
            }
            if (type.equalsIgnoreCase("LISPCheckAction")) {
                this.doLispCheckAction_movedFromCommWidget(propertyNames, propertyValues);
                return;
            }
            if (type.equalsIgnoreCase("StateGraph")) {
                this.doStateGraph(propertyNames, propertyValues);
                return;
            }
            if (type.equalsIgnoreCase("WrongUserMessage")) {
                this.doIncorrectAction_movedFromCommWidget(propertyNames, propertyValues);
                return;
            }
            if (type.equalsIgnoreCase("UnlockComposer")) {
                this.doUnlockComposer_movedFromCommWidget(propertyNames, propertyValues);
                return;
            }
            if (type.equalsIgnoreCase("InterfaceReboot")) {
                this.doInterfaceReboot();
                return;
            }
            if (type.equalsIgnoreCase("GetAllInterfaceDescriptions")) {
                this.doGetAllInterfaceDescriptions();
                return;
            }
            if (type.equalsIgnoreCase("SendWidgetLock")) {
                this.doSendWidgetLock(mo);
                return;
            }
        }
        catch (IllegalArgumentException ie) {
            Vector selection = (Vector)MessageObject.getValue(propertyNames, propertyValues, "selection");
            if (selection != null && selection.size() > 0) {
                this.unmatchedComponents.add(selection.get(0));
            }
            return;
        }
        catch (Exception e) {
            trace.err("Error handleCommMessage_movedFromCommWidget(" + mo + "): " + e);
            e.printStackTrace(System.err);
            return;
        }
        trace.out("**ERROR**: don't know type " + propertyNames.elementAt(0));
    }

    private void doSendWidgetLock(MessageObject mo) {
        Boolean lock = mo.getPropertyAsBoolean("WidgetLockFlag");
        for (JCommWidget w : this.getCommWidgetTable().values()) {
            w.isChangedFromResetState();
        }
    }

    private void doInterfaceReboot() {
        UniversalToolProxy utp = this.getUniversalToolProxy();
        if (utp == null) {
            return;
        }
        String CommComboBoxClassName = JCommComboBox.class.getName();
        String CommComposerClassName = JCommComposer.class.getName();
        Hashtable<String, JCommWidget> widgetTable = this.getCommWidgetTable();
        for (String wName : widgetTable.keySet()) {
            JCommWidget w = (JCommWidget)widgetTable.get(wName);
            w.reset(this);
            String className = w.getClass().getName();
            if (!className.equalsIgnoreCase(CommComboBoxClassName) && !className.equalsIgnoreCase(CommComposerClassName)) continue;
            w.setEditable(false);
        }
    }

    protected void doStateGraph(Vector propertyNames, Vector propertyValues) {
        WrapperSupport ws = this.getStudentInterface() == null ? null : this.getStudentInterface().getWrapperSupport();
        Object ssf = MessageObject.getValue(propertyNames, propertyValues, "suppressStudentFeedback");
        if (ssf != null && ws != null) {
            boolean suppressStudentFeedback = Boolean.parseBoolean(ssf.toString());
            ws.suppressFeedback(suppressStudentFeedback);
        }
    }

    protected void doConfirmDone() {
        String message = "Are you finished with this problem?";
        String title = "Confirm";
        int result = JOptionPane.showConfirmDialog(this.getStudentInterface().getActiveWindow(), message, title, 0);
        if (result == 0) {
            this.processDoneMatch();
        } else {
            MessageObject mo = this.createConfirmDoneMessage(result);
            LoggingSupport loggingSupport = this.getLoggingSupport();
            if (loggingSupport != null) {
                loggingSupport.oliLog(mo, false);
            }
        }
    }

    private MessageObject createConfirmDoneMessage(int optionPaneResult) {
        MessageObject mo = MessageObject.create("InterfaceAction", "NotePropertySet");
        mo.setSelection("ConfirmDone");
        mo.setAction("ButtonPressed");
        mo.setInput(optionPaneResult == 0 ? "yes" : "no");
        mo.setTransactionId(mo.makeTransactionId());
        return mo;
    }

    private void processDoneMatch() {
        trace.out("inter", "process done match");
        HintWindowInterface hwi = null;
        StudentInterfaceWrapper siw = this.getStudentInterface();
        if (siw != null) {
            WrapperSupport ws = siw.getWrapperSupport();
            if (ws != null) {
                ws.doneActionPerformed();
            }
            if (hwi != null) {
                hwi.reset();
            }
        }
    }

    @Override
    public StudentInterfaceWrapper getStudentInterface() {
        return this.studentInterface;
    }

    public JComponent getTutorPanel() {
        if (this.getStudentInterface() == null) {
            return null;
        }
        if (this.getStudentInterface().getWrapperSupport() == null) {
            return null;
        }
        return this.getStudentInterface().getWrapperSupport().getTutorPanel();
    }

    private void doResetAction_movedFromCommWidget(Vector propertyNames, Vector propertyValues) {
        Vector selection = (Vector)MessageObject.getValue(propertyNames, propertyValues, "selection");
        for (int i = 0; i < selection.size(); ++i) {
            String widgetName = (String)selection.elementAt(i);
            JCommWidget d = this.getCommWidget(widgetName);
            if (d == null) {
                trace.out(5, "JCommWidget.java", "Error: can't find selection called " + selection.elementAt(i));
                continue;
            }
            String CommTableClassName = "pact.CommWidgets.JCommTable";
            if (d.getClass().getName().equalsIgnoreCase("pact.CommWidgets.JCommTable")) {
                ((JCommTable)d).singleCellReset(widgetName);
                continue;
            }
            d.reset(this);
        }
    }

    public void doStartProblem_movedFromCommWidget() {
        StudentInterfaceWrapper stInterface = this.getStudentInterface();
        if (stInterface != null && stInterface.getHintInterface() != null) {
            stInterface.getHintInterface().reset();
        }
        this.resetAllWidgets();
        this.setStartStateInterface(true);
        Iterator<JCommWidget> e = this.getCommWidgetTable().values().iterator();
        String CommComboBoxClassName = "pact.CommWidgets.JCommComboBox";
        String CommComposerClassName = "pact.CommWidgets.JCommComposer";
        String className = "";
        while (e.hasNext()) {
            JCommWidget w = e.next();
            className = w.getClass().getName();
            if (!className.equalsIgnoreCase(CommComboBoxClassName) && !className.equalsIgnoreCase(CommComposerClassName)) continue;
            w.setEditable(false);
        }
        this.setStartFindWidgetsForProblem(true);
        this.setNotFoundWidgetsForProblem(new Vector<String>());
    }

    protected void doInterfaceAction_movedFromCommWidget(Vector propertyNames, Vector propertyValues) {
        Vector selection = (Vector)MessageObject.getValue(propertyNames, propertyValues, "selection");
        Vector action = (Vector)MessageObject.getValue(propertyNames, propertyValues, "action");
        Vector input = (Vector)MessageObject.getValue(propertyNames, propertyValues, "input");
        boolean oneWidgetFound = false;
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "doInterfaceAction_mov... selection " + selection);
        }
        if (selection != null) {
            for (int i = 0; i < selection.size(); ++i) {
                JCommWidget d = this.getCommWidget((String)selection.elementAt(i));
                if (trace.getDebugCode("inter")) {
                    trace.out("inter", "doInterfaceAction_mov... d[" + i + "] " + d);
                }
                if (d == null) continue;
                oneWidgetFound = true;
                d.doInterfaceAction((String)selection.elementAt(i), (String)action.elementAt(i), input.elementAt(i) == null ? null : input.elementAt(i).toString());
            }
            if (!oneWidgetFound) {
                throw new IllegalArgumentException("Could not find widgets for selection: " + selection);
            }
        }
    }

    protected void handleInterfaceDescriptionMessage_movedFromCommWidget(Vector propertyNames, Vector propertyValues) {
        String tempCommName = (String)MessageObject.getValue(propertyNames, propertyValues, "CommName");
        if (tempCommName == null || tempCommName == "") {
            return;
        }
        JCommWidget d = this.getCommWidget(tempCommName);
        if (d == null) {
            return;
        }
    }

    protected void handleInterfaceDescriptionMessage_movedFromCommWidget(MessageObject messageObject) {
        String tempCommName = (String)messageObject.getProperty("CommName");
        if (tempCommName == null || tempCommName == "") {
            return;
        }
        JCommWidget d = this.getCommWidget(tempCommName);
        if (d == null) {
            return;
        }
        d.doInterfaceDescription(messageObject);
    }

    private void doCorrectAction_movedFromCommWidget(Vector propertyNames, Vector propertyValues) {
        Vector selection = (Vector)MessageObject.getValue(propertyNames, propertyValues, "selection");
        Vector action = (Vector)MessageObject.getValue(propertyNames, propertyValues, "action");
        Vector input = (Vector)MessageObject.getValue(propertyNames, propertyValues, "input");
        if (selection.elementAt(0) == null) {
            trace.printStack("mps");
        }
        for (int i = 0; i < selection.size(); ++i) {
            JCommWidget d = this.getCommWidget((String)selection.elementAt(i));
            if (d == null) continue;
            d.doCorrectAction((String)selection.elementAt(i), (String)action.elementAt(i), input.elementAt(i) == null ? null : input.elementAt(i).toString());
        }
    }

    public void doLispCheckAction_movedFromCommWidget(Vector propertyNames, Vector propertyValues) {
        Vector selection = (Vector)MessageObject.getValue(propertyNames, propertyValues, "selection");
        Vector action = (Vector)MessageObject.getValue(propertyNames, propertyValues, "action");
        Vector input = (Vector)MessageObject.getValue(propertyNames, propertyValues, "input");
        int n = Math.min(selection.size(), input.size());
        for (int i = 0; i < n; ++i) {
            JCommWidget d = this.getCommWidget((String)selection.elementAt(i));
            if (d == null) {
                trace.out("Error: can't find selection called " + selection.elementAt(i));
                continue;
            }
            if (d instanceof JCommComposer && i < action.size()) {
                d.doLISPCheckAction((String)selection.elementAt(i), (String)action.elementAt(i), (String)input.elementAt(i));
                continue;
            }
            d.doLISPCheckAction((String)selection.elementAt(i), (String)input.elementAt(i));
        }
    }

    public void doIncorrectAction_movedFromCommWidget(Vector propertyNames, Vector propertyValues) {
        Vector selection = (Vector)MessageObject.getValue(propertyNames, propertyValues, "selection");
        Vector action = (Vector)MessageObject.getValue(propertyNames, propertyValues, "action");
        Vector input = (Vector)MessageObject.getValue(propertyNames, propertyValues, "Input");
        for (int i = 0; i < selection.size(); ++i) {
            JCommWidget d = this.getCommWidget((String)selection.elementAt(i));
            if (d == null) {
                trace.out("Error: can't find selection called " + selection.elementAt(i));
                continue;
            }
            d.doIncorrectAction((String)selection.elementAt(i), (String)action.elementAt(i), input.elementAt(i) == null ? null : input.elementAt(i).toString());
        }
    }

    public void doUnlockComposer_movedFromCommWidget(Vector propertyNames, Vector propertyValues) {
        Vector selection = (Vector)MessageObject.getValue(propertyNames, propertyValues, "selection");
        for (int i = 0; i < selection.size(); ++i) {
            JCommWidget d = this.getCommWidget((String)selection.elementAt(i));
            if (d == null) {
                trace.out("Error: can't find selection called " + selection.elementAt(i));
                continue;
            }
            if (!d.actionName.equalsIgnoreCase("UpdateComposer")) continue;
            d.unlockWidget();
        }
    }

    public void initAllWidgets_movedFromCommWidget() {
        if (this.utp == null) {
            throw new NullPointerException();
        }
        if (!this.isToolTipsInitialized()) {
            ToolTipManager t = ToolTipManager.sharedInstance();
            t.setInitialDelay(100);
            t.setReshowDelay(100);
            this.setToolTipsInitialized(true);
        }
        for (JCommWidget d : this.getCommWidgetTable().values()) {
            d.initialize(this);
            d.addMouseListener(this.getStudentInterface());
        }
    }

    public void doStartNewProblem_movedFromCommWidget() {
        HintWindowInterface hintInterface;
        if (this.getStudentInterface() != null && (hintInterface = this.getStudentInterface().getHintInterface()) != null) {
            hintInterface.reset();
        }
        this.resetAllWidgets();
        this.setStartStateInterface(true);
        this.setStartStateSent(false);
        Iterator<JCommWidget> i = this.getCommWidgetTable().values().iterator();
        String CommComboBoxClassName = "pact.CommWidgets.JCommComboBox";
        String CommComposerClassName = "pact.CommWidgets.JCommComposer";
        String className = "";
        while (i.hasNext()) {
            JCommWidget w = i.next();
            className = w.getClass().getName();
            if (className.equalsIgnoreCase(CommComboBoxClassName)) {
                ((JCommComboBox)w).setInitialValues();
            }
            if (!className.equalsIgnoreCase(CommComboBoxClassName) && !className.equalsIgnoreCase(CommComposerClassName)) continue;
            w.setEditable(true);
        }
    }

    public void doStartStateEnd_movedFromCommWidget() {
        this.setStartStateInterface(false);
        this.setStartStateSent(true);
        this.setStartFindWidgetsForProblem(false);
    }

    public void doGetAllInterfaceDescriptions() {
        Hashtable<String, JCommWidget> widgetTable = this.getCommWidgetTable();
        for (String wName : widgetTable.keySet()) {
            JCommWidget w = (JCommWidget)widgetTable.get(wName);
            MessageObject o = w.getDescriptionMessage(wName);
            if (o == null) {
                if (trace.getDebugCode("comm")) {
                    trace.out("comm", "Can't create message for " + wName + " because can't initialize (need to set comm name?)");
                }
            } else {
                this.bundleMessage(o, "GetAllInterfaceDescriptions");
            }
            if (w.isHintBtn() || w.isDoneButton() || !w.isChangedFromResetState()) continue;
            Vector<MessageObject> messageVector = w.getCurrentState();
            for (int j = 0; j < messageVector.size(); ++j) {
                o = messageVector.elementAt(j);
                if (o != null) {
                    this.bundleMessage(o, "GetAllInterfaceDescriptions");
                }
                if (!trace.getDebugCode("startstate")) continue;
                trace.out("startstate", "UTP.doGetAllInterfaceDescriptions() widget " + w.getCommName() + ", currentState " + o.summary());
            }
        }
        this.flushBundle("GetAllInterfaceDescriptions");
    }

    private int bundleMessage(MessageObject mo, String bundleName) {
        List<Element> bundle = this.bundles.get(bundleName);
        if (bundle == null) {
            bundle = new LinkedList<Element>();
        }
        bundle.add(mo.toElement());
        this.bundles.put(bundleName, bundle);
        return bundle.size();
    }

    private int flushBundle(String bundleName) {
        List<Element> bundle = this.bundles.remove(bundleName);
        if (bundle == null || bundle.size() < 1) {
            return 0;
        }
        MessageObject mo = MessageObject.create(bundleName, "NotePropertySet");
        mo.setProperty("messages", bundle);
        this.handleCommMessage(mo);
        return bundle.size();
    }

    public void finishedReceivingInterfaceStartState() {
    }

    public JCommWidget getCommWidget(String commName) {
        if (commName.equals("No_Selection")) {
            return null;
        }
        Enumeration<String> iterKeys = this.getCommWidgetTable().keys();
        while (iterKeys.hasMoreElements()) {
            String keyName = iterKeys.nextElement();
            if (!keyName.equalsIgnoreCase(commName)) continue;
            JCommWidget t = this.commNameTable.get(keyName);
            if (t == null) break;
            return t;
        }
        if (this.getStartFindWidgetsForProblem()) {
            this.getNotFoundWidgetsForProblem().addElement(commName);
        } else if (this.getInterfaceLoaded()) {
            try {
                throw new RuntimeException("Request for unknown component " + commName);
            }
            catch (RuntimeException re) {
                if ("null".equalsIgnoreCase(commName)) {
                    if (trace.getDebugCode("dw")) {
                        trace.printStack("dw", "TC.getCommWidget(): request for \"null\" component");
                    }
                }
                re.printStackTrace();
            }
        }
        return null;
    }

    public Object lookupWidgetByName(String name) {
        for (JCommWidget widget : this.getCommWidgetTable().values()) {
            String widgetName = widget.getCommName();
            String className = widget.getClass().getName();
            if (widgetName.equalsIgnoreCase(name)) {
                return widget;
            }
            if (!className.equalsIgnoreCase("pact.CommWidgets.JCommTable")) continue;
            int rows = ((JCommTable)widget).getRows();
            int columns = ((JCommTable)widget).getColumns();
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    JCommTable.TableCell cell = ((JCommTable)widget).getCell(r, c);
                    if (!cell.getCommName().equalsIgnoreCase(name)) continue;
                    if (trace.getDebugCode("boots20")) {
                        trace.out("boots20", "lookupWidgetByName/cell: returning an object of type " + cell.getClass());
                    }
                    return cell;
                }
            }
        }
        new Exception("Invalid widget name: " + name).printStackTrace();
        return null;
    }

    public void removeAllHighlights() {
        for (JCommWidget d : this.getCommWidgetTable().values()) {
            d.removeHighlight("");
        }
    }

    public Hashtable<String, JCommWidget> getCommWidgetTable() {
        return this.commNameTable;
    }

    public void resetAllWidgets() {
        ArrayList<JCommWidget> widgets = new ArrayList<JCommWidget>(this.getCommWidgetTable().values());
        for (int i = 0; i < widgets.size(); ++i) {
            JCommWidget w = widgets.get(i);
            w.reset(this);
        }
    }

    protected void clearWidgetInformation() {
        trace.printStack("inter", "CLEAR WIDGET TABLE");
        this.getCommWidgetTable().clear();
    }

    protected void setStartStateInterface(boolean startStateInterface) {
        this.startStateInterface = startStateInterface;
    }

    protected void setStartFindWidgetsForProblem(boolean startFindWidgetsForProblem) {
        this.startFindWidgetsForProblem = startFindWidgetsForProblem;
    }

    protected boolean getStartFindWidgetsForProblem() {
        return this.startFindWidgetsForProblem;
    }

    public void setNotFoundWidgetsForProblem(Vector<String> notFoundWidgetsForProblem) {
        this.notFoundWidgetsForProblem = notFoundWidgetsForProblem;
    }

    public Vector<String> getNotFoundWidgetsForProblem() {
        if (this.notFoundWidgetsForProblem == null) {
            this.notFoundWidgetsForProblem = new Vector();
        }
        return this.notFoundWidgetsForProblem;
    }

    public boolean isToolTipsInitialized() {
        return this.toolTipsInitialized;
    }

    public void setToolTipsInitialized(boolean toolTipsInitialized) {
        this.toolTipsInitialized = toolTipsInitialized;
    }

    public void setStartStateSent(boolean startStateSent) {
    }

    public boolean getInterfaceLoaded() {
        if (trace.getDebugCode("mps")) {
            trace.out("mps", "current interface = " + this.studentInterface);
        }
        return this.studentInterface != null;
    }

    public boolean invalidWidgetsExist() {
        return this.getStartFindWidgetsForProblem() && this.getNotFoundWidgetsForProblem().size() > 0;
    }

    public boolean isStartStateSent() {
        return true;
    }

    public UniversalToolProxy getUniversalToolProxy() {
        return this.utp;
    }

    public void toggleWidgetFocusForSimSt(Object dw) {
    }

    public boolean isSimStudentMode() {
        return false;
    }

    @Override
    public void addCtatModeListener(CtatModeListener listener) {
    }

    @Override
    public void closeApplication(boolean b) {
    }

    public void closeStudentInterface() {
        if (this.studentInterface == null) {
            return;
        }
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "closeStudentInterface() before clearWidgetInfo");
        }
        this.clearWidgetInformation();
        this.getPreferencesModel().setStringValue("Interface File", null);
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "closeStudentInterface() before setStuIntConnSta(Disconnected)");
        }
        if (this.utp != null && !Utils.isRuntime()) {
            this.utp.setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.Disconnected);
        }
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "closeStudentInterface() before dispose");
        }
        if (this.studentInterface instanceof JFrame) {
            ((JFrame)((Object)this.studentInterface)).dispose();
        }
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "closeStudentInterface() after dispose");
        }
        this.studentInterface = null;
    }

    @Override
    public void enqueueToolActionToStudent(Vector selection, Vector action, Vector input) {
    }

    @Override
    public BRPanel getBR_Frame() {
        return null;
    }

    @Override
    public CtatModeModel getCtatModeModel() {
        return null;
    }

    @Override
    public AbstractCtatWindow getDockedFrame() {
        return null;
    }

    @Override
    public JGraphPanel getJGraphWindow() {
        return null;
    }

    @Override
    public MissControllerExternal getMissController() {
        return null;
    }

    @Override
    public MT getModelTracer() {
        return null;
    }

    @Override
    public ProblemModel getProblemModel() {
        return null;
    }

    @Override
    public RuleActivationTree getRuleActivationTree() {
        return null;
    }

    @Override
    public boolean updateModelOnTraceFailure() {
        return false;
    }

    @Override
    public String getProblemFullName() {
        ProblemModel pm = this.getProblemModel();
        return pm == null ? null : pm.getProblemFullName();
    }

    @Override
    public String getProblemName() {
        ProblemModel pm = this.getProblemModel();
        return pm == null ? null : pm.getProblemName();
    }

    public static JComponent createStudentInterface(String studentInterfaceClassName) {
        if (studentInterfaceClassName == null) {
            return null;
        }
        Class<?> studentInterfaceClass = null;
        Class<?> cls = null;
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
            cls = Class.forName(studentInterfaceClassName, true, loader);
        }
        catch (Throwable e) {
            trace.errStack("Could not load student_interface class \"" + studentInterfaceClassName + "\"\n  using loader " + loader + ";\n  exception: " + e + ";\n  cause: " + e.getCause(), e);
            return null;
        }
        try {
            studentInterfaceClass = cls;
        }
        catch (ClassCastException cce) {
            trace.errStack("The student_interface class " + cls + " must inherit from " + JComponent.class.getName() + ";\n  exception: " + cce + ";\n  cause: " + cce.getCause(), cce);
            return null;
        }
        try {
            return (JComponent)studentInterfaceClass.newInstance();
        }
        catch (Exception e) {
            trace.errStack("Error instantiating student_interface class " + cls + ";\n  exception: " + e + ";\n  cause: " + e.getCause(), e);
            return null;
        }
    }

    @Override
    public Applet getApplet() {
        return null;
    }

    protected TSLauncherServer getTSLauncherServer() {
        return this.tsLauncherServer;
    }

    @Override
    public ProblemSummary getProblemSummary() {
        return null;
    }

    @Override
    public CTAT_Launcher getServer() {
        return null;
    }

    public void dispose() {
        if (this.utp != null) {
            this.utp.dispose();
        }
    }
}

