/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat;

import edu.cmu.hcii.ctat.CTATHTTPHandlerBase;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATHTTPServer;
import edu.cmu.pact.MessageSource;
import edu.cmu.pact.Utilities.trace;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;

public class WebServerLauncher {
    private CTATHTTPServer localWebServer = null;
    public static int localHTMLPort = 11000;
    private int wsPort = -1;
    private MessageSource msgSrc = null;

    public WebServerLauncher() {
        this(-1, null);
    }

    public WebServerLauncher(int wsPort, MessageSource msgSrc) {
        this.wsPort = wsPort;
        this.msgSrc = msgSrc;
    }

    public String launchServerAndHTMLPage(File targetHTMLFile, File problemFile, String sessionID, String mode) {
        URI generatedURL = this.initializationForHTMLPage(targetHTMLFile, problemFile, sessionID, mode);
        if (generatedURL == null) {
            return "Error intializing web server";
        }
        return this.launchURIInBrowser(generatedURL);
    }

    public URI initializationForHTMLPage(File targetHTMLFile, File question_file, String sessionID, String mode) {
        if (this.localWebServer != null) {
            this.localWebServer.startExiting();
        }
        URI generatedURL = null;
        CTATHTTPHandlerInterface handler = null;
        this.localWebServer = new CTATHTTPServer(localHTMLPort, "/", "dt.txt", handler);
        this.localWebServer.startWebServer();
        if (trace.getDebugCode("html")) {
            trace.out("html", "Server started with webRoot /");
        }
        if (this.msgSrc != null) {
            ((CTATHTTPHandlerBase)this.localWebServer.getHandler()).setGoToStateMessageSource(this.msgSrc);
        }
        try {
            generatedURL = new URI("http", "localhost:" + localHTMLPort, this.getURI(targetHTMLFile), "session=" + sessionID + (mode != null ? "&mode=" + mode : "") + (this.wsPort > 0 ? "&port=" + this.wsPort : "") + (question_file != null ? "&question_file=" + this.getURI(question_file) : "") + ("ctatAsListener".equals(mode) ? "&restore_problem_url=/goToState.cgi&problem_state_status=incomplete" : "") + (trace.getDebugCode("html") ? "&show_debug_traces=true" : ""), null);
        }
        catch (Exception e) {
            trace.errStack("Error creating URI for HTML file " + targetHTMLFile + ", sessionID " + sessionID, e);
            return null;
        }
        ++localHTMLPort;
        return generatedURL;
    }

    private String launchURIInBrowser(URI uri) {
        if (uri == null) {
            return "missing web address";
        }
        if (Desktop.isDesktopSupported()) {
            if (trace.getDebugCode("html")) {
                trace.out("html", "Opening: " + uri);
            }
            try {
                Desktop.getDesktop().browse(uri);
                return null;
            }
            catch (Exception e) {
                String msg = "Error trying to launch browser on uri " + uri;
                trace.errStack("WebServerLauncher: " + msg, e);
                return msg + ": " + e.toString();
            }
        }
        String msg = "Error: desktop operations not supported";
        trace.err("WebServerLauncher: " + msg);
        return msg;
    }

    public void startExiting() {
        if (this.localWebServer != null) {
            this.localWebServer.startExiting();
        }
    }

    private String getURI(File f) {
        String result = "";
        if (f != null) {
            result = f.toURI().toASCIIString().substring("file:".length());
        }
        if (trace.getDebugCode("html")) {
            trace.out("html", "getURI() rtns " + result);
        }
        return result;
    }
}

