/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.model;

import edu.cmu.pact.Utilities.VersionComparator;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.XMLSupport;
import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Skill
implements XMLSupport.Client,
Serializable {
    private static final long serialVersionUID = -2045143690658256687L;
    private static final String SKILL_BAR_DELIMITER_v2_11 = "`";
    private static final String SKILL_BAR_DELIMITER_v2_10 = "=";
    public static final String SKILL_BAR_DELIMITER = "=";
    public static double DEFAULT_MASTERY_THRESHOLD = 0.95f;
    public static double DEFAULT_P_GUESS = 0.2f;
    public static double DEFAULT_P_KNOWN = 0.3f;
    public static double DEFAULT_P_SLIP = 0.3f;
    public static double DEFAULT_P_LEARN = 0.15f;
    public static long DEFAULT_HISTORY = 0L;
    public static final String ELEMENT_NAME = "Skill";
    static XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat().setIndent(" ").setEncoding("UTF-8").setOmitEncoding(true).setOmitDeclaration(true).setLineSeparator("\n"));
    private static int precision = 2;
    private static final String NAME = "name";
    private static final String CATEGORY = "category";
    private final String skillName;
    private double masteryThreshold = DEFAULT_MASTERY_THRESHOLD;
    private Double pGuess;
    private Double pKnown;
    private Double pSlip;
    private Long history;
    private Double pLearn;
    private String description;
    private String label;
    private int transactionNumber = 0;
    private String skillBarDelimiter = "=";
    private int opportunityCount = 0;
    private static String floatFormat = Skill.makeFloatFormat();
    public static final String CORRECT = "correct";
    public static final String INCORRECT = "incorrect";
    public static final String HINT = "hint";
    private static Pattern HEX_REGEX = Pattern.compile("0*[xX]([0-9a-fA-F]+)");
    private static XMLSupport xmlSupport = null;

    public String getSkillBarDelimiter() {
        return this.skillBarDelimiter;
    }

    public Skill(String skillName, Double p_guess, Double p_known, Double p_slip, Double p_learn, Long _history) {
        xmlSupport = XMLSupport.initialize(this);
        this.skillName = skillName;
        this.pGuess = p_guess;
        this.pKnown = p_known;
        this.pLearn = p_learn;
        this.pSlip = p_slip;
        this.history = _history;
    }

    public Skill(String skillName) {
        this(skillName, DEFAULT_P_GUESS, DEFAULT_P_KNOWN, DEFAULT_P_SLIP, DEFAULT_P_LEARN, DEFAULT_HISTORY);
    }

    public Skill(String skillName, Double p_known) {
        this(skillName, DEFAULT_P_GUESS, p_known, DEFAULT_P_SLIP, DEFAULT_P_LEARN, DEFAULT_HISTORY);
    }

    public Skill(String skillName, Double p_known, Long _history) {
        this(skillName, DEFAULT_P_GUESS, p_known, DEFAULT_P_SLIP, DEFAULT_P_LEARN, _history);
    }

    public static Long updateHistory(String status, Long _history) {
        long h = _history << 1;
        long msb = Long.highestOneBit(-1L);
        if (((h |= (long)(status.equalsIgnoreCase(CORRECT) ? 1 : 0)) & msb) != 0L) {
            h ^= msb;
        }
        return h;
    }

    public static Double updatePKnown(String status, Double p_guess, Double p_known, Double p_slip, Double p_learn) {
        double knewIt = 0.0;
        if (status.equalsIgnoreCase(CORRECT)) {
            double guessedIt = p_guess * (1.0 - p_known);
            double knewAndPerformed = p_known * (1.0 - p_slip);
            knewIt = knewAndPerformed / (knewAndPerformed + guessedIt);
        } else if (status.equalsIgnoreCase(INCORRECT) || status.equalsIgnoreCase(HINT)) {
            double choked = p_known * p_slip;
            double dontKnowDontGuess = (1.0 - p_known) * (1.0 - p_guess);
            knewIt = choked / (choked + dontKnowDontGuess);
        }
        return new Double(knewIt + p_learn * (1.0 - knewIt));
    }

    public static double round(double d) {
        return Double.parseDouble(String.format(floatFormat, d));
    }

    public Double updatePKnown(String status) {
        this.pKnown = Skill.updatePKnown(status, this.pGuess, this.pKnown, this.pSlip, this.pLearn);
        return this.pKnown;
    }

    public Long updateHistory(String status) {
        this.history = Skill.updateHistory(status, this.history);
        return this.history;
    }

    public Skill clone() {
        return new Skill(new String(this.skillName), new Double(this.pGuess), new Double(this.pKnown), new Double(this.pSlip), new Double(this.pLearn), new Long(this.history));
    }

    public String getSkillName() {
        return this.skillName;
    }

    public String getCategory() {
        return Skill.getCategory(this.skillName);
    }

    public static String getCategory(String skillName) {
        int spPos = skillName.indexOf(32);
        if (spPos < 0) {
            return "";
        }
        return skillName.substring(spPos + 1);
    }

    public String getName() {
        return Skill.getName(this.skillName);
    }

    public static String getName(String skillName) {
        int spPos = skillName.indexOf(32);
        if (spPos < 0) {
            return skillName;
        }
        return skillName.substring(0, spPos);
    }

    public String getDescription() {
        if (this.description == null || this.description.length() < 1) {
            return this.skillName;
        }
        return this.description;
    }

    public String getLabel() {
        if (this.label == null || this.label.length() < 1) {
            return this.getName();
        }
        return this.label;
    }

    public Double getPGuess() {
        return this.pGuess;
    }

    public Double getPLearn() {
        return this.pLearn;
    }

    public Double getPSlip() {
        return this.pSlip;
    }

    public Double getPKnown() {
        return this.pKnown;
    }

    public Long getHistory() {
        return this.history;
    }

    public static Skill factory(Element elt) throws Exception {
        String skillName = elt.getAttributeValue(NAME);
        if (skillName == null || skillName.length() < 1) {
            throw new IllegalArgumentException("Bad XML for skill: required attribute name missing");
        }
        String category = elt.getAttributeValue(CATEGORY);
        if (category != null && category.length() > 0) {
            skillName = skillName + ' ' + category;
        }
        Skill sk = new Skill(skillName);
        xmlSupport.getAttributes(sk, elt);
        return sk;
    }

    public Element toXMLElement() {
        Element skElt = new Element(ELEMENT_NAME);
        skElt.setAttribute(NAME, this.getName());
        skElt.setAttribute(CATEGORY, this.getCategory());
        xmlSupport.setAttributes(this, skElt);
        return skElt;
    }

    public String toXMLString() {
        Element elt = this.toXMLElement();
        return xmlOutputter.outputString(elt);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getSkillName()).append(", pK=").append(this.getPKnown()).append("]");
        return sb.toString();
    }

    @Override
    public boolean isAttrProperty(String fName) {
        if ((fName = fName.toLowerCase()).equals("precision")) {
            return false;
        }
        return fName.startsWith("p") || fName.equals("history") || fName.equals("label") || fName.equals("description") || fName.equals("opportunitycount");
    }

    public void setPGuess(String guess) {
        try {
            this.pGuess = Double.valueOf(guess);
        }
        catch (NumberFormatException nfe) {
            trace.err("Error converting p-guess \"" + guess + "\" to float: " + nfe + ";\n  value " + this.pGuess + " unchanged");
        }
    }

    public void setPKnown(String known) {
        try {
            this.pKnown = Double.valueOf(known);
        }
        catch (NumberFormatException nfe) {
            trace.err("Error converting p-known \"" + known + "\" to float: " + nfe + ";\n  value " + this.pKnown + " unchanged");
        }
    }

    public void setPSlip(String slip) {
        try {
            this.pSlip = Double.valueOf(slip);
        }
        catch (NumberFormatException nfe) {
            trace.err("Error converting p-slip \"" + slip + "\" to float: " + nfe + ";\n  value " + this.pSlip + " unchanged");
        }
    }

    public void setPLearn(String learn) {
        try {
            this.pLearn = Double.valueOf(learn);
        }
        catch (NumberFormatException nfe) {
            trace.err("Error converting p-learn \"" + learn + "\" to float: " + nfe + ";\n  value " + this.pLearn + " unchanged");
        }
    }

    public void setHistory(String _history) {
        try {
            if (_history == null) {
                throw new NullPointerException(_history);
            }
            Matcher hm = HEX_REGEX.matcher(_history);
            this.history = hm.matches() ? Long.valueOf(hm.group(1), 16) : Long.valueOf(_history);
        }
        catch (Exception e) {
            trace.err("Error converting history \"" + _history + "\" to long integer: " + e + ";\n  value " + this.history + " unchanged");
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int changeOpportunityCount(int delta) {
        this.opportunityCount += delta;
        return this.opportunityCount;
    }

    public int getOpportunityCount() {
        return this.opportunityCount;
    }

    public void setOpportunityCount(String opportunityCount) {
        this.opportunityCount = Integer.valueOf(opportunityCount);
    }

    @Override
    public XMLSupport getXMLSupport() {
        return xmlSupport;
    }

    @Override
    public void setXMLSupport(XMLSupport newXMLSupport) {
        xmlSupport = newXMLSupport;
    }

    public double getMasteryThreshold() {
        return this.masteryThreshold;
    }

    public void setMasteryThreshold(double masteryThreshold) {
        this.masteryThreshold = masteryThreshold;
    }

    public String getSkillBarString() {
        return this.getSkillBarString(false);
    }

    public static SkillBar parseSkillBarString(String skillBarString) {
        return Skill.parseSkillBarString(skillBarString, "=");
    }

    public static SkillBar parseSkillBarString(String skillBarString, String delimiter) {
        String category = null;
        String name = null;
        Double pKnown = null;
        Boolean mastery = null;
        String label = null;
        if (skillBarString != null) {
            String sbDelimiter = delimiter == null || delimiter.length() < 1 ? "=" : delimiter;
            String[] fields = skillBarString.split(sbDelimiter);
            block8: for (int i = 0; i < fields.length; ++i) {
                switch (i) {
                    case 0: {
                        category = Skill.getCategory(fields[i]);
                        name = Skill.getName(fields[i]);
                        continue block8;
                    }
                    case 1: {
                        try {
                            pKnown = Double.valueOf(fields[i]);
                        }
                        catch (NumberFormatException nfe) {
                            trace.err("bad pKnown: " + nfe);
                        }
                        continue block8;
                    }
                    case 2: {
                        mastery = new Boolean('1' == fields[i].charAt(0));
                        continue block8;
                    }
                    case 3: {
                        label = fields[i];
                    }
                }
            }
        }
        return new SkillBar(category, name, pKnown, mastery, label);
    }

    public String getSkillBarString(boolean includeLabels) {
        StringBuffer sb = new StringBuffer(this.getSkillName());
        sb.append(this.getSkillBarDelimiter()).append(this.pKnown);
        sb.append(this.getSkillBarDelimiter()).append(this.hasReachedMastery() ? (char)'1' : '0');
        if (includeLabels) {
            sb.append(this.getSkillBarDelimiter()).append(this.getLabel());
        }
        if (trace.getDebugCode("skill")) {
            trace.out("skill", sb.toString());
        }
        return sb.toString();
    }

    public boolean hasReachedMastery() {
        if (this.pKnown == null) {
            return false;
        }
        return this.pKnown >= this.masteryThreshold;
    }

    public int getTransactionNumber() {
        return this.transactionNumber;
    }

    void setTransactionNumber(int transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    public static Skill skillBarToSkill(String skillBarStr) {
        return Skill.skillBarToSkill(skillBarStr, "=");
    }

    public static Skill skillBarToSkill(String skillBarStr, String delimiter) {
        String[] sbPieces = skillBarStr.split(delimiter);
        Skill result = new Skill(sbPieces[0]);
        if (sbPieces.length < 2) {
            return result;
        }
        try {
            result.setPKnown(sbPieces[1]);
        }
        catch (NumberFormatException nfe) {
            trace.err("bad pKnown in skill bar \"" + skillBarStr + "\": using default");
        }
        if (sbPieces.length > 3) {
            result.setLabel(sbPieces[3]);
        }
        return result;
    }

    public static String makeStepID(Vector selection, Vector action) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Vector v = selection;
        while (i++ < 2) {
            if (v != null && v.size() >= 1) {
                boolean vStarted = false;
                for (Object o : v) {
                    String s;
                    if (o == null || (s = o.toString()).length() < 1 || v == selection && (HINT.equalsIgnoreCase(s) || "help".equalsIgnoreCase(s)) || v == action && "PreviousFocus".equalsIgnoreCase(s)) continue;
                    sb.append(vStarted ? "," : "[").append(s);
                    vStarted = true;
                }
                if (vStarted) {
                    sb.append("]");
                }
            }
            v = action;
        }
        return sb.toString();
    }

    public void setVersion(String version) {
        if (version != null && version.length() > 0) {
            this.skillBarDelimiter = Skill.versionToSkillBarDelimiter(version);
        }
    }

    public static String versionToSkillBarDelimiter(String version) {
        if (version == null) {
            return "=";
        }
        if (VersionComparator.vc.compare(version, "2.11") >= 0) {
            return SKILL_BAR_DELIMITER_v2_11;
        }
        return "=";
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].toLowerCase().contains("h")) {
            System.out.printf("Usage:\n    java -cp ... %s {-v version... | [-pN] pGuess pKnown pSlip pLearn}\nwhere--\n    version... is or are CTAT version numbers to test versionToSkillBarDelimiter();\n    -pN (N a digit) means setPrecision(N); default %d;\n    pGuess pKnown etc. are arguments to updatePKnown(); defaults:\n        pGuess " + Skill.makeFloatFormat() + ", pKnown " + Skill.makeFloatFormat() + ", pSlip " + Skill.makeFloatFormat() + ", pLearn " + Skill.makeFloatFormat() + ".\n" + Skill.class.getName(), Skill.getPrecision(), DEFAULT_P_GUESS, DEFAULT_P_KNOWN, DEFAULT_P_SLIP, DEFAULT_P_LEARN);
            System.exit(2);
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("-v")) {
            for (int i = 1; i < args.length; ++i) {
                System.out.printf("versionToSkillBarDelimiter(%s) -> %s\n", args[i], Skill.versionToSkillBarDelimiter(args[i]));
            }
            String v = null;
            System.out.printf("versionToSkillBarDelimiter(%s) -> %s\n", v, Skill.versionToSkillBarDelimiter(v));
            return;
        }
        Double[] pArgs = new Double[]{DEFAULT_P_GUESS, DEFAULT_P_KNOWN, DEFAULT_P_SLIP, DEFAULT_P_LEARN};
        int i = 0;
        try {
            if (args.length > 0 && args[i].startsWith("-p")) {
                Skill.setPrecision(Integer.parseInt(args[i++].substring("-p".length())));
            }
        }
        catch (Exception e) {
            System.err.printf("Error %s converting precision argument[%d]: using default %d", e.toString(), i, Skill.getPrecision());
        }
        int j = 0;
        while (i < args.length) {
            try {
                pArgs[j] = Double.parseDouble(args[i]);
            }
            catch (Exception e) {
                System.err.printf("Error %s converting argument[%d]: using default " + Skill.makeFloatFormat() + "", e.toString(), i, pArgs[i]);
            }
            ++j;
            ++i;
        }
        System.out.printf("For pGuess " + Skill.makeFloatFormat() + ", pKnown " + Skill.makeFloatFormat() + ", pSlip " + Skill.makeFloatFormat() + ", pLearn " + Skill.makeFloatFormat() + ":\n    updatePKnown(%9s) = " + Skill.makeFloatFormat() + "\n    updatePKnown(%9s) = " + Skill.makeFloatFormat() + "\n", pArgs[0], pArgs[1], pArgs[2], pArgs[3], CORRECT, Skill.updatePKnown(CORRECT, pArgs[0], pArgs[1], pArgs[2], pArgs[3]), INCORRECT, Skill.updatePKnown(INCORRECT, pArgs[0], pArgs[1], pArgs[2], pArgs[3]));
    }

    public static int getPrecision() {
        return precision;
    }

    static String makeFloatFormat() {
        floatFormat = "%." + precision + "f";
        return floatFormat;
    }

    public static void setPrecision(int precision) {
        Skill.precision = precision;
    }

    public static class SkillBar
    implements Serializable {
        private static final long serialVersionUID = -539319473342965130L;
        private String category;
        private String name;
        private Double pKnown;
        private Boolean mastery;
        private String label;

        private SkillBar(String category, String name, Double pKnown, Boolean mastery, String label) {
            this.category = category;
            this.name = name;
            this.pKnown = pKnown;
            this.mastery = mastery;
            this.label = label;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public Double getPKnown() {
            return this.pKnown;
        }

        public Boolean getMastery() {
            return this.mastery;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

