/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctatview;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.pact.BehaviorRecorder.Controller.AuthorLauncherServer;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.model.CtatModeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pact.CommWidgets.RemoteProxy;
import pact.CommWidgets.StudentInterfaceConnectionStatus;
import pact.CommWidgets.UniversalToolProxy;

public class CtatModePanel
extends JComponent
implements ChangeListener {
    private static final long serialVersionUID = 6550476531267520998L;
    private static final String SICS_LABEL_TOOL_TIP = "<html>CTAT can be launched to connect to student interfaces<br/>running either in <b>Java</b> or in <b>HTML</b> or <b>Flash</b>.</html>";
    private Color startColor;
    private Color endColor;
    private JComboBox tutorTypeComboBox;
    private JComboBox authorModeComboBox;
    private final CTAT_Launcher ctatLauncher;
    public static final String TUTOR_TYPE_TOOL_TIP_TEXT = "<html>&nbsp;<b>Example-tracing Tutors</b> use demonstrated examples of problem-solving steps to evaluate student actions.<br>&nbsp;<b>Cognitive Tutors</b> employ a general cognitive model, composed of production rules, to evaluate or suggest student actions." + (VersionInformation.isRunningSimSt() ? "<br>&nbsp;<b>Simulated Student</b> induces production rules from demonstrated examples of problem-solving steps." : "") + "</html>";
    public static final String AUTHOR_MODE_TOOL_TIP_TEXT = "<html>&nbsp;<b>Set Start State mode:</b> enter the initial state of a problem.<br>&nbsp;<b>Demonstrate mode:</b> record problem-solving steps in a behavior graph.<br>&nbsp;<b>Test Tutor mode:</b> test the behavior of your tutor.</html>";
    public static final String AUTHOR_MODE_COMBO_BOX_EVENT_CMD = "AuthorModeComboBox changed";
    Icon logo = null;
    private JLabel sicsLabel = null;
    private Box collabPanel = null;
    private JLabel collabCount = null;

    public CtatModePanel(CTAT_Launcher server) {
        this.ctatLauncher = server;
        this.init();
        this.startColor = new Color(200, 200, 200);
        this.endColor = new Color(240, 240, 240);
        if (server.getAuthorLauncherServer() != null) {
            server.getAuthorLauncherServer().addChangeListener(this);
        }
    }

    protected void debug(String aMessage) {
        CTATBase.debug("CtatModePanel", aMessage);
    }

    protected void update(CtatModeEvent.SetModeEvent event) {
        trace.out("event = " + event);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int panelHeight = this.getHeight();
        int panelWidth = this.getWidth();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.startColor, panelWidth, panelHeight, this.endColor);
        if (g instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)g;
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, panelWidth, panelHeight);
            graphics2D.setColor(new Color(0, 0, 0));
            graphics2D.drawLine(0, panelHeight - 1, panelWidth, panelHeight - 1);
        }
    }

    private void init() {
        this.debug("init()");
        BorderLayout frameBox = new BorderLayout();
        this.setLayout(frameBox);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        panel.setOpaque(false);
        panel.setMinimumSize(new Dimension(100, 28));
        panel.setMaximumSize(new Dimension(50000, 28));
        JLabel tutorTypeLabel = new JLabel("Tutor Type:");
        tutorTypeLabel.setFont(new Font("Dialog", 0, 12));
        tutorTypeLabel.setToolTipText(TUTOR_TYPE_TOOL_TIP_TEXT);
        CtatModeModel ctatModeModel = this.getCtatLauncher().getFocusedController().getCtatModeModel();
        this.tutorTypeComboBox = new JComboBox(ctatModeModel.getModeComboBoxModel());
        this.tutorTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.tutorTypeComboBox.setName("tutorTypeComboBox");
        this.tutorTypeComboBox.setToolTipText(TUTOR_TYPE_TOOL_TIP_TEXT);
        this.tutorTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CtatModePanel.this.getCtatLauncher().getFocusedController().getCtatModeModel().userSetMode((String)CtatModePanel.this.tutorTypeComboBox.getSelectedItem());
                CtatModePanel.this.getCtatLauncher().getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", "SWITCH_MODE", CtatModePanel.this.tutorTypeComboBox.getSelectedItem().toString() + ", " + CtatModePanel.this.authorModeComboBox.getSelectedItem().toString());
            }
        });
        JLabel authorModeLabel = new JLabel("Author Mode:");
        authorModeLabel.setFont(new Font("Dialog", 0, 12));
        authorModeLabel.setToolTipText(AUTHOR_MODE_TOOL_TIP_TEXT);
        ComboBoxModel authorModeModel = this.getCtatLauncher().getFocusedController().getCtatModeModel().getAuthorModeComboBoxModel();
        this.authorModeComboBox = new JComboBox(authorModeModel);
        this.authorModeComboBox.setFont(new Font("Dialog", 0, 12));
        this.authorModeComboBox.setName("authorModeComboBox");
        this.authorModeComboBox.setActionCommand(AUTHOR_MODE_COMBO_BOX_EVENT_CMD);
        this.authorModeComboBox.setToolTipText(AUTHOR_MODE_TOOL_TIP_TEXT);
        this.authorModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CtatModePanel.this.getCtatLauncher().getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", "SWITCH_MODE", CtatModePanel.this.tutorTypeComboBox.getSelectedItem().toString() + ", " + CtatModePanel.this.authorModeComboBox.getSelectedItem().toString());
            }
        });
        c.gridy = 0;
        c.insets = new Insets(5, 10, 5, 0);
        c.weightx = 0.0;
        c.anchor = 13;
        panel.add((Component)tutorTypeLabel, c);
        c.insets = new Insets(5, 5, 5, 0);
        c.weightx = 1.0;
        c.anchor = 17;
        panel.add((Component)this.tutorTypeComboBox, c);
        c.insets = new Insets(5, 15, 5, 0);
        c.weightx = 0.0;
        c.anchor = 13;
        panel.add((Component)authorModeLabel, c);
        c.insets = new Insets(5, 5, 5, 0);
        c.weightx = 1.0;
        c.anchor = 17;
        panel.add((Component)this.authorModeComboBox, c);
        JLabel collabLabel = new JLabel("Collaborators");
        collabLabel.setName("collabLabel");
        collabLabel.setFont(new Font("Dialog", 0, 10));
        collabLabel.setAlignmentX(0.5f);
        collabLabel.setAlignmentY(0.5f);
        this.collabCount = new JLabel("0 of 0");
        this.collabCount.setName("collabCount");
        this.collabCount.setFont(new Font("Dialog", 0, 12));
        this.collabCount.setOpaque(true);
        this.collabCount.setBackground(Color.green.brighter().brighter());
        this.collabCount.setAlignmentX(0.5f);
        this.collabCount.setAlignmentY(0.0f);
        Dimension dim = this.collabCount.getPreferredSize();
        this.collabCount.setMaximumSize(new Dimension(Integer.MAX_VALUE, dim.height));
        this.collabCount.setHorizontalAlignment(0);
        this.collabCount.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
        this.collabPanel = new Box(1);
        this.collabPanel.add(collabLabel);
        this.collabPanel.add(this.collabCount);
        this.collabPanel.setVisible(false);
        c.insets = new Insets(1, 5, 1, 0);
        c.weightx = 1.0;
        c.anchor = 17;
        panel.add((Component)this.collabPanel, c);
        this.sicsLabel = new JLabel(this.getSicsLabelText());
        this.sicsLabel.setName("studentInterfaceConnectionStatusLabel");
        this.sicsLabel.setFont(new Font("Dialog", 0, 12));
        this.sicsLabel.setToolTipText(SICS_LABEL_TOOL_TIP);
        c.insets = new Insets(5, 0, 6, 5);
        c.anchor = 13;
        c.weightx = 0.0;
        panel.add((Component)this.sicsLabel, c);
        this.add(panel);
    }

    private String getSicsLabelText() {
        String result = "No Student Interface Connected";
        UniversalToolProxy utp = this.getCtatLauncher().getFocusedController().getUniversalToolProxy();
        if (utp != null && !Utils.isRuntime()) {
            result = String.format("For %s Student Interfaces", utp.getStudentInterfacePlatform());
        }
        return result;
    }

    public ComboBoxModel getComboBoxModel() {
        return this.tutorTypeComboBox.getModel();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "CtatModePanel.stateChanged() source " + e.getSource());
        }
        if (e.getSource() instanceof UniversalToolProxy || e.getSource() instanceof RemoteProxy) {
            this.updateStudentConnectionStatus();
        }
        if (e.getSource() instanceof AuthorLauncherServer) {
            this.updateCollabCounts((AuthorLauncherServer)e.getSource());
        }
    }

    private void updateCollabCounts(AuthorLauncherServer als) {
        int[] counts = als.getCollaborationCounts();
        final int nCollabs = counts[0];
        final int teamSize = counts[1];
        Runnable collabUpdater = new Runnable(){

            @Override
            public void run() {
                if (teamSize < 2) {
                    CtatModePanel.this.collabPanel.setToolTipText(null);
                    CtatModePanel.this.collabPanel.setVisible(false);
                } else {
                    if (nCollabs < teamSize) {
                        CtatModePanel.this.collabCount.setBackground(Color.pink);
                        CtatModePanel.this.collabPanel.setToolTipText(String.format("<html>The collaborators' team size is %d, but %sstudent interface%s connected so far.</html>", teamSize, nCollabs < 1 ? "no<br />" : "only <br />" + nCollabs + " ", nCollabs < 2 ? " is" : "s are"));
                    } else {
                        CtatModePanel.this.collabCount.setBackground(Color.green.brighter().brighter());
                        CtatModePanel.this.collabPanel.setToolTipText("All collaborators are now active.");
                    }
                    CtatModePanel.this.collabCount.setText(String.format("%d of %d", nCollabs, teamSize));
                    CtatModePanel.this.collabPanel.setVisible(true);
                }
            }
        };
        SwingUtilities.invokeLater(collabUpdater);
    }

    private void updateStudentConnectionStatus() {
        this.sicsLabel.setText(this.getSicsLabelText());
    }

    private CTAT_Launcher getCtatLauncher() {
        return this.ctatLauncher;
    }

    public void changeModes(BR_Controller controller) {
        ComboBoxModel modeModel = controller.getCtatModeModel().getModeComboBoxModel();
        ComboBoxModel authorModel = controller.getCtatModeModel().getAuthorModeComboBoxModel();
        this.tutorTypeComboBox.setModel(modeModel);
        this.authorModeComboBox.setModel(authorModel);
        this.tutorTypeComboBox.setSelectedItem(modeModel.getSelectedItem());
        this.authorModeComboBox.setSelectedItem(authorModel.getSelectedItem());
    }

    public void createStartState() {
        this.authorModeComboBox.setSelectedItem("Demonstrate");
    }

    public boolean checkCreateStartState(BR_Controller controller) {
        boolean shouldCreate = false;
        UniversalToolProxy utp = controller.getUniversalToolProxy();
        if (utp == null || utp.getStudentInterfaceConnectionStatus() == StudentInterfaceConnectionStatus.Disconnected) {
            int result = JOptionPane.showConfirmDialog(controller.getCtatFrameController().getDockedFrame(), "No student interface is active. Do you really want to \r\ncreate an empty start state for the problem graph?", "Create Start State", 0, 2);
            if (result == 0) {
                shouldCreate = true;
            }
        } else if (!utp.isStartStateModified()) {
            int result = JOptionPane.showConfirmDialog(controller.getCtatFrameController().getDockedFrame(), "No values have been entered in the student interface to \r\ndefine the problem for the student to solve. Do you really \r\nwant to create an empty start state for the problem graph?", "Create Start State", 0, 2);
            if (result == 0) {
                shouldCreate = true;
            }
        } else {
            shouldCreate = true;
        }
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "checkCreateStartState() shouldCreate=" + shouldCreate);
        }
        return shouldCreate;
    }

    public String queryForProblemName() {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "*! BR_Ctlr.queryForProblemName()");
        }
        while (this.checkCreateStartState(this.getCtatLauncher().getFocusedController())) {
            String problemName = JOptionPane.showInputDialog(this.getCtatLauncher().getActiveWindow(), (Object)"Please enter the problem name for this start state.");
            if (problemName == null) {
                return null;
            }
            boolean goodName = ProblemModel.checkForValidProblemName(problemName);
            if (!goodName) {
                String[] messages = new String[]{"The problem name must be non-empty can only contain ", "alphabetic characters, digits, +, - and _."};
                JOptionPane.showMessageDialog(this.getCtatLauncher().getActiveWindow(), messages, "Invalid Name", 1);
                continue;
            }
            return problemName;
        }
        return null;
    }

    public void addAuthorModeListener(ActionListener listener) {
        this.authorModeComboBox.addActionListener(listener);
    }
}

