/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessModelTracing;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jess.Rete;
import jess.Userfunction;
import jess.Userpackage;

public class FunctionPackage
implements Userpackage {
    private List functionInstances = new ArrayList();

    public FunctionPackage(String[] classNames, JessModelTracing jmt) {
        Class[] jmtParam = new Class[]{JessModelTracing.class};
        Class[] noParam = new Class[]{};
        Object[] jmtArg = new Object[]{jmt};
        Object[] noArg = new Object[]{};
        for (int i = 0; i < classNames.length; ++i) {
            Class<?> clazz;
            try {
                clazz = Class.forName(classNames[i]);
            }
            catch (ClassNotFoundException cnfe) {
                trace.err("Could not load class " + classNames[i] + ": " + cnfe);
                continue;
            }
            Object functionInstance = null;
            String lastNSMError = null;
            for (int j = 0; functionInstance == null && j < 2; ++j) {
                Class[] formalArgs = j < 1 ? jmtParam : noParam;
                Object[] actualArgs = j < 1 ? jmtArg : noArg;
                String signature = classNames[i] + "(" + (j < 1 ? "JessModelTracing" : "") + ")";
                try {
                    Constructor<?> constructor = clazz.getConstructor(formalArgs);
                    functionInstance = constructor.newInstance(actualArgs);
                    if (!trace.getDebugCode("mt")) continue;
                    trace.outNT("mt", "FunctionPackage loaded " + signature);
                    continue;
                }
                catch (NoSuchMethodException nsme) {
                    if (j < 1) {
                        lastNSMError = "Could not find constructor " + signature;
                        continue;
                    }
                    trace.err(lastNSMError + "or constructor " + signature + "): " + nsme);
                    continue;
                }
                catch (Exception e) {
                    trace.err("Error calling constructor " + signature + ": " + e);
                }
            }
            if (functionInstance instanceof Userfunction) {
                this.functionInstances.add(functionInstance);
                continue;
            }
            trace.err("Error loading " + classNames[i] + ": class does not implement jess.Userfunction");
        }
    }

    public void add(Rete engine) {
        int i = 0;
        Iterator it = this.functionInstances.iterator();
        while (it.hasNext()) {
            engine.addUserfunction((Userfunction)it.next());
            ++i;
        }
    }

    public int size() {
        return this.functionInstances.size();
    }
}

