/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jess.Context;
import jess.Defquery;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.HasLHS;
import jess.JessException;
import jess.QueryResult;
import jess.Rete;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import org.jdom.Content;
import org.jdom.Element;

public class GetCustomFieldsFact
implements Userfunction,
Serializable {
    private static final long serialVersionUID = 201310051610L;
    private static final String NAME = "get-custom-fields-fact";
    public static final String CUSTOM_FIELDS = "custom-fields";
    public static final String GET_CUSTOM_FIELDS = "get-custom-fields";
    private static final String DEFQUERY = "(defquery get-custom-fields  \"Retrieve any facts of type custom-fields\"  ?cf <- (custom-fields))";

    public String getName() {
        return NAME;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        Fact fact = GetCustomFieldsFact.get(context.getEngine());
        if (fact == null) {
            return Funcall.NIL;
        }
        return new FactIDValue(fact);
    }

    public static Fact get(Rete rete) {
        return GetCustomFieldsFact.get(rete, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fact get(Rete rete, boolean create) {
        Deftemplate dt;
        block20: {
            dt = null;
            try {
                HasLHS hasLHS = rete.findDefrule(GET_CUSTOM_FIELDS);
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "GetCustomFieldsFact() found " + hasLHS + ": deftemplate " + rete.findDeftemplate(CUSTOM_FIELDS));
                }
                if (null == (dt = rete.findDeftemplate(CUSTOM_FIELDS))) {
                    return null;
                }
                if (!(hasLHS instanceof Defquery)) {
                    if (null != hasLHS) {
                        throw new IllegalStateException("GetCustomFieldsFact: construct of type " + hasLHS.getClass().getSimpleName() + " has same name as defquery " + GET_CUSTOM_FIELDS);
                    }
                    Value v = rete.eval(DEFQUERY);
                    if (!Funcall.TRUE.equals(v)) {
                        throw new IllegalStateException("GetCustomFieldsFact: failed to parse defquery get-custom-fields");
                    }
                }
            }
            catch (Exception e) {
                String errorMessage = "Error finding deftemplate or defquery for get-custom-fields: " + e;
                trace.errStack(errorMessage, e);
                if (!(rete instanceof MTRete)) break block20;
                ((MTRete)rete).getTextOutput().append("\n").append(errorMessage).append("\n");
            }
        }
        Fact result = null;
        try (QueryResult qr = null;){
            qr = rete.runQueryStar(GET_CUSTOM_FIELDS, new ValueVector(0));
            if (qr.next()) {
                result = qr.get("cf").factValue(rete.getGlobalContext());
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "GetCustomFieldsFact() returning existing fact:\n  " + result);
                }
                Fact fact = result;
                return fact;
            }
            if (!create) {
                Fact fact = null;
                return fact;
            }
            result = rete.assertFact(new Fact(dt));
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "GetCustomFieldsFact() returning new fact:\n  " + result);
            }
            Fact fact = result;
            return fact;
        }
    }

    public static List<Element> toXML(Fact f, Context ctx) {
        if (f == null) {
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        Deftemplate dt = f.getDeftemplate();
        for (int i = 0; i < dt.getNSlots(); ++i) {
            String slotName = null;
            Object vObj = null;
            try {
                slotName = dt.getSlotName(i);
                Value v = f.getSlotValue(slotName);
                vObj = Utils.jessValueToJava(v, ctx);
            }
            catch (Exception e) {
                trace.errStack(String.format("Error in toXML() on slot[%d] name %s: %s", i, slotName, e.toString()), e);
            }
            Element nameElt = new Element("name");
            nameElt.addContent(slotName);
            Element valueElt = new Element("value");
            if (vObj != null) {
                if (!(vObj instanceof List)) {
                    valueElt.addContent(vObj.toString());
                } else {
                    int j = 0;
                    List vList = (List)vObj;
                    if (j < vList.size()) {
                        valueElt.addContent(vList.get(j).toString());
                    }
                    while (++j < vList.size()) {
                        valueElt.addContent(";").addContent(vList.get(j).toString());
                    }
                }
            }
            Element elt = new Element("custom_field");
            elt.addContent((Content)nameElt).addContent((Content)valueElt);
            result.add(elt);
        }
        return result;
    }

    public static Fact clear(Rete rete) {
        String errorMessage;
        Deftemplate dt;
        block11: {
            dt = null;
            try {
                dt = rete.findDeftemplate(CUSTOM_FIELDS);
                if (dt == null) {
                    return null;
                }
            }
            catch (JessException je) {
                String errorMessage2 = "Error finding deftemplate for get-custom-fields: " + (Object)((Object)je);
                trace.errStack(errorMessage2, je);
                if (rete instanceof MTRete) {
                    ((MTRete)rete).getTextOutput().append("\n").append(errorMessage2).append("\n");
                }
                return null;
            }
            try {
                Fact f = GetCustomFieldsFact.get(rete, false);
                if (f != null) {
                    rete.retract(f);
                }
            }
            catch (JessException je) {
                errorMessage = "Error retracting custom-fields fact: " + (Object)((Object)je);
                trace.errStack(errorMessage, je);
                if (!(rete instanceof MTRete)) break block11;
                ((MTRete)rete).getTextOutput().append("\n").append(errorMessage).append("\n");
            }
        }
        try {
            Fact result = rete.assertFact(new Fact(dt));
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "GetCustomFieldsFact.clear() returns new fact:\n  " + result);
            }
            return result;
        }
        catch (JessException je) {
            errorMessage = "Error asserting custom-fields fact: " + (Object)((Object)je);
            trace.errStack(errorMessage, je);
            if (rete instanceof MTRete) {
                ((MTRete)rete).getTextOutput().append("\n").append(errorMessage).append("\n");
            }
            return null;
        }
    }
}

