/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.TextOutput;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.HintFact;
import edu.cmu.pact.jess.JessOracleRete;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.ModelTracingUserfunction;
import edu.cmu.pact.jess.ResumeBreak;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.jess.RuleActivationTree;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jess.Context;
import jess.JessException;
import jess.ValueVector;

public class JessModelTracing {
    private RuleActivationNode rootActivation;
    private RuleActivationTree tree;
    private MTRete rete;
    boolean saiFound = false;
    private ArrayList<RuleActivationNode> nodeSeq = new ArrayList();
    private String defaultSkillCategory = null;
    static final int CORRECT = 1;
    static final int NOMODEL = 2;
    static final int BUGGY = 3;
    static final int FIREABLE = 4;
    static final int HINT = 5;
    private TextOutput textOutput = TextOutput.getNullOutput();
    private int nFirings = 0;
    private int maxDepth = 0;
    ResumeBreak resumeBreak;
    boolean useBreakPoints = false;
    static final String NOTAPPLICABLE = "No-Applicable";
    public static final String SUCCESS = "SUCCESS";
    public static final String NO_MODEL = "NO-MODEL";
    public static final String BUG = "BUG";
    public static final String FIREABLEBUG = "FIREABLE-BUG";
    public static final String HINT_RESULT = "HINT";
    private boolean hintMsgsRequired;
    private boolean isHint;
    private String studentSelection;
    private String studentAction;
    private String studentInput;
    private String tutorSelection = null;
    private String tutorAction = null;
    private String tutorInput = null;
    protected RuleActivationNode nodeNowFiring;
    private Vector modelTracingHooks;
    private List<String> wmImages;
    private boolean skipTree;
    private boolean skipWhyNotSaves = false;

    public ArrayList<String> getRuleSeq() {
        ArrayList<String> ruleSeq = new ArrayList<String>();
        Iterator<RuleActivationNode> it = this.nodeSeq.iterator();
        while (it.hasNext()) {
            ruleSeq.add(it.next().getDisplayName());
        }
        return ruleSeq;
    }

    public ArrayList<String> getSkillSeq() {
        ArrayList<String> skillSeq = new ArrayList<String>();
        Iterator<RuleActivationNode> it = this.nodeSeq.iterator();
        while (it.hasNext()) {
            skillSeq.addAll(it.next().getSkillNames(this.rete, this.defaultSkillCategory));
        }
        return skillSeq;
    }

    public JessModelTracing(MTRete r, CTAT_Controller controller) {
        this.rete = r;
        this.resumeBreak = new ResumeBreak();
        this.rootActivation = RuleActivationNode.create(null, 0);
        if (controller == null || Utils.isRuntime()) {
            return;
        }
        this.tree = controller.getRuleActivationTree();
        this.updateRuleActivationTree();
    }

    public boolean isHintTrace() {
        return this.isHint;
    }

    public String getStudentAction() {
        return this.studentAction;
    }

    public String getStudentInput() {
        return this.studentInput;
    }

    public String getStudentSelection() {
        return this.studentSelection;
    }

    public MTRete getRete() {
        return this.rete;
    }

    public void dispose() {
        this.rete = null;
        this.nodeSeq.clear();
        this.nodeSeq = null;
        this.textOutput = TextOutput.getNullOutput();
    }

    public void setErrorArea(TextOutput t) {
        this.textOutput = t == null ? TextOutput.getNullOutput() : t;
    }

    public void setUseBreakPoints(boolean b) {
        this.useBreakPoints = b;
    }

    RuleActivationTree getRuleActivationTree() {
        return this.tree;
    }

    public void updateRuleActivationTree() {
        if (this.tree != null) {
            this.tree.setRete(this.rete);
            this.tree.setResumeBreak(this.resumeBreak);
        }
    }

    private void displayTree() {
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "JMT.displayTree() tree " + this.tree + ", skipTree " + this.skipTree);
        }
        if (this.tree != null && !this.skipTree) {
            this.tree.displayTree();
            this.tree.getDisplayPanel().validate(this.tree);
        }
    }

    public RuleActivationNode getNodeNowFiring() {
        return this.nodeNowFiring;
    }

    public void setNodeNowFiring(RuleActivationNode nodeNowFiring) {
        this.nodeNowFiring = nodeNowFiring;
    }

    static String resultToString(int returnValue) {
        switch (returnValue) {
            case 1: {
                return SUCCESS;
            }
            case 2: {
                return NO_MODEL;
            }
            case 3: {
                return BUG;
            }
            case 4: {
                return FIREABLEBUG;
            }
            case 5: {
                return HINT_RESULT;
            }
        }
        return "(undefined)";
    }

    boolean isBuggyRuleSequence(List<RuleActivationNode> nodeSeq) {
        for (RuleActivationNode node : nodeSeq) {
            if (!MTRete.isBuggyRuleName(node.getName())) continue;
            return true;
        }
        return false;
    }

    boolean isFireableBuggyRuleSequence(List<RuleActivationNode> nodeSeq) {
        boolean result = false;
        for (RuleActivationNode node : nodeSeq) {
            if (MTRete.isBuggyRuleName(node.getName())) {
                return false;
            }
            if (!MTRete.isFireableBuggyRuleName(node.getName())) continue;
            result = true;
        }
        return result;
    }

    boolean isCorrectRuleSequence(List<RuleActivationNode> nodeSeq) {
        for (RuleActivationNode node : nodeSeq) {
            if (MTRete.isCorrectRuleName(node.getName())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runModelTrace(boolean useBreakPoints, boolean isHint, String sel, String act, String inp, Vector<String> messages) {
        long startTime = new Date().getTime();
        int rtnVal = Integer.MIN_VALUE;
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "to call modelTrace after synch: isHint " + isHint + ", sel " + sel + ", act " + act + ", inp " + inp);
        }
        JessModelTracing jessModelTracing = this;
        synchronized (jessModelTracing) {
            this.setUseBreakPoints(useBreakPoints);
            rtnVal = this.modelTrace(isHint, sel, act, inp, messages);
        }
        long endTime = new Date().getTime();
        long duration = endTime - startTime;
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "modelTrace(isHint " + isHint + ", sel " + sel + ", act " + act + ", inp " + inp + ") returns " + rtnVal + "; duration " + duration);
        }
        return JessModelTracing.resultToString(rtnVal);
    }

    public int modelTrace(boolean isHint, String selection, String action, String input, Vector<String> msgs) {
        this.wmImages = null;
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "modelTrace() rete=" + this.rete.hashCode());
        }
        if (this.modelTracingHooks != null && !this.modelTracingHooks.isEmpty()) {
            this.callHookFunctions(selection, action, input);
        }
        if (trace.getDebugCode("ishint")) {
            trace.out("ishint", "JMT.modelTrace()@" + this.hashCode() + " isHint was " + this.isHint + ", now " + isHint);
        }
        this.isHint = this.hintMsgsRequired = isHint;
        this.studentSelection = selection;
        this.studentAction = action;
        this.studentInput = input;
        this.clearTutorSAI();
        this.nodeSeq.clear();
        this.saiFound = false;
        this.rete.unloadBuggyRules();
        this.iterativeDeepening(this.tree, this.rete.getMaxDepth(), selection, action, input);
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "nodeSeq.size() after 1st iterativeDeepening " + this.nodeSeq.size() + "; clearing hintMsgsRequired, was " + this.hintMsgsRequired);
        }
        this.hintMsgsRequired = false;
        if (this.nodeSeq.size() <= 0 && !this.rete.useSinglePassTrace()) {
            try {
                this.rete.loadBuggyRules(this.textOutput);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.iterativeDeepening(this.tree, this.rete.getMaxDepth(), selection, action, input);
            if (trace.getDebugCode("mtt")) {
                trace.out("mtt", "nodeSeq.size() after +buggy iterativeDeepening " + this.nodeSeq.size());
            }
        }
        int rtnVal = -1;
        if (this.nodeSeq.size() > 0) {
            if (msgs != null) {
                msgs.addAll(this.getMessages(isHint, this.nodeSeq));
            }
            rtnVal = isHint ? 5 : (this.isBuggyRuleSequence(this.nodeSeq) ? 3 : (this.isFireableBuggyRuleSequence(this.nodeSeq) ? 4 : 1));
            this.setTutorSAI(isHint, this.nodeSeq);
        } else {
            rtnVal = 2;
        }
        this.displayTree();
        if (!(isHint || rtnVal != 3 && rtnVal != 2)) {
            this.clearTutorSAI();
            this.nodeSeq.clear();
            this.saiFound = false;
            HintFact.setHintFact(true, this.getRete());
            this.isHint = true;
            this.iterativeDeepening(null, this.rete.getMaxDepth(), selection, action, "");
            this.setTutorSAI(this.isHint, this.nodeSeq);
        }
        return rtnVal;
    }

    private void clearTutorSAI() {
        this.tutorSelection = null;
        this.tutorAction = null;
        this.tutorInput = null;
    }

    private boolean iterativeDeepening(RuleActivationTree tree, int maxDepth, String selection, String action, String input) {
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "iterativeDeepening(" + maxDepth + "," + (this.isHint ? HINT_RESULT : "SAI") + "," + selection + "," + action + "," + input);
        }
        this.clearTutorSAI();
        this.nFirings = 0;
        this.maxDepth = maxDepth;
        int depth = 1;
        boolean searchSucceeded = false;
        try {
            do {
                this.rootActivation = RuleActivationNode.create(null, 0);
                if (tree != null) {
                    tree.reset(this.rootActivation);
                }
                if (MTRete.displayChain || MTRete.displayFired) {
                    this.textOutput.append("\nIteration: " + depth);
                }
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "jmt.iterativeDeepening() depth=" + depth);
                }
                RuleActivationNode root = this.rootActivation;
                root.saveState(this.rete);
                List wholeAgenda = this.rete.getAgendaAsList(null);
                root.createChildren(wholeAgenda, this.isHint);
                List children = root.getChildren();
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "root.children.size() " + children.size());
                }
                for (int i = 0; !searchSucceeded && i < children.size(); ++i) {
                    RuleActivationNode child = (RuleActivationNode)children.get(i);
                    root.setUpState(this.rete, i);
                    searchSucceeded = this.newDepthLimited(child, this.isHint, depth, selection, action, input);
                }
                ++this.maxDepth;
            } while (!searchSucceeded && this.maxDepth <= this.rete.getMaxDepth() && !MTRete.stopModelTracing);
            if ((this.isHint || !searchSucceeded || this.isBuggyRuleSequence(this.nodeSeq)) && this.nFirings > 0) {
                this.rootActivation.loadState(this.rete);
            }
            return searchSucceeded;
        }
        catch (Exception e) {
            trace.err("Error from iterativeDeepening at depth " + depth + ": " + e);
            e.printStackTrace();
            return false;
        }
    }

    private boolean newDepthLimited(RuleActivationNode node, boolean isHint, int depth, String selection, String action, String input) throws Exception {
        boolean toSaveState;
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "newDepthLimited: depth " + depth + " this.maxDepth " + this.maxDepth);
        }
        if (depth > this.maxDepth) {
            return false;
        }
        node.setStudentSAI(selection, action, input);
        this.nodeNowFiring = node;
        List childActivations = node.fire(this.rete);
        ++this.nFirings;
        this.nodeNowFiring = null;
        if (MTRete.displayChain) {
            this.textOutput.append(this.indent(depth) + depth + ". " + node.getName());
        }
        this.processBreakpoint(node.getName(), this.maxDepth);
        int result = node.getMatchResult();
        if (result == 4) {
            result = node.isStudentSAIFound(selection, action, input, isHint, this.rete.getGlobalContext());
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "isSAIFound() returns " + result);
        }
        this.setTutorSAI(isHint, result, node);
        boolean bl = toSaveState = !Utils.isRuntime() && !this.skipWhyNotSaves || childActivations.size() > 1;
        if (trace.getDebugCode("whynot")) {
            trace.out("whynot", String.format("To save state if %b <= (! runtime %b && ! skip %b) || (nChild %d > 1)", toSaveState, Utils.isRuntime(), this.skipWhyNotSaves, childActivations.size()));
        }
        if (toSaveState) {
            node.saveState(this.rete);
        }
        boolean[] endSearch = new boolean[1];
        if (this.endChain(isHint, result, node.getNodeSequence(new ArrayList<RuleActivationNode>()), endSearch)) {
            return endSearch[0];
        }
        if (depth >= this.maxDepth) {
            return false;
        }
        RuleActivationNode chainNode = RuleActivationNode.create(-1, null, depth, node);
        chainNode.copyState(node);
        if (childActivations.size() < 1) {
            return false;
        }
        chainNode.createChildren(childActivations, isHint);
        List children = chainNode.getChildren();
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "newDepthLimited(" + depth + "): " + chainNode.getNodeId() + " children.size() " + children.size());
        }
        for (int i = 0; i < children.size(); ++i) {
            RuleActivationNode child = (RuleActivationNode)children.get(i);
            chainNode.setUpState(this.rete, i);
            boolean childResult = this.newDepthLimited(child, isHint, depth + 1, selection, action, input);
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "newDepthLimited(" + depth + "): child[" + i + "] " + child.getNodeId() + " result " + childResult);
            }
            if (!childResult) continue;
            return true;
        }
        return false;
    }

    private boolean setNodeSeq(boolean isHint, ArrayList<RuleActivationNode> nodeSeq) {
        if (!isHint) {
            this.nodeSeq = new ArrayList<RuleActivationNode>(nodeSeq);
            return true;
        }
        int oldResult = this.getMatchResult(this.nodeSeq);
        int newResult = this.getMatchResult(nodeSeq);
        int oldNHints = this.countHints(this.nodeSeq);
        int newNHints = this.countHints(nodeSeq);
        if (trace.getDebugCode("mt")) {
            trace.out("mt", String.format("JMT.setNodeSeq(isHint %b) old, new result %s, %s; nHints %d, %d", isHint, RuleActivationNode.matchIntToString(oldResult), RuleActivationNode.matchIntToString(newResult), oldNHints, newNHints));
        }
        if (this.nodeSeq == null || this.nodeSeq.isEmpty()) {
            this.nodeSeq = new ArrayList<RuleActivationNode>(nodeSeq);
            if (newNHints > 0) {
                return newResult == 1;
            }
            return false;
        }
        if (newResult == 1) {
            if (oldResult == 1) {
                if (oldNHints <= 0 && newNHints > 0) {
                    this.nodeSeq = new ArrayList<RuleActivationNode>(nodeSeq);
                    return true;
                }
                return false;
            }
            if (newNHints > 0) {
                this.nodeSeq = new ArrayList<RuleActivationNode>(nodeSeq);
            }
            return newNHints > 0;
        }
        if (oldNHints <= 0 && newNHints > 0) {
            this.nodeSeq = new ArrayList<RuleActivationNode>(nodeSeq);
        }
        return false;
    }

    private int getMatchResult(ArrayList<RuleActivationNode> nodeSeq) {
        int result = -1;
        if (nodeSeq == null) {
            result = 4;
        } else {
            for (int i = 0; i < nodeSeq.size() && result < 0; ++i) {
                RuleActivationNode node = nodeSeq.get(i);
                int matchResult = node.getMatchResult();
                if (matchResult == 3 || matchResult == 4) continue;
                result = matchResult;
            }
        }
        if (result < 0) {
            result = 2;
        }
        if (trace.getDebugCode("hints")) {
            trace.out("hints", String.format("JMT.getMatchResult() returns %s[%d]", RuleActivationNode.matchIntToString(result), result));
        }
        return result;
    }

    private int countHints(List<RuleActivationNode> nodeSeq) {
        int nHints = 0;
        if (nodeSeq == null) {
            return nHints;
        }
        for (RuleActivationNode node : nodeSeq) {
            nHints += node.getHintMessages().size();
        }
        return nHints;
    }

    private Vector<String> getMessages(boolean isHint, List<RuleActivationNode> nodeSeq) {
        Vector<String> msgs = new Vector<String>();
        boolean isBuggy = !this.isCorrectRuleSequence(nodeSeq);
        for (RuleActivationNode node : nodeSeq) {
            if (isBuggy) {
                msgs.addAll(node.getBuggyMessages());
                continue;
            }
            if (isHint) {
                msgs.addAll(node.getHintMessages());
                continue;
            }
            msgs.addAll(node.getSuccessMessages());
        }
        return msgs;
    }

    private boolean searchSucceeded(boolean isHint, int matchResult) {
        if (isHint) {
            return matchResult == 1 || matchResult == 2;
        }
        return matchResult == 1;
    }

    private boolean endChain(boolean isHint, int matchResult, ArrayList<RuleActivationNode> nodeSeq, boolean[] endSearch) {
        boolean result = false;
        if (this.searchSucceeded(isHint, matchResult)) {
            endSearch[0] = this.setNodeSeq(isHint, nodeSeq);
            result = true;
        } else if (matchResult == 2) {
            result = true;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "endSearch(" + isHint + "," + matchResult + ") returns " + result);
        }
        return result;
    }

    private String indent(int depth) {
        StringBuffer result = new StringBuffer("\n");
        for (int z = 0; z < depth; ++z) {
            result.append("  ");
        }
        return result.toString();
    }

    private boolean isBreakpointSet(String ruleName, int maxDepth) {
        if (this.tree == null) {
            return false;
        }
        Vector v = this.tree.getBreakPointRules();
        return this.useBreakPoints && maxDepth >= this.tree.getMinDepth() && v.contains(ruleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBreakpoint(String ruleName, int maxDepth) {
        File f;
        try {
            if (this.isBreakpointSet(ruleName, maxDepth)) {
                this.rete.saveState(".", "breakState.tmp");
                this.textOutput.append("\nBreakpoint on rule " + ruleName + " reached. \nSelect \"Resume\" from the Cognitive Model menu to continue.");
                if (this.tree != null) {
                    this.tree.getDisplayPanel().show(this.tree);
                }
                this.resumeBreak.isResume();
                this.rete.loadState(".", "breakState.tmp");
            }
            f = new File(".", "breakState.tmp");
        }
        catch (Throwable throwable) {
            File f2 = new File(".", "breakState.tmp");
            try {
                f2.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            f2 = null;
            throw throwable;
        }
        try {
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object var3_3 = null;
    }

    public void saveState(String dirName, String fileName) {
        long startTime = new Date().getTime();
        this.rete.saveState(dirName, fileName);
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "time(saveState) = " + (new Date().getTime() - startTime));
        }
    }

    public void loadState(String dirName, String fileName) {
        long startTime = new Date().getTime();
        this.rete.loadState(dirName, fileName);
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "time(loadState) = " + (new Date().getTime() - startTime));
        }
    }

    void haltRete(String routine) throws JessException {
        BR_Controller controller;
        MT mt;
        if (this.rete != null && (mt = this.rete.getMT()) != null && (controller = (BR_Controller)mt.getController()) != null) {
            controller.getMessageTank().resetMessageTank();
        }
        this.getRete().haltRete("JessModelTracing.haltRete(), called by " + routine);
    }

    public int testFiringNodeSAI(Matcher m, boolean isHint) {
        if (this.nodeNowFiring == null) {
            trace.err("JessModelTracing.testFiringNodeSelection(" + Utils.getSimpleName(m.getClass().getName()) + ") called when no node now firing");
            return 1;
        }
        this.nodeNowFiring.setMatcher(m);
        int result = isHint ? this.nodeNowFiring.testMatcherSelection() : this.nodeNowFiring.testMatcherSAI(isHint);
        this.nodeNowFiring.setMatchResult(result);
        return result;
    }

    int testFiringNodeSAI(String predictedSelection, String predictedAction, String predictedInput, String predictedInputTestFunction, Context ctx) {
        return this.testFiringNodeSAI(predictedSelection, predictedAction, predictedInput, predictedInputTestFunction, false, ctx);
    }

    int testFiringNodeSAI(String predictedSelection, String predictedAction, String predictedInput, String predictedInputTestFunction, boolean isHint, Context ctx) {
        if (this.nodeNowFiring == null) {
            trace.err("JessModelTracing.testFiringNodeSelection(" + predictedSelection + ") called when no node now firing");
            return 1;
        }
        int result = this.nodeNowFiring.isSAIFound(this.getStudentSelection(), this.getStudentAction(), this.getStudentInput(), predictedSelection, predictedAction, predictedInput, predictedInputTestFunction, isHint, ctx);
        this.nodeNowFiring.setMatchResult(result);
        return result;
    }

    int testFiringNodeSAI(boolean Matchresult) {
        int result = Matchresult ? 1 : 3;
        this.nodeNowFiring.setMatchResult(result);
        return result;
    }

    void setFiringNodeMessages(MessageGroup whichMsgs, ValueVector msgVV, Context ctx) throws JessException {
        if (this.nodeNowFiring == null) {
            trace.err("JessModelTracing.setFiringNodeMessages(" + msgVV.toStringWithParens() + ", " + ctx + ") called when no node now firing");
            return;
        }
        switch (whichMsgs) {
            case Hint: {
                this.nodeNowFiring.setHintMessages(msgVV, ctx);
                break;
            }
            case Success: {
                this.nodeNowFiring.setSuccessMessages(msgVV, ctx);
                break;
            }
            case Buggy: {
                this.nodeNowFiring.setBuggyMessages(msgVV, ctx);
                break;
            }
            default: {
                if (this.isHintTrace()) {
                    this.nodeNowFiring.setHintMessages(msgVV, ctx);
                    break;
                }
                if (!this.nodeNowFiring.isCorrectRule()) {
                    this.nodeNowFiring.setBuggyMessages(msgVV, ctx);
                    break;
                }
                this.nodeNowFiring.setHintMessages(msgVV, ctx);
            }
        }
    }

    void setRuleSAI(String predictedSelection, String predictedAction, String predictedInput, String predictedInputTestFunction) {
        if (this.nodeNowFiring == null) {
            trace.err("JessModelTracing.setRuleSAI(" + predictedSelection + ", " + predictedAction + ", " + predictedInput + ") called when no node now firing");
        } else {
            this.nodeNowFiring.setRuleSAI(predictedSelection, predictedAction, predictedInput, predictedInputTestFunction);
        }
    }

    void addRuleFoas(Vector foa) {
        if (this.nodeNowFiring == null) {
            trace.err("JessModelTracing.addRuleFoas(" + foa + ")");
        } else {
            for (int i = 0; i < foa.size(); ++i) {
                this.nodeNowFiring.addRuleFoa((String)foa.get(i));
            }
        }
    }

    void setRuleSAI(String predictedSelection, String predictedAction, String predictedInput) {
        this.setRuleSAI(predictedSelection, predictedAction, predictedInput, "NotSpecified");
    }

    int testFiringNodeSelection(String predictedSelection, Context ctx) {
        if (this.nodeNowFiring == null) {
            trace.err("JessModelTracing.testFiringNodeSelection(" + predictedSelection + ") called when no node now firing");
            return 1;
        }
        int result = this.nodeNowFiring.isSelectionFound(this.getStudentSelection(), predictedSelection, ctx);
        this.nodeNowFiring.setMatchResult(result);
        return result;
    }

    private void setTutorSAI(boolean isHint, int result, RuleActivationNode node) {
        if (result == 1 || !isHint || result == 2) {
            // empty if block
        }
    }

    private void setTutorSAI(boolean isHint, List<RuleActivationNode> nodeSeq) {
        if (nodeSeq == null || nodeSeq.size() < 1) {
            return;
        }
        RuleActivationNode lastNode = nodeSeq.get(nodeSeq.size() - 1);
        int lastResult = lastNode.getMatchResult();
        if (lastResult == 1 || isHint && lastResult == 2) {
            boolean S = true;
            int A = 2;
            int I = 4;
            int SAI = 7;
            int done = 0;
            for (int i = nodeSeq.size() - 1; 0 <= i && done != 7; --i) {
                RuleActivationNode node = nodeSeq.get(i);
                block11: for (int e = 1; e <= 4; e <<= 1) {
                    if (trace.getDebugCode("mt")) {
                        trace.out("mt", String.format("JMT.setTutorSAI() nodeSeq[%d][%x]: done %x, actualSelection=%s, Action=%s, Inupt=%s;", i, e, done, node.getActualSelection(), node.getActualAction(), node.getActualInput()));
                    }
                    if ((done & e) != 0) continue;
                    String s = null;
                    switch (e) {
                        case 1: {
                            s = node.getActualSelection();
                            break;
                        }
                        case 2: {
                            s = node.getActualAction();
                            break;
                        }
                        case 4: {
                            s = node.getActualInput();
                        }
                    }
                    if (s == null || s.trim().length() < 1 || "DONT-CARE".equalsIgnoreCase(s) || "NotSpecified".equalsIgnoreCase(s)) continue;
                    switch (e) {
                        case 1: {
                            this.tutorSelection = s;
                            done |= 1;
                            continue block11;
                        }
                        case 2: {
                            this.tutorAction = s;
                            done |= 2;
                            continue block11;
                        }
                        case 4: {
                            this.tutorInput = s;
                            done |= 4;
                        }
                    }
                }
            }
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "JMT.setTutorSAI() at end of nodeSeq: tutorSelection=" + this.tutorSelection + ", tutorAction=" + this.tutorAction + ", tutorInput=" + this.tutorInput + ";");
            }
            if ((done & 1) == 0) {
                this.tutorSelection = lastNode.getReqSelection();
            }
            if ((done & 2) == 0) {
                this.tutorAction = lastNode.getReqAction();
            }
            if ((done & 4) == 0) {
                this.tutorInput = lastNode.getReqInput();
            }
        }
    }

    public void setSkipTree(boolean b) {
        this.skipTree = b;
    }

    public boolean isModelTracing() {
        return this.nodeNowFiring != null;
    }

    public String getTutorSelection() {
        return this.tutorSelection;
    }

    public String getTutorAction() {
        return this.tutorAction;
    }

    public String getTutorInput() {
        return this.tutorInput;
    }

    void setRete(MTRete rete) {
        this.rete = rete;
        this.updateRuleActivationTree();
    }

    boolean addHookCall(ModelTracingUserfunction function) {
        if (this.modelTracingHooks == null) {
            this.modelTracingHooks = new Vector();
        } else if (MTRete.findUserfuction(function, this.modelTracingHooks) != -1) {
            return false;
        }
        this.modelTracingHooks.add(function);
        return true;
    }

    boolean removeHookCall(ModelTracingUserfunction function) {
        int index = MTRete.findUserfuction(function, this.modelTracingHooks);
        if (index == -1) {
            return false;
        }
        this.modelTracingHooks.remove(index);
        return true;
    }

    private void callHookFunctions(String selection, String action, String input) {
        ValueVector args = null;
        if (this.modelTracingHooks == null || this.modelTracingHooks.isEmpty()) {
            return;
        }
        for (ModelTracingUserfunction curFunction : this.modelTracingHooks) {
            try {
                args = curFunction.getArguments(selection, action, input, this.getRete());
                curFunction.javaCall(args, this.rete.getGlobalContext());
            }
            catch (JessException e) {
                String argErrMessage = "Error calling model trace hook," + curFunction.getName() + " arguments: " + args;
                trace.err(argErrMessage);
                e.printStackTrace();
                PrintWriter jessErrStream = this.rete.getErrStream();
                jessErrStream.println(argErrMessage);
                e.printStackTrace(jessErrStream);
            }
        }
    }

    static boolean isSAIToBeModelTraced(String sel, String act) {
        return act != null && sel != null && (!act.equalsIgnoreCase("ButtonPressed") || !sel.equalsIgnoreCase("help") && !sel.equalsIgnoreCase("hint"));
    }

    public void fireNode(RuleActivationNode ran) throws JessException {
        this.nodeNowFiring = ran;
        ran.fire(this.rete);
        this.nodeNowFiring = null;
    }

    public void fireNodeOracle(RuleActivationNode ran, JessOracleRete oracleRete) throws JessException {
        List wholeAgenda = oracleRete.getAgendaAsList(null);
        System.out.println("############ Whole agenda mesa stin ruleActivation fireOracle:" + wholeAgenda);
        this.nodeNowFiring = ran;
        ran.fireOracle(oracleRete);
        this.nodeNowFiring = null;
    }

    public Matcher getMatcher(String clsName) {
        block9: {
            if (clsName == null) {
                return null;
            }
            String[] clsNames = new String[]{clsName, "edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher." + clsName};
            Class<?> cls = null;
            for (int i = 0; i < clsNames.length && cls == null; ++i) {
                try {
                    cls = Class.forName(clsNames[i]);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    if (!trace.getDebugCode("mt")) continue;
                    trace.out("mt", "error finding class " + clsNames[i] + ": " + cnfe);
                }
            }
            if (cls == null) {
                return null;
            }
            try {
                Object inst = cls.newInstance();
                if (inst instanceof Matcher) {
                    return (Matcher)inst;
                }
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "error: class " + cls.getName() + " is not a subclass of Matcher");
                }
            }
            catch (Exception e) {
                if (!trace.getDebugCode("mt")) break block9;
                trace.out("mt", "error instantiating class " + cls.getName() + ": " + e);
            }
        }
        return null;
    }

    public List<String> getWMImages() {
        return this.wmImages;
    }

    public synchronized void addWMImage(String image) {
        if (this.wmImages == null) {
            this.wmImages = new ArrayList<String>();
        }
        this.wmImages.add(image);
    }

    boolean getSkipWhyNotSaves() {
        return this.skipWhyNotSaves;
    }

    void setSkipWhyNotSaves(boolean skipWhyNotSaves) {
        this.skipWhyNotSaves = skipWhyNotSaves;
    }

    public String getDefaultSkillCategory() {
        return this.defaultSkillCategory;
    }

    public void setDefaultSkillCategory(String defaultSkillCategory) {
        this.defaultSkillCategory = defaultSkillCategory;
    }

    boolean isHintMsgsRequired() {
        return this.hintMsgsRequired;
    }

    void setupForNewRequest(boolean hintMsgsRequired) {
        this.nFirings = 0;
        this.nodeSeq = new ArrayList();
        this.saiFound = false;
        this.studentInput = null;
        this.studentAction = null;
        this.studentSelection = null;
        this.tutorInput = null;
        this.tutorAction = null;
        this.tutorSelection = null;
        this.wmImages = null;
        this.isHint = false;
        this.hintMsgsRequired = hintMsgsRequired;
    }

    public static boolean isHintRequest(String sel, String act) {
        return act.toString().equalsIgnoreCase("ButtonPressed") && (sel.equalsIgnoreCase("hint") || sel.equalsIgnoreCase("help"));
    }

    static enum MessageGroup {
        Undefined,
        Hint,
        Success,
        Buggy;

    }
}

