/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.MTRete;
import java.io.Serializable;
import java.util.Iterator;
import jess.Context;
import jess.Fact;
import jess.Funcall;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

public class LogWorkingMemory
implements Userfunction,
Serializable {
    private static final String CLOSE_BRACKET = "]";
    private static final String OPEN_BRACKET = " [";
    private static final String LOG_WORKING_MEMORY = "log-working-memory";
    protected transient JessModelTracing jmt;
    protected transient Context context;

    public LogWorkingMemory() {
        this(null);
    }

    public LogWorkingMemory(JessModelTracing jmt) {
        this.jmt = jmt;
    }

    public String getName() {
        return LOG_WORKING_MEMORY;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        this.context = context;
        if (!vv.get(0).stringValue(context).equals(this.getName())) {
            throw new JessException(this.getName(), "called but ValueVector head differs", vv.get(0).stringValue(context));
        }
        if (this.getJmt() == null) {
            return Funcall.FALSE;
        }
        String label = this.getName();
        if (vv.size() > 1) {
            Value v = vv.get(1);
            if (v == null) {
                label = "(null)";
            } else {
                v = v.resolveValue(context);
                label = v.stringValue(context);
            }
        }
        StringBuffer sb = new StringBuffer(label);
        sb.append(OPEN_BRACKET);
        if (vv.size() > 2) {
            for (int i = 2; i < vv.size(); ++i) {
                Value v = vv.get(i);
                if (v == null) continue;
                v = v.resolveValue(context);
                if (i > 2) {
                    sb.append('\n');
                }
                if (v.type() == 16) {
                    sb.append(v.factValue(context).toStringWithParens());
                    continue;
                }
                sb.append(v.stringValue(context));
            }
        } else {
            Iterator it = this.jmt.getRete().listFacts();
            int i = 0;
            while (it.hasNext()) {
                Fact fact = (Fact)it.next();
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append(fact.toStringWithParens());
                ++i;
            }
        }
        sb.append(CLOSE_BRACKET);
        this.jmt.addWMImage(sb.toString());
        return Funcall.TRUE;
    }

    protected JessModelTracing getJmt() {
        if (this.jmt == null && this.context != null && this.context.getEngine() instanceof MTRete) {
            this.jmt = ((MTRete)this.context.getEngine()).getJmt();
        }
        return this.jmt;
    }

    public static String[] parseImage(String wmImage) {
        String[] result = new String[2];
        int endLabelIndex = wmImage.indexOf(OPEN_BRACKET);
        if (endLabelIndex > 0) {
            result[0] = wmImage.substring(0, endLabelIndex);
            result[1] = wmImage.substring(endLabelIndex + OPEN_BRACKET.length(), wmImage.length() - CLOSE_BRACKET.length());
        } else {
            result[0] = "working-memory-elements";
            result[1] = wmImage;
        }
        return result;
    }
}

