/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Log.LogReteChanges;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.MessageEvent;
import edu.cmu.pact.Utilities.MessageEventListener;
import edu.cmu.pact.Utilities.MessageEventSupport;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pact.jess.AlgExprFunctions;
import edu.cmu.pact.jess.FunctionPackage;
import edu.cmu.pact.jess.GoToWMMessgHandler;
import edu.cmu.pact.jess.JessConsole;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.ModelTracingUserfunction;
import edu.cmu.pact.jess.ProblemSummaryAccess;
import edu.cmu.pact.jess.ProdSysCheckMessgHandler;
import edu.cmu.pact.jess.RuleActivationTree;
import edu.cmu.pact.jess.SimStJessModelTracing;
import edu.cmu.pact.jess.Utils;
import edu.cmu.pact.jess.WMEEditor;
import java.awt.HeadlessException;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.JessException;
import jess.RU;
import jess.Rete;
import jess.Userfunction;
import jess.Userpackage;
import jess.Value;
import jess.ValueVector;

public class MT {
    ArrayList ruleSeq;
    ArrayList activationSeq;
    ArrayList mtRuleSeq = null;
    Vector messages = new Vector();
    Vector buggyMessages = new Vector();
    private MTRete externallyDefinedRete;
    private MTRete rete;
    Stack ruleStack;
    private WMEEditor wmeEditor;
    private String problemName;
    private JessConsole console;
    boolean useDebugger = true;
    private List interfaceTemplatesList = null;
    private List interfaceInstanceLists = null;
    private List<InterfaceAction> interfaceActionsList = null;
    private Map<String, Fact> interfaceFactsMap = null;
    private List specialFactsList = null;
    Vector edgeList = new Vector();
    private boolean bloadSuccessful = false;
    private boolean wmeTypesFromFile = false;
    private boolean prRulesFromFile = false;
    private boolean wmeInstancesFromFile = false;
    static String NOTAPPLICABLE = "No-Applicable";
    static String SUCCESS = "SUCCESS";
    static String NOMODEL = "NO-MODEL";
    static String BUG = "BUG";
    static String FIREABLEBUG = "FIREABLE-BUG";
    JessModelTracing jmt;
    Vector<MessageObject> groupDescriptionMessages = new Vector();
    ArrayList initialState = new ArrayList();
    boolean useProtege = false;
    private MessageEventSupport msgEvtSupport = new MessageEventSupport();
    private ProdSysCheckMessgHandler.Queue prodSysCheckMessgHandlerQ = new ProdSysCheckMessgHandler.Queue();
    private CTAT_Controller controller;
    private AlgExprFunctions algExprFns;
    private MTRete lastRete = null;
    private Vector startStateHooks;

    public static String getJessVersion() {
        if (!VersionInformation.includesJess()) {
            return null;
        }
        try {
            Rete r = new Rete();
            Value result = r.eval("(jess-version-string)");
            String strResult = result.stringValue(null);
            if (strResult != null && strResult.length() > 0) {
                return strResult;
            }
            return null;
        }
        catch (JessException je) {
            je.printStackTrace();
            return null;
        }
    }

    public ArrayList getMtRuleSeq() {
        return this.mtRuleSeq;
    }

    private int getEclipsePluginPort(String preferenceName) {
        if (this.controller == null) {
            return -1;
        }
        PreferencesModel pm = this.controller.getPreferencesModel();
        if (pm == null) {
            return -1;
        }
        Integer port = pm.getIntegerValue(preferenceName);
        if (port == null) {
            return -1;
        }
        return port;
    }

    public void clearRete() {
        if (trace.getDebugCode("mt")) {
            trace.printStack("mt", "*****MT.clearRete() called*****");
        }
        if (this.rete != null) {
            this.rete.removeListeners(this.controller.getPreferencesModel());
        }
        this.specialFactsList = new LinkedList();
        this.interfaceInstanceLists = new LinkedList();
        this.interfaceTemplatesList = new LinkedList();
        this.interfaceActionsList = new LinkedList<InterfaceAction>();
        this.interfaceFactsMap = new HashMap<String, Fact>();
        this.bloadSuccessful = false;
        this.wmeTypesFromFile = false;
        this.prRulesFromFile = false;
        this.wmeInstancesFromFile = false;
        if (this.externallyDefinedRete != null) {
            this.rete = this.externallyDefinedRete;
            this.rete.setMT(this);
            return;
        }
        this.rete = new MTRete(this.controller);
        this.rete.setMT(this);
        try {
            this.rete.reset();
            this.rete.showActivations("clearRete: reset");
        }
        catch (JessException e) {
            this.rete.getTextOutput().append("\nclearRete() error on (reset): " + (Object)((Object)e));
            e.printStackTrace();
        }
        MT.loadDefaultUserfunctions(this, this.rete, this.jmt);
        if (this.jmt != null) {
            this.jmt.setRete(this.rete);
            this.rete.setJmt(this.jmt);
        }
        this.clearRuleActivationTree();
        if (this.wmeEditor != null) {
            this.wmeEditor.setRete(this.rete);
        }
        if (this.console != null) {
            this.console.setRete(this.rete);
            this.console.getTextOutput().append("\n\n*****Engine Cleared*****\n\n");
        }
        MTRete.Routers.dumpRouters("clearRete()", this.rete);
    }

    public static void loadDefaultUserfunctions(Object obj, Rete rete, JessModelTracing jmt) {
        Userpackage[] userpackages;
        FunctionPackage fp;
        String thisPkg = obj.getClass().getPackage().getName();
        String[] userfunctions = new String[]{thisPkg + ".ConstructMessage", thisPkg + ".ConstructErrorMessage", thisPkg + ".ConstructHintMessage", thisPkg + ".ConstructSuccessMessage", thisPkg + ".PredictObservableAction", thisPkg + ".LHSPredictObservableAction", thisPkg + ".predict", thisPkg + ".TestSAI", thisPkg + ".PredictAlgebraInput", thisPkg + ".HereIsTheListOfFoas", thisPkg + ".PredictStoichInput", thisPkg + ".eval", thisPkg + ".LogWorkingMemory", thisPkg + ".PerformTutorAction", thisPkg + ".MTRegexpMatch", thisPkg + ".IsHint", thisPkg + ".UseStudentValuesFact", thisPkg + ".SetMaximumChainDepth", thisPkg + ".UseProblemSummary", thisPkg + ".GetCustomFieldsFact", thisPkg + ".SetHintPolicy", thisPkg + ".SetDefaultSkillCategory", thisPkg + ".UseUIComponentFacts", thisPkg + ".FindCognitiveModelDirectory"};
        if (trace.getDebugCode("dumpjessinfo")) {
            System.out.println("Jess Userfunction instances loaded:");
            for (String ufn : userfunctions) {
                try {
                    Class<?> cls = Class.forName(ufn);
                    Userfunction uf = (Userfunction)cls.newInstance();
                    System.out.printf(" (%s ...)\n", uf.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((fp = new FunctionPackage(userfunctions, jmt)).size() < userfunctions.length) {
            trace.err("Jess Model Tracer Warning: only " + fp.size() + " of " + userfunctions.length + " user functions loaded");
        }
        rete.addUserpackage((Userpackage)fp);
        AlgExprFunctions algExprFns = new AlgExprFunctions();
        if (trace.getDebugCode("dumpjessinfo")) {
            for (Userfunction uf : algExprFns) {
                try {
                    System.out.printf(" (%s ...)\n", uf.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "MT.loadDefaultUserfunctions() #algExprFns " + algExprFns.size() + ", obj " + obj);
        }
        for (Userpackage up : userpackages = new Userpackage[]{algExprFns}) {
            rete.addUserpackage(up);
        }
        if (obj instanceof MT) {
            ((MT)obj).setAlgExprFunctions(algExprFns);
        }
    }

    private void setAlgExprFunctions(AlgExprFunctions algExprFns) {
        this.algExprFns = algExprFns;
        this.setVariableTableInFunctions();
    }

    public MT(CTAT_Controller controller) {
        this(controller, null);
    }

    MT(CTAT_Controller controller, MTRete externallyDefinedRete) {
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "MT constructor");
        }
        this.controller = controller;
        this.setExternalRete(externallyDefinedRete);
    }

    public Value parse(Reader rdr) throws JessException {
        if (this.getRete() == null) {
            return null;
        }
        return this.getRete().parse(rdr);
    }

    public void addMessageEventListener(MessageEventListener listener) {
        this.msgEvtSupport.addMessageEventListener(listener);
    }

    public void removeMessageEventListener(MessageEventListener listener) {
        this.msgEvtSupport.removeMessageEventListener(listener);
    }

    public WMEEditor getWmeEditor() {
        return this.wmeEditor;
    }

    public JessConsole getConsole() {
        return this.console;
    }

    public JessModelTracing getModelTracing() {
        return this.jmt;
    }

    public void destroy() {
        this.ruleSeq = null;
        this.activationSeq = null;
        this.ruleStack = null;
        this.rete = null;
        this.jmt.dispose();
    }

    public boolean doesMatchSAI(Fact SAI, String selection, String action, String input) {
        try {
            String s = "";
            String a = "";
            String i = "";
            try {
                s = SAI.getSlotValue("selection").stringValue(null).trim();
            }
            catch (JessException e) {
                if (this.console != null && this.console.getTextOutput() != null) {
                    this.console.getTextOutput().append("\nThe selection slot in the special-tutor-fact should contain a value of type String. The value should be " + selection);
                }
                if (this.console != null && this.console.getTextOutput() != null) {
                    this.console.getTextOutput().append(e.toString());
                }
                e.printStackTrace();
            }
            try {
                a = SAI.getSlotValue("action").stringValue(null).trim();
            }
            catch (JessException e) {
                if (this.console != null && this.console.getTextOutput() != null) {
                    this.console.getTextOutput().append("\nThe action slot in the special-tutor-fact should contain a value of type String. The value should be " + action);
                }
                if (this.console != null && this.console.getTextOutput() != null) {
                    this.console.getTextOutput().append(e.toString());
                }
                e.printStackTrace();
            }
            try {
                i = SAI.getSlotValue("input").stringValue(null).trim();
            }
            catch (JessException e) {
                if (this.console != null && this.console.getTextOutput() != null) {
                    this.console.getTextOutput().append("\nThe input slot in the special-tutor-fact should contain a value of type String. The value should be " + input);
                }
                if (this.console != null && this.console.getTextOutput() != null) {
                    this.console.getTextOutput().append(e.toString());
                }
                e.printStackTrace();
            }
            return s.equals(selection.trim()) && a.equals(action.trim()) && i.equals(input.trim());
        }
        catch (Exception e) {
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "error in selection action action input fact");
            }
            e.printStackTrace();
            return false;
        }
    }

    String extractRuleName(String buggyRule) {
        StringTokenizer st = new StringTokenizer(buggyRule, " ");
        while (st.hasMoreTokens() && st.nextToken().indexOf("defrule") == -1) {
        }
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        return null;
    }

    public ArrayList getRuleSeq() {
        return this.ruleSeq;
    }

    public boolean noBuggyRulesPresent(ArrayList<String> rules) {
        for (String rule : rules) {
            if (rule.indexOf("buggy") == -1 && rule.indexOf("BUGGY") == -1 && rule.indexOf("Buggy") == -1) continue;
            return false;
        }
        return true;
    }

    public MTRete getRete() {
        return this.rete;
    }

    boolean authorActionLog(String toolName, String actionType, String argument, String result, String result2) {
        if (this.controller == null) {
            return false;
        }
        LoggingSupport ls = this.controller.getLoggingSupport();
        if (ls == null) {
            return false;
        }
        return ls.authorActionLog(toolName, actionType, argument, result, (Object)result2);
    }

    String getCognitiveModelDirectory(String subdir) {
        return this.getPreferenceDirectory("Problem Directory", null, subdir);
    }

    String getPreferenceDirectory(String pref, String defaultValue, String subdir) {
        String prefValue;
        PreferencesModel pm;
        String result = defaultValue;
        if (this.controller != null && (pm = this.controller.getPreferencesModel()) != null && (prefValue = pm.getStringValue(pref)) != null && prefValue.length() > 0) {
            result = prefValue;
        }
        if (result == null) {
            return null;
        }
        if (subdir != null && subdir.length() > 0) {
            result = edu.cmu.pact.Utilities.Utils.appendSlash(result) + subdir;
        }
        return edu.cmu.pact.Utilities.Utils.appendSlash(result);
    }

    public MessageObject handleCommMessage(MessageObject mo) {
        String checkResult = NOTAPPLICABLE;
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "message received: " + mo);
        }
        if (trace.getDebugCode("agenda")) {
            this.getRete().dumpAgenda("agenda", "\n    agenda before " + mo.summary(), true);
        }
        Enumeration enumerator = null;
        if ("ActionRequest".equalsIgnoreCase(mo.getVerb())) {
            return null;
        }
        Vector selection = mo.getSelection();
        Vector action = mo.getAction();
        Vector input = mo.getInput();
        this.jmt.setErrorArea(this.console == null ? null : this.console.getTextOutput());
        String messageType = mo.getMessageType();
        if (messageType == null) {
            trace.err("null messageType to MT.handleCommMessage()");
            return null;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "message type: " + messageType);
        }
        this.msgEvtSupport.fireMessageEvent(new MessageEvent(this, false, messageType, mo));
        Boolean uiFactChanged = this.rete.updateUIComponent(messageType, selection, action, input);
        if (messageType.equalsIgnoreCase("UntutoredAction")) {
            if (uiFactChanged != null && this.wmeEditor != null) {
                this.wmeEditor.getPanel().refresh();
            }
            return null;
        }
        if (messageType.equalsIgnoreCase("InterfaceDescription")) {
            if (!this.wmeTypesFromFile || !this.wmeInstancesFromFile) {
                Vector jessDeftemplates = (Vector)mo.getProperty("jessDeftemplates");
                Vector jessInstances = (Vector)mo.getProperty("jessInstances");
                if (jessDeftemplates != null && !this.wmeTypesFromFile) {
                    this.interfaceTemplatesList.addAll(jessDeftemplates);
                }
                if (jessInstances != null && !this.wmeInstancesFromFile) {
                    this.interfaceInstanceLists.add(jessInstances);
                }
            }
            return null;
        }
        if (messageType.equalsIgnoreCase("NumberOfTables")) {
            boolean numberOfTables = false;
        } else {
            if (messageType.equalsIgnoreCase("StartProblem")) {
                Object name;
                String[] path;
                String baseName;
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "StartProblem");
                }
                this.clearRete();
                MTRete.stopModelTracing = false;
                String fullName = this.getController().getProblemFullName();
                this.problemName = fullName != null && fullName.length() > 0 ? ((baseName = (path = fullName.split("[\\\\/]"))[path.length - 1]).toLowerCase().endsWith(".brd") ? baseName.substring(0, baseName.length() - 4) : baseName) : ((name = mo.getProperty("ProblemName")) instanceof String ? name.toString() : "");
                return null;
            }
            if (messageType.equalsIgnoreCase("StartStateEnd")) {
                block87: {
                    this.loadJessFiles(this.problemName, !edu.cmu.pact.Utilities.Utils.isRuntime());
                    if (!this.wmeTypesFromFile) {
                        try {
                            if (this.rete.findDeftemplate("problem") == null) {
                                String deftemplateStr = "(deftemplate problem (slot name) (multislot interface-elements) (multislot subgoals) (slot done) (slot description))";
                                this.rete.eval(deftemplateStr);
                                Deftemplate dt = this.rete.findDeftemplate("problem");
                            } else if (trace.getDebugCode("mt")) {
                                trace.out("mt", "Deftemplate problem found.");
                            }
                        }
                        catch (JessException je) {
                            if (this.console != null && this.console.getTextOutput() != null) {
                                this.console.getTextOutput().append(je.toString());
                            }
                            if (MTRete.breakOnExceptions) {
                                MTRete.stopModelTracing = true;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    try {
                        if (!this.bloadSuccessful) {
                            this.rete.eval("(defglobal ?*sSelection* = NotSpecified)");
                            this.rete.eval("(defglobal ?*sAction* = NotSpecified)");
                            this.rete.eval("(defglobal ?*sInput* = NotSpecified)");
                        }
                    }
                    catch (HeadlessException e1) {
                        e1.printStackTrace();
                    }
                    catch (JessException je) {
                        String errMsg = "Error defining selection-action-input globals";
                        if (this.console != null && this.console.getTextOutput() != null) {
                            this.console.getTextOutput().append("\n" + errMsg + ":\n" + (Object)((Object)je));
                        }
                        if (trace.getDebugCode("mt")) {
                            trace.out("mt", "ERROR CREATING S/A/I GLOBALS: " + (Object)((Object)je));
                        }
                        edu.cmu.pact.Utilities.Utils.showExceptionOccuredDialog((Exception)((Object)je), errMsg + ":\n" + je.getDetail(), "Jess Warning");
                    }
                    if (!this.wmeInstancesFromFile) {
                        if (this.console != null && this.console.getTextOutput() != null) {
                            this.console.getTextOutput().append("\nWME file not found, creating instances from interface definitions\n");
                        }
                        if (trace.getDebugCode("mt")) {
                            trace.out("mt", "StartStateEND");
                        }
                        try {
                            if (trace.getDebugCode("mt")) {
                                trace.out("mt", "loading interface facts upon StartStateEnd");
                            }
                            ValueVector interfaceInstancesValue = this.loadInterfaceInstances();
                            this.loadInterfaceActions();
                            if (this.rete.findDeftemplate("problem") != null) {
                                Fact problemFact = new Fact(this.rete.findDeftemplate("problem"));
                                problemFact.setSlotValue("name", new Value(this.problemName, 1));
                                if (interfaceInstancesValue != null) {
                                    problemFact.setSlotValue("interface-elements", new Value(interfaceInstancesValue, 512));
                                }
                                this.rete.assertFact(problemFact);
                                if (trace.getDebugCode("mt")) {
                                    trace.out("mt", "StartStateEnd: new problem fact id: " + new FactIDValue(problemFact));
                                }
                            }
                            if (this.rete.isUseBackwardChaining()) {
                                this.rete.eval("(do-backward-chainingspecial-tutor-fact)");
                                this.rete.eval("(do-backward-chainingspecial-tutor-fact-correct)");
                                this.rete.eval("(do-backward-chainingspecial-tutor-fact-buggy)");
                            }
                            this.rete.saveState(this.findCognitiveModelDirectory() + this.problemName + ".bload");
                            if (this.wmeEditor != null) {
                                this.wmeEditor.getPanel().refresh();
                            }
                        }
                        catch (JessException je) {
                            if (this.console != null && this.console.getTextOutput() != null) {
                                this.console.getTextOutput().append("\n" + je.toString() + "\n");
                            }
                            if (MTRete.breakOnExceptions) {
                                MTRete.stopModelTracing = true;
                            }
                        }
                        catch (Exception ex) {
                            if (this.console != null && this.console.getTextOutput() != null) {
                                this.console.getTextOutput().append("\n" + ex.toString() + "\n");
                            }
                            ex.printStackTrace();
                        }
                    }
                    for (int i = 0; i < this.groupDescriptionMessages.size(); ++i) {
                        MessageObject obj = this.groupDescriptionMessages.get(i);
                        this.assertGroupFact(obj);
                    }
                    try {
                        if (this.startStateHooks != null && !this.startStateHooks.isEmpty()) {
                            this.callStartStateHooks();
                        }
                    }
                    catch (JessException je) {
                        if (this.console != null && this.console.getTextOutput() != null) {
                            this.console.getTextOutput().append("\n" + je.toString() + "\n");
                        }
                        if (!MTRete.breakOnExceptions) break block87;
                        MTRete.stopModelTracing = true;
                    }
                }
                this.setVariableTableInFunctions();
                if (this.wmeEditor != null) {
                    this.wmeEditor.getPanel().refresh();
                }
                this.msgEvtSupport.fireMessageEvent(new MessageEvent(this, true, "StartStateComplete", null));
                this.clearRuleActivationTree();
                MTRete.Routers.dumpRouters("startStateEnd", this.rete);
                this.rete.showActivations("StartStateEnd");
                return null;
            }
            if (messageType.equalsIgnoreCase("Go_To_WM_State")) {
                Vector selectionList = (Vector)mo.getProperty("SelectionList");
                Vector inputList = (Vector)mo.getProperty("InputList");
                Vector actionList = (Vector)mo.getProperty("ActionList");
                GoToWMMessgHandler handler = new GoToWMMessgHandler(mo, this.jmt, this.controller);
                handler.processMessage();
                return handler.getMessageObject();
            }
            if (messageType.equalsIgnoreCase("LISPCheck")) {
                selection = mo.getSelection();
                input = mo.getInput();
                action = mo.getAction();
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "selection: " + selection + ";");
                }
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "action: " + action + ";");
                }
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "input: " + input + ";");
                }
                if (selection.size() > 0 && action.size() > 0 && input.size() > 0) {
                    String s = selection.get(0);
                    String a = action.get(0);
                    String i = input.get(0);
                    this.rete.setGlobalSAI(s, a, i);
                }
                if (trace.getDebugCode("agenda")) {
                    this.getRete().dumpAgenda("agenda", "\n    agenda after setGlobalSAI " + mo.summary(), true);
                }
                ProdSysCheckMessgHandler.executeSynchronously(mo, this.jmt, this.controller, this.wmeEditor);
            } else {
                if (messageType.equalsIgnoreCase("Send_ESEGraph")) {
                    Vector eseGraph = (Vector)mo.getProperty("ESEGraph");
                    Enumeration eseEnum = eseGraph.elements();
                    Vector edgeList = new Vector();
                    Vector edgesAlreadyChecked = new Vector();
                    Vector resultsOfEdgesChecked = new Vector();
                    String fileName = (String)((Vector)eseGraph.get(0)).get(0) + ".state";
                    this.rete.saveState(".", fileName);
                    int i = 0;
                    while (eseEnum.hasMoreElements()) {
                        Vector parentChildList = (Vector)eseEnum.nextElement();
                        if (trace.getDebugCode("mtt")) {
                            trace.out("mtt", "eseGraph[" + i + "] fileName " + fileName + ", parentChildList.size " + parentChildList.size());
                        }
                        if (parentChildList.size() > 1) {
                            String parentChildName = (String)parentChildList.elementAt(0);
                            Vector childrenInfoList = (Vector)parentChildList.elementAt(1);
                            Enumeration enumChildrenInfoList = childrenInfoList.elements();
                            int j = 0;
                            while (enumChildrenInfoList.hasMoreElements()) {
                                Vector<Object> edgeCheckResult;
                                Vector childInfo = (Vector)enumChildrenInfoList.nextElement();
                                String name = (String)childInfo.elementAt(0);
                                Integer uID = (Integer)childInfo.elementAt(1);
                                String auIntent = (String)childInfo.elementAt(2);
                                selection = (Vector)childInfo.elementAt(3);
                                action = (Vector)childInfo.elementAt(4);
                                input = (Vector)childInfo.elementAt(5);
                                String childStateName = name + ".state";
                                fileName = parentChildName + ".state";
                                if (trace.getDebugCode("mtt")) {
                                    trace.out("mtt", "eseGraph[" + i + "," + j + "] parentChildName " + parentChildName + ": " + name + ", " + uID + ", " + auIntent + ", " + selection + ", " + action + ", " + input + ", statePending(.," + fileName + ") " + this.rete.statePending(".", fileName));
                                }
                                if (this.rete.statePending(".", fileName)) {
                                    this.rete.loadState(".", fileName);
                                    enumerator = selection.elements();
                                    while (enumerator.hasMoreElements()) {
                                        Object selObject = enumerator.nextElement();
                                        StringBuffer sb1 = new StringBuffer((String)selObject);
                                        int selectionIndex = selection.indexOf(selObject);
                                        Object actionObject = action.get(selectionIndex);
                                        StringBuffer actionString = new StringBuffer((String)actionObject);
                                        try {
                                            if (!JessModelTracing.isSAIToBeModelTraced(sb1.toString(), actionString.toString())) continue;
                                            String inputString = (String)input.get(selectionIndex);
                                            this.rete.setGlobalSAI(sb1.toString(), actionString.toString(), inputString);
                                            checkResult = this.jmt.runModelTrace(false, false, sb1.toString(), actionString.toString(), inputString, null);
                                            if (checkResult.equalsIgnoreCase("SUCCESS") && auIntent.equalsIgnoreCase("Correct Action") || checkResult.equalsIgnoreCase("FIREABLE-BUG") && auIntent.equalsIgnoreCase("Fireable Buggy Action")) {
                                                this.rete.saveState(".", childStateName);
                                            }
                                            edgeCheckResult = new Vector();
                                            edgeCheckResult.addElement(uID);
                                            edgeCheckResult.addElement(checkResult);
                                            edgeList.addElement(edgeCheckResult);
                                            this.mtRuleSeq = this.jmt.getRuleSeq();
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                } else {
                                    checkResult = NOTAPPLICABLE;
                                    edgeCheckResult = new Vector<Object>();
                                    edgeCheckResult.addElement(uID);
                                    edgeCheckResult.addElement(checkResult);
                                    edgeList.addElement(edgeCheckResult);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    MessageObject resultMessageObject = MessageObject.create("CheckAllStatesResult");
                    resultMessageObject.setVerb("SetProperty");
                    resultMessageObject.setProperty("EdgeList", edgeList, true);
                    this.msgEvtSupport.fireMessageEvent(new MessageEvent(this, true, "CheckAllStatesResult", resultMessageObject));
                    return resultMessageObject;
                }
                if (messageType.equalsIgnoreCase("InterfaceAction")) {
                    if (trace.getDebugCode("mt")) {
                        trace.out("mt", "InterfaceAction");
                    }
                    selection = mo.getSelection();
                    input = mo.getInput();
                    action = mo.getAction();
                    InterfaceAction ia = new InterfaceAction(selection, action, input);
                    this.interfaceActionsList.add(ia);
                    return null;
                }
                if (messageType.equalsIgnoreCase("SendRuleProductionSet")) {
                    return null;
                }
                if (messageType.equalsIgnoreCase("SendSelectedElements")) {
                    trace.err("***ERROR*** MT.handleCommMessage() received msg type SendSelectedElements");
                    return null;
                }
                if (messageType.equalsIgnoreCase("GroupDescriptionStart")) {
                    this.groupDescriptionMessages.clear();
                } else if (!messageType.equalsIgnoreCase("GroupDescriptionEnd")) {
                    if (messageType.equalsIgnoreCase("GroupDescription")) {
                        this.groupDescriptionMessages.add(mo);
                    } else if (messageType.equalsIgnoreCase("AttributeDescription")) {
                        this.groupDescriptionMessages.add(mo);
                    } else if (messageType.equalsIgnoreCase("RestorJessInitialWMState")) {
                        this.clearRete();
                        if (this.wmeEditor != null) {
                            this.wmeEditor.getPanel().refresh();
                        }
                    } else if (!messageType.equalsIgnoreCase("RestorInitialWMState")) {
                        trace.err("MT.handleCommMessage(): Unknown msg type: " + messageType);
                    }
                }
            }
        }
        return null;
    }

    private void setVariableTableInFunctions() {
        VariableTable vt;
        CTAT_Controller ctlr = this.getController();
        ProblemModel pm = ctlr == null ? null : ctlr.getProblemModel();
        VariableTable variableTable = vt = pm == null ? null : pm.getVariableTable();
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "MT.setVariableTableInFunctions() # algExprFns " + (this.algExprFns == null ? null : Integer.valueOf(this.algExprFns.size())) + ", ctlr " + ctlr + ", pm " + pm + ", vt " + vt + " size() " + vt.size());
        }
        if (this.algExprFns == null) {
            return;
        }
        this.algExprFns.setVariableTable(vt);
    }

    private void clearRuleActivationTree() {
        if (this.jmt == null) {
            return;
        }
        RuleActivationTree tree = this.jmt.getRuleActivationTree();
        if (tree != null) {
            tree.clearTree(null);
        }
    }

    boolean addStartStateHookCall(ModelTracingUserfunction function) {
        if (this.startStateHooks == null) {
            this.startStateHooks = new Vector();
        } else if (MTRete.findUserfuction(function, this.startStateHooks) != -1) {
            return false;
        }
        this.startStateHooks.add(function);
        return true;
    }

    boolean removeStartStateHook(ModelTracingUserfunction function) {
        int index = MTRete.findUserfuction(function, this.startStateHooks);
        if (index != -1) {
            this.startStateHooks.remove(index);
            return true;
        }
        return false;
    }

    private void callStartStateHooks() throws JessException {
        if (this.interfaceActionsList == null || this.startStateHooks == null) {
            return;
        }
        Iterator funcIter = this.startStateHooks.iterator();
        while (funcIter.hasNext()) {
            Iterator<InterfaceAction> interfaceIter = this.interfaceActionsList.iterator();
            ModelTracingUserfunction curFunc = (ModelTracingUserfunction)funcIter.next();
            block3: while (interfaceIter.hasNext()) {
                InterfaceAction ia = interfaceIter.next();
                List selectionList = ia.selectionList;
                List actionList = ia.actionList;
                List inputList = ia.inputList;
                for (int tuplenum = 0; tuplenum < selectionList.size(); ++tuplenum) {
                    String s = (String)selectionList.get(tuplenum);
                    try {
                        String a = (String)actionList.get(tuplenum);
                        String i = (String)inputList.get(tuplenum);
                        ValueVector args = curFunc.getArguments(s, a, i, this.getRete());
                        curFunc.javaCall(args, this.getRete().getGlobalContext());
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException oobe) {
                        String errMsg = "Error calling startStateFunction " + curFunc.getName() + " at selection index " + tuplenum + ", selection " + s;
                        if (this.console != null && this.console.getTextOutput() != null) {
                            this.console.getTextOutput().append("\n" + errMsg + ":\n" + oobe);
                        }
                        if (!trace.getDebugCode("mt")) continue block3;
                        trace.out("mt", errMsg + ": " + oobe);
                        continue block3;
                    }
                }
            }
        }
    }

    private void assertGroupFact(MessageObject mo) {
        String groupName;
        Deftemplate groupTemplate = null;
        Fact groupFact = null;
        int attributeCounter = 0;
        ArrayList<Value> slotValues = new ArrayList<Value>();
        String messgType = mo.getMessageType();
        if (messgType.equals("GroupDescription")) {
            slotValues.clear();
            groupName = (String)mo.getProperty("Name");
            String type = (String)mo.getProperty("Type");
            Vector attributes = (Vector)mo.getProperty("Attributes");
            attributeCounter = attributes.size();
            try {
                groupTemplate = new Deftemplate(type, "A group of interface elements", (Rete)this.rete);
                groupTemplate.addSlot("name", Funcall.NIL, "SYMBOL");
            }
            catch (JessException e2) {
                e2.printStackTrace();
            }
        }
        if (messgType.equals("AttributeDescription")) {
            block24: {
                groupName = (String)mo.getProperty("GroupName");
                String attributeName = (String)mo.getProperty("AttributeName");
                String cardinality = (String)mo.getProperty("Cardinality");
                String type = (String)mo.getProperty("Type");
                Vector values = (Vector)mo.getProperty("Values");
                Vector valueTypes = (Vector)mo.getProperty("ValueTypes");
                if (attributeCounter > 0) {
                    --attributeCounter;
                }
                if (cardinality.equalsIgnoreCase("single")) {
                    try {
                        if (groupTemplate == null) break block24;
                        groupTemplate.addSlot(attributeName, Funcall.NIL, "SYMBOL");
                        if (values.size() > 0) {
                            String commWidgetName = (String)values.get(0);
                            slotValues.add(new Value(commWidgetName, 1));
                        }
                    }
                    catch (JessException e2) {
                        e2.printStackTrace();
                    }
                } else if (cardinality.equalsIgnoreCase("multiple")) {
                    try {
                        if (groupTemplate != null) {
                            groupTemplate.addMultiSlot(attributeName, Funcall.NILLIST);
                            ValueVector vv = new ValueVector();
                            for (int z = 0; z < values.size(); ++z) {
                                vv.add(new Value((String)values.get(z), 1));
                            }
                            slotValues.add(new Value(vv, 512));
                        }
                    }
                    catch (JessException e2) {
                        e2.printStackTrace();
                    }
                } else if (trace.getDebugCode("mt")) {
                    trace.out("mt", "Invlid cardinality: " + cardinality);
                }
            }
            if (attributeCounter == 0) {
                try {
                    Deftemplate dt = this.rete.findDeftemplate(groupTemplate.getBaseName());
                    if (dt == null) {
                        this.rete.addDeftemplate(groupTemplate);
                    }
                    try {
                        groupFact = new Fact(groupTemplate);
                        groupFact.setSlotValue("name", new Value(groupName, 1));
                        for (int k = 0; k < slotValues.size(); ++k) {
                            groupFact.setSlotValue(groupTemplate.getSlotName(k + 1), (Value)slotValues.get(k));
                        }
                        this.rete.assertFact(groupFact);
                    }
                    catch (JessException e3) {
                        e3.printStackTrace();
                    }
                }
                catch (JessException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private Fact modifyFromSAI(List selection, List action, List input) throws JessException {
        Fact lastFact = null;
        Iterator iterator = selection.iterator();
        int selectionIndex = 0;
        while (iterator.hasNext()) {
            String actionString;
            Object selObject = iterator.next();
            String selectionString = selObject.toString();
            if (action.size() <= selectionIndex || input.size() <= selectionIndex) break;
            Object actionObject = action.get(selectionIndex);
            String string = actionString = actionObject == null ? "" : actionObject.toString().toLowerCase();
            if (actionString.indexOf("update") >= 0) {
                Object inputObject = input.get(selectionIndex);
                String inputString = inputObject == null ? null : inputObject.toString();
                Value[] inpV = new Value[]{null};
                int type = Utils.getJessType(inputString, inpV);
                this.rete.updateChunkValues(selectionString, inputString);
                Fact fact = this.interfaceFactsMap.get(selectionString);
                if (fact == null) {
                    fact = this.getFactByName(this.rete, selectionString);
                }
                if (fact != null) {
                    Deftemplate deft = fact.getDeftemplate();
                    if (deft.getSlotIndex("value") < 0) {
                        if (trace.getDebugCode("mt")) {
                            trace.out("mt", "modifyFromSAI(" + selectionString + "): no value slot in deftemplate " + deft.getBaseName());
                        }
                    } else {
                        if (trace.getDebugCode("mt")) {
                            trace.out("mt", "modifyFromSAI(" + selectionString + "," + inpV[0].stringValue(null) + "," + RU.getTypeName((int)type) + ")");
                        }
                        lastFact = this.rete.modify(fact, "value", inpV[0]);
                    }
                } else if (this.console != null && this.console.getTextOutput() != null) {
                    this.console.getTextOutput().append("\nInterface fact not found: " + selectionString);
                }
            }
            ++selectionIndex;
        }
        return lastFact;
    }

    public String removeModuleName(String rule, String moduleName) {
        int start;
        StringBuffer sb = new StringBuffer(rule);
        while ((start = sb.indexOf(moduleName)) != -1) {
            sb.replace(start, start + moduleName.length(), "");
        }
        return sb.toString();
    }

    public String getElement(Vector list) {
        Vector selection = (Vector)list.get(0);
        return (String)selection.get(selection.size() - 1);
    }

    public void setValue(Vector propertyNames, Vector propertyValues, String propertyName, Object obj) {
        int pos = MT.fieldPosition(propertyNames, propertyName);
        if (pos != -1) {
            propertyValues.set(pos, obj);
        } else {
            propertyValues.add(obj);
            propertyNames.add(propertyName);
        }
    }

    public static Object getValue(Vector propertyNames, Vector propertyValues, String propertyName) {
        int pos = MT.fieldPosition(propertyNames, propertyName);
        if (pos != -1) {
            return propertyValues.elementAt(pos);
        }
        return null;
    }

    public static int fieldPosition(Vector from, String fieldName) {
        int toret = -1;
        int s = from.size();
        for (int i = 0; i < s; ++i) {
            if (!((String)from.elementAt(i)).equalsIgnoreCase(fieldName)) continue;
            return i;
        }
        return toret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fact getFactByName(MTRete r, String name) {
        Fact fact = null;
        Iterator it = r.listFacts();
        try {
            while (it.hasNext()) {
                Value v;
                fact = (Fact)it.next();
                if (fact.getDeftemplate().getSlotIndex("name") != -1 && (v = fact.getSlotValue("name")).stringValue(null).trim().equalsIgnoreCase(name)) {
                    Fact fact2 = fact;
                    return fact2;
                }
                fact = null;
            }
        }
        catch (JessException je) {
            if (this.console != null && this.console.getTextOutput() != null) {
                this.console.getTextOutput().append(je.toString());
            }
            if (MTRete.breakOnExceptions) {
                MTRete.stopModelTracing = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            it = null;
        }
        return fact;
    }

    public Fact getFactByTemplateName(MTRete r, String name) {
        Iterator it = null;
        Fact fact = null;
        it = r.listFacts();
        try {
            while (it.hasNext() && !(fact = (Fact)it.next()).getDeftemplate().getBaseName().equals(name)) {
                fact = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fact;
    }

    public boolean assertRule(String rule, String ruleName) {
        try {
            Value v = this.rete.eval(rule);
            return Funcall.TRUE.equals(v);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setExternalRete(MTRete external) {
        this.externallyDefinedRete = external;
        this.clearRete();
        this.jmt = VersionInformation.isRunningSimSt() && !edu.cmu.pact.Utilities.Utils.isRuntime() ? new SimStJessModelTracing(this.rete, this.controller) : new JessModelTracing(this.rete, this.controller);
        this.rete.setJmt(this.jmt);
        this.jmt.setRete(this.rete);
        if (!edu.cmu.pact.Utilities.Utils.isRuntime() && external == null) {
            this.wmeEditor = new WMEEditor(this.rete, this, null, true, false);
            this.wmeEditor.setProblemName(this.controller.getLogger().getStudentName());
            this.addMessageEventListener(this.wmeEditor);
            this.console = new JessConsole("Jess Console", this.rete, true, this.controller);
        }
    }

    private void loadJessFiles(String problemName, boolean useBinary) {
        this.bloadSuccessful = false;
        this.wmeTypesFromFile = false;
        this.prRulesFromFile = false;
        this.wmeInstancesFromFile = false;
        String[] filenames = new String[]{problemName + ".bload", "wmeTypes.clp", "productionRules.pr", problemName + ".wme"};
        boolean[] results = null;
        String cmDir = this.findCognitiveModelDirectory();
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = cmDir != null ? cmDir + filenames[i] : null;
        }
        if (!useBinary) {
            filenames[0] = null;
        }
        try {
            this.rete.clear();
            if (trace.getDebugCode("eep")) {
                trace.out("eep", "Filenames-0:" + filenames[0] + ",1:" + filenames[1] + ",2:" + filenames[2] + ",3:" + filenames[3]);
            }
            this.updateWMEEditorCognitiveModelFolder(filenames[1]);
            results = this.rete.loadJessFiles(filenames[0], filenames[1], filenames[2], filenames[3], this.interfaceTemplatesList);
        }
        catch (Exception e) {
            trace.err("Error " + e + " trying to load Jess files");
            return;
        }
        this.bloadSuccessful = results[0];
        this.wmeTypesFromFile = results[1] || results[0];
        this.prRulesFromFile = results[2] || results[0];
        boolean bl = this.wmeInstancesFromFile = results[3] || results[0];
        if (!edu.cmu.pact.Utilities.Utils.isRuntime() && this.lastRete != null) {
            LogReteChanges lrc = new LogReteChanges(this.getRete().getEventLogger(), this.lastRete, this.rete);
            lrc.logReteChanges();
        }
        this.lastRete = this.rete;
    }

    private void updateWMEEditorCognitiveModelFolder(String fn) {
        if (edu.cmu.pact.Utilities.Utils.isRuntime()) {
            return;
        }
        if (fn != null) {
            String dir;
            if (trace.getDebugCode("eep")) {
                trace.out("eep", "updateWMEEditorCognitiveModelFolder fn in:" + fn);
            }
            if ((dir = fn).contains(File.separator)) {
                dir = dir.substring(0, dir.lastIndexOf(File.separator));
            } else if (dir.contains("/")) {
                dir = dir.substring(0, dir.lastIndexOf("/"));
            }
            fn = dir.contains(File.separator) ? dir.substring(dir.lastIndexOf(File.separator) + 1, dir.length()) : (dir.contains("/") ? dir.substring(dir.lastIndexOf("/") + 1, dir.length()) : dir);
            if (dir.length() < 1) {
                trace.err("findCognitiveModelDirectory returned empty path in loadJessFiles");
                String path = fn;
            } else {
                String path;
                try {
                    File f = new File(dir);
                    path = f.getAbsolutePath();
                }
                catch (Exception e) {
                    path = dir;
                }
                if (trace.getDebugCode("eep")) {
                    trace.out("eep", "updateWMEEditorCognitiveModelFolder out: " + fn + ", " + path);
                }
                if (this.wmeEditor != null) {
                    this.wmeEditor.getPanel().updateCognitiveModelFolder(fn, path);
                }
            }
        } else {
            if (trace.getDebugCode("eep")) {
                trace.out("eep", "updateWMEEditorCognitiveModelFolder fn is null");
            }
            if (this.wmeEditor != null) {
                this.wmeEditor.getPanel().updateCognitiveModelFolder("Files Not Found", "Jess mode files (pr,clp,wme) could not be found");
            }
        }
    }

    public String findCognitiveModelDirectory() {
        String[] fileInDir = new String[]{"wmeTypes.clp", null};
        String result = null;
        Object f = null;
        int trial = 0;
        for (int pass = 0; pass < fileInDir.length; ++pass) {
            String dirname = this.getProblemSetCognitiveModelDirectory();
            ++trial;
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getProblemDirectory("CognitiveModel");
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getProblemDirectory("JessFiles/");
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getCognitiveModelDirectory("CognitiveModel");
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getCognitiveModelDirectory("JessFiles");
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getCognitiveModelDirectory(null);
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getProblemDirectory("");
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getPreferenceDirectory("workspace", null, "CognitiveModel");
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getPreferenceDirectory("workspace", null, "JessFiles/");
            if (this.directoryHasFile(dirname, fileInDir[pass])) {
                result = dirname;
                if (result != null) break;
                ++trial;
            }
            if (this.directoryHasFile(dirname = this.getPreferenceDirectory("workspace", null, null), fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getPreferenceDirectory("Interface Directory", null, "CognitiveModel");
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getPreferenceDirectory("Interface Directory", null, "JessFiles/");
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = this.getPreferenceDirectory("Interface Directory", null, null);
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = "./CognitiveModel/";
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = "./JessFiles/";
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
            ++trial;
            dirname = "./";
            if (this.directoryHasFile(dirname, fileInDir[pass]) && (result = dirname) != null) break;
        }
        result = edu.cmu.pact.Utilities.Utils.appendSlash(result);
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "findCognitiveModelDirectory() after " + trial + " trials returning: " + result);
        }
        return result;
    }

    private boolean directoryHasFile(String dirname, String fileInDir) {
        boolean result = edu.cmu.pact.Utilities.Utils.isDirectoryReadable(dirname, this);
        if (result && fileInDir != null) {
            File f = new File(dirname, fileInDir);
            result = f.canRead() && !f.isDirectory();
        }
        return result;
    }

    private String getProblemDirectory(String subdir) {
        String problemFullName;
        String string = problemFullName = this.controller == null ? null : this.controller.getProblemFullName();
        if (problemFullName == null || problemFullName.trim().length() < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder(problemFullName.replaceAll("\\\\", "/"));
        int offset = sb.lastIndexOf("/");
        if (offset < 0) {
            offset = 0;
            sb.replace(0, sb.length(), "./");
        }
        if (subdir == null) {
            subdir = "";
        }
        sb.replace(offset + 1, sb.length(), subdir);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    private String getProblemSetCognitiveModelDirectory() {
        String problemFullName;
        String string = problemFullName = this.controller == null ? null : this.controller.getProblemFullName();
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "MT.getProblemSetCognitiveModelDirectory() problemFullName " + problemFullName);
        }
        if (problemFullName == null || problemFullName.trim().length() < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder(problemFullName.replaceAll("\\\\", "/"));
        int offset = sb.lastIndexOf("/FinalBRDs/");
        if (offset >= 0) {
            sb.replace(offset + 1, sb.length(), "CognitiveModel");
            sb.append('/');
            return sb.toString();
        }
        offset = sb.lastIndexOf("/problems/");
        if (offset >= 0) {
            sb.replace(offset + 1, sb.length(), "CognitiveModel");
            sb.append('/');
            return sb.toString();
        }
        return null;
    }

    public boolean reloadProductionRulesFile() {
        boolean result = false;
        String filename = null;
        try {
            filename = this.findCognitiveModelDirectory() + "productionRules.pr";
            result = this.getController() != null && this.getController().getMissController() != null && this.getController().getMissController().isPLEon() ? this.rete.reloadProductionRulesFile(filename, false) : this.rete.reloadProductionRulesFile(filename, true);
        }
        catch (Exception e) {
            trace.err("Error " + e + " trying to load Jess files");
            return result;
        }
        this.clearRuleActivationTree();
        this.prRulesFromFile = true;
        this.rete.deleteBload();
        if (this.lastRete != null) {
            LogReteChanges lrc = new LogReteChanges(this.getRete().getEventLogger(), this.lastRete, this.rete);
            lrc.logReteChanges();
        }
        this.lastRete = this.rete;
        return result;
    }

    private ValueVector loadInterfaceInstances() {
        ValueVector resultVV = new ValueVector();
        ArrayList<FactIDValue> lastFacts = new ArrayList<FactIDValue>();
        if (this.interfaceInstanceLists == null) {
            System.err.println("NULL value in MT.loadInterfaceInstances(): interfaceInstanceLists is null");
            return resultVV;
        }
        try {
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "rete " + this.rete.hashCode() + " (rules) (agenda)");
            }
            if (trace.getDebugCode("mt")) {
                this.rete.eval("(rules)");
                this.rete.eval("(agenda)");
            }
        }
        catch (JessException je) {
            je.printStackTrace();
        }
        boolean firstTime = true;
        for (List assertCmds : this.interfaceInstanceLists) {
            FactIDValue lastFactId = null;
            for (String cmd : assertCmds) {
                block19: {
                    if (trace.getDebugCode("mt")) {
                        trace.out("mt", "cmd " + cmd);
                    }
                    String[] r = cmd.split("\\(name ");
                    String wmeName = (r = r[1].split("\\)"))[0];
                    if (this.rete.getFactByName(wmeName) != null) {
                        if (trace.getDebugCode("mt")) {
                            trace.out("mt", "Definition for " + wmeName + " already exists!");
                        }
                    } else {
                        if (firstTime && this.rete.getTextOutput() != null) {
                            this.rete.getTextOutput().append("\nLoading instances from interface definitions.");
                        }
                        try {
                            Value val = this.rete.eval(cmd);
                            if (trace.getDebugCode("mtt")) {
                                trace.out("mtt", "rete " + this.rete.hashCode() + " asserted interface fact, result " + val + ", type " + RU.getTypeName((int)val.type()) + ":\n" + cmd);
                            }
                            if (val.type() == 16) {
                                Fact fact = val.factValue(this.rete.getGlobalContext());
                                lastFactId = new FactIDValue(fact);
                                Value nameVal = fact.getSlotValue("name");
                                if (nameVal != null) {
                                    String name = nameVal.stringValue(this.rete.getGlobalContext());
                                    this.interfaceFactsMap.put(name, fact);
                                }
                            }
                        }
                        catch (JessException e1) {
                            String errMsg = "Error executing command \"" + cmd + "\":\n  " + (Object)((Object)e1) + (e1.getCause() == null ? "" : ";\n  " + e1.getCause().toString());
                            trace.err(errMsg);
                            e1.printStackTrace();
                            if (this.rete.getTextOutput() == null) break block19;
                            this.rete.getTextOutput().append("\n" + errMsg + "\n");
                        }
                    }
                }
                firstTime = false;
            }
            try {
                if (lastFactId == null || lastFactId == Funcall.FALSE) continue;
                lastFacts.add(lastFactId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.sortByName(lastFacts, resultVV);
        return resultVV;
    }

    private void sortByName(List facts, ValueVector vv) {
        Comparator byNameSorter = new Comparator(){

            public int compare(Object obj0, Object obj1) {
                if (!(obj0 instanceof FactIDValue)) {
                    throw new ClassCastException("left operand " + obj0 + " is not a Fact");
                }
                if (!(obj1 instanceof FactIDValue)) {
                    throw new ClassCastException("right operand " + obj1 + " is not a Fact");
                }
                FactIDValue v0 = (FactIDValue)obj0;
                FactIDValue v1 = (FactIDValue)obj1;
                try {
                    Fact f0 = v0.factValue(MT.this.rete.getGlobalContext());
                    v0 = f0.getSlotValue("name");
                }
                catch (Exception e) {
                    trace.err("byNameSorter: Exception getting name slot from left operand " + v0 + ": " + e);
                    v0 = null;
                }
                try {
                    Fact f1 = v1.factValue(MT.this.rete.getGlobalContext());
                    v1 = f1.getSlotValue("name");
                }
                catch (Exception e) {
                    trace.err("byNameSorter: Exception getting name slot from right operand " + v1 + ": " + e);
                    v1 = null;
                }
                if (v0 == null) {
                    return v1 == null ? 0 : 1;
                }
                if (v1 == null) {
                    return -1;
                }
                if (v0.equals(Funcall.NIL)) {
                    return v1.equals(Funcall.NIL) ? 0 : 1;
                }
                if (v1.equals(Funcall.NIL)) {
                    return -1;
                }
                String name0 = null;
                String name1 = null;
                try {
                    name0 = v0.stringValue(MT.this.rete.getGlobalContext());
                }
                catch (JessException je) {
                    name0 = null;
                }
                try {
                    name1 = v1.stringValue(MT.this.rete.getGlobalContext());
                }
                catch (JessException je) {
                    name1 = null;
                }
                if (name0 == null) {
                    return name1 == null ? 0 : 1;
                }
                if (name1 == null) {
                    return -1;
                }
                return name0.compareTo(name1);
            }
        };
        Collections.sort(facts, byNameSorter);
        if (vv == null) {
            return;
        }
        for (FactIDValue fIdV : facts) {
            vv.add((Value)fIdV);
        }
    }

    private void loadInterfaceActions() {
        if (this.interfaceActionsList == null) {
            System.err.println("NULL value in MT.loadInterfaceActions(): interfaceActionsList is null");
            return;
        }
        boolean first = true;
        Iterator<InterfaceAction> it = this.interfaceActionsList.iterator();
        while (it.hasNext()) {
            block6: {
                if (first && this.console != null && this.console.getTextOutput() != null) {
                    this.console.getTextOutput().append("\nSetting start state values in working memory.");
                }
                InterfaceAction ia = it.next();
                Object factId = null;
                try {
                    Fact f = this.modifyFromSAI(ia.selectionList, ia.actionList, ia.inputList);
                    if (trace.getDebugCode("mt")) {
                        trace.out("mt", "InterfaceAction: " + f);
                    }
                }
                catch (JessException je) {
                    String errMsg = "Error setting initial value for selection " + (ia.selectionList.size() < 1 ? "(empty)" : ia.selectionList.toString());
                    trace.err(errMsg);
                    je.printStackTrace();
                    if (this.console == null || this.console.getTextOutput() == null) break block6;
                    this.console.getTextOutput().append("\n" + errMsg + ": " + (Object)((Object)je));
                }
            }
            first = false;
        }
    }

    public void setResume(boolean b) {
        this.getModelTracing().resumeBreak.setResume(b);
    }

    public CTAT_Controller getController() {
        return this.controller;
    }

    public String getProblemName() {
        return this.problemName;
    }

    public void updateProblemSummaryFacts(ProblemSummary ps) {
        if (this.getRete() == null || !this.getRete().getUseProblemSummary()) {
            return;
        }
        ProblemSummaryAccess psa = new ProblemSummaryAccess();
        psa.updateProblemSummaryFacts(ps, this.getRete(), null);
        if (this.wmeEditor != null && this.wmeEditor.getPanel() != null) {
            this.wmeEditor.getPanel().refresh();
        }
    }

    public JessModelTracing getJMT() {
        return this.jmt;
    }

    private class InterfaceAction {
        final List selectionList;
        final List actionList;
        final List inputList;

        InterfaceAction(List selection, List action, List input) {
            this.selectionList = selection == null ? new LinkedList() : selection;
            this.actionList = action == null ? new LinkedList() : action;
            this.inputList = input == null ? new LinkedList() : input;
        }
    }
}

