/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Pattern;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

public class MTRegexpMatch
implements Userfunction,
Serializable {
    private static HashMap<String, Pattern> s_patterns = new HashMap();

    public String getName() {
        return "mtregexp";
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        String expression = vv.get(1).stringValue(context);
        String trial = vv.get(2).stringValue(context);
        Pattern regex = this.getPattern(expression);
        boolean match = regex.matcher(trial).matches();
        return match ? Funcall.TRUE : Funcall.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern getPattern(String expression) {
        HashMap<String, Pattern> hashMap = s_patterns;
        synchronized (hashMap) {
            Pattern p = s_patterns.get(expression);
            if (p == null) {
                p = Pattern.compile(expression);
                s_patterns.put(expression, p);
            }
            return p;
        }
    }
}

