/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.MTRete;
import java.io.Serializable;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

public class PredictObservableAction
implements Userfunction,
Serializable {
    private static final String PREDICT_OBSERVABLE_ACTION = "predict-observable-action";
    protected transient JessModelTracing jmt;
    protected transient Context context;

    public PredictObservableAction() {
        this(null);
    }

    public PredictObservableAction(JessModelTracing jmt) {
        this.jmt = jmt;
    }

    public String getName() {
        return PREDICT_OBSERVABLE_ACTION;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        this.context = context;
        if (!vv.get(0).stringValue(context).equals(this.getName())) {
            throw new JessException(this.getName(), "called but ValueVector head differs", vv.get(0).stringValue(context));
        }
        String predictedSelection = "NotSpecified";
        String predictedAction = "NotSpecified";
        String predictedInput = "NotSpecified";
        String predictedInputTestFunction = "=";
        if (this.getJmt() == null) {
            return Funcall.TRUE;
        }
        if (vv.size() > 1) {
            predictedSelection = vv.get(1).resolveValue(context).stringValue(context);
            if (vv.size() > 2) {
                predictedAction = vv.get(2).resolveValue(context).stringValue(context);
                if (vv.size() > 3) {
                    predictedInput = vv.get(3).resolveValue(context).stringValue(context);
                }
            }
        }
        if (predictedSelection == "NotSpecified" && predictedAction == "NotSpecified" && predictedInput == "NotSpecified") {
            throw new JessException(this.getName(), "at least one selection, action or input argument must be specified", "NotSpecified");
        }
        int matchResult = 3;
        if (vv.size() > 4) {
            predictedInputTestFunction = vv.get(vv.size() - 1).resolveValue(context).stringValue(context);
            trace.out("[ " + predictedSelection + " , " + predictedAction + " , " + predictedInput + " , " + predictedInputTestFunction + " ] ");
        }
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "predict-obs-act[ " + predictedSelection + " , " + predictedAction + " , " + predictedInput + " , " + predictedInputTestFunction + " ] ");
        }
        this.jmt.setRuleSAI(predictedSelection, predictedAction, predictedInput, predictedInputTestFunction);
        Matcher m = this.getMatcher(vv, context);
        matchResult = m != null ? this.jmt.testFiringNodeSAI(m, this.jmt.isHintTrace()) : this.jmt.testFiringNodeSAI(predictedSelection, predictedAction, predictedInput, predictedInputTestFunction, this.jmt.isHintTrace(), context);
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "(predict-observable-action " + predictedSelection + " " + predictedAction + " " + predictedInput + ") returns " + matchResult);
        }
        Value result = Funcall.TRUE;
        if (!this.jmt.isHintTrace() && matchResult == 2) {
            this.jmt.haltRete(this.getName());
            result = Funcall.FALSE;
        }
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "predict-observable-action returning " + result.stringValue(context));
        }
        return result;
    }

    public Matcher getMatcher(ValueVector vv, Context context) throws JessException {
        Matcher m = null;
        Value cnv = vv.get(vv.size() - 1).resolveValue(context);
        String possibleClassName = cnv == null ? null : cnv.stringValue(context);
        int lastArgIndex = vv.size() - 2;
        m = this.jmt.getMatcher(possibleClassName);
        if (m != null || vv.size() == 4) {
            // empty if block
        }
        if (m != null) {
            for (int i = 1; i <= lastArgIndex; ++i) {
                String param;
                Value rv = vv.get(i).resolveValue(context);
                String string = param = rv == null ? null : rv.stringValue(context);
                if ("NotSpecified".equals(param)) {
                    m.setParamNotSpecified(i - 1, "NotSpecified");
                    continue;
                }
                if ("DONT-CARE".equals(param)) {
                    m.setParamNotSpecified(i - 1, "DONT-CARE");
                    continue;
                }
                m.setParameterByIndex(param, i - 1);
            }
        }
        return m;
    }

    protected JessModelTracing getJmt() {
        if (this.jmt == null && this.context != null && this.context.getEngine() instanceof MTRete) {
            this.jmt = ((MTRete)this.context.getEngine()).getJmt();
        }
        return this.jmt;
    }

    protected void setJmt(JessModelTracing jmt) {
        this.jmt = jmt;
    }
}

