/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctatview.JHorizontalTable;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.ResumeBreak;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.jess.RuleActivationTreePanel;
import edu.cmu.pact.jess.WMEEditor;
import edu.cmu.pact.jess.WhyNot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jess.Defrule;

public class RuleActivationTree
implements PropertyChangeListener {
    TreeTableTree activationTree;
    JHorizontalTable treeTable;
    TreeTableModel activationModel;
    TreeTableModel tempActivationModel;
    private MTRete rete;
    private List<WhyNot> whyNotList = new LinkedList<WhyNot>();
    JLabel saiLabel = null;
    JDialog saiDialog = null;
    TreePath treePath;
    String restoreState = "dbgRstrState.tmp";
    Vector breakPointRules = new Vector();
    Vector<String> remainingRuleList = new Vector();
    ResumeBreak resumeBreak;
    int minDepth = 1;
    JLabel statusLbl;
    JLabel maxDepthLbl = new JLabel();
    private final CTAT_Controller controller;
    private LoggingSupport loggingSupport;
    public static final String RULE_BREAK_POINTS = "RULE_BREAK_POINTS";
    public static final String WHY_NOT = "WHY_NOT";
    public static final String SHOW_ACTIVATION = "SHOW_ACTIVATION";
    public static final String SHOW_SAI = "SHOW_SAI";

    public TreeTableModel getActivationModel() {
        return this.activationModel;
    }

    public RuleActivationTree(final CTAT_Controller controller) {
        this.controller = controller;
        this.loggingSupport = controller.getLoggingSupport();
        this.init(this.controller);
        if (trace.getDebugCode("sdc")) {
            trace.out("sdc", "constructor");
        }
        trace.printStack("sdc");
        this.activationModel = new TreeTableModel(RuleActivationNode.create(null, 0));
        this.tempActivationModel = new TreeTableModel(RuleActivationNode.create(null, 0));
        this.activationTree = new TreeTableTree(this.activationModel);
        this.treeTable = new JHorizontalTable(new TreeTableModelAdapter(new TreeTableModel(RuleActivationNode.create(null, 0)), this.activationTree)){
            private static final long serialVersionUID = 1L;

            @Override
            public int getEditingRow() {
                return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
            }
        };
        this.treeTable.setName("Rule Activation Tree");
        this.maxDepthLbl.setName("Max Depth Label");
        this.activationTree.setName("Activation Tree");
        for (int i = 0; i < 3; ++i) {
            this.treeTable.getColumnModel().getColumn(i).setPreferredWidth(25);
            this.treeTable.getColumnModel().getColumn(i).setMaxWidth(25);
        }
        this.activationTree.setRowHeight(this.treeTable.getRowHeight());
        this.treeTable.setDefaultRenderer(TreeTableModel.class, this.activationTree);
        this.treeTable.setDefaultRenderer(String.class, new MatchCellRenderer());
        this.treeTable.setDefaultEditor(TreeTableModel.class, this.activationTree);
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (!(me.getComponent() instanceof JTable)) {
                    return;
                }
                if (!(((JTable)me.getComponent()).getModel() instanceof TreeTableModelAdapter)) {
                    return;
                }
                TreeTableModelAdapter tm = (TreeTableModelAdapter)((JTable)me.getComponent()).getModel();
                int row = RuleActivationTree.this.treeTable.rowAtPoint(me.getPoint());
                int column = RuleActivationTree.this.treeTable.columnAtPoint(me.getPoint());
                RuleActivationNode node = (RuleActivationNode)tm.nodeForRow(row);
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "table mouse event node " + node + ", column" + column + ": me" + me);
                }
                if (column > 2) {
                    return;
                }
                String htmlText = node.getNodeToolTipText();
                if (htmlText == null || htmlText.length() < 1) {
                    return;
                }
                if (RuleActivationTree.this.saiLabel == null) {
                    RuleActivationTree.this.saiLabel = new JLabel(htmlText);
                    RuleActivationTree.this.saiLabel.setBackground(Color.WHITE);
                    RuleActivationTree.this.saiLabel.setOpaque(true);
                    JOptionPane optionPane = new JOptionPane();
                    optionPane.setMessage(new Object[]{RuleActivationTree.this.saiLabel});
                    optionPane.setMessageType(-1);
                    optionPane.setOptionType(-1);
                    RuleActivationTree.this.saiDialog = optionPane.createDialog(controller.getActiveWindow(), node.toString());
                    RuleActivationTree.this.loggingSupport.authorActionLog("CONFLICT_TREE", RuleActivationTree.SHOW_SAI, node.toString(), htmlText, (Object)"");
                    RuleActivationTree.this.saiDialog.setModal(false);
                } else {
                    RuleActivationTree.this.saiLabel.setText(htmlText);
                    RuleActivationTree.this.saiDialog.setTitle(node.toString());
                }
                RuleActivationTree.this.saiDialog.setVisible(true);
            }
        });
        final RuleActivationTree rat = this;
        this.activationTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                JTree t = (JTree)me.getComponent();
                if (t.getRowForLocation(me.getX(), me.getY()) != -1) {
                    RuleActivationTree.this.treePath = t.getClosestPathForLocation(me.getX(), me.getY());
                    RuleActivationNode node = (RuleActivationNode)RuleActivationTree.this.treePath.getLastPathComponent();
                    if (node == null) {
                        return;
                    }
                    if (node.isChainNode()) {
                        PopupListener popupListener = new PopupListener(node);
                        String title = "Why Not?";
                        final JDialog popupDialog = new JDialog(controller.getActiveWindow());
                        popupDialog.setTitle(title);
                        Box popup = new Box(1);
                        ArrayList<String> ruleNames = new ArrayList<String>();
                        Iterator<Object> it = RuleActivationTree.this.rete.allRulesIterator();
                        while (it.hasNext()) {
                            ruleNames.add(it.next().getName());
                        }
                        Collections.sort(ruleNames, String.CASE_INSENSITIVE_ORDER);
                        for (String ruleName : ruleNames) {
                            JMenuItem menuItem = new JMenuItem(ruleName);
                            menuItem.addActionListener(popupListener);
                            menuItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    popupDialog.dispose();
                                }
                            });
                            popup.add(menuItem);
                        }
                        JScrollPane popupSp = new JScrollPane(popup);
                        popupSp.validate();
                        Dimension spDim = new Dimension(popup.getPreferredSize().width + 60, controller.getActiveWindow().getSize().height / 2);
                        if (trace.getDebugCode("agenda")) {
                            trace.out("agenda", "RAT.mouseListener spDim " + spDim);
                        }
                        popupDialog.getContentPane().add((Component)popupSp, "Center");
                        popupDialog.setSize(spDim);
                        popupDialog.setLocationRelativeTo(RuleActivationTree.this.treeTable);
                        if (trace.getDebugCode("agenda")) {
                            trace.out("agenda", "RAT.mouseListener popupDialog\n  " + popupDialog);
                        }
                        popupDialog.setVisible(true);
                    } else {
                        String rule = node.getName();
                        Object[] nodes = RuleActivationTree.this.treePath.getPath();
                        RuleActivationTree.this.loggingSupport.authorActionLog("CONFLICT_TREE", RuleActivationTree.SHOW_ACTIVATION, node.toString(), "", (Object)"");
                        int nodePathLength = nodes.length - 1;
                        if (trace.getDebugCode("mt")) {
                            trace.out("mt", "nodePathLength " + nodePathLength + ", path selected " + RuleActivationTree.this.dumpPath(nodes));
                        }
                        ArrayList currentState = new ArrayList();
                        try {
                            MTRete wnRete = new MTRete(controller.getEventLogger(), null);
                            String errMsg = node.loadPriorState(wnRete);
                            if (errMsg != null) {
                                JOptionPane.showMessageDialog(controller.getActiveWindow(), errMsg, "Error loading state", 0);
                            } else {
                                Iterator fi = wnRete.listFacts();
                                while (fi.hasNext()) {
                                    currentState.add(fi.next());
                                }
                                Vector reqSAI = RuleActivationTree.this.getReqSAI(node, false);
                                Vector actualSAI = RuleActivationTree.this.getActualSAI(node, false, null);
                                WhyNot wn = new WhyNot(rule, currentState, wnRete.allRulesMap(), wnRete.getEventLogger());
                                RuleActivationTree.this.housekeepWhyNotList(me, wn);
                                wn.setReqSAI(reqSAI);
                                wn.setNodeSAI(actualSAI);
                                wn.setRete(wnRete);
                                MT mt = new MT(controller, wnRete);
                                WMEEditor wmeeditor = new WMEEditor(wnRete, mt, node.getState(), false, true);
                                wn.reasonOut(wmeeditor);
                                wn.requestFocus();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                RuleActivationTree.this.activationTree.revalidate();
                RuleActivationTree.this.treeTable.revalidate();
                RuleActivationTree.this.getDisplayPanel().repaint(rat);
            }
        });
    }

    private void housekeepWhyNotList(MouseEvent me, WhyNot wn) {
        this.housekeepWhyNotList(me.isShiftDown(), wn);
    }

    private void housekeepWhyNotList(ActionEvent ae, WhyNot wn) {
        this.housekeepWhyNotList((ae.getModifiers() & 1) != 0, wn);
    }

    private void housekeepWhyNotList(boolean preserveOld, WhyNot wn) {
        if (!preserveOld) {
            Iterator<WhyNot> it = this.whyNotList.iterator();
            while (it.hasNext()) {
                it.next().dispose();
            }
            this.whyNotList.clear();
        }
        this.whyNotList.add(wn);
    }

    public void setResumeBreak(ResumeBreak rb) {
        this.resumeBreak = rb;
    }

    public void displayBreakPointsPanel() {
        this.constructBreakPointsPanel().setVisible(true);
    }

    private JFrame constructBreakPointsPanel() {
        final JFrame breakPointsFrame = new JFrame("BreakPoints");
        final JTextField depth = new JTextField(3);
        JUndo.makeTextUndoable(depth);
        depth.setText("" + this.minDepth);
        this.remainingRuleList.clear();
        Iterator it = this.rete.listDefrules();
        while (it.hasNext()) {
            Defrule dr;
            Object obj = it.next();
            if (!obj.getClass().getName().equalsIgnoreCase("jess.defrule") || this.breakPointRules.contains((dr = (Defrule)obj).getName())) continue;
            this.remainingRuleList.add(dr.getName());
        }
        final DefaultListModel<String> allRuleModel = new DefaultListModel<String>();
        final JList allRulesList = new JList(allRuleModel);
        for (int i = 0; i < this.remainingRuleList.size(); ++i) {
            allRuleModel.addElement(this.remainingRuleList.get(i));
        }
        allRulesList.setMinimumSize(new Dimension(200, 200));
        allRulesList.setMaximumSize(new Dimension(200, 200));
        allRulesList.setPreferredSize(new Dimension(200, 200));
        final DefaultListModel breakPointsModel = new DefaultListModel();
        final JList breakPointsList = new JList(breakPointsModel);
        for (int i = 0; i < this.breakPointRules.size(); ++i) {
            breakPointsModel.addElement(this.breakPointRules.get(i));
        }
        breakPointsList.setMinimumSize(new Dimension(200, 200));
        breakPointsList.setMaximumSize(new Dimension(200, 200));
        breakPointsList.setPreferredSize(new Dimension(200, 200));
        JButton addBtn = new JButton(">");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int i;
                int[] indices = allRulesList.getSelectedIndices();
                for (i = 0; i < indices.length; ++i) {
                    Object obj = allRuleModel.get(indices[i]);
                    breakPointsModel.addElement(obj);
                }
                for (i = 0; i < indices.length; ++i) {
                    allRuleModel.remove(indices[i]);
                }
                allRulesList.updateUI();
                breakPointsList.updateUI();
            }
        });
        JButton removeBtn = new JButton("<");
        removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int i;
                int[] indices = breakPointsList.getSelectedIndices();
                breakPointsList.setSelectionMode(2);
                for (i = 0; i < indices.length; ++i) {
                    Object obj = breakPointsModel.get(indices[i]);
                    allRuleModel.addElement(obj);
                }
                for (i = 0; i < indices.length; ++i) {
                    breakPointsModel.remove(indices[i]);
                }
                allRulesList.updateUI();
                breakPointsList.updateUI();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 1));
        btnPanel.add(addBtn);
        btnPanel.add(removeBtn);
        JPanel listPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        listPanel.setLayout(gridBag);
        JPanel southBtnPanel = new JPanel();
        JButton okBtn = new JButton("Set");
        breakPointsFrame.getRootPane().setDefaultButton(okBtn);
        okBtn.setActionCommand("Set Rule Breakpoints");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RuleActivationTree.this.breakPointRules.clear();
                for (int i = 0; i < breakPointsModel.size(); ++i) {
                    RuleActivationTree.this.breakPointRules.addElement(breakPointsModel.get(i));
                }
                RuleActivationTree.this.loggingSupport.authorActionLog("CONFLICT_TREE", RuleActivationTree.RULE_BREAK_POINTS, RuleActivationTree.this.breakPointRules.toString(), "", (Object)"");
                RuleActivationTree.this.minDepth = Integer.parseInt(depth.getText());
                breakPointsFrame.dispose();
            }
        });
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.setActionCommand("Cancel Set Rule Breakpoints");
        cancelBtn.addActionListener(this.rete.getEventLogger());
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                breakPointsFrame.dispose();
            }
        });
        southBtnPanel.setLayout(new FlowLayout(2));
        southBtnPanel.add(okBtn);
        southBtnPanel.add(cancelBtn);
        JScrollPane allRuleSp = new JScrollPane(allRulesList);
        allRuleSp.setPreferredSize(new Dimension(200, 200));
        allRuleSp.setMaximumSize(new Dimension(200, 200));
        JScrollPane breakRuleSp = new JScrollPane(breakPointsList);
        breakRuleSp.setPreferredSize(new Dimension(200, 200));
        breakRuleSp.setMaximumSize(new Dimension(200, 200));
        JLabel allRuleLabel = new JLabel("Rule Names");
        JLabel breakOnLabel = new JLabel("Break On");
        JLabel depthLbl = new JLabel("Number of rules already fired >= ");
        JPanel depthPanel = new JPanel();
        depthPanel.add(depthLbl);
        depthPanel.add(depth);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        gridBag.setConstraints(allRuleLabel, gbc);
        listPanel.add(allRuleLabel);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        gridBag.setConstraints(breakOnLabel, gbc);
        listPanel.add(breakOnLabel);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.5;
        gridBag.setConstraints(allRuleSp, gbc);
        listPanel.add(allRuleSp);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gridBag.setConstraints(btnPanel, gbc);
        listPanel.add(btnPanel);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gridBag.setConstraints(breakRuleSp, gbc);
        listPanel.add((Component)breakRuleSp, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gridBag.setConstraints(southBtnPanel, gbc);
        listPanel.add(southBtnPanel);
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gridBag.setConstraints(depthPanel, gbc);
        listPanel.add(depthPanel);
        breakPointsFrame.getContentPane().add(listPanel);
        breakPointsFrame.pack();
        RuleActivationTreePanel displayPanel = this.getDisplayPanel();
        int x = displayPanel.getX() + displayPanel.getWidth() / 2 - breakPointsFrame.getWidth() / 2;
        int y = displayPanel.getY() + displayPanel.getHeight() / 2 - breakPointsFrame.getHeight() / 2;
        breakPointsFrame.setLocation(x, y);
        return breakPointsFrame;
    }

    public void addNode(RuleActivationNode parent, RuleActivationNode node) {
        this.tempActivationModel.insertNodeInto(node, parent, parent.getChildCount());
    }

    public void displayTree() {
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "see if Conflict Tree repaints");
        }
        this.activationModel = new TreeTableModel((RuleActivationNode)this.tempActivationModel.getRoot());
        this.activationTree.setModel(this.activationModel);
        this.activationTree.revalidate();
        this.treeTable.revalidate();
        this.expandTree((RuleActivationNode)this.activationModel.getRoot());
        this.getDisplayPanel().repaint(this);
    }

    public void clearTree(RuleActivationNode root) {
        this.reset(root);
        this.activationTree.revalidate();
        this.treeTable.revalidate();
        this.expandTree((RuleActivationNode)this.activationModel.getRoot());
        if (this.getDisplayPanel() != null) {
            this.getDisplayPanel().repaint(this);
        }
    }

    private void expandTree(RuleActivationNode node) {
        if (trace.getDebugCode("mtt")) {
            trace.out("mtt", "expandTree(" + node + ")");
        }
        this.activationTree.expandPath(new TreePath(node.getPath()));
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            this.expandTree((RuleActivationNode)e.nextElement());
        }
    }

    public void setRete(MTRete r) {
        this.rete = r;
    }

    public void reset(RuleActivationNode root) {
        ((RuleActivationNode)this.activationModel.getRoot()).removeAllChildren();
        this.activationModel.reload();
        if (root == null) {
            root = RuleActivationNode.create(null, 0);
        }
        this.tempActivationModel = new TreeTableModel(root);
    }

    public Vector getBreakPointRules() {
        return this.breakPointRules;
    }

    public static String copyRete(MTRete src, MTRete dest) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MTRete.Routers routers = src.saveState(baos);
            byte[] reteState = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(reteState);
            dest.loadState(bais, routers);
            return null;
        }
        catch (Exception e) {
            return "Error copying Rete state: " + e;
        }
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    private String dumpPath(Object[] nodes) {
        StringBuffer result = new StringBuffer("L:" + nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            result.append(" ").append(nodes[i].toString());
        }
        return result.toString();
    }

    public Vector getActualSAI(RuleActivationNode node, boolean scanChildren, String rule) {
        Vector<String> actualSAI = new Vector<String>();
        if (!scanChildren) {
            actualSAI.add(node.getActualSelection());
            actualSAI.add(node.getActualAction());
            actualSAI.add(node.getActualInput());
        } else {
            for (int z = 0; z < node.getChildCount(); ++z) {
                RuleActivationNode dn = (RuleActivationNode)node.getChildAt(z);
                String nodeName = dn.toString();
                if (!nodeName.equals(rule)) continue;
                actualSAI.add(dn.getActualSelection());
                actualSAI.add(dn.getActualAction());
                actualSAI.add(dn.getActualInput());
            }
        }
        return actualSAI;
    }

    public Vector getReqSAI(RuleActivationNode node, boolean scanChildren) {
        Vector<String> reqSAI = new Vector<String>();
        if (!scanChildren) {
            reqSAI.add(node.getReqSelection());
            reqSAI.add(node.getReqAction());
            reqSAI.add(node.getReqInput());
            return reqSAI;
        }
        for (int z = 0; z < node.getChildCount(); ++z) {
            RuleActivationNode dn = (RuleActivationNode)node.getChildAt(z);
            if (reqSAI.size() != 0) continue;
            String s = dn.getReqSelection();
            String a = dn.getReqAction();
            String in = dn.getReqInput();
            if (s.equals("NotSpecified") && a.equals("NotSpecified") && in.equals("NotSpecified")) continue;
            reqSAI.add(s);
            reqSAI.add(a);
            reqSAI.add(in);
        }
        return reqSAI;
    }

    private void getPreferencesFromModel(PreferencesModel model) {
        Integer integerValue = model.getIntegerValue("Tree Depth");
        if (integerValue != null) {
            this.maxDepthLbl.setText("Max Depth: " + integerValue);
        }
    }

    private void init(CTAT_Controller controller) {
        if (controller == null) {
            return;
        }
        PreferencesModel pm = controller.getPreferencesModel();
        if (pm == null) {
            return;
        }
        pm.addPropertyChangeListener("Tree Depth", this);
        this.getPreferencesFromModel(pm);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        String name = arg0.getPropertyName();
        Object newValue = arg0.getNewValue();
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "Changed " + name + " from " + arg0.getOldValue() + " to " + newValue);
        }
        if ("Tree Depth".equals(name)) {
            this.maxDepthLbl.setText("Max Depth: " + newValue);
        }
    }

    JTable getTreeTable() {
        return this.treeTable;
    }

    JLabel getDepthLabel() {
        return this.maxDepthLbl;
    }

    public RuleActivationTreePanel getDisplayPanel() {
        if (this.controller != null && this.controller.getServer() != null) {
            return this.controller.getServer().getDockManager().getConflictTreePanel();
        }
        return null;
    }

    public class TreeTableModelAdapter
    extends AbstractTableModel {
        private static final long serialVersionUID = 2811872749348512828L;
        JTree tree;
        TreeTableModel tableModel;

        public TreeTableModelAdapter(TreeTableModel tableModel, JTree tree) {
            this.tree = tree;
            this.tableModel = tableModel;
            tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
            tableModel.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }
            });
        }

        @Override
        public int getColumnCount() {
            return this.tableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return this.tableModel.getColumnName(column);
        }

        public Class getColumnClass(int column) {
            return this.tableModel.getColumnClass(column);
        }

        @Override
        public int getRowCount() {
            return this.tree.getRowCount();
        }

        protected Object nodeForRow(int row) {
            TreePath treePath = this.tree.getPathForRow(row);
            return treePath.getLastPathComponent();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.tableModel.getValueAt(this.nodeForRow(row), column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.tableModel.isCellEditable(this.nodeForRow(row), column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            this.tableModel.setValueAt(value, this.nodeForRow(row), column);
        }

        protected void delayedFireTableDataChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }
    }

    public class TreeTableModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = -7494300815613177157L;
        protected String[] cNames;

        public TreeTableModel(TreeNode root) {
            super(root);
            this.cNames = new String[]{"S", "A", "I", "Rule"};
        }

        public boolean isCellEditable(Object node, int column) {
            return this.getColumnClass(column) == TreeTableModel.class;
        }

        public void setValueAt(Object aValue, Object node, int column) {
        }

        public int getColumnCount() {
            return this.cNames.length;
        }

        public String getColumnName(int column) {
            return this.cNames[column];
        }

        public Class getColumnClass(int column) {
            if (column == 3) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        public Object getValueAt(Object node, int column) {
            int match = 3;
            switch (column) {
                case 0: {
                    match = ((RuleActivationNode)node).selectionMatches();
                    break;
                }
                case 1: {
                    match = ((RuleActivationNode)node).actionMatches();
                    break;
                }
                case 2: {
                    match = ((RuleActivationNode)node).inputMatches();
                    break;
                }
                case 3: {
                    return ((RuleActivationNode)node).getName();
                }
            }
            if (match == 1) {
                return "\u2713";
            }
            if (match == 2) {
                return "X";
            }
            if (match == 0) {
                return "*";
            }
            return null;
        }
    }

    public class MatchCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 2490846083534325752L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(Color.BLACK);
            if (value == null) {
                return this;
            }
            this.setForeground(new Color(0.0f, 0.5f, 0.0f));
            if (value.toString().equals("?")) {
                this.setForeground(Color.BLACK);
            } else if (value.toString().equals("X")) {
                this.setForeground(Color.RED);
            }
            return this;
        }
    }

    public class TreeTableTree
    extends JTree
    implements TableCellRenderer,
    TableCellEditor {
        private static final long serialVersionUID = 8443720787360882405L;
        protected int visibleRow;
        protected EventListenerList listenerList;

        public TreeTableTree(TreeModel m) {
            super(m);
            this.listenerList = new EventListenerList();
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, RuleActivationTree.this.treeTable.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return this;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(CellEditorListener.class, l);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                ((CellEditorListener)listeners[i + 1]).editingStopped(new ChangeEvent(this));
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                ((CellEditorListener)listeners[i + 1]).editingCanceled(new ChangeEvent(this));
            }
        }
    }

    class PopupListener
    implements ActionListener {
        private final RuleActivationNode node;

        PopupListener(RuleActivationNode node) {
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String rule = e.getActionCommand();
            String selectedPath = RuleActivationTree.this.dumpPath(RuleActivationTree.this.treePath.getPath());
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "PopupListener path selected " + selectedPath);
            }
            RuleActivationTree.this.loggingSupport.authorActionLog("CONFLICT_TREE", RuleActivationTree.WHY_NOT, rule, selectedPath, (Object)"");
            ArrayList currentState = new ArrayList();
            try {
                MTRete wnRete = new MTRete(RuleActivationTree.this.controller.getEventLogger(), null);
                String errMsg = null;
                errMsg = !this.node.isRoot() || this.node.getChildCount() > 0 ? this.node.loadPriorState(wnRete) : RuleActivationTree.copyRete(RuleActivationTree.this.rete, wnRete);
                if (errMsg != null) {
                    JOptionPane.showMessageDialog(RuleActivationTree.this.controller.getActiveWindow(), errMsg, "Error loading state", 0);
                    return;
                }
                Iterator fi = wnRete.listFacts();
                while (fi.hasNext()) {
                    currentState.add(fi.next());
                }
                Vector reqSAI = RuleActivationTree.this.getReqSAI(this.node, true);
                Vector actualSAI = RuleActivationTree.this.getActualSAI(this.node, true, rule);
                System.out.println("constructing WhyNot with rule = " + rule);
                WhyNot wn = new WhyNot(rule, currentState, wnRete.allRulesMap(), RuleActivationTree.this.rete.getEventLogger());
                RuleActivationTree.this.housekeepWhyNotList(e, wn);
                wn.setReqSAI(reqSAI);
                wn.setNodeSAI(actualSAI);
                wn.setRete(wnRete);
                MT mt = new MT(RuleActivationTree.this.controller, wnRete);
                WMEEditor wmeeditor = new WMEEditor(wnRete, mt, null, false, true);
                wn.reasonOut(wmeeditor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            RuleActivationTree.this.getDisplayPanel().repaint(RuleActivationTree.this.controller.getRuleActivationTree());
        }
    }
}

