/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.HintPolicyEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.jess.MTRete;
import java.io.Serializable;
import jess.Context;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

public class SetHintPolicy
implements Userfunction,
Serializable {
    private static final long serialVersionUID = 201311061041L;
    private static final String FUNCTION_NAME = "set-hint-policy";

    public String getName() {
        return FUNCTION_NAME;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        HintPolicyEnum[] policies;
        if (!(context.getEngine() instanceof MTRete)) {
            return new Value("ProblemModel not available", 2);
        }
        ProblemModel pm = ((MTRete)context.getEngine()).getMT().getController().getProblemModel();
        HintPolicyEnum oldPolicy = pm.getHintPolicy();
        String errorMsg = "";
        if (vv.size() > 1) {
            String arg = vv.get(1).stringValue(context);
            HintPolicyEnum newPolicy = HintPolicyEnum.fromString(arg, true);
            if (newPolicy != null) {
                pm.setHintPolicy(newPolicy);
                return new Value(oldPolicy.toString(), 2);
            }
            errorMsg = "Invalid policy \"" + arg + "\". ";
        }
        StringBuilder sb = new StringBuilder(errorMsg).append("Valid arguments:");
        for (HintPolicyEnum policy : policies = HintPolicyEnum.values()) {
            sb.append("\n  ").append(policy.toString());
        }
        return new Value(sb.toString(), 2);
    }
}

