/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.TextOutput;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessConsole;
import edu.cmu.pact.jess.JessParser;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.jess.RuleActivationTree;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStNode;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.jess.APlusModelTracing;
import edu.cmu.pact.miss.jess.UserFunctionPackage;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import jess.Activation;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.Jesp;
import jess.JessException;
import jess.RU;
import jess.Rete;
import jess.Strategy;
import jess.Value;
import jess.ValueVector;

public class SimStRete
extends MTRete
implements Serializable,
JessParser {
    private static final long serialVersionUID = 1L;
    public static String PROBLEM_NAME = "";
    public static final String ACTION = "UpdateTable";
    public static final String NOT_SPECIFIED = "NotSpecified";
    static int DEFAULT_MAX_DEPTH = 2;
    private int maxDepth = DEFAULT_MAX_DEPTH;
    private boolean bloadSuccessful = false;
    private boolean wmeTypesFromFile = false;
    private boolean prRulesFromFile = false;
    private boolean wmeInstancesFromFile = false;
    private transient JessConsole console;
    private transient BR_Controller controller;
    private APlusModelTracing amt;
    HashMap wmeChildSlots = new HashMap();
    private final String DEFAULT_STUCTURE_FILE = "wmeStructure.txt";
    private transient MT mt;
    private transient TextOutput textOutput = TextOutput.getNullOutput();

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean isBloadSuccessful() {
        return this.bloadSuccessful;
    }

    public void setBloadSuccessful(boolean bloadSuccessful) {
        this.bloadSuccessful = bloadSuccessful;
    }

    public boolean isWmeTypesFromFile() {
        return this.wmeTypesFromFile;
    }

    public void setWmeTypesFromFile(boolean wmeTypesFromFile) {
        this.wmeTypesFromFile = wmeTypesFromFile;
    }

    public boolean isPrRulesFromFile() {
        return this.prRulesFromFile;
    }

    public void setPrRulesFromFile(boolean prRulesFromFile) {
        this.prRulesFromFile = prRulesFromFile;
    }

    public boolean isWmeInstancesFromFile() {
        return this.wmeInstancesFromFile;
    }

    public void setWmeInstancesFromFile(boolean wmeInstancesFromFile) {
        this.wmeInstancesFromFile = wmeInstancesFromFile;
    }

    public JessConsole getConsole() {
        return this.console;
    }

    public void setConsole(JessConsole console) {
        this.console = console;
    }

    public BR_Controller getController() {
        return this.controller;
    }

    public void setController(BR_Controller controller) {
        this.controller = controller;
    }

    public APlusModelTracing getAmt() {
        return this.amt;
    }

    public void setAmt(APlusModelTracing amt) {
        this.amt = amt;
    }

    Vector getWmeChildSlots(String wmeType) throws Exception {
        Vector childSlots = (Vector)this.wmeChildSlots.get(wmeType);
        return childSlots;
    }

    public MT getMt() {
        return this.mt;
    }

    private void setMt(MT mt) {
        this.mt = mt;
    }

    @Override
    public TextOutput getTextOutput() {
        return this.textOutput;
    }

    @Override
    public void setTextOutput(TextOutput textOutput) {
        this.textOutput = textOutput;
    }

    public String getFactActualValue(String foaName) {
        String ret = "";
        ArrayList currentFacts = this.getFacts();
        foaName = foaName.replace(" ", "");
        for (int i = 0; i < currentFacts.size(); ++i) {
            Fact f = (Fact)currentFacts.get(i);
            try {
                Value val = f.getSlotValue("value");
                if (!f.getSlotValue("name").equals((Object)foaName)) continue;
                ret = "" + val + "";
                return ret;
            }
            catch (JessException jessException) {
                // empty catch block
            }
        }
        return ret;
    }

    public SimStRete(BR_Controller brController) {
        super(brController);
        this.controller = brController;
        this.mt = this.controller.getModelTracer();
        this.jmt = this.mt.getModelTracing();
        MT.loadDefaultUserfunctions(this.controller.getModelTracer(), this, null);
        ConflictResolutionStrategy.setStrategy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String problemName, boolean loadJessFiles) throws Exception {
        String[] problem;
        ArrayList<String> startElements = null;
        if (this.getController().getMissController() != null && this.getController().getMissController().getSimStPLE() != null) {
            startElements = this.getController().getMissController().getSimStPLE().getStartStateElements();
        } else if (this.getController().getMissController() != null && this.getController().getMissController().getSimSt().isValidationMode()) {
            startElements = new ArrayList();
            String file = this.getController().getMissController().getSimSt().getPackageName() + "/" + "simSt-config.txt";
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream is = cl.getResourceAsStream(file);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(isr);
                String line = reader.readLine();
                while (line != null) {
                    if (line.equals("startStateElements")) {
                        line = reader.readLine();
                        while (line != null && line.length() > 0) {
                            startElements.add(line);
                            line = reader.readLine();
                        }
                    }
                    if (line == null) continue;
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "Unable to read config file: " + e.getMessage());
                }
                e.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        } else {
            throw new Exception("Need to initialize the working memory with start state elements.");
        }
        PROBLEM_NAME = SimSt.convertFromSafeProblemName(problemName);
        if (loadJessFiles) {
            MT.loadDefaultUserfunctions(this.controller.getModelTracer(), this, null);
            this.initWMUsingJessFiles(problemName, false);
        }
        if ((problem = PROBLEM_NAME.split(this.controller.getMissController().getSimSt().getProblemDelimiter()))[0].contains("=")) {
            problem = PROBLEM_NAME.split("=");
        }
        if (problem[0].isEmpty()) {
            return;
        }
        for (int i = 0; i < startElements.size(); ++i) {
            this.setSAIDirectly(startElements.get(i), ACTION, problem[i]);
        }
    }

    public void initWMUsingJessFiles(String problemName, boolean useBinary) {
        this.loadJessFiles(problemName, useBinary);
        this.loadWMEStructureFromFile("wmeStructure.txt");
        try {
            if (!this.bloadSuccessful) {
                this.eval("(defglobal ?*sSelection* = NotSpecified)");
                this.eval("(defglobal ?*sAction* = NotSpecified)");
                this.eval("(defglobal ?*sInput* = NotSpecified)");
            }
        }
        catch (HeadlessException e1) {
            e1.printStackTrace();
        }
        catch (JessException je) {
            String errMsg = "Error defining selection-action-input globals";
            this.console.getTextOutput().append("\n" + errMsg + ":\n" + (Object)((Object)je));
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "ERROR CREATING S/A/I GLOBALS: " + (Object)((Object)je));
            }
            JOptionPane.showMessageDialog(null, errMsg + ":\n" + je.getDetail(), "Jess Warning", 2);
        }
        if (!this.wmeInstancesFromFile) {
            try {
                if (this.findDeftemplate("problem") != null) {
                    Fact problemFact = new Fact(this.findDeftemplate("problem"));
                    problemFact.setSlotValue("name", new Value(problemName, 1));
                    this.assertFact(problemFact);
                    if (trace.getDebugCode("mt")) {
                        trace.out("mt", "StartStateEnd: new problem fact id: " + new FactIDValue(problemFact));
                    }
                }
            }
            catch (Exception ex) {
                this.console.getTextOutput().append("\n" + ex.toString() + "\n");
                ex.printStackTrace();
            }
        }
        this.clearRuleActivationTree();
        this.showActivations("StartStateEnd");
    }

    public void setUp(String[] fileNames) {
        try {
            this.clear();
            this.eval("(set-salience-evaluation when-activated)");
            this.eval("(defglobal ?*hintRequest* = NotSpecified)");
            this.eval("(defglobal ?*studentSelection* = NotSpecified)");
            this.loadUserfunctions(this, this.getAmt());
            if (fileNames.length > 0) {
                for (int i = 0; i < fileNames.length; ++i) {
                    this.loadJessFile(fileNames[i]);
                }
            }
            this.clearRuleActivationTree();
            this.showActivations("StartStateEnd");
        }
        catch (JessException e) {
            e.printStackTrace();
        }
    }

    private void loadUserfunctions(SimStRete simStRete, APlusModelTracing amt) {
        String thisPkg = amt != null ? amt.getClass().getPackage().getName() : "edu.cmu.pact.miss.jess";
        String[] userFunctions = new String[]{thisPkg + ".ConstructTutorHintMessage", thisPkg + ".ConstructCLHintMessage", thisPkg + ".GetLhsForProblem", thisPkg + ".GetRhsForProblem", thisPkg + ".PredictedSAI", thisPkg + ".CompProblemWithHindsight", thisPkg + ".UpdateWMIfRuleSAIEqualsStudentSAI", thisPkg + ".UpdateFailedQuizPListAndTutoredQuizPList", thisPkg + ".UpdateWMIfStudentProblemMatchesList", thisPkg + ".UpdateWMIfRuleSAIEqualsStudentEnteredSide", thisPkg + ".GetQuizStatus", thisPkg + ".GetFailedQuizItems", thisPkg + ".GetProblem", thisPkg + ".GetSimilarProblem", thisPkg + ".ProblemType", thisPkg + ".GetFirstProblem", thisPkg + ".HasFirstSuggestedProblemBeenTutored", thisPkg + ".GetCurrentStudentEnteredProblem", thisPkg + ".GetAbstractedProblem", thisPkg + ".AddProblemIfNotInList", thisPkg + ".RemoveProblemFromHeadOfList", thisPkg + ".IsProblemSubsetOfList", thisPkg + ".GetCorrectSAI", thisPkg + ".CheckCorrectnessSimStStep", thisPkg + ".CheckCorrectnessSimStStepJO"};
        UserFunctionPackage ufp = new UserFunctionPackage(userFunctions, amt);
        if (ufp.size() < userFunctions.length) {
            trace.err("Warning: Only " + ufp.size() + " of " + userFunctions.length + " userFunctions defined were loaded");
        }
        simStRete.addUserpackage(ufp);
    }

    public void restoreInitialWMState(ProblemNode startNode, boolean loadJessFiles) {
        try {
            this.init(startNode.getName(), loadJessFiles);
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void goToWMState(ProblemNode startNode, Vector edge, boolean loadFiles) {
        int i;
        ArrayList currentFacts = this.getFacts();
        if (edge.size() == 0 || startNode == null) {
            return;
        }
        for (i = 0; i < currentFacts.size(); ++i) {
            Fact f = (Fact)currentFacts.get(i);
            if (f.getName().contains("MAIN::column") || f.getName().contains("MAIN::table") || f.getName().contains("MAIN::problem") || f.getName().contains("MAIN::initial-fact") || f.getName().contains("MAIN::ModelTrace")) continue;
            try {
                Value val = f.getSlotValue("value");
                String strValue = val.toString();
                if (!strValue.equalsIgnoreCase(NOT_SPECIFIED)) continue;
                Value inputVal = SimStRete.stringToValue("nil");
                this.modify(f, "value", inputVal);
                continue;
            }
            catch (JessException e) {
                trace.err("" + f + "\t" + f.getName());
                e.printStackTrace();
            }
        }
        this.restoreInitialWMState(startNode, loadFiles);
        for (i = 0; i < edge.size(); ++i) {
            ProblemEdge currEdge = (ProblemEdge)edge.elementAt(i);
            this.setSAIDirectly(currEdge.getSelection(), currEdge.getAction(), currEdge.getInput());
        }
    }

    public void updateWorkingMemory(SimStNode ssNode, Map hm) {
        ArrayList currentFacts = this.getFacts();
        if (ssNode == null) {
            return;
        }
        for (int i = 0; i < currentFacts.size(); ++i) {
            Fact f = (Fact)currentFacts.get(i);
            if (f.getName().contains("MAIN::column") || f.getName().contains("MAIN::table") || f.getName().contains("MAIN::problem")) continue;
            try {
                Value val = f.getSlotValue("value");
                String strValue = val.toString();
                if (!strValue.equalsIgnoreCase(NOT_SPECIFIED)) continue;
                Value inputVal = SimStRete.stringToValue("nil");
                this.modify(f, "value", inputVal);
                continue;
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        try {
            if (!ssNode.getName().contains("state")) {
                this.reset();
                this.init(ssNode.getName(), true);
            } else {
                for (RuleActivationNode key : hm.keySet()) {
                    SimStNode node = (SimStNode)hm.get(key);
                    if (!node.equals(ssNode)) continue;
                    this.setSAIDirectly(key.getActualSelection(), key.getActualAction(), key.getActualInput());
                }
            }
        }
        catch (JessException je) {
            je.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearRuleActivationTree() {
        if (this.controller.getModelTracer().getModelTracing() == null) {
            return;
        }
        RuleActivationTree tree = this.controller.getModelTracer().getModelTracing().getRuleActivationTree();
        if (tree != null) {
            tree.clearTree(null);
        }
    }

    @Override
    public int run(int maxNum) throws JessException {
        try {
            return super.run(maxNum);
        }
        catch (MTRete.HaltReteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public Value parse(Reader rdr) throws JessException {
        return this.parse(rdr, false);
    }

    @Override
    MTRete.Routers saveState(ByteArrayOutputStream baos) throws IOException {
        MTRete.Routers routers = new MTRete.Routers(this);
        if (this.getAmt() != null && this.getAmt().isModelTraceMode()) {
            try {
                this.remove(this.getController().getMissController().getSimSt().getModelTraceWM());
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        super.bsave(baos);
        return routers;
    }

    @Override
    void loadState(ByteArrayInputStream bais, MTRete.Routers routers) throws IOException, ClassNotFoundException {
        super.bload(bais);
        if (this.getAmt() != null && this.getAmt().isModelTraceMode()) {
            try {
                this.add(this.getController().getMissController().getSimSt().getModelTraceWM());
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        if (routers != null) {
            routers.setRouters(this);
        }
    }

    public void remove(Object o) throws JessException {
        this.undefinstance(o);
    }

    @Override
    void showActivations(String label) {
        if (!trace.getDebugCode("mt")) {
            return;
        }
        int nActs = 0;
        Iterator it = this.listActivations();
        while (it.hasNext()) {
            it.next();
            ++nActs;
        }
        int nFacts = 0;
        Iterator it2 = this.listFacts();
        while (it2.hasNext()) {
            it2.next();
            ++nFacts;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", label + " nActs=" + nActs + ", nFacts " + nFacts + ", rete " + this.hashCode());
        }
    }

    @Override
    public boolean setSAIDirectly(String selection, String action, String input) {
        Fact f = this.getFactByName(this, selection);
        if (f == null) {
            return false;
        }
        try {
            f.getSlotValue("value");
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        try {
            Value inputVal = SimStRete.stringToValue(input);
            this.modify(f, "value", inputVal);
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        this.updateChunkValues(selection, input);
        return true;
    }

    @Override
    public ArrayList getFacts() {
        ArrayList facts = new ArrayList();
        Iterator it = this.listFacts();
        while (it.hasNext()) {
            facts.add(it.next());
        }
        return facts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fact getFactByName(SimStRete ssRete, String name) {
        Fact fact = null;
        Iterator it = ssRete.listFacts();
        try {
            while (it.hasNext()) {
                Value v;
                fact = (Fact)it.next();
                if (fact.getDeftemplate().getSlotIndex("name") != -1 && (v = fact.getSlotValue("name")).stringValue(null).trim().equalsIgnoreCase(name)) {
                    Fact fact2 = fact;
                    return fact2;
                }
                fact = null;
            }
        }
        catch (JessException je) {
            this.console.getTextOutput().append(je.toString());
            if (MTRete.breakOnExceptions) {
                MTRete.stopModelTracing = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            it = null;
        }
        return fact;
    }

    private void loadJessFile(String rulesFile) {
        String fileName = this.getDirectory(rulesFile) + rulesFile;
        String[] fileNames = new String[]{fileName};
        Object[] files = this.findFiles(fileNames);
        Object rdr = null;
        Object resource = null;
        for (int i = 0; i < files.length; ++i) {
            if (this.getController().getMissController() == null || !this.getController().getMissController().isPLEon()) continue;
            this.parse(files[i], false, false);
        }
    }

    private void loadJessFiles(String problemName, boolean useBinary) {
        this.bloadSuccessful = false;
        this.wmeTypesFromFile = false;
        this.prRulesFromFile = false;
        this.wmeInstancesFromFile = false;
        String[] filenames = new String[]{problemName + ".bload", "wmeTypes.clp", "productionRules.pr", "init.wme", problemName + ".wme"};
        boolean[] results = null;
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = this.getDirectory(filenames[i]) + filenames[i];
        }
        if (!useBinary) {
            filenames[0] = null;
        }
        try {
            this.clear();
            results = this.loadJessFiles(filenames[0], filenames[1], filenames[2], filenames[3], filenames[4], null);
        }
        catch (Exception e) {
            trace.err("Error " + e + " trying to load Jess files");
            return;
        }
        this.bloadSuccessful = results[0];
        this.wmeTypesFromFile = results[1] || results[0];
        this.prRulesFromFile = results[2] || results[0];
        this.wmeInstancesFromFile = results[4] || results[0];
    }

    @Override
    public void clear() throws JessException {
        super.clear();
        ConflictResolutionStrategy.setStrategy(this);
    }

    private String getDirectory(String origFilename) {
        Object f = null;
        String dirname = this.getProblemDirectory();
        boolean validFilename = this.checkFilenameValid(dirname + origFilename);
        if (trace.getDebugCode("rr")) {
            trace.out("rr", "MT.getDirectory(): getProblemDirectory() result " + dirname + "+" + origFilename + " valid? " + validFilename);
        }
        if (!validFilename && !this.checkFilenameValid((dirname = this.controller.getPreferencesModel().getStringValue("workspace") + "/") + origFilename)) {
            dirname = null;
        }
        return dirname;
    }

    private boolean checkFilenameValid(String filename) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        File f = new File(filename);
        if (f == null || !f.isAbsolute() || !f.exists()) {
            File result = Utils.getFileAsResource(filename, this);
            if (trace.getDebugCode("rr")) {
                trace.out("rr", "rr.checkFilenameValid(" + filename + ") file result " + result);
            }
            if (null == result || !result.exists()) {
                URL url = Utils.getURL(filename, this);
                if (trace.getDebugCode("rr")) {
                    trace.out("rr", "rr.checkFilenameValid(" + filename + ") URL result " + url);
                }
                return url != null;
            }
        }
        return true;
    }

    String getProblemDirectory() {
        String prefValue;
        PreferencesModel pm;
        String result = ".";
        if (this.controller != null && (pm = this.controller.getPreferencesModel()) != null && (prefValue = pm.getStringValue("Problem Directory")) != null && prefValue.length() > 0) {
            result = prefValue;
        }
        if (!result.endsWith(File.separator) && !result.endsWith("/")) {
            return result + File.separator;
        }
        return result;
    }

    @Override
    boolean[] loadJessFiles(String bloadName, String templatesName, String rulesName, String problemFactsName, List interfaceTemplatesList) throws JessException {
        boolean[] temp = this.loadJessFiles(bloadName, templatesName, rulesName, "init.wme", problemFactsName, interfaceTemplatesList);
        boolean[] output = new boolean[]{temp[0], temp[1], temp[2], temp[4]};
        return output;
    }

    boolean[] loadJessFiles(String bloadName, String templatesName, String rulesName, String initFactsName, String problemFactsName, List interfaceTemplatesList) throws JessException {
        String[] filenames = new String[]{bloadName, templatesName, rulesName, initFactsName, problemFactsName};
        boolean templateFileIndex = true;
        int rulesFileIndex = 2;
        int factsFileIndex = 3;
        Object[] files = this.findFiles(filenames);
        File bloadFile = null;
        boolean[] results = new boolean[files.length];
        boolean doBload = false;
        if (files[0] instanceof File && ((File)files[0]).exists()) {
            bloadFile = (File)files[0];
            long bloadTime = bloadFile.lastModified();
            doBload = true;
            for (int i = 1; doBload && i < files.length; ++i) {
                if (!(files[i] instanceof File)) {
                    doBload = false;
                    continue;
                }
                File fi = (File)files[i];
                if (!fi.exists() || bloadTime <= fi.lastModified()) {
                    doBload = false;
                }
                if (!trace.getDebugCode("mt")) continue;
                trace.out("mt", "doBload " + doBload + ", files[" + i + "] " + fi + ", exists " + fi.exists());
            }
        }
        if (doBload) {
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(bloadFile));
                String fileLoadMsg = "\nLoading saved start state from binary file " + bloadFile.getAbsolutePath();
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", fileLoadMsg);
                }
                this.textOutput.append(fileLoadMsg);
                this.bload(in);
                in.close();
                results[0] = true;
                this.textOutput.append("\n");
                return results;
            }
            catch (Exception e) {
                trace.err("Error trying to load file " + bloadFile.getAbsolutePath() + ": " + e);
                this.clear();
            }
        }
        if (bloadFile != null && bloadFile.exists()) {
            bloadFile.delete();
        }
        Object errorMessage = null;
        for (int i = 1; i < files.length; ++i) {
            Object rdr = null;
            Object resource = null;
            results[i] = this.getController().getMissController() != null && this.getController().getMissController().isPLEon() ? this.parse(files[i], i == 2, false) : this.parse(files[i], i == 2, true);
        }
        this.textOutput.append("\n");
        return results;
    }

    private int loadInterfaceTemplates(List interfaceTemplatesList) {
        int count = 0;
        if (interfaceTemplatesList == null) {
            trace.err("MT.loadInterfaceTemplates(): interfaceTemplatesList is null");
            return 0;
        }
        for (String deftemplateCmd : interfaceTemplatesList) {
            try {
                if (count < 1 && this.textOutput != null) {
                    this.textOutput.append("\nLoading deftemplates from interface definitions.");
                }
                Value val = this.eval(deftemplateCmd);
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "rete " + this.hashCode() + " deftemplate, result " + val + ", type " + RU.getTypeName((int)val.type()) + ":\n" + deftemplateCmd);
                }
            }
            catch (JessException e1) {
                String errMsg = "Error executing deftemplate command " + (count + 1) + ":\n  " + deftemplateCmd + ":\n  " + (Object)((Object)e1) + (e1.getCause() == null ? "" : ";\n  " + e1.getCause().toString());
                trace.err(errMsg);
                e1.printStackTrace();
                this.textOutput.append("\n" + errMsg + "\n");
            }
            ++count;
        }
        return count;
    }

    private Object[] findFiles(String[] filenames) {
        Object[] results = new Object[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            File f = null;
            if (filenames[i] != null && filenames[i].length() > 0) {
                f = new File(filenames[i]);
            }
            if (f != null && f.isAbsolute() && f.exists()) {
                results[i] = f;
            } else {
                results[i] = Utils.getFileAsResource(filenames[i], this);
                if (null == results[i] || !((File)results[i]).exists()) {
                    results[i] = Utils.getURL(filenames[i], this);
                }
            }
            if (!trace.getDebugCode("mt")) continue;
            trace.out("mt", "filenames[" + i + "]=" + filenames[i] + ": " + (results[i] instanceof File ? ((File)results[i]).getAbsolutePath() : (results[i] instanceof URL ? results[i] : null)));
        }
        return results;
    }

    private boolean parse(Object file, boolean removeBuggyRules, boolean popupError) {
        InputStreamReader rdr;
        String fullPath;
        block6: {
            fullPath = null;
            try {
                if (file instanceof File) {
                    File f = (File)file;
                    fullPath = f.getCanonicalPath();
                    rdr = new FileReader(f);
                    break block6;
                }
                if (file instanceof URL) {
                    URL url = (URL)file;
                    fullPath = url.toString();
                    rdr = new InputStreamReader(url.openStream());
                    break block6;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                String errorMessage = "Error reading file " + fullPath + ":\n  " + e;
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", errorMessage);
                }
                this.textOutput.append("\n" + errorMessage);
                if (popupError) {
                    JOptionPane.showMessageDialog(null, errorMessage, "Jess File Evaluation Error", 2);
                }
                return false;
            }
        }
        return this.parse(rdr, fullPath, removeBuggyRules, popupError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse(Reader rdr, String fullPath, boolean removeBuggyRules, boolean popupError) {
        try {
            String fileParseMsg = "\nReading " + Utils.getBaseName(fullPath, false) + " (" + fullPath + ")";
            if (trace.getDebugCode("mt")) {
                trace.out("mt", fileParseMsg);
            }
            this.textOutput.append(fileParseMsg);
            Value lastV = this.parse(rdr, removeBuggyRules);
            boolean bl = true;
            return bl;
        }
        catch (JessException je) {
            je.printStackTrace();
            String errorMessage = "Error parsing file " + fullPath + " at line " + je.getLineNumber() + ":\n" + (je.getDetail() == null ? "" : je.getDetail() + ". ") + (je.getData() == null ? "" : je.getData());
            if (trace.getDebugCode("mt")) {
                trace.out("mt", errorMessage);
            }
            this.textOutput.append("\nError parsing file " + fullPath + ":\n  " + (Object)((Object)je) + "\n");
            if (popupError) {
                JOptionPane.showMessageDialog(null, errorMessage, "Jess File Evaluation Error", 2);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            String errorMessage = "Error parsing file " + fullPath + ":\n  " + e;
            if (trace.getDebugCode("mt")) {
                trace.out("mt", errorMessage);
            }
            this.textOutput.append("\n" + errorMessage);
            if (popupError) {
                JOptionPane.showMessageDialog(null, errorMessage, "Jess File Evaluation Error", 2);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Value parse(Reader rdr, boolean removeBuggyRules) throws JessException {
        UID uid = new UID();
        if (!(rdr instanceof BufferedReader) && !(rdr instanceof StringReader)) {
            rdr = new BufferedReader(rdr);
        }
        Jesp jesp = new Jesp(rdr, (Rete)this);
        Value result = jesp.parse(false, this.getGlobalContext());
        return result;
    }

    @Override
    public List getAgendaAsList(Activation stopAct) {
        ArrayList<Activation> result = new ArrayList<Activation>();
        int i = 0;
        Iterator it = this.listActivations();
        while (it.hasNext()) {
            Activation act = (Activation)it.next();
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "agenda[" + i + "]= " + (act.isInactive() ? "IN " : "AC ") + act);
            }
            if (stopAct != null && stopAct == act) break;
            result.add(act);
            ++i;
        }
        return result;
    }

    @Override
    public void dumpAgenda(String label) {
        this.dumpAgenda("mt", label, false);
    }

    @Override
    public void dumpAgenda(String debugCode, String label, boolean verbose) {
        if (debugCode == null) {
            return;
        }
        boolean err = "err".equals(debugCode);
        if (!err && !trace.getDebugCode(debugCode)) {
            return;
        }
        StringBuffer sb = new StringBuffer(label == null ? "dumpAgenda()" : label);
        sb.append(":");
        Iterator it = this.listActivations();
        int i = 0;
        while (it.hasNext()) {
            Activation a = (Activation)it.next();
            sb.append("\n ");
            if (i < 10) {
                sb.append(" ");
            }
            sb.append(i).append(".");
            sb.append(a.isInactive() ? "IN " : "AC ");
            if (!verbose) {
                sb.append(a.toString());
            } else {
                sb.append('[').append(a.getRule() == null ? "(null rule)" : a.getRule().getName());
                sb.append(' ').append(a.getToken() == null ? "(null token)" : a.getToken().toString());
                sb.append("; salience ").append(a.getSalience()).append(']');
            }
            ++i;
        }
        sb.append(" <").append(this.getClass().getName()).append(".dumpAgenda>");
        if (err) {
            trace.err(sb.toString());
        } else {
            trace.out(debugCode, sb.toString());
        }
    }

    @Override
    public void setActivationToFire(Activation act) {
        Strategy s = this.getStrategy();
        if (!(s instanceof ConflictResolutionStrategy)) {
            return;
        }
        ((ConflictResolutionStrategy)s).setActToFire(act, this);
        try {
            this.setStrategy(s);
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "setActivationToFire() a[" + SimStRete.getActivationIndex(act, this) + "]: " + act);
            }
        }
        catch (JessException je) {
            je.printStackTrace();
        }
    }

    public static int getActivationIndex(Activation act, Rete rete) {
        if (act == null) {
            return -2;
        }
        int result = 0;
        Iterator it = rete.listActivations();
        while (it.hasNext()) {
            if (act.equals(it.next())) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    private Vector getChildren(Fact f) {
        String ne = f.getName().toString().replace("MAIN::", "");
        Vector childs = new Vector();
        try {
            childs = this.getWmeChildSlots(ne);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return childs;
    }

    boolean hasSlotValue(Fact f) {
        boolean returnValue = true;
        Deftemplate factTemplate = f.getDeftemplate();
        if (factTemplate.getSlotIndex("value") < 0) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean loadWMEStructureFromFile(String structureFilePath) {
        String curLine;
        BufferedReader reader;
        File file = new File(structureFilePath);
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        boolean loadStructure = true;
        boolean loadTerminals = false;
        boolean loadIgnore = false;
        Pattern whitespace = Pattern.compile("\\s+");
        do {
            try {
                curLine = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (curLine == null) break;
            if (curLine.startsWith(";;") || whitespace.matcher(curLine).matches() || curLine.equals("")) continue;
            if ((curLine = curLine.trim()).startsWith("-")) {
                if (loadStructure) {
                    loadStructure = false;
                    loadTerminals = true;
                    continue;
                }
                if (!loadTerminals) continue;
                loadTerminals = false;
                loadIgnore = true;
                continue;
            }
            if (!loadStructure) continue;
            String[] contents = whitespace.split(curLine);
            String parent = contents[0].replace("MAIN::", "");
            Vector<String> children = new Vector<String>();
            if (contents[1].contains(",")) {
                String[] tmp = contents[1].split(",");
                Collections.addAll(children, tmp);
            } else {
                children.add(contents[1]);
            }
            this.wmeChildSlots.put(parent, children);
        } while (curLine != null);
        return true;
    }

    protected boolean isParent(Fact currentFact, Fact testFact) throws JessException {
        String multislotName = this.getMultislotName(testFact);
        Deftemplate template = currentFact.getDeftemplate();
        int numberSlots = template.getNSlots();
        for (int i = 0; i < numberSlots; ++i) {
            if (!template.getSlotName(i).equals(multislotName)) continue;
            return true;
        }
        return false;
    }

    protected String getMultislotName(Fact fact) {
        String ret = fact.getName();
        String ret2 = ret.replace("MAIN::", "") + "s";
        return ret2;
    }

    protected Fact getFactParent(Fact fact) throws JessException {
        Iterator iter = this.listFacts();
        while (iter.hasNext()) {
            Fact curFact = (Fact)iter.next();
            if (!this.isParent(curFact, fact)) continue;
            Value tableValues = curFact.getSlotValue(this.getMultislotName(fact));
            ValueVector tables = tableValues.listValue(this.getGlobalContext());
            for (int i = 0; i < tables.size(); ++i) {
                Fact tmpTable = tables.get(i).factValue(this.getGlobalContext());
                if (!tmpTable.getSlotValue("name").equals(fact.getSlotValue("name"))) continue;
                return curFact;
            }
        }
        return null;
    }

    @Override
    public void updateChunkValues(String selection, String input) {
        if (this.wmeChildSlots.isEmpty()) {
            this.loadWMEStructureFromFile("wmeStructure.txt");
        }
        try {
            this.updateParentChunkfromFact(this.getFactByName(selection), input);
        }
        catch (JessException e) {
            e.printStackTrace();
        }
    }

    public static boolean isList(String value) {
        return value.contains(",");
    }

    private static Vector<String> parseChunk(String value) {
        Vector<String> returnVector = new Vector<String>();
        String token = "";
        int depth = 0;
        for (char c : value.toCharArray()) {
            if (c == '[') {
                ++depth;
                token = token + c;
                continue;
            }
            if (c == ']') {
                token = token + c;
                --depth;
                continue;
            }
            if (c == ',' && depth == 0) {
                returnVector.add(token);
                token = "";
                continue;
            }
            token = token + c;
        }
        returnVector.add(token);
        return returnVector;
    }

    public static boolean isNilVal(String value) {
        boolean returnVal = true;
        if (value.charAt(0) == '[') {
            if (value.charAt(value.length() - 1) != ']') {
                trace.err("an improper wme chunk was detected ");
                new Exception().printStackTrace();
            } else {
                value = value.substring(1, value.length() - 1);
            }
        }
        Vector<String> chunks = SimStRete.parseChunk(value);
        for (String chunk : chunks) {
            if (SimStRete.isList(chunk)) {
                if (SimStRete.isNilVal(chunk)) continue;
                returnVal = false;
                break;
            }
            if (chunk.equals("nil")) continue;
            returnVal = false;
            break;
        }
        return returnVal;
    }

    public String nilValue(String wmeName) {
        Fact fact = this.getFactByName(wmeName);
        String value = "";
        try {
            value = fact.getSlotValue("value").toString();
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        String pattern = "(\\d)|(nil$)";
        String returnValue = value.replaceAll(pattern, "nil");
        if (!returnValue.contains("nil") || returnValue.contains("nilnil")) {
            returnValue = "nil";
        }
        return returnValue;
    }

    private String getNewFactValue(Fact f, String otherFactName, String oldValue) throws JessException {
        Vector childs = this.getChildren(f);
        String newValue = "";
        for (int e = 0; e < childs.size(); ++e) {
            Value v = f.getSlotValue((String)childs.get(e));
            ValueVector vv = v.listValue(this.getGlobalContext());
            for (int i = 0; i < vv.size(); ++i) {
                Fact tmpvv = vv.get(i).factValue(this.getGlobalContext());
                if (tmpvv.getSlotValue("name").equals((Object)otherFactName)) {
                    newValue = newValue + oldValue;
                } else {
                    newValue = newValue + tmpvv.getSlotValue("value").toString() + ",";
                    newValue = newValue.substring(0, newValue.length() - 1);
                }
                newValue = newValue + ",";
            }
        }
        newValue = newValue.substring(0, newValue.length() - 1);
        newValue = newValue.replace("\"", "");
        return newValue;
    }

    protected void updateParentChunkfromFact(Fact f1, String value) throws JessException {
        Fact f = this.getFactParent(f1);
        if (f == null) {
            return;
        }
        String newValue = "";
        if (this.hasSlotValue(f)) {
            newValue = "[" + this.getNewFactValue(f, f1.getSlotValue("name").toString(), value) + "]";
            Value iv = SimStRete.stringToValue(newValue);
            this.modify(f, "value", iv);
        } else {
            newValue = this.getNewFactValue(f, f1.getSlotValue("name").toString(), value);
        }
        this.updateParentChunkfromFact(f, newValue);
    }

    public static class ConflictResolutionStrategy
    implements Strategy,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Strategy oldStrategy = null;
        private Activation actToFire = null;
        private Activation cachedActToFire = null;
        private int cacheUse;

        private void setActToFire(Activation act, Rete r) {
            this.actToFire = act;
            this.cachedActToFire = null;
            this.cacheUse = 0;
        }

        private static Strategy setStrategy(Rete r) {
            Strategy oldStrategy = null;
            try {
                oldStrategy = r.getStrategy();
                ConflictResolutionStrategy crs = new ConflictResolutionStrategy();
                crs.oldStrategy = oldStrategy;
                r.setStrategy((Strategy)crs);
                return oldStrategy;
            }
            catch (JessException e) {
                e.printStackTrace();
                return oldStrategy;
            }
        }

        public int compare(Activation arg0, Activation arg1) {
            int result = 0;
            Defrule r0 = arg0.getRule();
            Defrule r1 = arg1.getRule();
            if (this.cachedActToFire != null) {
                ++this.cacheUse;
                if (arg0 == this.cachedActToFire) {
                    result = -1;
                } else if (arg1 == this.cachedActToFire) {
                    result = 1;
                }
            } else if (this.actToFire != null) {
                if (arg0.equals((Object)this.actToFire)) {
                    this.cachedActToFire = arg0;
                    result = -1;
                } else if (arg1 == this.actToFire) {
                    this.cachedActToFire = arg1;
                    result = 1;
                }
            }
            if (result == 0) {
                result = this.oldStrategy.compare(arg0, arg1);
            }
            return result;
        }

        public String getName() {
            return "conflict-resolution-strategy";
        }
    }
}

