/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.trace;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.JessToken;
import jess.ReaderTokenizer;
import jess.Value;
import jess.ValueVector;

public class Utils {
    private static final Pattern notSymbol = Pattern.compile("[~`!@%^&(){}|\\\"':;\"',]|\\s|\\[|\\]");

    public static Object jessValueToJava(Value jessVal, Context context) throws JessException {
        Object result;
        if (jessVal == null) {
            result = null;
        } else if (jessVal.isLexeme(context)) {
            result = jessVal.type() == 1 && jessVal.isNumeric(context) ? Double.valueOf(jessVal.floatValue(context)) : jessVal.stringValue(context);
        } else if (jessVal.isNumeric(context)) {
            result = jessVal.type() == 4 ? (Number)jessVal.intValue(context) : (Number)jessVal.floatValue(context);
        } else if (jessVal.type() == 2048) {
            result = jessVal.javaObjectValue(context);
        } else if (jessVal.type() == 0) {
            result = null;
        } else if (jessVal.type() == 512) {
            result = new ArrayList();
            ValueVector vv = jessVal.listValue(context);
            for (int i = 0; i < vv.size(); ++i) {
                ((List)result).add(Utils.jessValueToJava(vv.get(i), context));
            }
        } else {
            result = jessVal.resolveValue(context).toString();
        }
        return result;
    }

    public static String escapeString(String s) {
        return Utils.escapeString(s, false);
    }

    public static String escapeString(String s, boolean coerceSymbolsToStrings) {
        int ruType = -1;
        try {
            ruType = Utils.getJessType(s, null);
        }
        catch (JessException je) {
            trace.err("exception from getJessType shouldn't happen on null Value[]: " + (Object)((Object)je));
            je.printStackTrace();
            return s;
        }
        switch (ruType) {
            case 0: {
                return "nil";
            }
            case 1: 
            case 4: 
            case 32: 
            case 65536: {
                if (coerceSymbolsToStrings) break;
                return s;
            }
        }
        if (s.length() <= 0) {
            return "\"\"";
        }
        StringBuffer result = new StringBuffer("\"");
        StringTokenizer tkzr = new StringTokenizer(s, "\"\\", true);
        block10: while (tkzr.hasMoreTokens()) {
            String tkn = tkzr.nextToken();
            if (tkn.length() > 1) {
                result.append(tkn);
                continue;
            }
            switch (tkn.charAt(0)) {
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block10;
                }
            }
            result.append(tkn);
        }
        result.append("\"");
        return result.toString();
    }

    public static int getJessType(String s, Value[] v) throws JessException {
        return Utils.getJessType(s, v, false);
    }

    public static int getJessType(String s, Value[] v, boolean coerceSymbolsToStrings) throws JessException {
        if (s == null) {
            if (v != null) {
                v[0] = Funcall.NIL;
            }
            return 0;
        }
        if (s.length() <= 0) {
            if (v != null) {
                v[0] = new Value("", 2);
            }
            return 2;
        }
        try {
            int i = Integer.parseInt(s);
            if (v != null) {
                v[0] = new Value(i, 4);
            }
            return 4;
        }
        catch (NumberFormatException i) {
            try {
                long el = Long.parseLong(s);
                if (v != null) {
                    v[0] = new Value((double)el, 65536);
                }
                return 65536;
            }
            catch (NumberFormatException el) {
                try {
                    double d = Double.parseDouble(s);
                    if (v != null) {
                        v[0] = new Value(d, 32);
                    }
                    return 32;
                }
                catch (NumberFormatException d) {
                    if (!coerceSymbolsToStrings) {
                        try {
                            Matcher m = notSymbol.matcher(s);
                            if (!m.find() && Utils.countTokens(s) < 2) {
                                if (v != null) {
                                    v[0] = new Value(s, 1);
                                }
                                return 1;
                            }
                        }
                        catch (JessException je) {
                            trace.err("WMEEditor.getJessType(" + s + ") error matching symbol: " + (Object)((Object)je) + (je.getCause() == null ? "" : "; cause " + je.getCause()));
                        }
                    }
                    if (v != null) {
                        v[0] = new Value(s, 2);
                    }
                    return 2;
                }
            }
        }
    }

    static int countTokens(String s) throws JessException {
        ReaderTokenizer tkzr = new ReaderTokenizer((Reader)new StringReader(s), true);
        int result = 0;
        JessToken tk = tkzr.nextToken();
        while (tk != null && !tk.isEOF()) {
            ++result;
            tk = tkzr.nextToken();
        }
        return result;
    }
}

