/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Log.AuthorLogListener;
import edu.cmu.pact.Utilities.EventLogger;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.jess.RuleActivationTree;
import edu.cmu.pact.jess.RulePrinter;
import edu.cmu.pact.jess.VBNTableModel;
import edu.cmu.pact.jess.VariableBindingNode;
import edu.cmu.pact.jess.WMEEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import jess.Activation;
import jess.ConditionalElement;
import jess.Context;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.Group;
import jess.JessException;
import jess.PrettyPrinter;
import jess.RU;
import jess.Rete;
import jess.Test1;
import jess.Token;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import jess.Visitable;

public class WhyNot
extends JFrame
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1334042918027485168L;
    private static final String REQUIRED_VALUE_WAS = ", the required value was ";
    private static final String FOR_THE_VARIABLE_OR_EXPRESSION = "For the variable or expression ";
    private static final String ALL_VARIABLES_BOUND_SUCCESSFULLY = "LHS matched.";
    JTextArea ruleDisplay;
    JLabel summary;
    JTable varTable;
    JTable saiTable;
    JList instList;
    Vector saiColumnNames;
    Vector filters;
    Vector newFilter;
    Box filterBox;
    JScrollPane filterScroll;
    Color[] colors;
    String ruleName;
    Defrule rule;
    ArrayList facts;
    ArrayList vMap = new ArrayList();
    ArrayList factsForPatterns = new ArrayList();
    ArrayList patterns = new ArrayList();
    ArrayList currentValues = new ArrayList();
    ArrayList conditionalList = new ArrayList();
    Stack open = new Stack();
    Context context;
    JTextArea textArea;
    Vector reqSAI;
    Vector actualSAI;
    Vector nodeSAI;
    ArrayList resultsList = new ArrayList();
    ArrayList summaries = new ArrayList();
    ArrayList resultsListFiltered = new ArrayList();
    ArrayList summaryListFiltered = new ArrayList();
    VBNTableModel vbnTableModel;
    int errorRow = -1;
    int mouseOverRow = -1;
    ArrayList index_depthList = new ArrayList();
    ArrayList index_varsList = new ArrayList();
    MTRete rete;
    static String SUCCESS = "SUCCESSFUL MATCH OF THE LHS OF THE RULE";
    static String FAILURE = "FAILED TO SUCCESSFULLY MATCH THE LHS OF THE RULE";
    boolean stopWhyNot = false;
    boolean showFull = true;
    private List analysisErrors = new LinkedList();
    private RulePrinter rulePrinter = null;
    RuleAgenda ruleAgenda = new RuleAgenda(null, null);
    private EventLogger eventLogger;
    private String mouseOverHighlightedVarName = null;
    private Highlighter.Highlight mouseOverHighlight = null;
    public static final String FILTER_REMOVE = "FILTER_REMOVE";
    public static final String FILTER_APPLY = "FILTER_APPLY";
    public static final String FILTER_VALUE = "FILTER_VALUE";
    public static final String FILTER_VARIABLE = "FILTER_VARIABLE";
    public static final String INSTANTIATION_INDEX = "INSTANTIATION_INDEX";
    public static final String CLOSE = "CLOSE";
    public static final String INSPECT_PARTIAL_ACTIVITION = "INSPECT_PARTIAL_ACTIVITION";

    public Defrule getRule() {
        return this.rule;
    }

    public VBNTableModel getVbnTableModel() {
        return this.vbnTableModel;
    }

    public WhyNot(String defruleName, ArrayList facts, Map defrulesMap, EventLogger eventLogger) {
        super("Why not?: " + defruleName);
        this.ruleName = defruleName;
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "WhyNot(" + defruleName + ") before cloneFactsList(): " + facts);
        }
        this.facts = facts;
        this.eventLogger = eventLogger;
        this.rule = (Defrule)defrulesMap.get(defruleName);
        Image image = new ImageIcon("ctaticon.png").getImage();
        if (image != null && image.getHeight(null) != -1) {
            this.setIconImage(image);
        }
        this.stopWhyNot = false;
        this.colors = new Color[8];
        this.colors[0] = new Color(226, 229, 159);
        this.colors[1] = new Color(223, 212, 219);
        this.colors[2] = new Color(249, 223, 121);
        this.colors[3] = new Color(204, 229, 162);
        this.colors[4] = new Color(167, 230, 196);
        this.colors[5] = new Color(189, 208, 238);
        this.colors[6] = new Color(228, 210, 231);
        this.colors[7] = new Color(235, 198, 211);
        this.addWindowListener(new AuthorLogListener(this.getEventLogger()));
    }

    public static WhyNot makeWhyNot(RuleActivationNode ran, MTRete mtRete, BR_Controller brController) {
        MTRete wnRete = new MTRete(brController.getEventLogger(), null);
        String errMsg = null;
        errMsg = !ran.isRoot() || ran.getChildCount() > 0 ? ran.loadPriorState(wnRete) : RuleActivationTree.copyRete(mtRete, wnRete);
        ArrayList currentState = new ArrayList();
        Iterator fi = wnRete.listFacts();
        while (fi.hasNext()) {
            currentState.add(fi.next());
        }
        String rule = ran.getName();
        WhyNot wn = new WhyNot(rule, currentState, wnRete.allRulesMap(), wnRete.getEventLogger());
        Vector reqSAI = brController.getRuleActivationTree().getReqSAI(ran, true);
        Vector actualSAI = brController.getRuleActivationTree().getActualSAI(ran, true, rule);
        wn.setReqSAI(reqSAI);
        wn.setNodeSAI(actualSAI);
        wn.setRete(wnRete);
        MT mt = brController.getModelTracer().getRete().getMT();
        WMEEditor wmeeditor = new WMEEditor(wnRete, mt, null, true, true);
        wn.reasonOut(wmeeditor);
        return wn;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void setRete(MTRete r) {
        this.rete = r;
        this.context = r.getGlobalContext();
        this.ruleAgenda = new RuleAgenda(r, this.ruleName);
    }

    public void setShowFull(boolean _sf) {
        this.showFull = _sf;
    }

    public void doPreprocessing() {
        this.getPatterns(this.rule);
        Iterator it = this.patterns.iterator();
        this.getVariables(this.rule);
        while (it.hasNext()) {
            this.factsForPatterns.add(this.factsForPattern(((jess.Pattern)it.next()).getName(), this.facts));
        }
    }

    public void getRuleInstantiations(VariableBindingNode vbn, ArrayList tempList) {
        int newStackDepth;
        Stack localOpen = new Stack();
        int patternIndex = vbn.getDepth();
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "instantiations for " + vbn.dump());
        }
        boolean[] wasPattern = new boolean[]{false};
        if (tempList == null) {
            tempList = new ArrayList((ArrayList)this.factsForPatterns.get(patternIndex));
        }
        int oldStackDepth = localOpen.size();
        int n = this.getVariableValues(vbn, tempList, localOpen, wasPattern);
        if (n != (newStackDepth = localOpen.size()) - oldStackDepth && trace.getDebugCode("mt")) {
            trace.outNT("mt", "getVariableValues(" + vbn.dump() + "," + tempList + "," + localOpen + ") returns n=" + n + " while stackDepthDiff=" + (newStackDepth - oldStackDepth));
        }
        if ((n = newStackDepth - oldStackDepth) <= 0) {
            return;
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "getVariableValues() rtns n " + n + ", stack depth " + localOpen.size() + ", currentValues size " + (this.currentValues == null ? "(null)" : Integer.toString(this.currentValues.size())));
        }
        while (!localOpen.empty() && !this.stopWhyNot) {
            for (int j = 0; j < n; ++j) {
                TestResult testResult = (TestResult)localOpen.pop();
                int nVars = 0;
                boolean assignOk = true;
                if (testResult.isList()) {
                    List multiVar = testResult.vbnList;
                    Iterator it = multiVar.iterator();
                    while (assignOk && it.hasNext()) {
                        assignOk = this.assignCurrentValue((VariableBindingNode)it.next());
                    }
                    nVars = multiVar.size();
                } else {
                    vbn = testResult.vbn;
                    if (trace.getDebugCode("mt")) {
                        trace.outNT("mt", "wasPattern " + wasPattern[0] + ", localOpen.pop(" + j + ") gets vbn " + vbn.dump());
                    }
                    assignOk = this.assignCurrentValue(vbn);
                    nVars = 1;
                }
                if (!assignOk) continue;
                this.advanceOrEndInstantiation(vbn, nVars, patternIndex, new ArrayList(testResult.factList));
            }
        }
    }

    private boolean assignCurrentValue(VariableBindingNode vbn) {
        int i = this.containsVariable(0, this.currentValues, vbn.getVariableName());
        if (i != -1) {
            VariableBindingNode oldVbn = (VariableBindingNode)this.currentValues.get(i);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "pop() replaces currentValues[" + i + "] oldVbn " + oldVbn.dump());
            }
            this.currentValues.remove(i);
            this.currentValues.add(i, vbn);
        } else {
            this.currentValues.add(vbn);
        }
        if (vbn.getVariableType() == 2 || vbn.getVariableType() == 3 || vbn.isVariableReference()) {
            return true;
        }
        try {
            String vbnName = vbn.getExtVariableName();
            Value vbnVal = vbn.getVariableValue();
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "assignCurrentValue: about to setVariable(" + vbnName + "," + vbnVal + ")");
            }
            this.context.setVariable(vbnName, vbnVal);
            return true;
        }
        catch (JessException je) {
            String errMsg = "Error setting value of " + vbn.getExtVariableName() + " in Rete";
            this.analysisErrors.add(errMsg + ": " + (Object)((Object)je));
            System.err.println(errMsg + "; vbn " + vbn.dump());
            je.printStackTrace();
            return false;
        }
    }

    private void advanceOrEndInstantiation(VariableBindingNode vbn, int n, int patternIndex, ArrayList tempList) {
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "advanceOrEndInstantiation() n=" + n + "after replace or add currentValues.size() " + (this.currentValues == null ? "(null)" : Integer.toString(this.currentValues.size())));
        }
        ListIterator lit = this.currentValues.listIterator();
        while (lit.hasNext()) {
            if (((VariableBindingNode)lit.next()).getSrNo() <= vbn.getSrNo() + n - 1) continue;
            lit.remove();
        }
        lit = null;
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "after remove vars w/ srNo too high currentValues.size() " + (this.currentValues == null ? "(null)" : Integer.toString(this.currentValues.size())) + ", rtn SUCCESS if vbn.getSrNo " + vbn.getSrNo() + "==vMap.size " + this.vMap.size() + "-1");
        }
        if (vbn.getSrNo() >= this.vMap.size() - 1) {
            this.printRuleInstantiations(-1, null, SUCCESS);
            return;
        }
        int k = vbn.getSrNo() + n;
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "k=" + k + "=vbn.getSrNo()+n " + n + "; recurse if k<vMap.size()=" + this.vMap.size() + " && !(stopWhyNot=" + this.stopWhyNot + "); else SUCCESS");
        }
        if (k < this.vMap.size() && !this.stopWhyNot) {
            vbn = (VariableBindingNode)this.vMap.get(k);
            if (vbn.getDepth() == patternIndex) {
                this.getRuleInstantiations(vbn, tempList);
            } else {
                this.getRuleInstantiations(vbn, null);
            }
        } else {
            this.printRuleInstantiations(-1, null, SUCCESS);
            return;
        }
    }

    public ArrayList factsForPattern(String patternName, ArrayList currentState) {
        ArrayList<Fact> ffp = new ArrayList<Fact>();
        Iterator it = currentState.iterator();
        StringBuffer traceSb = new StringBuffer("factsForPattern " + patternName);
        while (it.hasNext()) {
            Fact fact = (Fact)it.next();
            if (!fact.getName().equals(patternName)) continue;
            ffp.add(fact);
            traceSb.append("\n  ").append(Integer.toString(fact.getFactId()));
            traceSb.append(" ").append(fact.toString());
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", traceSb.toString());
        }
        return ffp;
    }

    public void getPatterns(Defrule rule) {
        System.out.println("getPatterns: rule = " + rule);
        ConditionalElement ce = rule.getConditionalElements();
        this.addPattern(ce);
    }

    public void addPattern(ConditionalElement ce) {
        if (ce.isGroup()) {
            Group group = (Group)ce;
            int size = group.getGroupSize();
            for (int i = 0; i < size; ++i) {
                ConditionalElement conditionalElement = group.getConditionalElement(i);
                this.addPattern(conditionalElement);
            }
        } else {
            this.patterns.add(ce);
        }
    }

    private VariableBindingNode makeVBNforTemplate(jess.Pattern pattern, int patternIndex, ArrayList vMap) {
        VariableBindingNode result = null;
        String boundName = pattern.getBoundName();
        if (boundName != null) {
            VariableBindingNode oldVbn;
            int i = this.containsVariable(0, vMap, boundName);
            VariableBindingNode variableBindingNode = oldVbn = i < 0 ? null : (VariableBindingNode)vMap.get(i);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "makeVBNforTemplate() oldVbn at vMap[" + i + "] " + (oldVbn != null ? oldVbn.dump() : null));
            }
            if (oldVbn == null) {
                VariableBindingNode vbn = new VariableBindingNode(boundName, patternIndex, vMap.size(), -1, -1, 2, 0, 0);
                vMap.add(vbn);
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "new vbn for boundName at vMap[" + (vMap.size() - 1) + "] " + vbn.dump());
                }
                result = vbn;
            }
        }
        try {
            Value testValue;
            Deftemplate dt = pattern.getDeftemplate();
            String templateName = dt != null ? dt.getName() : null;
            String templateBaseName = dt != null ? dt.getBaseName() : null;
            Userfunction uf = this.rete.findUserfunction(templateName);
            Userfunction ubf = this.rete.findUserfunction(templateBaseName);
            String ufName = uf != null ? uf.getName() : null;
            String ubfName = ubf != null ? ubf.getName() : null;
            int s = pattern.getNSlots();
            int t = s > 0 ? pattern.getNTests(0) : -99;
            Test1 test = s > 0 && t > 0 ? pattern.getTest(0, 0) : null;
            Value value = testValue = test != null ? test.getValue() : null;
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "makeVBNforTemplate(): template=" + templateName + " templateBase=" + templateBaseName + " uf=" + ufName + ", ubf=" + ubfName + " NSlots=" + s + ", NTests[0]=" + t + ", test[0,0] " + test + ", valueType " + (testValue != null ? RU.getTypeName((int)testValue.type()) : null));
            }
            if (testValue != null && testValue.type() == 64) {
                return result;
            }
            Value val = new Value(templateName, 2);
            VariableBindingNode vbn = new VariableBindingNode(templateName, patternIndex, vMap.size(), -1, -1, 3, 0, 0);
            vbn.setValue(val);
            vMap.add(vbn);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "makeVBNforTemplate(): new vbn at vMap[" + (vMap.size() - 1) + "] " + vbn.dump());
            }
            result = vbn;
        }
        catch (JessException je) {
            this.analysisErrors.add("Error adding pattern-template test: " + (Object)((Object)je));
        }
        return result;
    }

    public void getVariables(Defrule rule) {
        for (jess.Pattern p : this.patterns) {
            int patternIndex = this.patterns.indexOf(p);
            String patternString = new PrettyPrinter((Visitable)p).toString();
            Deftemplate template = p.getDeftemplate();
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "getVariables() top: p" + patternIndex + ": \"" + patternString + "\", template " + template.getName() + ", NSlots" + p.getNSlots());
            }
            if (template == null) {
                this.analysisErrors.add("Cannot get deftemplate for pattern:\n  " + patternString);
                continue;
            }
            this.makeVBNforTemplate(p, patternIndex, this.vMap);
            for (int j = 0; j < p.getNSlots(); ++j) {
                try {
                    int slotType = template.getSlotType(j) == 16384 ? 0 : 1;
                    if (trace.getDebugCode("mt")) {
                        trace.outNT("mt", "getVariables(): p" + patternIndex + "s" + j + " templateSlotType=" + RU.getTypeName((int)template.getSlotType(j)) + " slotType=" + (slotType == 0 ? "SLOT" : "MULTISLOT") + ", NTests " + p.getNTests(j));
                    }
                    for (int k = 0; k < p.getNTests(j); ++k) {
                        StringBuffer sb;
                        int varType = 4;
                        boolean varIsLocal = false;
                        Test1 test = p.getTest(j, k);
                        int testType = test.getTest();
                        if (trace.getDebugCode("mt")) {
                            trace.outNT("mt", "p" + patternIndex + ",s" + j + ",t" + k + " test \"" + test + "\", testTest=" + testType + " testValue=\"" + test.getValue() + "\" testValueType=" + test.getValue().type() + " slotType=" + (slotType == 16384 ? "SLOT" : "MULTISLOT"));
                        }
                        if (test.getValue().type() != 64) {
                            sb = new StringBuffer(test.getValue().toString());
                            if (sb.charAt(0) == '$') {
                                if (sb.length() > 1 && sb.charAt(1) == '?') {
                                    if (VariableBindingNode.isBlank(sb.toString())) {
                                        varIsLocal = true;
                                    }
                                    sb.delete(0, 2);
                                    varType = 1;
                                } else {
                                    varType = 4;
                                    String err = "Expected \"$?\" but found \"$\" in pattern \"" + patternString + "\"";
                                    this.analysisErrors.add(err);
                                }
                            } else if (sb.charAt(0) == '?') {
                                if (VariableBindingNode.isBlank(sb.toString())) {
                                    varIsLocal = true;
                                }
                                sb.deleteCharAt(0);
                                varType = 0;
                            } else {
                                varType = 2;
                            }
                        } else {
                            varType = 3;
                            sb = new StringBuffer(test.getValue().toString());
                        }
                        if (trace.getDebugCode("mt")) {
                            trace.outNT("mt", "p" + patternIndex + ",s" + j + ",t" + k + " testValueType=" + RU.getTypeName((int)test.getValue().type()) + ", varType=" + varType + ", sb=\"" + sb + "\"");
                        }
                        if (varType == 4) continue;
                        VariableBindingNode varBindingNode = null;
                        if (varType == 2 || varType == 3) {
                            varBindingNode = new VariableBindingNode("LIT_", sb.toString(), patternIndex, this.vMap.size(), j, test.getMultiSlotIndex(), slotType, varType, testType);
                            varBindingNode.setValue(test.getValue());
                            if (varType == 3) {
                                varBindingNode.setTest(test);
                            }
                        } else {
                            int i = this.containsVariable(0, this.vMap, sb.toString());
                            if (i == -1) {
                                varBindingNode = new VariableBindingNode(sb.toString(), patternIndex, this.vMap.size(), j, test.getMultiSlotIndex(), slotType, varType, testType);
                                if (varBindingNode.getVariableValue() != null) {
                                    this.context.setVariable(varBindingNode.getExtVariableName(), varBindingNode.getVariableValue());
                                }
                            } else {
                                varBindingNode = new VariableBindingNode("REF_", sb.toString(), patternIndex, this.vMap.size(), j, test.getMultiSlotIndex(), slotType, varType, testType);
                            }
                        }
                        if (varBindingNode == null) continue;
                        this.vMap.add(varBindingNode);
                        if (!trace.getDebugCode("mt")) continue;
                        trace.outNT("mt", "added vbn at vMap[" + (this.vMap.size() - 1) + "] " + varBindingNode.dump());
                    }
                    continue;
                }
                catch (Exception ex) {
                    this.analysisErrors.add("Error on pattern \"" + patternString + "\": " + ex);
                    ex.printStackTrace();
                }
            }
        }
    }

    private boolean testForFactOnList(VariableBindingNode vbn, List factList) {
        if (factList.isEmpty()) {
            return false;
        }
        Fact fact = null;
        try {
            fact = vbn.getVariableValue().factValue(this.context);
        }
        catch (JessException je) {
            String errMsg = "Error testing variable " + vbn.getExtVariableName() + ", cannot retrieve value: " + (Object)((Object)je);
            this.analysisErrors.add(errMsg);
            System.err.println("\n" + errMsg + "\n");
            je.printStackTrace();
            return false;
        }
        int fId = fact.getFactId();
        ListIterator lit = factList.listIterator();
        while (lit.hasNext()) {
            Fact factFromList = (Fact)lit.next();
            if (factFromList.getFactId() == fId) continue;
            lit.remove();
        }
        return factList.size() > 0;
    }

    public int getVariableValues(VariableBindingNode vbn, ArrayList factList, Stack localOpen, boolean[] wasPattern) {
        String boundName;
        int n = 0;
        wasPattern[0] = false;
        ArrayList tempList = factList;
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "tempList or depth " + vbn.getDepth() + " at top of getVariableValues:\n" + tempList);
        }
        int patternIndex = vbn.getDepth();
        jess.Pattern p = (jess.Pattern)this.patterns.get(patternIndex);
        String patternName = p.getName();
        Deftemplate patternTemplate = p.getDeftemplate();
        boolean mathFact = false;
        if ("MAIN::MATHFACT".equals(patternName)) {
            mathFact = true;
        }
        int lastSlot = vbn.getSlotIndex();
        if (mathFact) {
            lastSlot = p.getNSlots();
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "getVariableValues() top for vbn " + vbn.dump() + " on p" + patternIndex + " " + patternName + ", template " + (patternTemplate == null ? "(null)" : patternTemplate.getName()) + ", lastSlot" + lastSlot + ", tempList.size() " + tempList.size());
        }
        if ((boundName = p.getBoundName()) != null) {
            int h = this.containsVariable(0, this.currentValues, boundName);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "boundName " + boundName + " at h=" + h + " in currentValues");
            }
            if (h != -1) {
                VariableBindingNode v = (VariableBindingNode)this.currentValues.get(h);
                Value currentVal = v.getVariableValue();
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "boundName varBN " + v.dump() + " currentVal.type() " + RU.getTypeName((int)currentVal.type()));
                }
                if (currentVal.type() == 16) {
                    if (!this.testForFactOnList(v, tempList)) {
                        String diagMsg = "?" + boundName + " is not bound to a fact of the proper type";
                        if (patternTemplate != null) {
                            diagMsg = "?" + boundName + " is not bound to a fact of type " + patternTemplate.getName();
                        }
                        this.printRuleInstantiations(patternIndex, diagMsg, FAILURE);
                        return 0;
                    }
                } else {
                    this.printRuleInstantiations(patternIndex, "?" + boundName + " is not bound to a fact", FAILURE);
                }
            }
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "tempList after bound-name:\n  " + tempList);
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "tempList after doTest()s " + tempList);
        }
        if (vbn.getVariableType() == 3) {
            boolean testResult = this.doTest(vbn.getTest(), this.context);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "getVariableValues() pattern " + p + " FUNCALL vbn " + vbn.dump() + " test result " + testResult);
            }
            if (!testResult || this.stopWhyNot) {
                VariableBindingNode newVbn = new VariableBindingNode(vbn);
                newVbn.setValue(Funcall.FALSE);
                this.currentValues.add(newVbn);
                this.printRuleInstantiations(patternIndex, vbn.getExtVariableName() + " did not return TRUE", FAILURE);
                this.currentValues.remove(newVbn);
                return 0;
            }
            VariableBindingNode newVbn = new VariableBindingNode(vbn);
            newVbn.setValue(Funcall.TRUE);
            n = 1;
            localOpen.push(new TestResult(newVbn, (List)tempList));
        } else {
            if (tempList.isEmpty()) {
                this.printRuleInstantiations(patternIndex, "no facts match", FAILURE);
                return 0;
            }
            if (vbn.getSlotType() == 3) {
                this.testPatternTemplate(patternIndex, vbn, localOpen, tempList, n);
                if (tempList.isEmpty()) {
                    this.printRuleInstantiations(patternIndex, "no facts of type " + vbn.getVariableName(), FAILURE);
                    return 0;
                }
                n = 1;
                VariableBindingNode newVbn = new VariableBindingNode(vbn);
                n = this.pushInstancePerFact(vbn, localOpen, tempList);
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "tempList size after testPatternTemplate " + tempList.size());
                }
            } else if (vbn.isVariableReference()) {
                this.testVariableReference(patternIndex, vbn, localOpen, tempList, n);
                if (tempList.isEmpty()) {
                    return 0;
                }
                n = 1;
                VariableBindingNode newVbn = new VariableBindingNode(vbn);
                newVbn.setVariableType(2);
                n = this.pushInstancePerFact(vbn, localOpen, tempList);
            } else if (vbn.getVariableType() == 2 && vbn.getSlotType() != 1) {
                this.testLiteral(patternIndex, vbn, localOpen, tempList, n);
                if (tempList.isEmpty()) {
                    return 0;
                }
                VariableBindingNode newVbn = new VariableBindingNode(vbn);
                newVbn.setVariableType(2);
                n = this.pushInstancePerFact(vbn, localOpen, tempList);
            } else {
                for (int i = 0; i < tempList.size() && !this.stopWhyNot; ++i) {
                    try {
                        Fact fact = (Fact)tempList.get(i);
                        String templateName = fact.getDeftemplate().getName();
                        if (trace.getDebugCode("mt")) {
                            trace.outNT("mt", "tempList[" + i + "] template " + templateName + " NSlots " + fact.getDeftemplate().getNSlots() + " vbn.SlotIndex " + vbn.getSlotIndex());
                        }
                        if (vbn.getSlotType() == 2) {
                            n = this.testPatternBinding(patternIndex, vbn, localOpen, fact, n);
                            continue;
                        }
                        if (fact.getDeftemplate().getNSlots() <= vbn.getSlotIndex()) {
                            this.printRuleInstantiations(patternIndex, "error binding variable", FAILURE);
                            return n;
                        }
                        String slotName = fact.getDeftemplate().getSlotName(vbn.getSlotIndex());
                        Value val = fact.getSlotValue(slotName);
                        if (trace.getDebugCode("mt")) {
                            trace.outNT("mt", "tempList[" + i + "] slot " + slotName + " val " + val + " vbn" + vbn.dump());
                        }
                        if (vbn.getSlotType() == 1) {
                            n = this.bindMultislotPattern(val, vbn, localOpen, fact, slotName);
                            wasPattern[0] = true;
                            if (!trace.getDebugCode("mt")) continue;
                            trace.outNT("mt", "match_pattern()=>" + n);
                            continue;
                        }
                        if (vbn.getVariableType() != 0) continue;
                        ++n;
                        VariableBindingNode newVbn = new VariableBindingNode(vbn);
                        newVbn.setValue(val);
                        if (val != null) {
                            this.context.setVariable(newVbn.getExtVariableName(), val);
                        }
                        localOpen.push(new TestResult(newVbn, fact));
                        if (!trace.getDebugCode("mt")) continue;
                        trace.outNT("mt", "MATCHES_SINGLE n " + n + ", var " + newVbn.getVariableName() + ", val" + val);
                        continue;
                    }
                    catch (Exception ex) {
                        this.analysisErrors.add("Error setting variables on pattern " + patternName + ": " + ex);
                        ex.printStackTrace();
                    }
                }
            }
        }
        return n;
    }

    private int pushInstancePerFact(VariableBindingNode vbn, Stack localOpen, List factList) {
        int n = 0;
        Iterator it = factList.iterator();
        while (it.hasNext()) {
            VariableBindingNode newVbn = new VariableBindingNode(vbn);
            localOpen.push(new TestResult(newVbn, (Fact)it.next()));
            ++n;
        }
        return n;
    }

    private int testLiteral(int patternIndex, VariableBindingNode vbn, Stack localOpen, List factList, int n) {
        try {
            Value vVal = vbn.getVariableValue();
            if (vVal == null) {
                throw new Exception("literal's value was null");
            }
            ListIterator lit = factList.listIterator();
            while (lit.hasNext()) {
                VariableBindingNode newVbn;
                Fact fact = (Fact)lit.next();
                Deftemplate dt = fact.getDeftemplate();
                String slotName = dt != null ? dt.getSlotName(vbn.getSlotIndex()) : "";
                Value fVal = fact.getSlotValue(slotName);
                Value rfVal = fact.getSlotValue(slotName).resolveValue(this.context);
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "testLiteral n=" + n + ", fact " + fact + " slot " + slotName + " fVal " + fVal + " rfVal " + rfVal + " var " + vbn.dump());
                }
                if (vbn.getTestType() == 0) {
                    if (!vVal.equals(fVal)) {
                        lit.remove();
                        newVbn = new VariableBindingNode(vbn);
                        this.currentValues.add(newVbn);
                        this.printRuleInstantiations(patternIndex, "failed to match literal " + vVal, FAILURE);
                        this.currentValues.remove(newVbn);
                        continue;
                    }
                    if (!trace.getDebugCode("mt")) continue;
                    trace.outNT("mt", "match LITERAL EQ n " + n + ", var " + vbn.dump() + ", val" + fVal);
                    continue;
                }
                if (vbn.getTestType() != 1) continue;
                if (vVal.equals(fVal)) {
                    lit.remove();
                    newVbn = new VariableBindingNode(vbn);
                    this.currentValues.add(newVbn);
                    this.printRuleInstantiations(patternIndex, "failed on literal test ~" + vVal, FAILURE);
                    this.currentValues.remove(newVbn);
                    continue;
                }
                if (!trace.getDebugCode("mt")) continue;
                trace.outNT("mt", "match LITERAL NEQ n " + n + ", var " + vbn.dump() + ", fVal" + fVal);
            }
            return factList.size();
        }
        catch (Exception e) {
            String errMsg = "In " + this.indexToLineNo(patternIndex) + ": error testing literal \"" + vbn.getVariableValue() + "\": " + e.getMessage();
            this.analysisErrors.add(errMsg);
            System.err.println("\n" + errMsg + "\n for refVbn " + vbn.dump() + "\n");
            factList.clear();
            return 0;
        }
    }

    private int testVariableReference(int patternIndex, VariableBindingNode refVbn, Stack localOpen, List factList, int n) {
        String varName = refVbn.getExtVariableName();
        try {
            int h = this.containsVariable(0, this.currentValues, varName);
            if (h < 0) {
                String errMsg = "Cannot reference variable ?" + varName;
                System.err.println("\n" + errMsg + "\n");
                throw new Exception(errMsg);
            }
            VariableBindingNode vbn = (VariableBindingNode)this.currentValues.get(h);
            Value vVal = vbn.getVariableValue();
            if (vVal == null) {
                throw new Exception("No value for variable ?" + varName + ": value should have been bound already");
            }
            ListIterator lit = factList.listIterator();
            while (lit.hasNext()) {
                VariableBindingNode newVbn;
                Fact fact = (Fact)lit.next();
                Deftemplate dt = fact.getDeftemplate();
                String slotName = dt != null ? dt.getSlotName(vbn.getSlotIndex()) : "";
                Value fVal = fact.getSlotValue(slotName);
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "testVariableReference n=" + n + ", fact " + fact + " slot " + slotName + " fVal " + fVal + " var " + refVbn.dump());
                }
                if (refVbn.getTestType() == 0) {
                    if (!vVal.equals(fVal)) {
                        lit.remove();
                        newVbn = new VariableBindingNode(vbn);
                        newVbn.setValue(vVal);
                        this.currentValues.add(newVbn);
                        this.printRuleInstantiations(patternIndex, "failed to match value of ?" + vbn.getVariableName(), FAILURE);
                        this.currentValues.remove(newVbn);
                        newVbn = null;
                        continue;
                    }
                    if (!trace.getDebugCode("mt")) continue;
                    trace.outNT("mt", "match REF VARIABLE EQ n " + n + ", var " + vbn.dump());
                    continue;
                }
                if (refVbn.getTestType() == 1) {
                    if (vVal.equals(fVal)) {
                        lit.remove();
                        newVbn = new VariableBindingNode(vbn);
                        newVbn.setValue(vVal);
                        this.currentValues.add(newVbn);
                        this.printRuleInstantiations(patternIndex, "failed on test ~?" + vbn.getVariableName(), FAILURE);
                        this.currentValues.remove(newVbn);
                        newVbn = null;
                        continue;
                    }
                    if (!trace.getDebugCode("mt")) continue;
                    trace.outNT("mt", "match REF VARIABLE NEQ n " + n + ", var " + vbn.dump());
                    continue;
                }
                String errMsg = "Unable to interpret test";
                throw new Exception(errMsg);
            }
            return factList.size();
        }
        catch (Exception e) {
            String errMsg = "In " + this.indexToLineNo(patternIndex) + ": error referring to variable ?" + refVbn.getExtVariableName() + ": " + e.getMessage();
            this.analysisErrors.add(errMsg);
            System.err.println("\n" + errMsg + "\n for refVbn " + refVbn.dump() + "\n");
            factList.clear();
            return 0;
        }
    }

    private int testPatternBinding(int patternIndex, VariableBindingNode vbn, Stack localOpen, Fact fact, int n) throws JessException {
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "testPatternBinding(" + patternIndex + "," + vbn.dump() + ",stackSize " + localOpen.size() + "," + fact + "," + n + ")");
        }
        FactIDValue val = new FactIDValue(fact);
        Value currentVal = vbn.getVariableValue();
        VariableBindingNode newVbn = new VariableBindingNode(vbn);
        newVbn.setValue((Value)val);
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "testPatternBinding{newVbn val " + val + ", fact " + val.factValue(this.context) + "}");
        }
        if (currentVal != null) {
            this.currentValues.add(newVbn);
            this.printRuleInstantiations(patternIndex, "?" + vbn.getVariableName() + " should be unbound at start of pattern", FAILURE);
            this.currentValues.remove(newVbn);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "testPatternBinding failure n=" + n + ", vbn " + vbn.dump() + ", val" + val);
            }
            newVbn = null;
        } else {
            ++n;
            localOpen.push(new TestResult(newVbn, fact));
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "testPatternBinding success n=" + n + ", var " + newVbn.getVariableName() + ", val" + val);
            }
        }
        return n;
    }

    private int testPatternTemplate(int patternIndex, VariableBindingNode vbn, Stack localOpen, List factList, int n) {
        Value val = vbn.getVariableValue();
        try {
            String vbnTemplateName = val.stringValue(this.context);
            ListIterator lit = factList.listIterator();
            while (lit.hasNext()) {
                String templateName;
                Fact fact = (Fact)lit.next();
                Deftemplate dt = fact.getDeftemplate();
                String string = templateName = dt != null ? dt.getName() : "";
                if (!templateName.equals(vbnTemplateName)) {
                    lit.remove();
                    if (!trace.getDebugCode("mt")) continue;
                    trace.outNT("mt", "testPatternTemplate: vbn " + vbn.dump() + " removed fact " + fact);
                    continue;
                }
                if (!trace.getDebugCode("mt")) continue;
                trace.outNT("mt", "testPatternTemplate: vbn " + vbn.dump() + " matched fact " + fact);
            }
            return factList.size();
        }
        catch (Exception e) {
            String errMsg = "Internal error testing facts' deftemplate types: " + e;
            this.analysisErrors.add(errMsg);
            System.err.println("\n" + errMsg + "\n");
            factList.clear();
            return 0;
        }
    }

    private String extractVariableName(String varName) {
        if (varName.charAt(0) == '?') {
            int i = this.containsVariable(0, this.currentValues, varName = varName.substring(1));
            if (i != -1) {
                return ((VariableBindingNode)this.currentValues.get(i)).getVariableValue().toString();
            }
            return null;
        }
        if (varName.charAt(0) == '$' && varName.charAt(1) == '?') {
            return null;
        }
        return varName;
    }

    public boolean doTest(Test1 test, Context context) {
        boolean result = false;
        try {
            result = test.doTest(context);
        }
        catch (JessException jessException) {
            // empty catch block
        }
        return result;
    }

    private void printError(String string) {
        this.textArea.append("\n***************************************************************************\n");
        this.textArea.append(string);
        this.textArea.append("\n***************************************************************************\n");
    }

    public int containsVariable(int startIndex, ArrayList<VariableBindingNode> variableList, String name) {
        for (int i = startIndex; i < variableList.size(); ++i) {
            VariableBindingNode vbn = variableList.get(i);
            if (!vbn.getVariableName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void printRuleInstantiations(int patternIndex, String errorDesc, String result) {
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "?print patternIndex=" + patternIndex + ", result=" + result + ", " + errorDesc);
        }
        if (!this.showFull && result.equals(FAILURE)) {
            return;
        }
        jess.Pattern pattern = null;
        StringBuffer outputString = new StringBuffer();
        Object varName = null;
        VBNTableModel vbnTableModel = new VBNTableModel(this, null);
        for (int i = 0; i < this.currentValues.size(); ++i) {
            VariableBindingNode vbn = (VariableBindingNode)this.currentValues.get(i);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "?print currentValues[" + i + "] vbn " + vbn.dump());
            }
            if (vbn.getVariableType() == 2 || vbn.getSlotType() == 3 || vbn.isVariableReference() || vbn.getVariableName().indexOf("_blank_") != -1) continue;
            vbnTableModel.add(vbn);
        }
        boolean start = false;
        boolean end = false;
        boolean found = false;
        int i = 0;
        int j = 0;
        int k = 0;
        for (i = 0; i < this.patterns.size(); ++i) {
            pattern = (jess.Pattern)this.patterns.get(i);
            boolean mathFact = false;
            if (pattern.getName().equals("MAIN::MATHFACT")) {
                mathFact = true;
            }
            String variableName = pattern.getBoundName();
        }
        boolean alreadyListed = false;
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "before duplicate skip: resultsList.size() " + this.resultsList.size());
        }
        if (!alreadyListed && vbnTableModel.getRowCount() > 0) {
            this.resultsList.add(vbnTableModel);
            if (result == SUCCESS) {
                this.summaries.add(ALL_VARIABLES_BOUND_SUCCESSFULLY);
            } else {
                StringBuffer errorSumm = new StringBuffer();
                if (0 <= patternIndex && patternIndex < this.patterns.size()) {
                    errorSumm.append("In " + this.indexToLineNo(patternIndex) + ": ");
                }
                if (errorDesc == null) {
                    errorDesc = "Error matching pattern";
                }
                errorSumm.append(errorDesc).append(".");
                this.summaries.add(errorSumm.toString());
            }
            int[] a = new int[]{this.resultsList.size() - 1, i + j + k};
            this.index_depthList.add(a);
            int[] vl = new int[]{this.resultsList.size() - 1, vbnTableModel.getRowCount()};
            this.index_varsList.add(vl);
        }
    }

    private String indexToLineNo(int i) {
        if (this.rulePrinter == null) {
            this.rulePrinter = new RulePrinter(this.rule);
        }
        return this.rulePrinter.patternIndexToLineNo(i);
    }

    Context getContext() {
        return this.context;
    }

    private VariableBindingNode[] makeMultislotVbnList(jess.Pattern pattern, int slotIndex, VariableBindingNode vbn0) {
        int nTests = pattern.getNTests(slotIndex);
        int vMapIdx = vbn0.getSrNo();
        VariableBindingNode[] result = new VariableBindingNode[nTests];
        int t = 0;
        while (t < nTests) {
            Test1 test = pattern.getTest(slotIndex, t);
            int testType = test.getTest();
            int testValueType = test.getValue().type();
            VariableBindingNode vbn = (VariableBindingNode)this.vMap.get(vMapIdx);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "makeMultislotVbnList s" + slotIndex + ",t" + t + " test \"" + test + "\", testTest=" + testType + " testValue=\"" + test.getValue() + "\" testValueType=" + testValueType + "=" + RU.getTypeName((int)testValueType));
            }
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "vbn " + vbn.dump());
            }
            result[t] = vbn;
            ++t;
            ++vMapIdx;
        }
        return result;
    }

    private int countScalarTests(VariableBindingNode[] vbnArr, ValueVector vv, int patternIndex, String slotName) {
        int result = 0;
        for (int i = 0; i < vbnArr.length; ++i) {
            if (vbnArr[i].getVariableType() == 1) continue;
            ++result;
        }
        if (vv.size() >= result) {
            return result;
        }
        this.printRuleInstantiations(patternIndex, "the fact's multislot " + slotName + " has " + vv.size() + " entries, but the pattern's tests require at least " + result, FAILURE);
        return -1;
    }

    private int assignScalarOrList(ValueVector vv, int start, int end, VariableBindingNode vbn, int patternIdx) throws Exception {
        int v;
        String vName = vbn.getVariableName();
        if (vbn.getVariableType() != 1) {
            if (start >= vv.size() || start >= end) {
                return -1;
            }
            Value newVal = vv.get(start).resolveValue(this.context);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "assignScalarOrList() vbn varName " + vbn.getVariableName() + ", type " + vbn.getTypeOfVariableAsString() + ", isVarRef " + vbn.isVariableReference() + "; newVal " + newVal);
            }
            if (vbn.getVariableType() == 3) {
                String errMsg = "At line " + this.indexToLineNo(patternIdx) + ": Why Not? cannot analyze function calls in multislot patterns";
                this.analysisErrors.add(errMsg);
                trace.err(errMsg);
                return -1;
            }
            if (vbn.getVariableType() == 2) {
                Value litVal = vbn.getVariableValue();
                if (!newVal.equals(litVal)) {
                    return -1;
                }
            } else if (vbn.isVariableReference()) {
                String varName = vbn.getExtVariableName();
                int h = this.containsVariable(0, this.currentValues, varName);
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "assignScalarOrList() isVariableReference: extVfarName " + varName + ", currentValues index h " + h);
                }
                if (h < 0) {
                    String errMsg = "Cannot reference variable ?" + varName;
                    System.err.println("\n" + errMsg + "\n");
                    throw new Exception(errMsg);
                }
                VariableBindingNode refVbn = (VariableBindingNode)this.currentValues.get(h);
                Value vVal = refVbn.getVariableValue();
                if (vVal == null) {
                    throw new Exception("No value for variable ?" + varName + ": value should have been bound already");
                }
                if (!newVal.equals(vVal)) {
                    return -1;
                }
                vbn.setValue(newVal);
            } else {
                vbn.setValue(newVal);
                boolean varName = this.assignCurrentValue(vbn);
            }
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "assignScalarOrList: vbn " + vbn.getVariableName() + " gets newVal " + newVal + " from vv[" + start + "]");
            }
            return start + 1;
        }
        if (end > vv.size()) {
            end = vv.size();
        }
        ValueVector newVv = new ValueVector(end - start);
        for (v = start; v < end; ++v) {
            Value newVal = vv.get(v).resolveValue(this.context);
            newVv.add(newVal);
            if (!trace.getDebugCode("mt")) continue;
            trace.outNT("mt", "assignScalarOrList: vbn " + vbn.getVariableName() + " adds newVal " + newVal + " from vv[" + v + "]");
        }
        Value newListVal = new Value(newVv, 512);
        vbn.setValue(newListVal);
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "assignScalarOrList: vbn " + vbn.getVariableName() + " list length " + newVv.size());
        }
        return v;
    }

    private boolean doScalarTests(MultislotMatch mm, List valList) {
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "doScalarTests top: mm " + mm.dump());
        }
        VariableBindingNode vbn = mm.nextScalarTest();
        while (vbn != null) {
            try {
                vbn = new VariableBindingNode(vbn);
                int vvIdx = this.assignScalarOrList(mm.vv, mm.vvIdx, mm.vvIdx + 1, vbn, mm.patternIdx);
                if (vvIdx < 0) {
                    return false;
                }
                mm.vvIdx = vvIdx;
                --mm.nScalarTests;
                valList.add(vbn);
            }
            catch (Exception e) {
                String errMsg = "Jess error assigning multislot entry to variable at line " + this.indexToLineNo(mm.patternIdx) + ": " + e.toString();
                this.analysisErrors.add(errMsg);
                trace.err(errMsg);
                e.printStackTrace();
                return false;
            }
            vbn = mm.nextScalarTest();
        }
        return true;
    }

    private int doMultiTest(MultislotMatch mm0, List valList0, Stack localOpen) {
        VariableBindingNode vbn = mm0.nextTest();
        if (vbn == null) {
            return 0;
        }
        int maxSize = mm0.vv.size() - mm0.vvIdx - mm0.nScalarTests;
        int minSize = 0;
        if (mm0.getNMultiTestsRemaining() < 1) {
            minSize = maxSize;
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "doMultiTest top: mm0 " + mm0.dump() + ", maxSize " + maxSize + ", minSize " + minSize);
        }
        try {
            int n = 0;
            int size = maxSize;
            while (size >= minSize) {
                MultislotMatch mm = mm0.copy();
                ArrayList<VariableBindingNode> valList = new ArrayList<VariableBindingNode>(valList0);
                int vvIdx = this.assignScalarOrList(mm.vv, mm.vvIdx, mm.vvIdx + size, vbn = new VariableBindingNode(vbn), mm.patternIdx);
                if (vvIdx >= 0) {
                    mm.vvIdx = vvIdx;
                    valList.add(vbn);
                    if (this.doScalarTests(mm, valList)) {
                        if (mm.vbnIdx < mm.vbnArr.length) {
                            this.doMultiTest(mm, valList, localOpen);
                        } else {
                            if (trace.getDebugCode("mt")) {
                                trace.outNT("mt", "doMultiTest to push valList: " + valList);
                            }
                            localOpen.push(new TestResult(valList, mm.fact));
                        }
                    }
                }
                --size;
                ++n;
            }
            return n;
        }
        catch (Exception e) {
            String errMsg = "Error assigning multislot entry to variable at line " + this.indexToLineNo(mm0.patternIdx) + ": " + e.toString();
            this.analysisErrors.add(errMsg);
            trace.err(errMsg);
            e.printStackTrace();
            return 0;
        }
    }

    private int bindMultislotPattern(Value val, VariableBindingNode vbn0, Stack localOpen, Fact fact, String slotName) {
        int oldStackDepth = localOpen.size();
        int slotIndex = vbn0.getSlotIndex();
        String patternString = "(unset)";
        int patternIndex = -1;
        int n = 0;
        VariableBindingNode[] vbnArr = null;
        ArrayList result = new ArrayList();
        int nScalarTests = 0;
        try {
            jess.Pattern pattern = (jess.Pattern)this.patterns.get(vbn0.getDepth());
            patternString = new PrettyPrinter((Visitable)pattern).toString();
            patternIndex = this.patterns.indexOf(pattern);
            vbnArr = this.makeMultislotVbnList(pattern, slotIndex, vbn0);
            ValueVector vv = val.listValue(this.context);
            nScalarTests = this.countScalarTests(vbnArr, vv, patternIndex, slotName);
            if (nScalarTests < 0) {
                return 0;
            }
            MultislotMatch mm = new MultislotMatch(vv, vbnArr, patternIndex, nScalarTests, fact);
            if (!this.doScalarTests(mm, result)) {
                return 0;
            }
            if (mm.vbnIdx < mm.vbnArr.length) {
                int vType = vbnArr[mm.vbnIdx].getVariableType();
                if (vType == 1) {
                    n = this.doMultiTest(mm, result, localOpen);
                    return localOpen.size() - oldStackDepth;
                }
                String errMsg = "Error analyzing multislot pattern at line " + this.indexToLineNo(patternIndex) + ": unexpected test type";
                this.analysisErrors.add(errMsg);
                trace.err(errMsg + " " + vType + ", mm.vbnIdx " + mm.vbnIdx);
                return 0;
            }
            if (mm.vbnIdx < vv.size()) {
                this.printRuleInstantiations(patternIndex, "multislot " + slotName + " has too many elements", FAILURE);
                return 0;
            }
            localOpen.push(new TestResult(result, fact));
            ++n;
            return localOpen.size() - oldStackDepth;
        }
        catch (JessException je) {
            String errMsg = "Jess error analyzing multislot pattern at line " + this.indexToLineNo(patternIndex) + ": " + je.toString();
            this.analysisErrors.add(errMsg);
            trace.err(errMsg);
            je.printStackTrace();
            return 0;
        }
        catch (Exception ex) {
            String errMsg = "Error analyzing multislot pattern at line " + this.indexToLineNo(patternIndex) + ": " + ex.toString();
            this.analysisErrors.add(errMsg);
            trace.err(errMsg);
            ex.printStackTrace();
            return 0;
        }
    }

    private int match_pattern(Value val, jess.Pattern pattern, int slotIndex, Stack localOpen) {
        int n;
        block58: {
            ArrayList<VariableBindingNode> variableList = new ArrayList<VariableBindingNode>();
            int patternIndex = this.patterns.indexOf(pattern);
            int i = 0;
            n = 0;
            try {
                VariableBindingNode valueNode;
                String patternString = new PrettyPrinter((Visitable)pattern).toString();
                ValueVector vv = val.listValue(null);
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "match_pattern[p,slot,test " + patternIndex + "," + slotIndex + "," + 0 + "] " + pattern + ", val " + (val == null ? "(null)" : val.toStringWithParens()) + ", localOpen.size() " + (localOpen == null ? "(null)" : Integer.toString(localOpen.size())));
                }
                Test1 test = pattern.getTest(slotIndex, 0);
                VariableBindingNode vbn = this.getVariableType(test.getValue().toString(), patternIndex, test.getTest());
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "match_pattern top " + vbn.dump());
                }
                if (vbn.getVariableType() == 1) {
                    i = 1;
                    if ((vbn = this.getVariableType((test = pattern.getTest(slotIndex, i++)).getValue().toString(), patternIndex, test.getTest())).getVariableType() == 1) {
                        do {
                            if (!trace.getDebugCode("mt")) continue;
                            trace.outNT("mt", "match_pattern skip0 MULTI/LOCAL at test[" + (i - 1) + "] " + vbn.dump());
                        } while (i < pattern.getNTests(slotIndex) && (vbn = this.getVariableType((test = pattern.getTest(slotIndex, i++)).getValue().toString(), patternIndex, test.getTest())).getVariableType() == 1);
                    }
                    if (vbn.getVariableType() == 0 || vbn.getVariableType() == 2) {
                        do {
                            if (trace.getDebugCode("mt")) {
                                trace.outNT("mt", "match_pattern add SINGLE/LITERAL at test[" + (i - 1) + "] " + vbn.dump());
                            }
                            variableList.add(vbn);
                        } while (i < pattern.getNTests(slotIndex) && ((vbn = this.getVariableType((test = pattern.getTest(slotIndex, i++)).getValue().toString(), patternIndex, test.getTest())).getVariableType() == 0 || vbn.getVariableType() == 2));
                    }
                    if (trace.getDebugCode("mt")) {
                        trace.outNT("mt", "match_pattern at test[" + i + "] of NTests " + pattern.getNTests(slotIndex) + ", variableList size " + variableList.size());
                    }
                    if (vbn.getVariableType() == 1) {
                        do {
                            if (!trace.getDebugCode("mt")) continue;
                            trace.outNT("mt", "match_pattern skip1 MULTI/LOCAL at test[" + (i - 1) + "] " + vbn.dump());
                        } while (i < pattern.getNTests(slotIndex) && (vbn = this.getVariableType((test = pattern.getTest(slotIndex, i++)).getValue().toString(), patternIndex, test.getTest())).getVariableType() == 1);
                        if (trace.getDebugCode("mt")) {
                            trace.outNT("mt", "match_pattern after 2nd multi at test[" + i + "] of NTests " + pattern.getNTests(slotIndex) + ", variableList size " + variableList.size() + "; last vbn " + vbn.dump());
                        }
                        if (i >= pattern.getNTests(slotIndex) && vbn.getVariableType() == 1) {
                            if (vv.size() == 0) {
                                boolean singleVar = false;
                                for (int m = variableList.size() - 1; m >= 0 && !singleVar; --m) {
                                    vbn = (VariableBindingNode)variableList.get(m);
                                    if (vbn.getVariableType() == 0) {
                                        singleVar = true;
                                        this.printRuleInstantiations(patternIndex, "there is no list entry for ?" + vbn.getVariableName(), FAILURE);
                                        continue;
                                    }
                                    if (vbn.getVariableType() == 2) {
                                        singleVar = true;
                                        this.printRuleInstantiations(patternIndex, "there is no list entry to match the literal \"" + vbn.getVariableValue() + "\"", FAILURE);
                                        continue;
                                    }
                                    valueNode = new VariableBindingNode(vbn);
                                    valueNode.setValue(new Value((Object)vv));
                                    if (valueNode.getVariableValue() != null) {
                                        this.context.setVariable(valueNode.getExtVariableName(), valueNode.getVariableValue());
                                    }
                                    valueNode.setDepth(patternIndex);
                                    valueNode.setSlotIndex(slotIndex);
                                    valueNode.setSubIndex(-1);
                                    this.currentValues.add(valueNode);
                                }
                            }
                            block6: for (int j = 0; j <= vv.size() - variableList.size(); ++j) {
                                n = 0;
                                int end = vv.size();
                                boolean first = false;
                                for (int m = 0; m < variableList.size(); ++m) {
                                    vbn = (VariableBindingNode)variableList.get(m);
                                    if (vbn.getVariableType() == 0) {
                                        valueNode = new VariableBindingNode(vbn);
                                        valueNode.setValue(vv.get(j + m));
                                        if (valueNode.getVariableValue() != null) {
                                            this.context.setVariable(valueNode.getExtVariableName(), valueNode.getVariableValue());
                                        }
                                        valueNode.setDepth(patternIndex);
                                        valueNode.setSlotIndex(slotIndex);
                                        valueNode.setSubIndex(j + m);
                                        ++n;
                                        localOpen.push(valueNode);
                                        continue;
                                    }
                                    if (vbn.getVariableType() != 2 || vv.get(j + m).equals(vbn.getVariableValue())) continue;
                                    for (int z = 0; z < n; ++z) {
                                        localOpen.pop();
                                    }
                                    continue block6;
                                }
                            }
                            break block58;
                        }
                        this.analysisErrors.add("At " + this.indexToLineNo(patternIndex) + ": WhyNot cannot analyze multislot patterns of the form \"" + patternString.replaceAll("\\?_\\w*_\\w*", "?") + "\"");
                        if (trace.getDebugCode("mt")) {
                            trace.outNT("mt", "not at end of MULTI list w/ n=" + n + ": found nonMULTI after 2nd MULT group at test[" + (i - 1) + "] " + vbn.dump());
                        }
                        break block58;
                    }
                    if (i >= pattern.getNTests(slotIndex)) {
                        if (vv.size() == 0) {
                            this.printRuleInstantiations(patternIndex, "the list should not be empty", FAILURE);
                            return 0;
                        }
                        int m = 0;
                        int j = vv.size() - variableList.size();
                        while (j < vv.size()) {
                            vbn = (VariableBindingNode)variableList.get(m);
                            if (vbn.getVariableType() == 0) {
                                valueNode = new VariableBindingNode(vbn);
                                valueNode.setValue(vv.get(j));
                                if (valueNode.getVariableValue() != null) {
                                    this.context.setVariable(valueNode.getExtVariableName(), valueNode.getVariableValue());
                                }
                                valueNode.setDepth(patternIndex);
                                valueNode.setSlotIndex(slotIndex);
                                valueNode.setSubIndex(j);
                                ++n;
                                localOpen.push(valueNode);
                            } else if (vbn.getVariableType() == 2 && !vv.get(j).equals(vbn.getVariableValue())) {
                                for (int z = 0; z < n; ++z) {
                                    localOpen.pop();
                                }
                                break block58;
                            }
                            ++j;
                            ++m;
                        }
                        break block58;
                    }
                    this.analysisErrors.add("At " + this.indexToLineNo(patternIndex) + ": WhyNot cannot analyze multislot patterns of the form: \"" + patternString.replaceAll("\\?_\\w*_\\w*", "?") + "\"");
                    if (trace.getDebugCode("mt")) {
                        trace.outNT("mt", "not MULTI, not LOCAL, not at end w/ i=" + i + "?< pattern.getNTests(slotIndex=" + slotIndex + ")=" + pattern.getNTests(slotIndex));
                    }
                    this.printRuleInstantiations(patternIndex, null, FAILURE);
                    return 0;
                }
                if (vbn.getVariableType() == 0) {
                    i = 1;
                    do {
                        variableList.add(vbn);
                    } while (i < pattern.getNTests(slotIndex) && (vbn = this.getVariableType((test = pattern.getTest(slotIndex, i++)).getValue().toString(), patternIndex, test.getTest())).getVariableType() == 0);
                    if (vbn.getVariableType() == 1) {
                        while (i < pattern.getNTests(slotIndex) && (vbn = this.getVariableType((test = pattern.getTest(slotIndex, i++)).getValue().toString(), patternIndex, test.getTest())).getVariableType() == 1) {
                        }
                        if (vbn.getVariableType() != 1) {
                            this.analysisErrors.add("At " + this.indexToLineNo(patternIndex) + ": WhyNot cannot analyze multislot patterns of the form: \"" + patternString.replaceAll("\\?_\\w*_\\w*", "?") + "\"");
                            if (trace.getDebugCode("mt")) {
                                trace.outNT("mt", "Pattern not of type ? ? ? ? ? $ $ $ w/ i=" + i + "?< pattern.getNTests(slotIndex=" + slotIndex + ")=" + pattern.getNTests(slotIndex));
                            }
                            this.printRuleInstantiations(patternIndex, null, "FAILED to Match pattern");
                            return 0;
                        }
                    }
                    if (i >= pattern.getNTests(slotIndex)) {
                        if (vv.size() == 0) {
                            boolean singlevar = false;
                            for (int m = variableList.size() - 1; m >= 0; --m) {
                                vbn = (VariableBindingNode)variableList.get(m);
                                if (vbn.getVariableType() == 0 || vbn.getVariableType() == 2) {
                                    this.printRuleInstantiations(patternIndex, "Need a non-empty list", FAILURE);
                                    continue;
                                }
                                valueNode = new VariableBindingNode(vbn);
                                valueNode.setValue(new Value((Object)vv));
                                if (valueNode.getVariableValue() != null) {
                                    this.context.setVariable(valueNode.getExtVariableName(), valueNode.getVariableValue());
                                }
                                valueNode.setDepth(patternIndex);
                                valueNode.setSlotIndex(slotIndex);
                                valueNode.setSubIndex(-1);
                                this.currentValues.add(valueNode);
                            }
                            break block58;
                        }
                        for (int m = 0; m < variableList.size(); ++m) {
                            vbn = (VariableBindingNode)variableList.get(m);
                            if (vbn.getVariableType() == 0) {
                                valueNode = new VariableBindingNode(vbn);
                                valueNode.setValue(vv.get(m));
                                if (valueNode.getVariableValue() != null) {
                                    this.context.setVariable(valueNode.getExtVariableName(), valueNode.getVariableValue());
                                }
                                valueNode.setDepth(patternIndex);
                                valueNode.setSlotIndex(slotIndex);
                                valueNode.setSubIndex(m);
                                ++n;
                                localOpen.push(valueNode);
                                continue;
                            }
                            if (vbn.getVariableType() != 2 || vv.get(m).equals(vbn.getVariableValue())) continue;
                            for (int z = 0; z < n; ++z) {
                                localOpen.pop();
                            }
                            break block58;
                        }
                        break block58;
                    }
                    this.analysisErrors.add("At " + this.indexToLineNo(patternIndex) + ": WhyNot cannot analyze multislot patterns of the form: \"" + patternString.replaceAll("\\?_\\w*_\\w*", "?") + "\"");
                    if (trace.getDebugCode("mt")) {
                        trace.outNT("mt", "Pattern not of type ? ? ? ? ? $ $ $ w/ i=" + i + "?< pattern.getNTests(slotIndex=" + slotIndex + ")=" + pattern.getNTests(slotIndex));
                    }
                    this.printRuleInstantiations(patternIndex, null, "FAILED to Match pattern");
                    break block58;
                }
                if (vbn.getVariableType() == 2) {
                    if (vv.size() == 0 && vbn.getVariableValue().stringValue(this.context).equalsIgnoreCase("nil")) {
                        n = 1;
                        valueNode = new VariableBindingNode(vbn);
                        localOpen.push(valueNode);
                    } else if (vv.size() == 0 && !vbn.getVariableValue().stringValue(this.context).equalsIgnoreCase("nil")) {
                        this.printRuleInstantiations(patternIndex, "There is no list entry to match " + vbn.getVariableValue().toString(), FAILURE);
                    } else if (!vbn.getVariableValue().toString().equals(vv.get(vbn.getSubSlotIndexes()).toString())) {
                        this.printRuleInstantiations(patternIndex, "No list entry matches " + vbn.getVariableValue().toString(), FAILURE);
                    } else {
                        n = 1;
                        valueNode = new VariableBindingNode(vbn);
                        localOpen.push(valueNode);
                    }
                }
            }
            catch (Exception ex) {
                this.analysisErrors.add("Error analyzing pattern at line " + this.indexToLineNo(patternIndex) + ": " + ex);
                ex.printStackTrace();
            }
        }
        return n;
    }

    public VariableBindingNode getVariableType(String variableName, int depth, int testType) {
        int variableType;
        VariableBindingNode varBindingNode = null;
        StringBuffer sb = new StringBuffer(variableName);
        if (testType == 64) {
            variableType = 3;
        } else if (sb.charAt(0) == '$') {
            if (sb.length() > 1 && sb.charAt(1) == '?') {
                sb.delete(0, 2);
                variableType = 1;
            } else {
                variableType = 4;
            }
        } else if (sb.charAt(0) == '?') {
            variableType = 0;
            sb.deleteCharAt(0);
        } else {
            variableType = 2;
        }
        int i = this.containsVariable(0, this.vMap, sb.toString());
        if (i == -1) {
            varBindingNode = new VariableBindingNode(sb.toString(), variableType, 1, testType);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "getVariableType(): new vbn " + varBindingNode.dump());
            }
        } else {
            varBindingNode = (VariableBindingNode)this.vMap.get(i);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "getVariableType(): existing vMap[" + i + "] " + varBindingNode.dump());
            }
        }
        if (variableType == 2) {
            try {
                varBindingNode.setValue(new Value(variableName, 1));
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "context.< for LITERAL:" + varBindingNode.dump());
                }
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        if ((i = this.containsVariable(0, this.currentValues, sb.toString())) != -1) {
            variableType = 2;
            varBindingNode = new VariableBindingNode((VariableBindingNode)this.currentValues.get(i));
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "new LITERAL for vbn at currentValues[" + i + "] " + varBindingNode.dump());
            }
            varBindingNode.setVariableType(variableType);
        }
        String fIdVstr = "not a fact";
        try {
            if (varBindingNode.getVariableValue() instanceof FactIDValue) {
                FactIDValue fIdV = (FactIDValue)varBindingNode.getVariableValue();
                fIdVstr = fIdV.factValue(this.context).toString();
            }
        }
        catch (JessException je) {
            fIdVstr = je.toString();
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", "getVariableType returning " + varBindingNode.dump() + ":\n  " + fIdVstr);
        }
        return varBindingNode;
    }

    public void setTextArea(JTextArea ta) {
        this.textArea = ta;
    }

    public ArrayList reasonOut(WMEEditor wmeeditor) {
        int[] a;
        int p;
        this.doPreprocessing();
        StringBuffer traceSB = new StringBuffer("vMap after doPreprocessing():");
        Iterator it = this.vMap.iterator();
        while (it.hasNext()) {
            traceSB.append("\n  ").append(((VariableBindingNode)it.next()).dump());
        }
        if (trace.getDebugCode("mt")) {
            trace.outNT("mt", traceSB.toString());
        }
        VariableBindingNode vbn = (VariableBindingNode)this.vMap.get(0);
        try {
            this.getRuleInstantiations(vbn, null);
        }
        catch (Exception e) {
            String errMsg = "Error analyzing rule";
            this.analysisErrors.add(errMsg + ": " + e);
            trace.err(errMsg);
            e.printStackTrace();
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JSplitPane split = new JSplitPane(0);
        if (this.rulePrinter == null) {
            this.rulePrinter = new RulePrinter(this.rule);
        }
        JLabel ruleLabel = new JLabel("Rule definition:");
        ruleLabel.setAlignmentX(0.0f);
        this.getContentPane().add(ruleLabel);
        this.ruleDisplay = new JTextArea(40, 100){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tipText = null;
                int oldMouseOverRow = WhyNot.this.mouseOverRow;
                int offset = WhyNot.this.ruleDisplay.viewToModel(e.getPoint());
                String varName = WhyNot.this.getHighlightedVar(offset);
                if (WhyNot.this.vbnTableModel == null) {
                    WhyNot.this.mouseOverRow = -1;
                } else {
                    WhyNot.this.mouseOverRow = WhyNot.this.vbnTableModel.findDisplayName(varName);
                    if (WhyNot.this.mouseOverRow >= 0) {
                        tipText = WhyNot.this.vbnTableModel.getToolTipText(WhyNot.this.mouseOverRow);
                    }
                }
                if (oldMouseOverRow != WhyNot.this.mouseOverRow) {
                    WhyNot.this.varTable.repaint();
                }
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "getToolTipText(" + varName + ") rtns " + tipText);
                }
                return tipText;
            }
        };
        this.ruleDisplay.setToolTipText("rule text area tool tip");
        this.ruleDisplay.setText(this.rulePrinter.toString());
        this.ruleDisplay.setEditable(false);
        this.ruleDisplay.setFont(Font.decode("Courier-normal-12"));
        this.ruleDisplay.setCaretPosition(0);
        JScrollPane ruleScroll = new JScrollPane(this.ruleDisplay);
        ruleScroll.setAlignmentX(0.0f);
        ruleScroll.setPreferredSize(new Dimension(700, 480));
        ruleScroll.setMinimumSize(new Dimension(700, 250));
        split.add(ruleScroll);
        if (this.analysisErrors.size() > 0) {
            JEditorPane errorDisplay = new JEditorPane();
            errorDisplay.setContentType("text/html");
            errorDisplay.setAutoscrolls(true);
            errorDisplay.setEditable(false);
            StringBuffer sb = new StringBuffer("<b>Unable to analyze rule. Reason(s):</b><ul>");
            Iterator it2 = this.analysisErrors.iterator();
            while (it2.hasNext()) {
                sb.append("\n<li>").append((String)it2.next()).append("</li>");
            }
            sb.append("\n</ul></html>");
            errorDisplay.setText(sb.toString());
            errorDisplay.setCaretPosition(0);
            JScrollPane errorScroll = new JScrollPane(errorDisplay);
            errorScroll.setAlignmentX(0.0f);
            errorScroll.setPreferredSize(new Dimension(700, 250));
            errorScroll.setMinimumSize(new Dimension(700, 100));
            split.add(errorScroll);
            this.getContentPane().add(split);
            this.setSize(new Dimension(700, 600));
            this.show();
            return this.resultsList;
        }
        ArrayList sortedResults = new ArrayList();
        ArrayList sortedSummaries = new ArrayList();
        for (p = 0; p < this.index_varsList.size(); ++p) {
            a = (int[])this.index_varsList.get(p);
            for (int q = p; q < this.index_varsList.size(); ++q) {
                int[] b = (int[])this.index_varsList.get(q);
                if (a[1] >= b[1]) continue;
                int temp = a[0];
                a[0] = b[0];
                b[0] = temp;
                temp = a[1];
                a[1] = b[1];
                b[1] = temp;
            }
        }
        for (p = 0; p < this.index_varsList.size(); ++p) {
            a = (int[])this.index_varsList.get(p);
            sortedResults.add(this.resultsList.get(a[0]));
            sortedSummaries.add(this.summaries.get(a[0]));
        }
        this.resultsList = this.resultsListFiltered = sortedResults;
        this.summaries = this.summaryListFiltered = sortedSummaries;
        Box listBox = new Box(1);
        JLabel instLabel = new JLabel("Partial Activations:");
        instLabel.setAlignmentX(0.0f);
        Vector<String> instText = new Vector<String>();
        ListIterator li = this.resultsListFiltered.listIterator();
        ListIterator sum2 = this.summaryListFiltered.listIterator();
        while (li.hasNext()) {
            if (sum2.next().toString().equals(ALL_VARIABLES_BOUND_SUCCESSFULLY)) {
                instText.add("<html><font color=\"black\">" + ((VBNTableModel)li.next()).getRowCount() + " variables bound</font></html>");
                continue;
            }
            instText.add("<html><font color=\"red\">" + ((VBNTableModel)li.next()).getRowCount() + " variables bound</font></html>");
        }
        if (instText.isEmpty()) {
            instText.add("No variables bound");
        }
        this.instList = new JList(instText);
        this.instList.setPrototypeCellValue("999 variables bound");
        this.instList.setAlignmentX(1.0f);
        this.instList.setSelectionBackground(Color.LIGHT_GRAY);
        this.instList.addListSelectionListener(this);
        JScrollPane instListScroll = new JScrollPane(this.instList);
        listBox.add(instLabel);
        listBox.add(instListScroll);
        Box instBox = new Box(3);
        this.summary = new JLabel(" ");
        this.summary.setAlignmentX(0.0f);
        instBox.add(this.summary);
        VBNTableModel varTableModel = new VBNTableModel(this, null);
        class VarTable
        extends JTable {
            VarTable(TableModel tableModel) {
                super(tableModel);
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                Object cellContent;
                Object tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                int column = this.columnAtPoint(p);
                int mColumn = this.convertColumnIndexToModel(column);
                TableModel tm = this.getModel();
                if (tm instanceof VBNTableModel && (cellContent = ((VBNTableModel)tm).getObjectAt(row, mColumn)) instanceof VBNTableModel.Entry) {
                    return ((VBNTableModel.Entry)cellContent).getToolTipText();
                }
                cellContent = tm.getValueAt(row, mColumn);
                return cellContent.getClass().getName();
            }

            @Override
            public JToolTip createToolTip() {
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "table createToolTip()");
                }
                return super.createToolTip();
            }
        }
        this.varTable = new VarTable(varTableModel);
        class VarTableCellRenderer
        extends DefaultTableCellRenderer {
            VarTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setBackground(WhyNot.this.colors[row % WhyNot.this.colors.length]);
                c.setForeground(Color.BLACK);
                if (row == WhyNot.this.errorRow) {
                    c.setForeground(Color.RED);
                }
                ((JComponent)c).setBorder(null);
                if (row == WhyNot.this.mouseOverRow) {
                    ((JComponent)c).setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                }
                return c;
            }
        }
        this.varTable.setDefaultRenderer(Object.class, new VarTableCellRenderer());
        this.varTable.setAlignmentX(0.0f);
        JScrollPane varTableScroll = new JScrollPane(this.varTable);
        this.saiColumnNames = new Vector();
        this.saiColumnNames.add(" ");
        this.saiColumnNames.add("Rule");
        this.saiColumnNames.add("Student Action");
        this.saiTable = new JTable(new DefaultTableModel(null, this.saiColumnNames){

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }
        });
        this.saiTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value.toString().length() > 0) {
                    if (WhyNot.this.reqSAI.get(row).equals(WhyNot.this.actualSAI.get(row)) || WhyNot.this.actualSAI.get(row).toString().equalsIgnoreCase("DONT-CARE")) {
                        c.setBackground(new Color(0.3f, 1.0f, 0.3f));
                    } else {
                        c.setBackground(new Color(1.0f, 0.3f, 0.3f));
                    }
                }
                return c;
            }
        });
        this.saiTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value.toString().length() > 0) {
                    if (WhyNot.this.reqSAI.get(row).equals(WhyNot.this.actualSAI.get(row)) || WhyNot.this.actualSAI.get(row).toString().equalsIgnoreCase("DONT-CARE")) {
                        c.setBackground(new Color(0.3f, 1.0f, 0.3f));
                    } else {
                        c.setBackground(new Color(1.0f, 0.3f, 0.3f));
                    }
                }
                return c;
            }
        });
        wmeeditor.getPanel().setSize(new Dimension(600, 300));
        wmeeditor.getPanel().setAlignmentX(0.0f);
        this.instList.setSelectedIndex(0);
        wmeeditor.getPanel().refresh();
        JSplitPane splitW = new JSplitPane(0, varTableScroll, wmeeditor.getPanel());
        splitW.setResizeWeight(0.5);
        instBox.add(splitW);
        Box detailBox = new Box(0);
        detailBox.setAlignmentX(0.0f);
        detailBox.add(listBox);
        detailBox.add(Box.createHorizontalStrut(10));
        detailBox.add(instBox);
        split.add(detailBox);
        this.getContentPane().add(split);
        this.setSize(new Dimension(760, 800));
        this.validate();
        this.setVisible(true);
        return this.resultsList;
    }

    private void setActualSAI(Vector actualSAI) {
        this.actualSAI = actualSAI;
    }

    public void setReqSAI(Vector reqSAI) {
        this.reqSAI = reqSAI;
    }

    public void setNodeSAI(Vector nodeSAI) {
        this.nodeSAI = nodeSAI;
    }

    public ArrayList getIndex_depthList() {
        return this.index_depthList;
    }

    public ArrayList getIndex_varsList() {
        return this.index_varsList;
    }

    public void setIndex_depthList(ArrayList index_depthList) {
        this.index_depthList = index_depthList;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String varName;
        int selectedIndex = this.instList.getSelectedIndex();
        if (selectedIndex < 0 || this.resultsListFiltered.size() <= selectedIndex) {
            if (this.resultsListFiltered.size() <= selectedIndex) {
                System.err.println("\nError in WhyNot.valueChanged(): selected index " + selectedIndex + " out of list range " + this.resultsListFiltered.size() + ".\n");
            }
            this.summary.setText(this.resultsListFiltered.size() < 1 ? "No partial instantiations." : " ");
            this.varTable.setModel(new VBNTableModel(this, null));
            this.saiTable.setModel(new DefaultTableModel(null, this.saiColumnNames){

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            });
            this.repaint();
            return;
        }
        this.vbnTableModel = (VBNTableModel)this.resultsListFiltered.get(this.instList.getSelectedIndex());
        if (this.vbnTableModel.getRowCount() < 1) {
            this.summary.setText("No variables could be bound for this partial activation.");
            this.varTable.setModel(this.vbnTableModel);
            this.saiTable.setModel(new DefaultTableModel(null, this.saiColumnNames){

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            });
            this.repaint();
            return;
        }
        Pattern p = Pattern.compile("\\(modify \\?special-tutor-fact \\(selection ([^\\)]*)\\) \\(action ([^\\)]*)\\) \\(input ([^\\)]*)\\)");
        Matcher m = p.matcher(this.ruleDisplay.getText());
        this.actualSAI = new Vector();
        if (!m.find()) {
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "actualSAI: not match (modify ...)");
            }
        } else {
            for (int i = 1; i <= 3; ++i) {
                String g = m.group(i);
                if (trace.getDebugCode("mt")) {
                    trace.outNT("mt", "actualSAI[" + i + "] match \"" + g + "\"");
                }
                if (g.charAt(0) == '?') {
                    int varIndex = this.vbnTableModel.findDisplayName(g);
                    if (varIndex >= 0) {
                        this.actualSAI.add(this.vbnTableModel.getDisplayValue(varIndex));
                    }
                    if (!trace.getDebugCode("mt")) continue;
                    trace.outNT("mt", "actualSAI[" + i + "] varIndex=" + varIndex + " for \"" + g + "\"");
                    continue;
                }
                if (g.charAt(0) == '\"') {
                    this.actualSAI.add(g.substring(1, g.length() - 1));
                    continue;
                }
                this.actualSAI.add(g);
            }
        }
        String summaryString = this.summaryListFiltered.get(this.instList.getSelectedIndex()).toString();
        boolean showSAI = false;
        this.summary.setForeground(Color.RED);
        if (summaryString.equals(ALL_VARIABLES_BOUND_SUCCESSFULLY)) {
            Color[] summaryColor = new Color[]{new Color(0.0f, 0.5f, 0.0f)};
            summaryString = this.makeSAISummary(summaryString, this.actualSAI, this.reqSAI, this.nodeSAI, summaryColor);
            this.summary.setForeground(summaryColor[0]);
        }
        this.summary.setText(summaryString);
        this.ruleDisplay.getHighlighter().removeAllHighlights();
        this.errorRow = -1;
        p = Pattern.compile("For the variable or expression (.*), the required value was .*");
        m = p.matcher(summaryString);
        if (m.matches()) {
            int varNum = 0;
            Iterator vn_it = this.vbnTableModel.nameIterator();
            while (vn_it.hasNext()) {
                varName = (String)vn_it.next();
                if (varName != null && varName.equals(m.group(1))) {
                    this.errorRow = varNum;
                    break;
                }
                ++varNum;
            }
        } else {
            p = Pattern.compile("Could not match pattern for (.*)\\.");
            m = p.matcher(summaryString);
            if (m.matches()) {
                Pattern var_p = Pattern.compile("\\Q" + m.group(1) + " <- \\E");
                Matcher var_m = var_p.matcher(this.ruleDisplay.getText());
                while (var_m.find()) {
                    try {
                        this.ruleDisplay.getHighlighter().addHighlight(var_m.start(), var_m.end() - 1, new DefaultHighlighter.DefaultHighlightPainter(new Color(1.0f, 0.3f, 0.3f)));
                    }
                    catch (BadLocationException exc) {
                        if (!trace.getDebugCode("mt")) continue;
                        trace.outNT("mt", "WhyNot.valueChanged() error while highlighting pattern: " + exc.toString());
                    }
                }
            }
        }
        if (this.vbnTableModel == null) {
            this.vbnTableModel = new VBNTableModel(this, null);
        }
        this.varTable.setModel(this.vbnTableModel);
        int varNum = 0;
        Iterator varName_it = this.vbnTableModel.nameIterator();
        while (varName_it.hasNext()) {
            varName = (String)varName_it.next();
            Pattern var_p = Pattern.compile("\\Q" + varName + "\\E[^a-zA-Z0-9\\-_]");
            Matcher var_m = var_p.matcher(this.ruleDisplay.getText());
            while (var_m.find()) {
                try {
                    this.ruleDisplay.getHighlighter().addHighlight(var_m.start(), var_m.end() - 1, new DefaultHighlighter.DefaultHighlightPainter(this.colors[varNum % this.colors.length]));
                }
                catch (BadLocationException exc) {
                    if (!trace.getDebugCode("mt")) continue;
                    trace.outNT("mt", "WhyNot.valueChanged() error while highlighting variable: " + exc.toString());
                }
            }
            ++varNum;
        }
        if (showSAI && this.actualSAI.size() == 3 && this.reqSAI.size() == 3) {
            Vector saiRowData = new Vector();
            Vector<String> selectionRow = new Vector<String>();
            selectionRow.add("<HTML><B>Selection</B></HTML>");
            selectionRow.add(this.actualSAI.get(0).toString());
            selectionRow.add(this.reqSAI.get(0).toString());
            saiRowData.add(selectionRow);
            Vector<String> actionRow = new Vector<String>();
            actionRow.add("<HTML><B>Action</B></HTML>");
            actionRow.add(this.actualSAI.get(1).toString());
            actionRow.add(this.reqSAI.get(1).toString());
            saiRowData.add(actionRow);
            Vector<String> inputRow = new Vector<String>();
            inputRow.add("<HTML><B>Input</B></HTML>");
            inputRow.add(this.actualSAI.get(2).toString());
            inputRow.add(this.reqSAI.get(2).toString());
            saiRowData.add(inputRow);
            this.saiTable.setModel(new DefaultTableModel(saiRowData, this.saiColumnNames){

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            });
        } else {
            this.saiTable.setModel(new DefaultTableModel(null, this.saiColumnNames){

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            });
        }
        this.saiTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value.toString().length() > 0) {
                    if (WhyNot.this.reqSAI.get(row).equals(WhyNot.this.actualSAI.get(row)) || WhyNot.this.actualSAI.get(row).toString().equalsIgnoreCase("DONT-CARE")) {
                        c.setBackground(new Color(0.3f, 1.0f, 0.3f));
                    } else {
                        c.setBackground(new Color(1.0f, 0.3f, 0.3f));
                    }
                }
                return c;
            }
        });
        this.saiTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value.toString().length() > 0) {
                    if (WhyNot.this.reqSAI.get(row).equals(WhyNot.this.actualSAI.get(row)) || WhyNot.this.actualSAI.get(row).toString().equalsIgnoreCase("DONT-CARE")) {
                        c.setBackground(new Color(0.3f, 1.0f, 0.3f));
                    } else {
                        c.setBackground(new Color(1.0f, 0.3f, 0.3f));
                    }
                }
                return c;
            }
        });
        StringBuffer sb = new StringBuffer();
        if (this.vbnTableModel != null) {
            for (int i = 0; i < this.vbnTableModel.getRowCount(); ++i) {
                sb.append(this.vbnTableModel.getValueAt(i, 0) + " = " + this.vbnTableModel.getValueAt(i, 1) + "\n");
            }
        }
        if (!e.getValueIsAdjusting()) {
            this.getEventLogger().log(true, "WHY_NOT_WINDOW", INSTANTIATION_INDEX, selectedIndex + ": " + this.summary.getText(), this.ruleName, sb.toString());
        }
        this.repaint();
    }

    private String makeSAISummary(String result, List actualSAI, List reqSAI, List nodeSAI, Color[] summaryColor) {
        if (reqSAI == null || reqSAI.size() < 3 || nodeSAI == null || nodeSAI.size() < 3 || MTRete.isSAIUnspecified(nodeSAI)) {
            return result;
        }
        summaryColor[0] = Color.BLACK;
        return result + " Click on S/A/I cells in the Conflict Tree to check selection, action, input.";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getEventLogger().log(true, "WHY_NOT_WINDOW", e.getActionCommand(), "", "", "");
        if (e.getActionCommand().equals(FILTER_VARIABLE)) {
            String var = ((JComboBox)this.newFilter.get(1)).getSelectedItem().toString();
            Vector vals = new Vector();
            ListIterator li = this.resultsList.listIterator();
            while (li.hasNext()) {
                Vector binding = (Vector)li.next();
                ListIterator var_it = binding.listIterator();
                while (var_it.hasNext()) {
                    Vector v = (Vector)var_it.next();
                    if (!v.get(0).equals(var) || vals.contains(v.get(1))) continue;
                    vals.add(v.get(1));
                }
            }
            ((JComboBox)this.newFilter.get(2)).setModel(new DefaultComboBoxModel(vals));
            this.repaint();
        } else if (e.getActionCommand().equals(FILTER_APPLY)) {
            Object oldSelection = null;
            if (this.instList.getSelectedIndex() != -1) {
                oldSelection = this.resultsListFiltered.get(this.instList.getSelectedIndex());
            }
            String var = ((JComboBox)this.newFilter.get(1)).getSelectedItem().toString();
            String val = ((JComboBox)this.newFilter.get(2)).getSelectedItem().toString();
            ArrayList<Vector> newFilteredList = new ArrayList<Vector>();
            ArrayList newSummaryList = new ArrayList();
            ListIterator li = this.resultsListFiltered.listIterator();
            ListIterator sum_it = this.summaryListFiltered.listIterator();
            while (li.hasNext()) {
                Vector binding = (Vector)li.next();
                Object summary = sum_it.next();
                boolean match = false;
                ListIterator var_it = binding.listIterator();
                while (var_it.hasNext()) {
                    Vector v = (Vector)var_it.next();
                    if (!v.get(0).equals(var) || !v.get(1).equals(val)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                newFilteredList.add(binding);
                newSummaryList.add(summary);
            }
            this.resultsListFiltered = newFilteredList;
            this.summaryListFiltered = newSummaryList;
            Vector<String> instText = new Vector<String>();
            int i = 0;
            int selection = -1;
            ListIterator li2 = this.resultsListFiltered.listIterator();
            ListIterator sum2 = this.summaryListFiltered.listIterator();
            while (li2.hasNext()) {
                Vector result = (Vector)li2.next();
                if (sum2.next().toString().equals(ALL_VARIABLES_BOUND_SUCCESSFULLY)) {
                    instText.add("<HTML><FONT COLOR=#00CC00>" + result.size() + " variables bound</FONT></HTML>");
                } else {
                    instText.add("<HTML><FONT COLOR=#FF0000>" + result.size() + " variables bound</FONT></HTML>");
                }
                if (result == oldSelection) {
                    selection = i;
                }
                ++i;
            }
            this.instList.setListData(instText);
            if (selection != -1) {
                this.instList.setSelectedIndex(selection);
            }
            ((JButton)this.newFilter.get(3)).setText("Remove");
            ((JButton)this.newFilter.get(3)).setActionCommand(FILTER_REMOVE);
            ((JComboBox)this.newFilter.get(1)).setEnabled(false);
            ((JComboBox)this.newFilter.get(2)).setEnabled(false);
            this.filters.add(this.newFilter);
            Vector vars = new Vector();
            ListIterator li3 = ((Vector)this.resultsList.get(0)).listIterator();
            while (li3.hasNext()) {
                vars.add(((Vector)li3.next()).get(0));
            }
            li3 = this.filters.listIterator();
            while (li3.hasNext()) {
                Vector filter = (Vector)li3.next();
                String usedVar = (String)((JComboBox)filter.get(1)).getSelectedItem();
                vars.remove(usedVar);
            }
            Vector vals = new Vector();
            ListIterator li4 = this.resultsList.listIterator();
            while (li4.hasNext()) {
                Vector binding = (Vector)li4.next();
                ListIterator var_it = binding.listIterator();
                while (var_it.hasNext()) {
                    Vector v = (Vector)var_it.next();
                    if (v.size() <= 1 || vars.size() <= 0 || !v.get(0).equals(vars.get(0))) continue;
                    vals.add(v.get(1));
                }
            }
            this.newFilter = new Vector();
            Box newFilterPanel = new Box(0);
            newFilterPanel.add(new JLabel("Show only cases where "));
            JComboBox newFilterVar = new JComboBox(vars);
            newFilterVar.setSelectedIndex(0);
            newFilterVar.setActionCommand(FILTER_VARIABLE);
            newFilterVar.addActionListener(this);
            newFilterPanel.add(newFilterVar);
            newFilterPanel.add(new JLabel(" equals "));
            JComboBox newFilterVal = new JComboBox(vals);
            newFilterVal.setSelectedIndex(0);
            newFilterVal.setActionCommand(FILTER_VALUE);
            newFilterVal.addActionListener(this);
            newFilterPanel.add(newFilterVal);
            JButton apply = new JButton("Apply");
            apply.setActionCommand(FILTER_APPLY);
            apply.addActionListener(this);
            newFilterPanel.add(apply);
            this.newFilter.add(newFilterPanel);
            this.newFilter.add(newFilterVar);
            this.newFilter.add(newFilterVal);
            this.newFilter.add(apply);
            newFilterPanel.setMaximumSize(new Dimension(700, 25));
            this.filterBox.add(newFilterPanel);
            this.repaint();
        } else if (e.getActionCommand().equals(FILTER_REMOVE)) {
            Box filterPanel = null;
            Component[] children = this.filterBox.getComponents();
            for (int i = 0; i < children.length; ++i) {
                if (((JComponent)children[i]).getComponents()[4] != e.getSource()) continue;
                filterPanel = (Box)children[i];
            }
            if (filterPanel == null) {
                return;
            }
            this.filterBox.remove(filterPanel);
            this.filterScroll.revalidate();
            Vector filterToRemove = null;
            ListIterator li = this.filters.listIterator();
            while (li.hasNext()) {
                Vector filter = (Vector)li.next();
                if (filter.get(0) != filterPanel) continue;
                filterToRemove = filter;
            }
            if (filterToRemove != null) {
                this.filters.remove(filterToRemove);
            }
            ArrayList<Vector> newFilteredList = new ArrayList<Vector>();
            ArrayList newSummaryList = new ArrayList();
            ListIterator li5 = this.resultsList.listIterator();
            ListIterator sum_it = this.summaries.listIterator();
            while (li5.hasNext()) {
                Vector binding = (Vector)li5.next();
                Object summary = sum_it.next();
                boolean matchAll = true;
                ListIterator filter_it = this.filters.listIterator();
                while (filter_it.hasNext() && matchAll) {
                    Vector filter = (Vector)filter_it.next();
                    String var = ((JComboBox)filter.get(1)).getSelectedItem().toString();
                    String val = ((JComboBox)filter.get(2)).getSelectedItem().toString();
                    boolean match = false;
                    ListIterator var_it = binding.listIterator();
                    while (var_it.hasNext()) {
                        Vector v = (Vector)var_it.next();
                        if (!v.get(0).equals(var) || !v.get(1).equals(val)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    matchAll = false;
                }
                if (!matchAll) continue;
                newFilteredList.add(binding);
                newSummaryList.add(summary);
            }
            this.resultsListFiltered = newFilteredList;
            this.summaryListFiltered = newSummaryList;
            Vector<String> instText = new Vector<String>();
            ListIterator li6 = this.resultsListFiltered.listIterator();
            ListIterator sum3 = this.summaryListFiltered.listIterator();
            while (li6.hasNext()) {
                if (sum3.next().toString().equals(ALL_VARIABLES_BOUND_SUCCESSFULLY)) {
                    instText.add("<HTML><FONT COLOR=#00CC00>" + ((Vector)li6.next()).size() + " variables bound</FONT></HTML>");
                    continue;
                }
                instText.add("<HTML><FONT COLOR=#FF0000>" + ((Vector)li6.next()).size() + " variables bound</FONT></HTML>");
            }
            this.instList.setListData(instText);
            Vector vars = new Vector();
            ListIterator li7 = ((Vector)this.resultsList.get(0)).listIterator();
            while (li7.hasNext()) {
                vars.add(((Vector)li7.next()).get(0));
            }
            li7 = this.filters.listIterator();
            while (li7.hasNext()) {
                Vector filter = (Vector)li7.next();
                String usedVar = (String)((JComboBox)filter.get(1)).getSelectedItem();
                vars.remove(usedVar);
            }
            Vector vals = new Vector();
            ListIterator li8 = this.resultsList.listIterator();
            while (li8.hasNext()) {
                Vector binding = (Vector)li8.next();
                ListIterator var_it = binding.listIterator();
                while (var_it.hasNext()) {
                    Vector v = (Vector)var_it.next();
                    if (!v.get(0).equals(vars.get(0))) continue;
                    vals.add(v.get(1));
                }
            }
            ((JComboBox)this.newFilter.get(1)).setModel(new DefaultComboBoxModel(vars));
            ((JComboBox)this.newFilter.get(2)).setModel(new DefaultComboBoxModel(vals));
            this.repaint();
        }
    }

    private String getHighlightedVar(int offset) {
        String varName = null;
        if (this.mouseOverHighlight == null || offset < this.mouseOverHighlight.getStartOffset() || this.mouseOverHighlight.getEndOffset() < offset) {
            this.mouseOverHighlight = null;
            Highlighter.Highlight[] highlights = this.ruleDisplay.getHighlighter().getHighlights();
            for (int i = 0; this.mouseOverHighlight == null && i < highlights.length; ++i) {
                Highlighter.Highlight h = highlights[i];
                if (h.getStartOffset() > offset || offset > h.getEndOffset()) continue;
                this.mouseOverHighlight = h;
            }
        }
        if (this.mouseOverHighlight != null) {
            varName = this.ruleDisplay.getText().substring(this.mouseOverHighlight.getStartOffset(), this.mouseOverHighlight.getEndOffset());
        }
        return varName;
    }

    EventLogger getEventLogger() {
        return this.eventLogger;
    }

    private class TestResult {
        final VariableBindingNode vbn;
        final List vbnList;
        final List factList;

        TestResult(VariableBindingNode vbn, Fact fact) {
            this.vbn = vbn;
            this.vbnList = null;
            this.factList = new ArrayList();
            this.factList.add(fact);
        }

        TestResult(VariableBindingNode vbn, List factList) {
            this.vbn = vbn;
            this.vbnList = null;
            this.factList = factList;
        }

        TestResult(List vbnList, Fact fact) {
            this.vbn = null;
            this.vbnList = vbnList;
            this.factList = new ArrayList();
            this.factList.add(fact);
        }

        TestResult(List vbnList, List factList) {
            this.vbn = null;
            this.vbnList = vbnList;
            this.factList = factList;
        }

        boolean isList() {
            return this.vbnList != null;
        }
    }

    private class MultislotMatch
    implements Cloneable {
        final Fact fact;
        final ValueVector vv;
        int vvIdx = 0;
        final VariableBindingNode[] vbnArr;
        int vbnIdx = 0;
        int nScalarTests;
        final int patternIdx;
        String failureDesc = null;

        MultislotMatch(ValueVector vv, VariableBindingNode[] vbnArr, int patternIdx, int nScalarTests, Fact fact) {
            this.vv = vv;
            this.vbnArr = vbnArr;
            this.patternIdx = patternIdx;
            this.nScalarTests = nScalarTests;
            this.fact = fact;
        }

        MultislotMatch copy() {
            MultislotMatch result = new MultislotMatch(this.vv, this.vbnArr, this.patternIdx, this.nScalarTests, this.fact);
            result.failureDesc = this.failureDesc;
            result.vbnIdx = this.vbnIdx;
            result.vvIdx = this.vvIdx;
            return result;
        }

        String dump() {
            StringBuffer sb = new StringBuffer("[ mm");
            sb.append(" patternIdx=").append(Integer.toString(this.patternIdx));
            sb.append(" nScalarTests=").append(Integer.toString(this.nScalarTests));
            sb.append(" vv=").append(this.vv.toString());
            sb.append(" vvIdx=").append(Integer.toString(this.vvIdx));
            sb.append(" vbnArr.length=").append(Integer.toString(this.vbnArr.length));
            sb.append(" vbnIdx=").append(Integer.toString(this.vbnIdx));
            sb.append(" ]");
            return sb.toString();
        }

        int getNMultiTestsRemaining() {
            return this.vbnArr.length - this.vbnIdx - this.nScalarTests;
        }

        VariableBindingNode nextTest() {
            if (this.vbnIdx >= this.vbnArr.length) {
                return null;
            }
            VariableBindingNode result = this.vbnArr[this.vbnIdx];
            ++this.vbnIdx;
            return result;
        }

        VariableBindingNode nextScalarTest() {
            if (this.vbnIdx >= this.vbnArr.length) {
                return null;
            }
            VariableBindingNode result = this.vbnArr[this.vbnIdx];
            if (result.getVariableType() == 1) {
                return null;
            }
            ++this.vbnIdx;
            return result;
        }
    }

    private class RuleAgenda {
        private Set factSetsSet = new HashSet();
        private String agendaDump = "(empty)";

        RuleAgenda(Rete r, String ruleName) {
            if (r == null || ruleName == null) {
                return;
            }
            int count = 0;
            StringBuffer sb = new StringBuffer("  ");
            try {
                Iterator agenda = r.listActivations();
                while (agenda.hasNext()) {
                    Defrule rule;
                    Activation a = (Activation)agenda.next();
                    if (a.isInactive() || !ruleName.equals((rule = a.getRule()).getName())) continue;
                    HashSet<Fact> factSet = new HashSet<Fact>();
                    Token token = a.getToken();
                    if (++count > 1) {
                        sb.append("\n  ");
                    }
                    sb.append(a.toString());
                    sb.append("\n    ").append(token.toString());
                    for (int i = 0; i < token.size(); ++i) {
                        factSet.add(token.fact(i));
                    }
                    this.factSetsSet.add(factSet);
                }
            }
            catch (Exception e) {
                WhyNot.this.analysisErrors.add("Cannot list activations: " + e.toString());
                e.printStackTrace();
            }
            if (this.size() > 0) {
                this.agendaDump = sb.toString();
            }
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "new RuleAgenda:\n" + this.toString());
            }
        }

        public int size() {
            return this.factSetsSet.size();
        }

        public String toString() {
            return this.agendaDump;
        }
    }
}

