/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.InquiryClAlgebraTutor;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowUtilities;
import edu.cmu.pact.miss.PeerLearning.SimStConversation;
import edu.cmu.pact.miss.PeerLearning.SimStPLE;
import edu.cmu.pact.miss.ProblemAssessor;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.minerva_3_1.StepAbstractor;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class AlgebraProblemAssessor
extends ProblemAssessor {
    public static final String UNKNOWN_EQUATION = "Unknown";
    public static final String ONE_STEP_EQUATION = "OneStep";
    public static final String TWO_STEP_EQUATION = "TwoStep";
    public static final String BOTH_SIDES_EQUATION = "BothSides";
    public static final String BOTH_SIDES_COMPLEX_EQUATION = "BothSidesComplex";
    public static final String COMPLEX_EQUATION = "Complex";
    public static final String SIMPLIFY_EQUATION = "Simplify";
    public static final String COMBINE_CONSTANT_TERMS_EQUATION = "CombineConstantTerms";
    public static final String NO_SOLUTION = "?";

    @Override
    public String abstractProblem(String problem) {
        StepAbstractor abstractor = new StepAbstractor();
        String abstracted = abstractor.signedAbstraction(SimSt.convertFromSafeProblemName(problem));
        return abstracted;
    }

    @Override
    public String classifyProblem(String problem) {
        String abstracted = this.abstractProblem(problem);
        String[] parts = abstracted.split("=");
        if (parts.length > 2 || parts.length < 2) {
            return UNKNOWN_EQUATION;
        }
        if (!parts[0].contains("v") && !parts[1].contains("v")) {
            return UNKNOWN_EQUATION;
        }
        if (parts[0].contains("v") && parts[1].contains("v")) {
            if (parts[0].contains("(") || parts[1].contains("(") || parts[0].split("v").length > 2 || parts[1].split("v").length > 2 || parts[0].contains("/") || parts[1].contains("/")) {
                return BOTH_SIDES_COMPLEX_EQUATION;
            }
            return BOTH_SIDES_EQUATION;
        }
        if (parts[0].contains("(") || parts[1].contains("(") || parts[0].split("v").length > 2 || parts[1].split("v").length > 2 || parts[0].contains("/") && parts[0].indexOf(47) < parts[0].indexOf(118) || parts[1].contains("/") && parts[1].indexOf(47) < parts[1].indexOf(118)) {
            return COMPLEX_EQUATION;
        }
        if (parts[0].equals("v") || parts[1].equals("v")) {
            return SIMPLIFY_EQUATION;
        }
        if (this.isNumber(parts[0])) {
            if (parts[1].equals("-v")) {
                return ONE_STEP_EQUATION;
            }
            if (parts[1].contains("-v")) {
                return TWO_STEP_EQUATION;
            }
            if (this.countNumbers(parts[1]) == 2) {
                return TWO_STEP_EQUATION;
            }
            if (this.countNumbers(parts[1]) == 1) {
                return ONE_STEP_EQUATION;
            }
            if (this.countNumbers(parts[1]) > 2) {
                return COMBINE_CONSTANT_TERMS_EQUATION;
            }
        }
        if (this.isNumber(parts[1])) {
            if (parts[0].equals("-v")) {
                return ONE_STEP_EQUATION;
            }
            if (parts[0].contains("-v")) {
                return TWO_STEP_EQUATION;
            }
            if (this.countNumbers(parts[0]) == 2) {
                return TWO_STEP_EQUATION;
            }
            if (this.countNumbers(parts[0]) == 1) {
                return ONE_STEP_EQUATION;
            }
            if (this.countNumbers(parts[0]) > 2) {
                return COMBINE_CONSTANT_TERMS_EQUATION;
            }
        }
        return UNKNOWN_EQUATION;
    }

    private boolean isNumber(String value) {
        if (value.length() == 1 && Character.isLetter(value.charAt(0)) && value.charAt(0) != 'v') {
            return true;
        }
        return value.startsWith("-") && value.length() == 2 && Character.isLetter(value.charAt(1)) && value.charAt(1) != 'v';
    }

    private int countNumbers(String value) {
        int count = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i)) || value.charAt(i) == 'v') continue;
            ++count;
        }
        return count;
    }

    @Override
    public String formatSolution(Vector<ProblemEdge> path, String problem) {
        String eqTemplate = "LHS = RHS  [SKILL]";
        String solution = "";
        String step = eqTemplate.replace("LHS = RHS", problem);
        for (ProblemEdge edge : path) {
            String selection = edge.getSelection();
            if (selection.equalsIgnoreCase("DONE")) {
                String color = this.isProblemComplete(problem, path) ? "green" : "red";
                String input = "<font color=" + color + "><b>" + edge.getSelection() + "</b></font>";
                step = step.replaceAll("SKILL", input);
                solution = solution + step + "<br>";
                step = eqTemplate;
                continue;
            }
            int idx = selection.indexOf("_") - 1;
            if (idx < 0) continue;
            char c = selection.charAt(idx);
            int column = c - 49 + 1;
            boolean isCorrect = edge.isCorrect();
            String color = isCorrect ? "green" : "red";
            String input = "<font color=" + color + "><b>" + edge.getInput() + "</b></font>";
            switch (column) {
                case 1: {
                    step = step.replace("LHS", input);
                    break;
                }
                case 2: {
                    step = step.replace("RHS", input);
                    break;
                }
                case 3: {
                    step = step.replaceAll("SKILL", input);
                    solution = solution + step + "<br>";
                    step = eqTemplate;
                }
            }
        }
        if (!step.equals(eqTemplate)) {
            solution = solution + step + "<br>";
        }
        solution = solution.replace("[SKILL]", "");
        return solution;
    }

    @Override
    public boolean isProblemComplete(String problem, Vector<ProblemEdge> solutionPath) {
        String[] problemParts = problem.split("=");
        if (problemParts.length < 2) {
            return false;
        }
        String firstPrev = problemParts[0];
        String secondPrev = problemParts[1];
        if (solutionPath == null || solutionPath.size() == 0) {
            return false;
        }
        for (ProblemEdge edge : solutionPath) {
            if (edge.getSelection().equalsIgnoreCase("DONE")) {
                if (firstPrev.length() == 1 && Character.isLetter(firstPrev.charAt(0))) {
                    boolean valid = true;
                    for (int i = 0; i < secondPrev.length(); ++i) {
                        if (secondPrev.charAt(0) == '-' && i == 0 || secondPrev.charAt(i) == '.') continue;
                        if (secondPrev.charAt(i) == '/') {
                            if (!secondPrev.substring(i + 1).contains("/")) continue;
                            valid = false;
                            break;
                        }
                        if (Character.isDigit(secondPrev.charAt(i))) continue;
                        valid = false;
                        break;
                    }
                    return !secondPrev.contains(firstPrev) && !secondPrev.contains(" ") && valid;
                }
                if (secondPrev.length() == 1 && Character.isLetter(secondPrev.charAt(0))) {
                    boolean valid = true;
                    for (int i = 0; i < firstPrev.length(); ++i) {
                        if (firstPrev.charAt(0) == '-' && i == 0 || firstPrev.charAt(i) == '.') continue;
                        if (firstPrev.charAt(i) == '/') {
                            if (!firstPrev.substring(i + 1).contains("/")) continue;
                            valid = false;
                            break;
                        }
                        if (Character.isDigit(firstPrev.charAt(i))) continue;
                        valid = false;
                        break;
                    }
                    return !firstPrev.contains(secondPrev) && !firstPrev.contains(" ");
                }
            }
            if (!edge.isCorrect()) {
                return false;
            }
            firstPrev = secondPrev;
            secondPrev = edge.getInput();
        }
        return false;
    }

    @Override
    public boolean isSolution(String problem, String solution) {
        return GameShowUtilities.isSolution(SimSt.convertFromSafeProblemName(problem), solution);
    }

    @Override
    public String determineSolution(String problem, Vector<ProblemEdge> solutionPath) {
        if (solutionPath == null) {
            return NO_SOLUTION;
        }
        ProblemEdge lastStep = solutionPath.get(solutionPath.size() - 1);
        if (!lastStep.getSelection().equalsIgnoreCase("DONE")) {
            return NO_SOLUTION;
        }
        if (solutionPath.size() <= 1) {
            return SimSt.convertFromSafeProblemName(problem);
        }
        if ((solutionPath.size() - 1) % 3 != 0) {
            return NO_SOLUTION;
        }
        String solution = solutionPath.get(solutionPath.size() - 3).getInput();
        solution = solution + "=";
        solution = solution + solutionPath.get(solutionPath.size() - 2).getInput();
        return solution;
    }

    @Override
    public String determineSolution(String problem, ProblemNode node) {
        Vector<ProblemEdge> path = this.findSolutionPath(node);
        return this.determineSolution(problem, path);
    }

    @Override
    public Vector<ProblemEdge> findSolutionPath(ProblemNode node) {
        return node.findSolutionPathAlgebra();
    }

    @Override
    public String calcProblemStepString(ProblemNode startNode, ProblemNode currentNode, String lastOperand) {
        if (currentNode == null) {
            return "";
        }
        String lastEquation = this.findLastStep(startNode, currentNode);
        if (lastEquation == null) {
            lastEquation = startNode.getName();
        }
        boolean useOperand = false;
        if (currentNode.getInDegree() > 0) {
            ProblemEdge edge = currentNode.getIncomingEdges().get(currentNode.getInDegree() - 1);
            if (edge.getSource().getInDegree() > 0) {
                ProblemEdge prevEdge = edge.getSource().getIncomingEdges().get(edge.getSource().getInDegree() - 1);
                if (edge.getSelection().contains("dorminTable3_") || prevEdge.getSelection().contains("dorminTable3_")) {
                    useOperand = true;
                }
            } else {
                useOperand = true;
            }
        }
        if (lastOperand == null) {
            lastOperand = this.findLastOperand(startNode, currentNode);
        }
        if (useOperand && lastOperand != null) {
            lastEquation = lastEquation + "[" + lastOperand + "]";
        }
        return lastEquation;
    }

    @Override
    public String findLastStep(ProblemNode startNode, ProblemNode problemNode) {
        String lastEquation;
        Vector pathEdges = InquiryClAlgebraTutor.findPathDepthFirst(startNode, problemNode);
        String string = lastEquation = pathEdges != null ? this.lastEquation(pathEdges) : problemNode.getName();
        if (lastEquation == null) {
            lastEquation = startNode.getName();
        }
        return lastEquation;
    }

    private String lastEquation(Vector pathEdges) {
        String lastEquation = null;
        int edgeCount = 0;
        ProblemEdge[] edgeQueue = new ProblemEdge[3];
        for (int i = 0; i < pathEdges.size(); ++i) {
            edgeQueue[edgeCount++] = (ProblemEdge)pathEdges.get(i);
            if (edgeCount != 3) continue;
            String[] eqSide = new String[2];
            for (int j = 0; j < 2; ++j) {
                String input;
                EdgeData edgeData = edgeQueue[j + 1].getEdgeData();
                eqSide[j] = input = (String)edgeData.getInput().get(0);
            }
            lastEquation = eqSide[0] + "=" + eqSide[1];
            edgeCount = 0;
            for (int k = 0; k < 3; ++k) {
                edgeQueue[k] = null;
            }
        }
        return lastEquation;
    }

    @Override
    public String findLastOperand(ProblemNode startNode, ProblemNode problemNode) {
        Vector pathEdges = InquiryClAlgebraTutor.findPathDepthFirst(startNode, problemNode);
        String lastOperand = "";
        if (pathEdges == null) {
            return lastOperand;
        }
        int edgeCount = 0;
        ProblemEdge[] edgeQueue = new ProblemEdge[3];
        for (int i = 0; i < pathEdges.size(); ++i) {
            EdgeData edgeData;
            String lastSkill;
            edgeQueue[edgeCount++] = (ProblemEdge)pathEdges.get(i);
            if (edgeCount == 1 && EqFeaturePredicate.isValidSimpleSkill((lastSkill = (String)(edgeData = edgeQueue[edgeCount - 1].getEdgeData()).getInput().get(0)).split(" ")[0])) {
                lastOperand = lastSkill;
            }
            if (edgeCount != 3) continue;
            edgeCount = 0;
            for (int k = 0; k < 3; ++k) {
                edgeQueue[k] = null;
            }
        }
        return lastOperand;
    }

    @Override
    public boolean performInteractiveAnswerCheck(SimStPLE ple, String problem, String solution) {
        DecimalFormat df = new DecimalFormat("#.#####");
        if (ple == null) {
            return true;
        }
        SimStConversation conversation = ple.getConversation();
        String var = this.determineVariable(solution);
        String value = this.determineValue(solution);
        String[] problemParts = SimSt.convertFromSafeProblemName(problem).split("=");
        boolean correctness = false;
        if (var.length() == 0 || value.length() == 0) {
            String message = conversation.getMessage("NO_VAR_VALUE_CHECK_ANS");
            ple.giveMessage(message);
            this.pause();
        } else {
            String message = conversation.getMessage("CHECK_ANSWER", SimSt.convertFromSafeProblemName(problem), value, var, -1);
            ple.giveMessage(message);
            this.pause();
            ArrayList<String> startStates = ple.getStartStateElements();
            Double[] plugIns = new Double[2];
            String[] plugStrs = new String[2];
            for (int i = 0; i < startStates.size() && i < problemParts.length && i < 2; ++i) {
                String selection = "in" + ple.getComponentName(startStates.get(i));
                String plugged = this.plugInValue(problemParts[i], var, value);
                plugIns[i] = this.evaluateExpression(plugged);
                plugStrs[i] = plugIns[i] - (double)plugIns[i].intValue() == 0.0 ? "" + plugIns[i].intValue() : "" + df.format(plugIns[i]);
                String plugExpr = "";
                plugExpr = problemParts[i].equals(plugStrs[i]) ? plugStrs[i] : plugged + " or " + plugStrs[i];
                trace.out("ss", "ProblemParts[i] " + problemParts[i]);
                trace.out("ss", "Plugged " + plugged);
                trace.out("ss", "PlugIns[i] " + plugIns[i]);
                trace.out("ss", "PlugStrs[i] " + plugStrs[i]);
                trace.out("ss", "PlugExpr " + plugExpr);
                if (problemParts[i].contains(var)) {
                    ple.giveMessage(conversation.getMessage("PLUG_IN", selection, problemParts[i], plugExpr, i));
                } else {
                    ple.giveMessage(conversation.getMessage("NO_VAR_TO_PLUG", selection, problemParts[i], plugExpr, i));
                }
                this.pause();
            }
            boolean bl = correctness = Math.abs(plugIns[0] - plugIns[1]) < 1.0E-4;
            if (correctness) {
                ple.giveMessage(conversation.getMessage("BALANCE_CHECK_ANSWER", "", plugStrs[0], "" + plugStrs[1], -1));
            } else {
                ple.giveMessage(conversation.getMessage("NO_BALANCE_CHECK_ANSWER", "", "" + plugStrs[0], "" + plugStrs[1], -1));
            }
            this.pause();
        }
        return correctness;
    }

    private void pause() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String plugInValue(String expression, String var, String value) {
        String result = expression.replaceAll(var, "(" + value + ")");
        return GameShowUtilities.insertMultiplySymbols(result);
    }

    private double evaluateExpression(String expression) {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("JavaScript");
        String eval2 = null;
        try {
            eval2 = "" + engine.eval(expression);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return Double.parseDouble(eval2);
    }

    private String determineVariable(String equation) {
        String var = "";
        for (int j = 0; j < equation.length(); ++j) {
            if (!Character.isLetter(equation.charAt(j))) continue;
            var = "" + equation.charAt(j);
        }
        return var;
    }

    private String determineValue(String equation) {
        String[] solParts = equation.split("=");
        for (int i = 0; i < solParts.length; ++i) {
            boolean containsVar = false;
            for (int j = 0; j < solParts[i].length(); ++j) {
                if (!Character.isLetter(solParts[i].charAt(j))) continue;
                containsVar = true;
            }
            if (containsVar) continue;
            return solParts[i];
        }
        return "";
    }
}

