/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.DStoBRD;

import edu.cmu.pact.miss.userDef.algebra.IsEquivalent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.Vector;

public class DStoCTAT {
    private final String LHS_SELECTION = "LHS";
    private final String RHS_SELECTION = "RHS";
    private final String OK_OUTCOME = "OK";
    private final String AUTOFILL_SKILL = "auto-typein";
    private final String HINT_SKILL = "hint";
    private String[] SKILL_NAMES = new String[]{"add", "aproot", "clt", "distribute", "divide", "expon", "fact", "ivm", "mt", "multiply", "rds", "rf", "subtract", "left", "right"};
    private Vector skillNames;
    private int numDsTransactions = 0;
    private int numCtatTransactions = 0;
    private int typeinWritten = 0;
    private boolean firstTransactionInProblem = true;
    IsEquivalent isEquivalent = new IsEquivalent();
    private String lastProblem = "";
    private String lastProblemID = "";

    Vector getSkillNames() {
        if (this.skillNames == null) {
            this.skillNames = new Vector();
            for (int i = 0; i < this.SKILL_NAMES.length; ++i) {
                this.skillNames.add(this.SKILL_NAMES[i]);
            }
        }
        return this.skillNames;
    }

    private void incNumDsTransactions() {
        ++this.numDsTransactions;
    }

    private int getNumDsTransactions() {
        return this.numDsTransactions;
    }

    private void resetNumDsTransactions() {
        this.numDsTransactions = 0;
    }

    private void incNumCtatTransactions() {
        ++this.numCtatTransactions;
    }

    private int getNumCtatTransactions() {
        return this.numCtatTransactions;
    }

    private void resetNumCtatTransactions() {
        this.numCtatTransactions = 0;
    }

    BufferedWriter openOutputFile(String ctatFileName) throws IOException {
        FileWriter fout = new FileWriter(new File(ctatFileName));
        BufferedWriter out = new BufferedWriter(fout);
        String header = "id\tstudent\tproblem\tskill\tselection\tinput\tstep\toutcome\n";
        out.write(header);
        return out;
    }

    BufferedReader openInputFile(String dsFileName) throws IOException {
        return new BufferedReader(new FileReader(dsFileName));
    }

    void convertDStoCTAT(String dsFile, String ctatFile) throws IOException {
        Scanner in = new Scanner(new FileReader(dsFile));
        BufferedWriter out = this.openOutputFile(ctatFile);
        CtatTransaction previousTransaction = null;
        this.resetFirstTransactionInProblem();
        this.resetNumCtatTransactions();
        this.resetNumDsTransactions();
        Vector<CtatTransaction> incompletes = new Vector<CtatTransaction>();
        String dsReadIn = in.nextLine();
        dsReadIn = in.nextLine();
        this.incNumDsTransactions();
        while (in.hasNext()) {
            CtatTransaction ctatTransaction = this.convertDStoCtatTransaction(dsReadIn);
            ArrayList<CtatTransaction> problemList = new ArrayList<CtatTransaction>();
            problemList.add(ctatTransaction);
            String problemName = ctatTransaction.problem;
            while (in.hasNext()) {
                dsReadIn = in.nextLine();
                this.incNumDsTransactions();
                ctatTransaction = this.convertDStoCtatTransaction(dsReadIn);
                if (!problemName.equals(ctatTransaction.problem)) break;
                problemList.add(ctatTransaction);
            }
            if (this.hasManualTypein(problemList)) {
                CtatTransaction manualTransaction = null;
                boolean first = true;
                for (int x = 0; x < problemList.size(); ++x) {
                    CtatTransaction currentTransaction = problemList.get(x);
                    if (first) {
                        this.resetFirstTransactionInProblem();
                        previousTransaction = null;
                        first = false;
                    } else {
                        this.denyFirstTransactionInProblem();
                    }
                    if (currentTransaction.hasSelection()) {
                        String equation;
                        if (this.updateSelection(currentTransaction, incompletes)) {
                            this.writeCtatTransactionToFile(out, incompletes);
                        } else {
                            incompletes.clear();
                        }
                        if (this.nextIsManualTypein(problemList, x)) {
                            if (previousTransaction != null && !this.previousWasManualTypein(problemList, x)) {
                                equation = this.getStepEquation(currentTransaction);
                                this.writeAutoTypeinTransactionToFile(out, equation, previousTransaction, incompletes);
                            }
                            manualTransaction = currentTransaction;
                        } else if (currentTransaction.skill.equals("left") || currentTransaction.skill.equals("right")) {
                            if (manualTransaction != null) {
                                this.writeTypeinTransactionToFile(out, currentTransaction, manualTransaction.skill);
                            }
                        } else if (!(previousTransaction == null || previousTransaction.skill.equals("left") || previousTransaction.skill.equals("right") || manualTransaction != null && manualTransaction.skill.equals(previousTransaction.skill))) {
                            equation = this.getStepEquation(currentTransaction);
                            this.writeAutoTypeinTransactionToFile(out, equation, previousTransaction, incompletes);
                        }
                        if (!currentTransaction.skill.equals("left") && !currentTransaction.skill.equals("right")) {
                            this.writeCtatTransactionToFile(out, currentTransaction);
                        }
                        incompletes.clear();
                    }
                    previousTransaction = currentTransaction;
                }
                continue;
            }
            boolean first = true;
            for (CtatTransaction currentTransaction : problemList) {
                if (first) {
                    this.resetFirstTransactionInProblem();
                    previousTransaction = null;
                    first = false;
                } else {
                    this.denyFirstTransactionInProblem();
                }
                if (currentTransaction.hasSelection()) {
                    if (this.updateSelection(currentTransaction, incompletes)) {
                        this.writeCtatTransactionToFile(out, incompletes);
                    } else {
                        incompletes.clear();
                    }
                    if (previousTransaction != null) {
                        String equation = this.getStepEquation(currentTransaction);
                        this.writeAutoTypeinTransactionToFile(out, equation, previousTransaction, incompletes);
                    }
                    this.writeCtatTransactionToFile(out, currentTransaction);
                    incompletes.clear();
                } else if (currentTransaction.hasSkill()) {
                    incompletes.add(currentTransaction);
                }
                previousTransaction = currentTransaction;
            }
        }
        in.close();
        out.close();
        System.out.println(this.getNumDsTransactions() + " DS transactions read.");
        System.out.println(this.getNumCtatTransactions() + " CTAT transactions wrote.");
    }

    private boolean hasDifferentProblemName(CtatTransaction previousTransaction, CtatTransaction ctatTransaction) {
        return previousTransaction == null || !previousTransaction.problem.equals(ctatTransaction.problem);
    }

    private void writeAutoTypeinTransactionToFile(BufferedWriter out, String equation, CtatTransaction previousTransaction, Vector incompletes) throws IOException {
        CtatTransaction autoFillTransaction;
        if (this.isFirstTransactionInProblem()) {
            return;
        }
        if (!this.isOK(previousTransaction.outcome)) {
            return;
        }
        if (!this.isTypedIn("LHS", incompletes)) {
            autoFillTransaction = this.createCtatTransactionAutoFill("LHS", previousTransaction, equation);
            this.writeCtatTransactionToFile(out, autoFillTransaction);
        }
        if (!this.isTypedIn("RHS", incompletes)) {
            autoFillTransaction = this.createCtatTransactionAutoFill("RHS", previousTransaction, equation);
            this.writeCtatTransactionToFile(out, autoFillTransaction);
        }
    }

    private void writeTypeinTransactionToFile(BufferedWriter out, CtatTransaction currentTransaction, String skillAction) throws IOException {
        String id = currentTransaction.id;
        String student = currentTransaction.student;
        String problem = currentTransaction.problem;
        String skill = "typein";
        String selection = currentTransaction.selection;
        if (currentTransaction.skill.equals("left")) {
            selection = "LHS";
        } else if (currentTransaction.skill.equals("right")) {
            selection = "RHS";
        }
        String input = currentTransaction.input;
        String step = currentTransaction.step;
        String outcome = currentTransaction.outcome;
        CtatTransaction typeinTransaction = new CtatTransaction(id, student, problem, skill, selection, input, step, outcome);
        this.writeCtatTransactionToFile(out, typeinTransaction);
    }

    private boolean isFirstTransactionInProblem() {
        return this.firstTransactionInProblem;
    }

    private void denyFirstTransactionInProblem() {
        this.firstTransactionInProblem = false;
    }

    private void resetFirstTransactionInProblem() {
        this.firstTransactionInProblem = true;
    }

    CtatTransaction createCtatTransactionAutoFill(String side, CtatTransaction ctatTransaction, String equation) {
        String id = ctatTransaction.id;
        String student = ctatTransaction.student;
        String problem = ctatTransaction.problem;
        String skill = "auto-typein";
        String selection = side;
        String[] sides = equation.split("=");
        String input = null;
        if ("LHS".equalsIgnoreCase(side)) {
            input = sides[0];
        } else if ("RHS".equalsIgnoreCase(side)) {
            input = sides[1];
        }
        if (input != null) {
            input = input.replaceAll(" ", "");
        }
        String step = "AutoTypein by DStoCTAT";
        String outcome = "OK";
        return new CtatTransaction(id, student, problem, skill, selection, input, step, outcome);
    }

    private boolean isTypedIn(String side, Vector incompletes) {
        boolean isTypedIn = false;
        for (int i = 0; i < incompletes.size(); ++i) {
            CtatTransaction transaction = (CtatTransaction)incompletes.get(i);
            if (!this.isOK(transaction.outcome) || !side.equals(transaction.selection)) continue;
            isTypedIn = true;
            break;
        }
        return isTypedIn;
    }

    private boolean updateSelection(CtatTransaction ctatTransaction, Vector incompletes) {
        String equation = this.getStepEquation(ctatTransaction);
        String[] sides = equation.split("=");
        String lhsStr = sides[0].replaceFirst(" $", "");
        String rhsStr = sides[1].replaceFirst("^ ", "");
        String currentSelection = null;
        boolean updateSelection = true;
        for (int i = incompletes.size() - 1; i >= 0; --i) {
            CtatTransaction transaction = (CtatTransaction)incompletes.get(i);
            if (!transaction.problem.equals(ctatTransaction.problem)) {
                return this.updateSelectionLastStep(incompletes);
            }
            if (!this.isOK(transaction.outcome)) {
                if (currentSelection == null) continue;
                transaction.selection = currentSelection;
                continue;
            }
            String selection = null;
            if (this.equalsIgnoreSpaceCase(transaction.input, lhsStr)) {
                selection = "LHS";
            } else if (this.equalsIgnoreSpaceCase(transaction.input, rhsStr)) {
                selection = "RHS";
            } else if (this.isEquivalent(transaction.input, lhsStr)) {
                selection = "LHS";
            } else if (this.isEquivalent(transaction.input, rhsStr)) {
                selection = "RHS";
            } else if ("typein".equals(transaction.skill)) {
                // empty if block
            }
            transaction.selection = selection;
            if (selection == null) {
                currentSelection = null;
                continue;
            }
            if (!selection.equals(currentSelection)) {
                currentSelection = selection;
                continue;
            }
            updateSelection = false;
            System.out.println("selection mismatch: " + transaction);
            break;
        }
        return updateSelection;
    }

    private boolean isEquivalent(String exp1, String exp2) {
        String result = this.isEquivalent.inputMatcher(exp1, exp2);
        return result != null;
    }

    private boolean updateSelectionLastStep(Vector incompletes) {
        String selection = null;
        for (int i = incompletes.size() - 1; i >= 0; --i) {
            CtatTransaction transaction = (CtatTransaction)incompletes.get(i);
            if (!this.isOK(transaction.outcome)) {
                if (selection != null) {
                    transaction.selection = selection;
                    continue;
                }
                this.updateSelectionEndNonOk(null, incompletes);
                continue;
            }
            String equation = this.getStepEquation(transaction);
            String[] sides = equation.split("=");
            selection = sides[0].indexOf(transaction.input) != -1 ? "LHS" : (sides.length > 1 && sides[1].indexOf(transaction.input) != -1 ? "RHS" : "N/A");
            transaction.selection = selection;
        }
        return true;
    }

    private void updateSelectionErrorTrouble(CtatTransaction ctatTransaction, Vector incompletes, CtatTransaction transaction) {
        System.out.println("updateSelection had trouble identify selection for ");
        System.out.println(transaction);
        System.out.println("ctatTransaction:");
        System.out.println(ctatTransaction);
        System.out.println("incompletes:");
        for (int j = 0; j < incompletes.size(); ++j) {
            System.out.println((CtatTransaction)incompletes.get(j));
        }
    }

    private void updateSelectionEndNonOk(CtatTransaction ctatTransaction, Vector incompletes) {
        System.out.println("updateSelection gotten transactions ending with non-OK outcome");
        System.out.println("ctatTransaction:");
        System.out.println(ctatTransaction);
        System.out.println("incompletes:");
        for (int j = 0; j < incompletes.size(); ++j) {
            System.out.println((CtatTransaction)incompletes.get(j));
        }
    }

    private boolean equalsIgnoreSpaceCase(String input, String string) {
        return input.replaceAll(" ", "").equalsIgnoreCase(string.replaceAll(" ", ""));
    }

    private boolean isOK(String outcome) {
        return "OK".equalsIgnoreCase(outcome);
    }

    private void writeCtatTransactionToFile(BufferedWriter out, Vector incompletes) throws IOException {
        for (int i = 0; i < incompletes.size(); ++i) {
            this.writeCtatTransactionToFile(out, (CtatTransaction)incompletes.get(i));
        }
    }

    private void writeCtatTransactionToFile(BufferedWriter out, CtatTransaction ctatTransaction) throws IOException {
        String transaction = ctatTransaction.id + "\t";
        transaction = transaction + ctatTransaction.student + "\t";
        transaction = transaction + ctatTransaction.problem + "\t";
        transaction = transaction + ctatTransaction.skill + "\t";
        transaction = transaction + ctatTransaction.selection + "\t";
        transaction = transaction + ctatTransaction.input + "\t";
        transaction = transaction + ctatTransaction.step + "\t";
        transaction = transaction + ctatTransaction.outcome + "\n";
        out.write(transaction);
        this.incNumCtatTransactions();
    }

    private CtatTransaction convertDStoCtatTransaction(String dsReadIn) {
        String[] tokens = dsReadIn.split("\t");
        String id = tokens[2];
        String student = tokens[1];
        String skill = tokens[16];
        String selection = this.identifySelection(skill);
        String input = this.reformInputString(tokens[17]);
        String step = this.reformInputString(tokens[12]);
        String problem = tokens[11];
        String outcome = tokens[14];
        if (this.isHint(outcome)) {
            skill = "hint";
        }
        return new CtatTransaction(id, student, problem, skill, selection, input, step, outcome);
    }

    private String reformInputString(String stepName) {
        return stepName.replaceAll("\"", "").replaceAll(",", "");
    }

    private boolean isHint(String outcome) {
        return outcome != null && outcome.indexOf("HINT") != -1;
    }

    private String identifySelection(String skill) {
        return this.getSkillNames().contains(skill) ? "SKILL" : "";
    }

    private String getLastProblem() {
        return this.lastProblem;
    }

    private void setLastProblem(String lastProblem) {
        this.lastProblem = lastProblem;
    }

    private String getLastProblemID() {
        return this.lastProblemID;
    }

    private void setLastProblemID(String lastProblemID) {
        this.lastProblemID = lastProblemID;
    }

    String identifyProblemName(String problemId, String stepName) {
        String problemName = this.getProblemName(stepName);
        if (this.getLastProblemID().equals(problemId) && this.couldBeDerivative(this.getLastProblem(), problemName)) {
            problemName = this.getLastProblem();
        } else {
            this.setLastProblemID(problemId);
            this.setLastProblem(problemName);
        }
        return problemName;
    }

    private boolean couldBeDerivative(String lastProblemName, String problemName) {
        if (problemName.indexOf(61) == -1) {
            return true;
        }
        char var1 = this.getFirstVariable(lastProblemName);
        char var2 = this.getFirstVariable(problemName);
        return var1 == '\uffffffff' || var2 == '\uffffffff' || var1 == var2;
    }

    private char getFirstVariable(String lastProblemName) {
        char[] letters = lastProblemName.toLowerCase().toCharArray();
        for (int i = 0; i < letters.length; ++i) {
            if ('a' > letters[i] || letters[i] > 'z') continue;
            return letters[i];
        }
        return '\uffff';
    }

    private String getProblemName(String stepName) {
        return stepName.substring(stepName.indexOf(32) + 1);
    }

    private String getStepEquation(CtatTransaction ctatTransaction) {
        return ctatTransaction.step;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("DStoCTAT <input_file> <output_file>");
            System.out.println("You must specify two arguments for the file names.");
            System.exit(-1);
        }
        try {
            new DStoCTAT().convertDStoCTAT(args[0], args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean hasManualTypein(ArrayList<CtatTransaction> problemList) {
        for (CtatTransaction c : problemList) {
            if (!c.skill.equals("left") && !c.skill.equals("right")) continue;
            return true;
        }
        return false;
    }

    private boolean nextIsManualTypein(ArrayList<CtatTransaction> problemList, int index) {
        String currentSkill = problemList.get((int)index).skill;
        if (currentSkill.equals("left") || currentSkill.equals("right")) {
            return false;
        }
        for (int i = index + 1; i < problemList.size(); ++i) {
            CtatTransaction c = problemList.get(i);
            if (!c.hasSelection()) continue;
            return c.skill.equals("left") || c.skill.equals("right");
        }
        return false;
    }

    private boolean previousWasManualTypein(ArrayList<CtatTransaction> problemList, int index) {
        String currentSkill = problemList.get((int)index).skill;
        if (currentSkill.equals("left") || currentSkill.equals("right")) {
            return true;
        }
        for (int i = index - 1; i >= 0; ++i) {
            CtatTransaction c = problemList.get(i);
            if (!c.hasSelection()) continue;
            return c.skill.equals("left") || c.skill.equals("right");
        }
        return false;
    }

    public class CtatTransaction {
        String id;
        String student;
        String problem;
        String skill;
        String selection;
        String input;
        String step;
        String outcome;

        public CtatTransaction(String id, String student, String problem, String skill, String selection, String input, String step, String outcome) {
            this.id = id;
            this.student = student;
            this.problem = problem;
            this.skill = skill;
            this.selection = selection;
            this.input = input;
            this.step = step;
            this.outcome = outcome;
        }

        boolean hasSkill() {
            return !this.skill.equals("");
        }

        boolean hasSelection() {
            return !this.selection.equals("");
        }

        public String toString() {
            return "<" + this.id + " [student " + this.student + "][problem " + this.problem + "][skill " + this.skill + "][selection " + this.selection + "][input " + this.input + "][step " + this.step + "][outcome " + this.outcome + "]>";
        }
    }
}

