/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.Rule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import jess.Fact;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import mylib.CombinatoricException;
import mylib.Permutations;

public class FOAOrder {
    static boolean orderFOA(Instruction instr, Rule r, MTRete mtRete) {
        boolean useInput;
        ArrayList wmePaths = r.getLhsPath();
        Vector<String> varNames = new Vector<String>();
        for (int i = 0; i < instr.numFocusOfAttention(); ++i) {
            String curPath = (String)wmePaths.get(i);
            String[] pathVars = curPath.split("\n");
            String binding = pathVars[pathVars.length - 1];
            varNames.add(i, binding.substring(0, binding.indexOf(" ")));
        }
        Vector seeds = instr.getSeeds();
        Vector<String> foaNames = new Vector<String>();
        boolean bl = useInput = instr.numFocusOfAttention() > instr.numSeeds();
        if (useInput) {
            String inputName = Instruction.getNameFromFoa(instr.getFocusOfAttention(0));
            foaNames.add(inputName);
        }
        Iterator iter = seeds.iterator();
        while (iter.hasNext()) {
            foaNames.add(Instruction.getNameFromFoa((String)iter.next()));
        }
        HashMap wmeToVar = FOAOrder.findFoaToVarMappings(r.getLhsTopologicalConsts(), useInput, foaNames, varNames, mtRete);
        if (wmeToVar != null) {
            String[] orderedFOA = new String[instr.numFocusOfAttention()];
            for (int foaNum = 0; foaNum < instr.numFocusOfAttention(); ++foaNum) {
                String curFoa = instr.getFocusOfAttention(foaNum);
                String curName = Instruction.getNameFromFoa(curFoa);
                String variable = (String)wmeToVar.get(curName);
                int index = varNames.indexOf(variable);
                orderedFOA[index] = curFoa;
            }
            Vector<String> v = new Vector<String>(orderedFOA.length);
            for (int i = 0; i < orderedFOA.length; ++i) {
                v.add(orderedFOA[i]);
            }
            instr.setFocusOfAttention(v);
            return true;
        }
        return false;
    }

    private static HashMap findFoaToVarMappings(ArrayList constraints, boolean useInput, Vector foaNames, Vector varNames, MTRete mtRete) {
        HashMap theMap = new HashMap();
        Object bestMap = null;
        int maxSatisfied = 0;
        if (useInput) {
            String inputVar = (String)varNames.lastElement();
            theMap.put(foaNames.firstElement(), inputVar);
            foaNames.remove(0);
        }
        try {
            Permutations p = new Permutations(foaNames.toArray(), foaNames.size());
            while (p.hasMoreElements()) {
                int numSatisfied;
                Object[] permutation = (Object[])p.nextElement();
                for (int i = 0; i < foaNames.size(); ++i) {
                    theMap.put(permutation[i], varNames.get(i));
                }
                try {
                    numSatisfied = FOAOrder.countConstrantsSatisfied(theMap, constraints, mtRete);
                }
                catch (JessException e) {
                    e.printStackTrace();
                    continue;
                }
                if (numSatisfied <= maxSatisfied) continue;
                maxSatisfied = numSatisfied;
                bestMap = theMap.clone();
            }
        }
        catch (CombinatoricException e) {
            e.printStackTrace();
            return null;
        }
        return (HashMap)bestMap;
    }

    private static int countConstrantsSatisfied(HashMap wmeToVarMap, ArrayList constranits, MTRete mtRete) throws JessException {
        int numSatisfied = 0;
        HashMap varNameToFact = new HashMap();
        for (String WMEName : wmeToVarMap.keySet()) {
            String varName = (String)wmeToVarMap.get(WMEName);
            Fact f = mtRete.getFactByName(WMEName);
            varNameToFact.put(varName, f);
        }
        for (String curConstraint : constranits) {
            curConstraint = curConstraint.substring(curConstraint.indexOf("(") + 1, curConstraint.lastIndexOf(")"));
            String[] constraintParts = curConstraint.split(" ");
            String constraintName = constraintParts[0];
            Userfunction function = mtRete.findUserfunction(constraintName);
            ValueVector args = new ValueVector();
            args.add(constraintName);
            for (int argnum = 1; argnum < constraintParts.length; ++argnum) {
                Fact f = (Fact)varNameToFact.get(constraintParts[argnum]);
                args.add((Object)f);
            }
            if (!function.call(args, mtRete.getGlobalContext()).equals(new Value(true))) continue;
            ++numSatisfied;
        }
        return numSatisfied;
    }
}

