/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.Relation;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.WebStartFileDownloader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class FoilData
implements Serializable {
    private static final long serialVersionUID = 2893338886802027987L;
    private static String foilName = "foil6" + (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? ".exe" : "");
    public static String foilBase = null;
    private static String FOIL_EXE;
    private static String FOIL_JARDIR;
    public static boolean WEBSTARTMODE;
    private final String FOIL_LOG = "foil-log";
    private final String LOG_DIR = "./";
    private String foilLogDir = "./";
    public static final String TYPE_NAME = "V";
    public static final int TYPE_NO = 0;
    public final String USE_DEFAULT_TUPLES = "Use default foil tuples";
    private String foilMaxTuples = "Use default foil tuples";
    private final String FOIL_TARGET_LINE = "^Clause [0-9]+:.*";
    private String targetName;
    private Relation targetRelation = null;
    private Hashtable relationHash = new Hashtable();
    private HashMap featurePredicateHash;
    Vector allValues = new Vector();
    private Vector decomposers;
    int procNum = 0;
    private static final String FOIL_EXECUTABLE = "foil6";

    public static void setFoilBase(String foilBase) {
        FoilData.foilBase = foilBase;
        FOIL_EXE = foilBase + "/" + foilName;
    }

    private void setFoilBase() {
        if (trace.getDebugCode("gusIL")) {
            trace.out("gusIL", "SimSt.getHomeDir() = " + SimSt.getHomeDir());
        }
        foilBase = this.isFoilExistIn(SimSt.getHomeDir() + "/FOIL6") ? SimSt.getHomeDir() + "/FOIL6" : "f:/Project/CTAT/ML/FOIL6";
    }

    private boolean isFoilExistIn(String dir) {
        return new File(dir).exists();
    }

    public String getFoilExe() {
        return FOIL_EXE;
    }

    public void setFoilDir() {
        foilBase = System.getProperty("ssFoilBase");
        if (foilBase != null) {
            foilBase = SimSt.stripQuotes(foilBase);
        }
        if (trace.getDebugCode("gusIL")) {
            trace.out("gusIL", "foilBase = " + foilBase);
        }
        if (foilBase == null) {
            if (trace.getDebugCode("gusIL")) {
                trace.out("gusIL", "entered if");
            }
            this.setFoilBase();
        }
        FOIL_EXE = foilBase + "/" + foilName;
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "setFoilDir for FOIL_EXE: " + FOIL_EXE);
        }
    }

    private String getFoilLogDir() {
        return this.foilLogDir;
    }

    public void setFoilLogDir(String foilLogDir) {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "setFoilLogDir: " + foilLogDir);
        }
        this.foilLogDir = foilLogDir;
        File file = new File(foilLogDir);
        if (!file.exists() || !file.isDirectory()) {
            file.delete();
            file.mkdir();
        }
    }

    private String getMaxTuples() {
        return this.foilMaxTuples;
    }

    private void setMaxTuples(String foilMaxtuples) {
        this.foilMaxTuples = foilMaxtuples;
    }

    String getTargetName() {
        return this.targetName;
    }

    private void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public Relation getTargetRelation() {
        return this.targetRelation;
    }

    public int getTargetRelationArity() {
        return this.targetRelation.getArity();
    }

    private void setTargetRelation(Relation targetRelation) {
        this.targetRelation = targetRelation;
    }

    private void addRelation(String predicate, Relation relation) {
        this.relationHash.put(predicate, relation);
    }

    private Relation getRelation(String predicate) {
        return (Relation)this.relationHash.get(predicate);
    }

    private Enumeration getPredicates() {
        return this.relationHash.keys();
    }

    void setFeaturePredicateHash(HashMap hash) {
        this.featurePredicateHash = hash;
    }

    FeaturePredicate getFeaturePredicate(String predicateName) {
        return (FeaturePredicate)this.featurePredicateHash.get(predicateName);
    }

    public FoilData() {
        this.setFoilDir();
    }

    public FoilData(String name, int arity, Vector predicates, Vector focusOfAttention, HashMap featurePredicateHash, String foilLogDir, String maxTuples) {
        this();
        this.setTargetName(name);
        this.setTargetRelation(new Relation(this.getTargetName(), arity, featurePredicateHash));
        this.setFeaturePredicateHash(featurePredicateHash);
        this.setFoilLogDir(foilLogDir);
        this.setMaxTuples(maxTuples);
        this.getTargetRelation().setTargetArgType(focusOfAttention);
        for (int i = 0; i < predicates.size(); ++i) {
            String predicateName = (String)predicates.get(i);
            this.addRelation(predicateName, new Relation(predicateName, featurePredicateHash));
        }
    }

    void addInstruction(Instruction instruction) {
        Vector targetArguments = instruction.targetArguments();
        this.getTargetRelation().addPositiveTuple(targetArguments);
        Vector newValues = instruction.getValues();
        this.allValues = this.addNewElements(this.allValues, newValues);
        if (this.decomposers != null) {
            this.allValues = this.addNewElements(this.allValues, SimSt.chainDecomposedValues(newValues, this.decomposers));
        }
        Enumeration predicates = this.getPredicates();
        while (predicates.hasMoreElements()) {
            String predicate = (String)predicates.nextElement();
            Relation relation = this.getRelation(predicate);
            Vector outputValues = relation.evalRelation(this.allValues);
            if (outputValues == null) continue;
            this.allValues = this.addNewElements(this.allValues, outputValues);
            String values = "";
            for (int i = 0; i < outputValues.size(); ++i) {
                values = values + (String)outputValues.get(i) + ", ";
            }
        }
    }

    void addNegativeInstruction(Instruction instruction) {
        Vector newValues = instruction.getValues();
        this.allValues = this.addNewElements(this.allValues, newValues);
        if (this.decomposers != null) {
            this.allValues = this.addNewElements(this.allValues, SimSt.chainDecomposedValues(newValues, this.decomposers));
        }
        Enumeration predicates = this.getPredicates();
        while (predicates.hasMoreElements()) {
            String predicate = (String)predicates.nextElement();
            Relation relation = this.getRelation(predicate);
            Vector outputValues = relation.evalRelation(this.allValues);
            if (outputValues == null) continue;
            this.allValues = this.addNewElements(this.allValues, outputValues);
            String values = "";
            for (int i = 0; i < outputValues.size(); ++i) {
                values = values + (String)outputValues.get(i) + ", ";
            }
        }
    }

    public int getFoilArity() {
        return this.getTargetRelation().getArity();
    }

    void signalTargetNegative(Instruction instruction) {
        int instArity = instruction.numFocusOfAttention() - 1;
        int theArity = this.getTargetRelation().getArity();
        if (theArity == instArity) {
            Vector targetArguments = instruction.targetArguments();
            this.getTargetRelation().addNegativeTuple(targetArguments);
        } else {
            new Exception("Error: instruction's arity != foilData's arity").printStackTrace();
        }
    }

    void signalTargetExplicitNegative(Instruction instruction) {
        int instArity = instruction.numFocusOfAttention() - 1;
        int theArity = this.getTargetRelation().getArity();
        if (theArity == instArity) {
            Vector targetArguments = instruction.targetArguments();
            this.getTargetRelation().addExplicitNegativeTuple(targetArguments);
        } else {
            new Exception("Error: instruction's arity != foilData's arity").printStackTrace();
        }
    }

    private Vector arrayToVector(Object[] array) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < array.length; ++i) {
            v.add(array[i]);
        }
        return v;
    }

    private List makeList(Enumeration en) {
        Vector l = new Vector();
        while (en.hasMoreElements()) {
            Object[] wmeArray = (Object[])en.nextElement();
            Vector vector = this.arrayToVector(wmeArray);
        }
        return l;
    }

    public void printInfo() {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", FOIL_EXE);
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", this.getFoilLogDir());
        }
    }

    Vector searchFeatures(String numRules, String numSteps) {
        Vector<Vector> features = null;
        String numP = "00" + this.getTargetRelation().numPosTuples();
        numP = numP.substring(Math.min(numP.length() - 2, 2));
        String numN = "00" + this.getTargetRelation().numNegTuples();
        numN = numN.substring(Math.min(numN.length() - 2, 2));
        String id = "R" + numRules + "S" + numSteps + "-P" + numP + "N" + numN;
        String dataFileName = this.getFoilLogDir();
        dataFileName = dataFileName + this.getTargetName() + "-" + id + ".d";
        String foilLogFileName = this.getFoilLogDir();
        foilLogFileName = foilLogFileName + this.getTargetName() + "-" + id + "-log.txt";
        this.runFoil(dataFileName, foilLogFileName, true);
        if (!WEBSTARTMODE) {
            try {
                dataFileName = new File(dataFileName).getCanonicalPath();
                foilLogFileName = new File(foilLogFileName).getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                foilLogFileName = new File(foilLogFileName).getCanonicalPath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            FileReader logReader = new FileReader(foilLogFileName);
            BufferedReader logFile = new BufferedReader(logReader);
            String logLine = "";
            while ((logLine = logFile.readLine()) != null) {
                if (!logLine.matches("^Clause [0-9]+:.*")) continue;
                Vector feature = this.extractFeaturesFromLogLine(logLine);
                if (feature != null) {
                    if (features == null) {
                        features = new Vector<Vector>();
                    }
                    features.add(feature);
                    continue;
                }
                features = null;
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return features;
    }

    private Vector extractFeaturesFromLogLine(String logLine) {
        Vector<String> features = new Vector<String>();
        String headString = logLine.split("\\(")[0].split(": ")[1];
        String featureString = logLine.split(":- ")[1].replaceAll(".$", "");
        if (featureString.indexOf(headString) >= 0) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "FOIL: recursive call detected >>>>>>>>>>>>>>>> discarded...");
            }
            return null;
        }
        String[] featurePredicate = featureString.split(", ");
        for (int i = 0; i < featurePredicate.length; ++i) {
            String predicate = featurePredicate[i];
            String jessName = this.predicateJessName(predicate);
            features.add(jessName);
        }
        return features;
    }

    private String predicateJessName(String predicateSymbol) {
        return this.isArithmeticOp(predicateSymbol) ? this.predicateJessNameArithmeticOp(predicateSymbol) : this.predicateJessNameUserDefined(predicateSymbol);
    }

    private boolean isArithmeticOp(String predicateName) {
        return predicateName.indexOf("=") != -1 || predicateName.indexOf("<>") != -1;
    }

    private String predicateJessNameArithmeticOp(String predicateName) {
        String jessName = "";
        String closeP = "";
        if (predicateName.indexOf("=") != -1) {
            jessName = jessName + "(eq ";
            closeP = ")";
        } else if (predicateName.indexOf("<>") != -1) {
            jessName = jessName + "(not (eq ";
            closeP = "))";
        }
        jessName = jessName + "?" + predicateName.charAt(0) + " ";
        jessName = jessName + "?" + predicateName.charAt(predicateName.length() - 1) + " ";
        jessName = jessName + closeP;
        return jessName;
    }

    private String predicateJessNameUserDefined(String predicateSymbol) {
        boolean isNegative = predicateSymbol.startsWith("not(");
        if (isNegative) {
            predicateSymbol = predicateSymbol.replaceAll("not\\(", "");
            predicateSymbol = predicateSymbol.replaceAll("\\)\\)", "\\)");
        }
        String predicateHead = predicateSymbol.split("\\(")[0];
        String predicateArgs = predicateSymbol.replaceAll(predicateHead, "");
        Relation relation = null;
        Enumeration allPredicates = this.getPredicates();
        while (allPredicates.hasMoreElements()) {
            String predicate = (String)allPredicates.nextElement();
            int count = predicate.length() - predicate.replace(".", "").length();
            String predicateName = predicate.split("\\.")[count];
            int parenthesesIndex = predicateName.indexOf(40);
            if (!(predicateName = predicateName.substring(0, parenthesesIndex)).matches(predicateHead)) continue;
            relation = this.getRelation(predicate);
            break;
        }
        String args = "";
        String[] argV = predicateArgs.split("\\p{Punct}");
        for (int i = 1; i < argV.length; ++i) {
            args = args + "?" + argV[i] + " ";
        }
        String jessName = isNegative ? "(not (" : "(";
        jessName = jessName + relation.getPredicate().getName() + " ";
        jessName = jessName + args;
        jessName = jessName + (isNegative ? "))" : ")");
        return jessName;
    }

    void runFoil() {
        String numP = "00" + this.getTargetRelation().numPosTuples();
        numP = numP.substring(Math.min(numP.length() - 2, 2));
        String numN = "00" + this.getTargetRelation().numNegTuples();
        numN = numN.substring(Math.min(numN.length() - 2, 2));
        String id = numP + "-" + numN;
        String dataFileName = this.getFoilLogDir();
        dataFileName = dataFileName + this.getTargetName() + "-" + id + ".d";
        String foilLogFileName = this.getFoilLogDir();
        foilLogFileName = foilLogFileName + this.getTargetName() + "-" + id + "-log.txt";
        this.runFoil(dataFileName, foilLogFileName, true);
    }

    public void runFoil(String dataFileName, String foilLogFileName, boolean createDataFile) {
        if (!WEBSTARTMODE) {
            try {
                dataFileName = new File(dataFileName).getCanonicalPath();
                foilLogFileName = new File(foilLogFileName).getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (createDataFile) {
                try {
                    File parentDir = new File(dataFileName).getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    FileOutputStream out = new FileOutputStream(dataFileName);
                    PrintWriter writer = new PrintWriter(out);
                    writer.println(this);
                    writer.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            File logFile = new File(foilLogFileName);
            logFile.delete();
            Process foilProcess = null;
            try {
                String[] foilName = this.getMaxTuples() == null || this.getMaxTuples().equals("Use default foil tuples") ? new String[]{FOIL_EXE, "-a100"} : new String[]{FOIL_EXE, "-a100", "-m " + this.getMaxTuples()};
                foilProcess = Runtime.getRuntime().exec(foilName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FileOutputStream fos = null;
            FileInputStream fis = null;
            Thread outputGobbler = null;
            Thread inputGobbler = null;
            try {
                fos = new FileOutputStream(foilLogFileName);
                outputGobbler = new StreamGobbler(foilProcess.getInputStream(), fos, true);
                fis = new FileInputStream(dataFileName);
                inputGobbler = new StreamGobbler((InputStream)fis, foilProcess.getOutputStream());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            inputGobbler.start();
            outputGobbler.start();
            try {
                outputGobbler.join();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            try {
                fos.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                dataFileName = new File(dataFileName).getCanonicalPath();
                foilLogFileName = new File(foilLogFileName).getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File parentDir = null;
            if (createDataFile) {
                try {
                    parentDir = new File(dataFileName).getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    FileOutputStream out = new FileOutputStream(dataFileName);
                    PrintWriter writer = new PrintWriter(out);
                    writer.println(this);
                    writer.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            File logFiles = new File(foilLogFileName);
            logFiles.delete();
            Process foilProcess = null;
            try {
                String[] foilName = new String[]{WebStartFileDownloader.SimStWebStartDir + FOIL_EXECUTABLE, "-a100"};
                if (trace.getDebugCode("miss")) {
                    trace.out("WebStartMode: " + WEBSTARTMODE + "    " + foilName[0] + "    " + this.getFoilLogDir());
                }
                foilProcess = Runtime.getRuntime().exec(foilName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FileOutputStream fos = null;
            FileInputStream fis = null;
            Thread outputGobbler = null;
            Thread inputGobbler = null;
            try {
                fos = new FileOutputStream(foilLogFileName);
                outputGobbler = new StreamGobbler(foilProcess.getInputStream(), fos, true);
                fis = new FileInputStream(dataFileName);
                inputGobbler = new StreamGobbler((InputStream)fis, foilProcess.getOutputStream());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            inputGobbler.start();
            outputGobbler.start();
            try {
                outputGobbler.join();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            try {
                fos.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void runFoilDos(String dataFileName, String foilLogFileName, String dosBATfile) {
        PrintWriter writer;
        FileOutputStream out;
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "= = = = = = = = = = = = = = = = = = = = =");
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Running FOIL on " + this.getTargetName());
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "dataFileName: " + dataFileName);
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "foilLogFileName: " + foilLogFileName);
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "- - - - - - - - - - - - - - - - - - - - -");
        }
        try {
            out = new FileOutputStream(dataFileName);
            writer = new PrintWriter(out);
            writer.println(this);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            out = new FileOutputStream(dosBATfile);
            writer = new PrintWriter(out);
            String cmd = FOIL_EXE + " < " + dataFileName + " > " + foilLogFileName;
            writer.println(cmd);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        File logFile = new File(foilLogFileName);
        logFile.delete();
        Process foilProcess = null;
        try {
            foilProcess = Runtime.getRuntime().exec(dosBATfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        Hashtable<String, Vector> typeHash = new Hashtable<String, Vector>();
        String dataStr = "";
        dataStr = dataStr + this.getTargetRelation().toString() + "\n";
        for (int i = 0; i < this.getTargetRelation().getArity(); ++i) {
            int argType = this.getTargetRelation().getTargetArgType(i);
            String typeStr = TYPE_NAME + argType;
            Vector types = (Vector)typeHash.get(typeStr);
            Vector addTypes = this.getTargetRelation().getTypesFor(i);
            types = types != null ? this.addNewElements(types, addTypes) : addTypes;
            typeHash.put(typeStr, types);
        }
        Enumeration predicates = this.getPredicates();
        while (predicates.hasMoreElements()) {
            String predicateName = (String)predicates.nextElement();
            Relation relation = this.getRelation(predicateName);
            if (relation == null) continue;
            int index = predicateName.indexOf(40);
            predicateName = predicateName.substring(0, index);
            FeaturePredicate fp = this.getFeaturePredicate(predicateName);
            relation.setTuple(fp);
            if (!relation.hasTuples()) continue;
            String tmpStr = relation.toString();
            if (tmpStr != null) {
                dataStr = dataStr + tmpStr + "\n";
            }
            for (int i = 0; i < relation.getArity(); ++i) {
                int argType = relation.getArgType(i);
                String typeStr = TYPE_NAME + argType;
                Vector types = (Vector)typeHash.get(typeStr);
                Vector addTypes = relation.getTypesFor(i);
                types = types != null ? this.addNewElements(types, addTypes) : addTypes;
                typeHash.put(typeStr, types);
            }
        }
        String typeStr = this.toStringType(typeHash);
        return typeStr + dataStr;
    }

    private Vector addNewElements(Vector v1, Vector v2) {
        Vector addAll = new Vector(v1);
        for (int i = 0; i < v2.size(); ++i) {
            if (v1.contains(v2.get(i))) continue;
            addAll.add(v2.get(i));
        }
        return addAll;
    }

    private String toStringType(Hashtable typeHash) {
        String typeStr = "";
        Enumeration typeElements = typeHash.keys();
        while (typeElements.hasMoreElements()) {
            String theType = (String)typeElements.nextElement();
            Vector theConstants = (Vector)typeHash.get(theType);
            theType = theType + ": ";
            for (int i = 0; i < theConstants.size(); ++i) {
                String val = (String)theConstants.get(i);
                theType = theType + val + ", ";
            }
            theType = theType.substring(0, theType.length() - 2);
            theType = theType + ".\n";
            typeStr = typeStr + theType;
        }
        typeStr = this.escapeECs(typeStr) + "\n";
        return typeStr;
    }

    String v2string(Vector v) {
        if (v == null) {
            return null;
        }
        String va = "";
        for (int i = 0; i < v.size(); ++i) {
            va = va + (String)v.get(i) + " ";
        }
        return va;
    }

    private Vector getValidArgs(Vector initialArgs, Vector relations) {
        Vector<String> validArgs = new Vector<String>(initialArgs);
        boolean isIntact = false;
        while (!isIntact) {
            isIntact = true;
            for (int i = 0; i < relations.size(); ++i) {
                Relation relation = (Relation)relations.get(i);
                String key = relation.getKey();
                int arity = key.indexOf(45);
                if (arity < 0) {
                    arity = key.length();
                }
                Vector tuples = relation.getPositiveTuples();
                for (int j = 0; j < tuples.size(); ++j) {
                    Vector types = (Vector)tuples.get(j);
                    if (!this.isValidArgs(types, arity, validArgs)) continue;
                    for (int k = 0; k < types.size(); ++k) {
                        String arg = (String)types.get(k);
                        if (validArgs.contains(arg)) continue;
                        validArgs.add(arg);
                        isIntact = false;
                    }
                }
            }
        }
        return validArgs;
    }

    private boolean isValidArgs(Vector args, int arity, Vector validArgs) {
        boolean isValidArgs = true;
        for (int i = 0; i < arity; ++i) {
            if (validArgs.contains((String)args.get(i))) continue;
            isValidArgs = false;
            break;
        }
        return isValidArgs;
    }

    public static String replaceCommas(String value) {
        if (!value.contains(",")) {
            return value;
        }
        String resultString = "";
        boolean mode = false;
        String tmp = "";
        for (char c : value.toCharArray()) {
            tmp = tmp + c;
            if (c == '[' && !mode) {
                mode = true;
            }
            if (mode && c == ',') {
                tmp = "\\,";
            }
            if (mode && c == ']') {
                mode = false;
            }
            resultString = resultString + tmp;
            tmp = "";
        }
        return resultString;
    }

    private String escapeECs(String nativeStr) {
        String openP = nativeStr.replaceAll("\\(", "\\\\(");
        String closeP = openP.replaceAll("\\)", "\\\\)");
        String comma = FoilData.replaceCommas(closeP);
        return comma;
    }

    public Vector getDecomposers() {
        return this.decomposers;
    }

    public void setDecomposers(Vector decomposers) {
        this.decomposers = decomposers;
    }

    static {
        FOIL_JARDIR = SimSt.getHomeDir() + "/bin";
        WEBSTARTMODE = false;
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;
        OutputStream os;
        boolean notifyWhenDone = false;
        boolean completed = false;

        StreamGobbler(InputStream is, OutputStream redirect) {
            this(is, redirect, false);
        }

        StreamGobbler(InputStream is, OutputStream redirect, boolean notifyWhenDone) {
            this.is = is;
            this.os = redirect;
            this.notifyWhenDone = notifyWhenDone;
        }

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        public void waitForComplition() {
            while (!this.completed) {
                System.out.print(".");
            }
        }

        @Override
        public void run() {
            try {
                PrintWriter pw = null;
                if (this.os != null) {
                    pw = new PrintWriter(this.os);
                }
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    line = line + "\n";
                    if (pw == null) continue;
                    pw.print(line);
                    pw.flush();
                }
                if (pw != null) {
                    pw.flush();
                    pw.close();
                }
                this.completed = true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

