/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.PeerLearning.SimStPLEActionListener;
import edu.cmu.pact.miss.SimSt;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXTaskPane;

class QuizPane
extends JXTaskPane {
    private static final long serialVersionUID = 1L;
    boolean locked = false;
    boolean hasResults = false;
    SimStLogger logger;
    BR_Controller brController;
    protected SimStPLEActionListener actionListener;

    public ImageIcon createImageIcon(String path) {
        String file = "/edu/cmu/pact/miss/PeerLearning/" + path;
        URL url = ((Object)((Object)this)).getClass().getResource(file);
        return new ImageIcon(url);
    }

    public QuizPane(String title, SimStLogger logger, BR_Controller brController, SimStPLEActionListener actionListener) {
        super(title);
        this.logger = logger;
        this.brController = brController;
        this.actionListener = actionListener;
    }

    void updatePane(boolean lock, boolean finished) {
        this.locked = lock;
        if (finished) {
            this.setIcon(this.createImageIcon("img/medal.png"));
            this.hasResults = true;
        } else if (this.locked) {
            this.setIcon(this.createImageIcon("img/lock.png"));
        } else {
            this.setIcon(this.createImageIcon("img/nolock.png"));
        }
    }

    public void setCollapsed(boolean collapsed) {
        if (this.locked) {
            return;
        }
        if (!this.hasResults && !collapsed) {
            int result = JOptionPane.showConfirmDialog(null, "This quiz has not yet been taken.  Do you want " + SimSt.getSimStName() + " to take it now?", "Take Quiz?", 0);
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Student Tried to Expand Untaken Quiz", "" + (result == 0), this.logger.getCurrentTime());
            if (result == 1 || result == 2 || result == -1) {
                return;
            }
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Student Initiated Quiz on Untaken Quiz Expand", "", this.logger.getCurrentTime());
            if (this.brController.getMissController() != null && this.brController.getMissController().getSimSt() != null && this.brController.getMissController().getSimSt().isSsMetaTutorMode() && this.brController.getAmt() != null) {
                this.brController.getAmt().handleInterfaceAction("quiz", "ButtonPressed", "-1");
            }
            this.actionListener.takeQuiz();
        }
        super.setCollapsed(collapsed);
    }
}

