/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class SimStExample
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String QUIZ_LOCKED = "lock";
    public static String QUIZ_CORRECT = "correct";
    public static String QUIZ_INCORRECT = "incorrect";
    public static String QUIZ_INCOMPLETE = "incomplete";
    public static String QUIZ_OLD = "old";
    public static String EXAMPLE = "example";
    private int index = 0;
    private int sectionNumber = 0;
    private String title = "Example";
    private String explanation = "This is an example.";
    private Hashtable<String, StringPair> steps;
    private Hashtable<String, StringPair> steps_hover;
    private static final Color CORRECT_COLOR = Color.green.darker();
    private static final Color INCORRECT_COLOR = Color.red;
    private String status = EXAMPLE;
    private String shortDescription;
    private Queue<String> stepOrder;

    public SimStExample(String title, String explanation) {
        this.title = title;
        this.explanation = explanation;
        this.steps = new Hashtable();
        this.steps_hover = new Hashtable();
        this.stepOrder = new LinkedList<String>();
    }

    public SimStExample() {
        this.steps = new Hashtable();
        this.steps_hover = new Hashtable();
        this.stepOrder = new LinkedList<String>();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getSection() {
        return this.sectionNumber;
    }

    public void setSection(int section) {
        this.sectionNumber = section;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getNextStep4Display(String currentStep) {
        String foaName;
        Iterator it = this.stepOrder.iterator();
        while (it.hasNext() && !currentStep.equals(foaName = (String)it.next())) {
        }
        foaName = it.hasNext() ? (String)it.next() : currentStep;
        return foaName;
    }

    public String getPreviousStep4Display(String currentStep) {
        String foaName;
        String lowestLimit = this.getMinimumStep();
        if (currentStep.equals(lowestLimit)) {
            return currentStep;
        }
        String previous = currentStep;
        Iterator it = this.stepOrder.iterator();
        while (it.hasNext() && !currentStep.equals(foaName = (String)it.next())) {
            previous = foaName;
        }
        return previous;
    }

    public String getLastStep() {
        String foaName = "";
        Iterator it = this.stepOrder.iterator();
        while (it.hasNext() && !(foaName = (String)it.next()).equals("done")) {
        }
        return foaName;
    }

    public HashSet getValidSteps4display(String currentStep) {
        HashSet<String> valid4display = new HashSet<String>();
        for (String foaName : this.stepOrder) {
            valid4display.add(foaName);
            if (!currentStep.equals(foaName)) continue;
            break;
        }
        return valid4display;
    }

    public String getMinimumStep() {
        ArrayList<String> startStateElements = new ArrayList<String>();
        String file = "simSt-config.txt";
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(file);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(isr);
            String line = reader.readLine();
            while (line != null) {
                if (line.equals("startStateElements")) {
                    line = reader.readLine();
                    while (line != null && line.length() > 0) {
                        startStateElements.add(line);
                        line = reader.readLine();
                    }
                    continue;
                }
                line = reader.readLine();
            }
        }
        catch (Exception line) {
            // empty catch block
        }
        String[] startStateArray = new String[startStateElements.size()];
        for (int i = 0; i < startStateElements.size(); ++i) {
            startStateArray[i] = (String)startStateElements.get(i);
        }
        return startStateArray[startStateElements.size() - 1];
    }

    public void addStep(String selection, String input, String tooltip, String hover) {
        StringPair info = new StringPair(input, tooltip);
        this.steps.put(selection, info);
        StringPair info1 = new StringPair(input, hover);
        this.steps_hover.put(selection, info1);
        this.stepOrder.add(selection);
    }

    public void addStep(String selection, String input, String tooltip, boolean correct, String hover) {
        StringPair info = new StringPair(input, tooltip);
        info.color = correct ? CORRECT_COLOR : INCORRECT_COLOR;
        this.steps.put(selection, info);
        StringPair info1 = new StringPair(input, hover);
        this.steps_hover.put(selection, info1);
        this.stepOrder.add(selection);
    }

    public String getStepInput(String selection) {
        StringPair input = this.steps.get(selection);
        if (input != null) {
            return input.value;
        }
        return "";
    }

    public String getStepTooltip(String selection) {
        StringPair input = this.steps.get(selection);
        if (input != null) {
            return input.extended;
        }
        return "";
    }

    public String getStepTooltipHover(String selection) {
        StringPair input = this.steps_hover.get(selection);
        if (input != null) {
            return input.extended;
        }
        return "";
    }

    public Color getStepColor(String selection) {
        StringPair input = this.steps.get(selection);
        if (input != null) {
            return input.color;
        }
        return Color.gray;
    }

    public String toString() {
        String example = "(" + this.sectionNumber + ") " + this.title + ": " + this.explanation + "\n";
        for (String key : this.steps.keySet()) {
            example = example + key + "=" + this.steps.get(key) + "\n";
        }
        return example;
    }

    private class StringPair
    implements Serializable {
        String value;
        String extended;
        Color color = Color.black;

        StringPair(String val, String ext) {
            this.value = val;
            this.extended = ext;
        }

        public String toString() {
            return this.value + " - " + this.extended;
        }
    }
}

