/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.jess.APlusModelTracing;
import edu.cmu.pact.miss.jess.ModelTraceWorkingMemory;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.LinkedList;

public class SimStLogAgent {
    protected static BR_Controller brController;
    protected ModelTraceWorkingMemory mtwm;
    protected APlusModelTracing apmt;
    SimStLogger logger;
    protected LinkedList<LogEntry> logBuffer = new LinkedList();

    public SimStLogAgent(BR_Controller brController) {
        this.logger = new SimStLogger(brController);
        SimStLogAgent.brController = brController;
        if (brController.getMissController().getSimSt().getModelTraceWM() != null) {
            this.mtwm = brController.getMissController().getSimSt().getModelTraceWM();
        }
    }

    public String getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");
        return dateFormat.format(new GregorianCalendar().getTime());
    }

    public class LogEntry {
        public String actionType;
        public String action;
        public String step;
        public String result;
        public Object resultDetails;
        public Sai sai;
        public ProblemNode node;
        public String correctness;
        public String expSelection;
        public String expAction;
        public String expInput;
        public int duration;
        public String feedback;
        public String opponent;
        public String info;
        public int myRating;
        public String event_time;

        public LogEntry(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating, String event_time) {
            this.actionType = actionType;
            this.action = action;
            this.step = step;
            this.result = result;
            this.resultDetails = resultDetails;
            this.sai = sai;
            this.node = node;
            this.correctness = correctness;
            this.expSelection = expSelection;
            this.expAction = expSelection;
            this.expInput = expInput;
            this.duration = duration;
            this.feedback = feedback;
            this.opponent = opponent;
            this.info = info;
            this.myRating = myRating;
            this.event_time = event_time;
        }

        public void log(SimStLogger logger, String hintType, String hintFollowed) {
            logger.simStLog(this.actionType, this.action, this.step, this.result, this.resultDetails, this.sai, this.node, this.correctness, this.expSelection, this.expAction, this.expInput, this.duration, this.feedback, this.opponent, this.info, this.myRating, false, hintType, hintFollowed, this.event_time);
        }

        public void clear() {
            this.actionType = this.actionType;
            this.action = this.action;
            this.step = this.step;
            this.result = this.result;
            this.resultDetails = this.resultDetails;
            this.sai = null;
            this.node = null;
            this.correctness = "";
            this.expSelection = "";
            this.expAction = "";
            this.expInput = "";
            this.duration = 0;
            this.feedback = "";
            this.opponent = "";
            this.info = "";
            this.myRating = 0;
            this.event_time = "";
        }
    }
}

