/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.minerva_3_1.StepAbstractor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class SimStLoggingAgent {
    public static String PROBLEM = "Problem";
    public static String PROBLEMTYPE = "ProblemType";
    public static String QUIZ = "Quiz";
    public static String FEEDBACK = "Feedback";
    public static String RESOURCE = "Resource";
    private static final String FEEDBACK_REQUEST = "feedback-request";
    private static final String HINT_REQUEST = "hint-request";
    private static final String COG_HINT = "Demonstrate Step";
    private static SimStLoggingAgent instance = null;
    private Queue<LogEntry> logBuffer = new LinkedList<LogEntry>();
    private LogEntry hintLogEntry;
    private LogEntry hintLogEntryRep;
    private LogEntry hintLogEntryRequest;
    private LinkedHashMap<String, String> ssElementValues;
    private LinkedHashMap<String, String> mtElementValuesHashLive;
    private LinkedHashMap<String, String> mtElementValuesHash;
    public String e = "";
    private static BR_Controller brController;
    private boolean hintFollowed = false;
    private boolean isHintRepeated = false;
    private String feedbackSuggestion = "";
    private String requestType = "";
    private String anticipatedResource = "";
    private boolean timeToLogHint = false;
    private boolean hintGiven = false;
    private String hintType = "-1";

    public static SimStLoggingAgent getInstance(BR_Controller newBrController) {
        if (instance == null) {
            instance = new SimStLoggingAgent(newBrController);
        }
        return instance;
    }

    public static SimStLoggingAgent getInstance() {
        return instance;
    }

    public SimStLoggingAgent() {
        LogEntry hintLogEntry = new LogEntry();
        LogEntry hintLogEntryRep = new LogEntry();
        LogEntry hintLogEntryRequest = new LogEntry();
        this.ssElementValues = new LinkedHashMap();
        this.mtElementValuesHash = new LinkedHashMap();
        this.mtElementValuesHashLive = new LinkedHashMap();
    }

    public SimStLoggingAgent(BR_Controller newBrController) {
        LogEntry hintLogEntry = new LogEntry();
        LogEntry hintLogEntryRep = new LogEntry();
        LogEntry hintLogEntryRequest = new LogEntry();
        this.ssElementValues = new LinkedHashMap();
        this.mtElementValuesHash = new LinkedHashMap();
        this.mtElementValuesHashLive = new LinkedHashMap();
        brController = newBrController;
    }

    public void copy_mtElementValuesHash() {
        Set<Map.Entry<String, String>> set = this.mtElementValuesHashLive.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.mtElementValuesHash.put(key, value);
        }
    }

    public String resovleHint(String feedback, String result) {
        if (result.contains(HINT_REQUEST) || result.contains("quiz") || result.contains("resource")) {
            if (feedback.contains("Quiz button")) {
                return QUIZ;
            }
            if (result.contains("demonstrate")) {
                return COG_HINT;
            }
            if (feedback.contains("similar")) {
                return PROBLEMTYPE;
            }
            if (result.contains("resource")) {
                return RESOURCE;
            }
            return PROBLEM;
        }
        return FEEDBACK;
    }

    public boolean isHintFollowed() {
        return this.hintFollowed;
    }

    public void setIsHintRepeated(boolean value) {
        this.isHintRepeated = value;
    }

    public boolean getIsHintRepeated() {
        return this.isHintRepeated;
    }

    public String get_isHintFollowedString() {
        if (this.getIsHintRepeated()) {
            return "Repeated";
        }
        if (this.getHintType() == FEEDBACK || this.getHintType() == COG_HINT) {
            return "Not Tracked";
        }
        if (this.hintFollowed) {
            return "Followed";
        }
        return "Not followed";
    }

    public void keepTrackOfssElements(String actionType, String action, Sai sai) {
        if (actionType == "SIM_STUDENT_METATUTOR" && action == "Metatutor Model Traced" && sai.getA().equals("UpdateTable")) {
            this.update_ssElements(sai.getS(), sai.getI());
        }
    }

    public LogEntry getHintLogEntry() {
        if (this.getIsHintRepeated()) {
            return this.hintLogEntryRep;
        }
        return this.hintLogEntry;
    }

    public LogEntry getHintLogRequestEntry() {
        return this.hintLogEntryRequest;
    }

    public String getFeedbackSuggestion(String feedback) {
        if (feedback.contains("Yes")) {
            return "Yes";
        }
        return "No";
    }

    public String getFeedBackSuggestion() {
        return this.feedbackSuggestion;
    }

    public void setFeedbackSuggestion(String value) {
        this.feedbackSuggestion = value;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String get_isHintRequestFollowed() {
        return "";
    }

    public boolean handleHintRequestLogEntry(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating, String event_time) {
        if (action == "Metatutor Hint Requested") {
            this.setRequestType((String)resultDetails);
            if (this.hintLogEntryRequest == null) {
                this.hintLogEntryRequest = new LogEntry();
            } else {
                this.hintLogEntryRequest.clear();
            }
            this.hintLogEntryRequest.fill(actionType, action, step, result, feedback, sai, node, correctness, expSelection, expAction, expInput, duration, (String)resultDetails, opponent, info, myRating, event_time);
            return false;
        }
        return true;
    }

    public void setAnticipatedResource(String result) {
        this.anticipatedResource = result.contains("example") ? "Examples" : (result.contains("overview") ? "Unit Overview".replaceAll(" ", "") : (result.contains("bank") ? "Unit Overview".replaceAll(" ", "") : "Unknown resource"));
    }

    public String getAnticipatedResource() {
        return this.anticipatedResource;
    }

    public boolean handleHintLogEntry(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating, String event_time) {
        if (action == "Metatutor Hint Given") {
            if (!this.getHintGiven()) {
                if (this.resovleHint(feedback, result) == QUIZ) {
                    System.out.println("We have a Quiz, waiting for quiz button...");
                    this.setHintType(QUIZ);
                    this.setHintGiven(true);
                    this.setTimeToLogHint(false);
                    this.setIsHintRepeated(false);
                    if (this.hintLogEntry == null) {
                        this.hintLogEntry = new LogEntry();
                    } else {
                        this.hintLogEntry.clear();
                    }
                    this.hintLogEntry.fill(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time);
                } else if (this.resovleHint(feedback, result) == FEEDBACK) {
                    System.out.println("We have a Feedback hint... just log it");
                    this.setFeedbackSuggestion(this.getFeedbackSuggestion(feedback));
                    this.setHintType(FEEDBACK);
                    this.setTimeToLogHint(true);
                    this.setIsHintRepeated(false);
                    if (this.hintLogEntry == null) {
                        this.hintLogEntry = new LogEntry();
                    } else {
                        this.hintLogEntry.clear();
                    }
                    this.hintLogEntry.fill(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time);
                } else if (this.resovleHint(feedback, result) == RESOURCE) {
                    this.setAnticipatedResource(result);
                    System.out.println("We have a resource usage hint ... waiting for " + this.getAnticipatedResource() + " tab...");
                    this.setFeedbackSuggestion(this.getFeedbackSuggestion(feedback));
                    this.setHintType(RESOURCE);
                    this.setTimeToLogHint(false);
                    this.setIsHintRepeated(false);
                    this.setHintGiven(true);
                    if (this.hintLogEntry == null) {
                        this.hintLogEntry = new LogEntry();
                    } else {
                        this.hintLogEntry.clear();
                    }
                    this.hintLogEntry.fill(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time);
                } else if (this.resovleHint(feedback, result) == COG_HINT) {
                    System.out.println("We have a demonstration hint ... just log it");
                    this.setFeedbackSuggestion(this.getFeedbackSuggestion(feedback));
                    this.setHintType(COG_HINT);
                    this.setTimeToLogHint(true);
                    this.setIsHintRepeated(false);
                    if (this.hintLogEntry == null) {
                        this.hintLogEntry = new LogEntry();
                    } else {
                        this.hintLogEntry.clear();
                    }
                    this.hintLogEntry.fill(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time);
                } else {
                    System.out.println("We have a Problem, waiting for yes button.... ");
                    this.setHintType(this.resovleHint(feedback, result));
                    String[] fr = this.extractEquation(feedback);
                    String[] f1 = fr[0].split("\\/");
                    String[] f2 = fr[1].split("\\/");
                    this.mtElementValuesHash.put("dorminTable1_C1R1", f1[0]);
                    this.mtElementValuesHash.put("dorminTable1_C1R2", f1[1]);
                    this.mtElementValuesHash.put("dorminTable2_C1R1", f2[0]);
                    this.mtElementValuesHash.put("dorminTable2_C1R2", f2[1]);
                    this.setHintGiven(true);
                    this.setTimeToLogHint(false);
                    this.setIsHintRepeated(false);
                    if (this.hintLogEntry == null) {
                        this.hintLogEntry = new LogEntry();
                    } else {
                        this.hintLogEntry.clear();
                    }
                    this.hintLogEntry.fill(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time);
                }
                return false;
            }
            this.setHintType(this.getHintType());
            this.setIsHintRepeated(true);
            this.setTimeToLogHint(true);
            if (this.hintLogEntryRep == null) {
                this.hintLogEntryRep = new LogEntry();
            } else {
                this.hintLogEntryRep.clear();
            }
            this.hintLogEntryRep.fill(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time);
            return false;
        }
        if (this.getHintGiven()) {
            if (this.isYesNoButtonClicked(actionType, action, sai)) {
                if ((this.getHintType() == PROBLEM || this.getHintType() == PROBLEMTYPE) && this.isActionYesButton(actionType, action, sai)) {
                    this.hintFollowed = this.isProblemHintFollowed();
                } else if (this.getHintType() != FEEDBACK) {
                    this.hintFollowed = false;
                }
                this.resetFlagsToLog();
                return false;
            }
            if (action.equals("Quiz Button Clicked") || action.equals("Student Initiated Quiz on Untaken Quiz Expand")) {
                this.hintFollowed = this.getHintType() == QUIZ;
                this.resetFlagsToLog();
                return false;
            }
            if (sai != null && sai.getA().equals("TabClicked") && this.getHintType() == RESOURCE) {
                System.out.println(this.anticipatedResource + "=" + sai.getS());
                this.hintFollowed = sai.getS().contains(this.anticipatedResource);
                this.resetFlagsToLog();
                return false;
            }
        }
        return true;
    }

    public void resetFlagsToLog() {
        this.setHintGiven(false);
        this.setTimeToLogHint(true);
        this.setIsHintRepeated(false);
    }

    public void clear_mtElementValuesHash() {
        this.mtElementValuesHash.clear();
    }

    public void abstractHashes() {
        StepAbstractor abstractor = new StepAbstractor();
        Set<Map.Entry<String, String>> set = this.ssElementValues.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String value = entry.getValue();
            String abstracted = abstractor.signedAbstraction(value);
            this.ssElementValues.put(key, abstracted);
        }
        Set<Map.Entry<String, String>> set1 = this.mtElementValuesHashLive.entrySet();
        for (Map.Entry<String, String> entry1 : set1) {
            String key1 = entry1.getKey();
            String value1 = entry1.getValue();
            String abstracted1 = abstractor.signedAbstraction(value1);
            this.mtElementValuesHash.put(key1, abstracted1);
        }
    }

    public boolean isProblemHintFollowed() {
        if (this.getHintType() == PROBLEM) {
            return this.mtElementValuesHash.equals(this.ssElementValues);
        }
        this.abstractHashes();
        return this.mtElementValuesHash.equals(this.ssElementValues);
    }

    public boolean getHintGiven() {
        return this.hintGiven;
    }

    public void setHintGiven(boolean value) {
        this.hintGiven = value;
    }

    public boolean isActionYesButton(String actionType, String action, Sai sai) {
        return actionType == "SIM_STUDENT_METATUTOR" && action == "Metatutor Model Traced" && sai.getS() == "yes" && sai.getA() == "ButtonPressed";
    }

    public boolean isActionNoButton(String actionType, String action, Sai sai) {
        return actionType == "SIM_STUDENT_METATUTOR" && action == "Metatutor Model Traced" && sai.getS() == "no" && sai.getA() == "ButtonPressed";
    }

    public boolean isYesNoButtonClicked(String actionType, String action, Sai sai) {
        return actionType == "SIM_STUDENT_METATUTOR" && action == "Metatutor Model Traced" && (sai.getS() == "yes" && sai.getA() == "ButtonPressed" || sai.getS() == "no" && sai.getA() == "ButtonPressed");
    }

    public LinkedHashMap<String, String> get_mtElementValuesHash() {
        return this.mtElementValuesHash;
    }

    public LinkedHashMap<String, String> get_mtElementValuesHashLive() {
        return this.mtElementValuesHashLive;
    }

    public Queue<LogEntry> getLogBuffer() {
        return this.logBuffer;
    }

    public boolean handleDialogMessage(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating, String event_time) {
        if (actionType == "SIM_STUDENT_DIALOGUE") {
            boolean doesFeedbackIndicateStartTopic = brController.getMissController().getSimStPLE().getConversation().isTextInTopic("START_PROBLEM", feedback);
            if (doesFeedbackIndicateStartTopic && !this.logBuffer.isEmpty()) {
                this.logBuffer.clear();
            }
            if (feedback.equals("Me: Yes") || doesFeedbackIndicateStartTopic) {
                LogEntry logTemp = new LogEntry(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating);
                this.getLogBuffer().add(logTemp);
                return true;
            }
            return false;
        }
        return false;
    }

    public void reinstateDialogMessagesFromBuffer(String actionType, String action, Sai sai, SimStLogger logger) {
        System.out.println(sai);
        if (actionType == "SIM_STUDENT_METATUTOR" && action == "Metatutor Model Traced" && sai.getS() == "yes" && sai.getA() == "ButtonPressed") {
            Iterator it = this.getLogBuffer().iterator();
            while (it.hasNext()) {
                LogEntry tmp = (LogEntry)it.next();
                it.remove();
                System.out.println("popping out " + tmp.feedback);
            }
        }
    }

    public String[] extractEquation(String hint) {
        String[] result = new String[]{"notFound", "notFound"};
        String needle = "Start by putting ";
        int e = hint.indexOf(needle);
        if (e == -1) {
            return result;
        }
        hint = hint.substring(e + needle.length(), hint.length());
        String needle1 = "on the first fraction and ";
        int e1 = hint.indexOf(needle1);
        String lhs = hint.substring(0, e1);
        hint = hint.substring(e1 + needle1.length(), hint.length());
        String needle2 = "on the second fraction ";
        int e2 = hint.indexOf(needle2);
        String rhs = hint.substring(0, e2);
        lhs = lhs.trim();
        rhs = rhs.trim();
        result[0] = lhs;
        result[1] = rhs;
        return result;
    }

    private void populate_ssElements() {
        ArrayList<String> ssElements = brController.getMissController().getSimStPLE().getStartStateElements();
        for (String s : ssElements) {
            this.ssElementValues.put(s, "empty");
        }
    }

    public LinkedHashMap<String, String> get_ssElementValues() {
        return this.ssElementValues;
    }

    public void update_ssElements(String selection, String input) {
        if (this.ssElementValues.isEmpty()) {
            this.populate_ssElements();
        }
        this.ssElementValues.put(selection, input);
    }

    public String getHintType() {
        return this.hintType;
    }

    public void setHintType(String hintType) {
        this.hintType = hintType;
    }

    public boolean isTimeToLogHint() {
        return this.timeToLogHint;
    }

    public void setTimeToLogHint(boolean timeToLogHint) {
        this.timeToLogHint = timeToLogHint;
    }

    class LogEntry {
        public String actionType;
        public String action;
        public String step;
        public String result;
        public Object resultDetails;
        public Sai sai;
        public ProblemNode node;
        public String correctness;
        public String expSelection;
        public String expAction;
        public String expInput;
        public int duration;
        public String feedback;
        public String opponent;
        public String info;
        public int myRating;
        public String event_time;

        public LogEntry(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating) {
            this.actionType = actionType;
            this.action = action;
            this.step = step;
            this.result = result;
            this.resultDetails = resultDetails;
            this.sai = sai;
            this.node = node;
            this.correctness = correctness;
            this.expSelection = expSelection;
            this.expAction = expSelection;
            this.expInput = expInput;
            this.duration = duration;
            this.feedback = feedback;
            this.opponent = opponent;
            this.info = info;
            this.myRating = myRating;
        }

        public LogEntry() {
        }

        public void fill(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating, String event_time) {
            this.actionType = actionType;
            this.action = action;
            this.step = step;
            this.result = result;
            this.resultDetails = resultDetails;
            this.sai = sai;
            this.node = node;
            this.correctness = correctness;
            this.expSelection = expSelection;
            this.expAction = expSelection;
            this.expInput = expInput;
            this.duration = duration;
            this.feedback = feedback;
            this.opponent = opponent;
            this.info = info;
            this.myRating = myRating;
            this.event_time = event_time;
        }

        public void clear() {
            this.actionType = this.actionType;
            this.action = this.action;
            this.step = this.step;
            this.result = this.result;
            this.resultDetails = this.resultDetails;
            this.sai = null;
            this.node = null;
            this.correctness = "";
            this.expSelection = "";
            this.expAction = "";
            this.expInput = "";
            this.duration = 0;
            this.feedback = "";
            this.opponent = "";
            this.info = "";
            this.myRating = 0;
            this.event_time = "";
        }
    }
}

