/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class StudentAvatarDisplay
extends JLayeredPane {
    private static final long serialVersionUID = 1L;
    private JLabel staticGraphic;
    JLabel backgroundLabel;
    JLabel hairLabel;
    JLabel shirtLabel;
    JLabel faceLabel;
    String expression = "img/face1.png";
    public static int PREFERRED_WIDTH = 125;
    public static int PREFERRED_HEIGHT = 140;
    int xOffset = 0;
    int yOffset = 0;

    public StudentAvatarDisplay() {
        this.setPreferredSize(new Dimension(PREFERRED_WIDTH, PREFERRED_HEIGHT));
        this.setUpDisplay(0, 0);
    }

    public StudentAvatarDisplay(String img) {
        this.setPreferredSize(new Dimension(PREFERRED_WIDTH, PREFERRED_HEIGHT));
        this.setUpDisplay(0, 0);
        this.setImage(img);
    }

    public StudentAvatarDisplay(int offset) {
        this.xOffset = offset;
        this.yOffset = offset;
        this.setPreferredSize(new Dimension(PREFERRED_WIDTH, PREFERRED_HEIGHT));
        this.setUpDisplay(offset, offset);
    }

    public StudentAvatarDisplay(int xOffset, int yOffset) {
        this.setPreferredSize(new Dimension(PREFERRED_WIDTH, PREFERRED_HEIGHT));
        this.setUpDisplay(xOffset, yOffset);
    }

    public StudentAvatarDisplay(String img, int offset) {
        this.xOffset = offset;
        this.yOffset = offset;
        this.setPreferredSize(new Dimension(PREFERRED_WIDTH, PREFERRED_HEIGHT));
        this.setUpDisplay(offset, offset);
        this.setImage(img);
    }

    protected void setUpDisplay(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.staticGraphic = new JLabel();
        ImageIcon icon = this.createImageIcon("img/head1.png");
        this.backgroundLabel = new JLabel(icon);
        this.backgroundLabel.setBounds(xOffset, yOffset, icon.getIconWidth(), icon.getIconHeight());
        this.add((Component)this.backgroundLabel, new Integer(2));
        icon = this.createImageIcon("img/hair1.png");
        this.hairLabel = new JLabel(icon);
        this.hairLabel.setBounds(xOffset, yOffset, icon.getIconWidth(), icon.getIconHeight());
        this.add((Component)this.hairLabel, new Integer(3));
        icon = this.createImageIcon("img/shirt1.png");
        this.shirtLabel = new JLabel(icon);
        this.shirtLabel.setBounds(xOffset, yOffset, icon.getIconWidth(), icon.getIconHeight());
        this.add((Component)this.shirtLabel, new Integer(1));
        icon = this.createImageIcon("img/face1.png");
        this.faceLabel = new JLabel(icon);
        this.faceLabel.setBounds(xOffset, yOffset, icon.getIconWidth(), icon.getIconHeight());
        this.add((Component)this.faceLabel, new Integer(3));
        this.staticGraphic.setBounds(0, 0, PREFERRED_WIDTH, PREFERRED_HEIGHT);
        this.add((Component)this.staticGraphic, new Integer(4));
        this.staticGraphic.setVisible(false);
    }

    public void setIsStaticGraphic(boolean isStatic) {
        this.staticGraphic.setVisible(isStatic);
        this.backgroundLabel.setVisible(!isStatic);
        this.hairLabel.setVisible(!isStatic);
        this.shirtLabel.setVisible(!isStatic);
        this.faceLabel.setVisible(!isStatic);
    }

    public void setImage(String img) {
        if (!img.startsWith("%")) {
            ImageIcon icon = this.createImageIcon(img);
            this.staticGraphic.setIcon(icon);
        } else {
            String[] parts = img.split("%");
            ImageIcon icon = this.createImageIcon(parts[1]);
            ImageIcon icon2 = this.createImageIcon(parts[2]);
            ImageIcon icon5 = this.createImageIcon(parts[3]);
            ImageIcon icon6 = this.createImageIcon(this.expression);
            this.backgroundLabel.setIcon(icon);
            this.hairLabel.setIcon(icon2);
            this.shirtLabel.setIcon(icon5);
            this.faceLabel.setIcon(icon6);
        }
    }

    public void setExpression(String expression) {
        ImageIcon icon = this.createImageIcon(expression);
        this.faceLabel.setIcon(icon);
        this.expression = expression;
    }

    protected ImageIcon createImageIcon(String path) {
        String file = "/edu/cmu/pact/miss/PeerLearning/" + path;
        URL url = this.getClass().getResource(file);
        return new ImageIcon(url);
    }

    public void clearImage() {
        ImageIcon icon = new ImageIcon();
        this.backgroundLabel.setIcon(icon);
        this.hairLabel.setIcon(icon);
        this.shirtLabel.setIcon(icon);
        this.faceLabel.setIcon(icon);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(PREFERRED_WIDTH + this.xOffset, PREFERRED_HEIGHT + this.yOffset);
    }
}

