/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.TutorialBuilderUtility;

import edu.cmu.pact.miss.PeerLearning.TutorialBuilderUtility.DOMNode;
import edu.cmu.pact.miss.PeerLearning.TutorialBuilderUtility.GUIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class DOMTree
implements TreeSelectionListener,
ComponentListener {
    private DOMNode head;
    private IDManager manager = new IDManager();
    private JTree jtree;

    protected DOMNode getHead() {
        return this.head;
    }

    protected DOMTree(Object contents, ArrayList<DOMNode> children) {
        this.head = new DOMNode(contents, null);
        if (children == null) {
            this.head.setChildren(new ArrayList<DOMNode>());
        } else {
            this.head.setChildren(children);
        }
    }

    protected DOMTree(Container c) {
        this.head = new DOMNode((Object)c, null);
        this.createTreeFromComponent(c, this.head);
        this.removeDuplicates();
        this.addTags();
    }

    protected void createTreeFromComponent(Container c, DOMNode currentParent) {
        if (currentParent == null) {
            return;
        }
        this.addChildren(c.getComponents(), currentParent);
        for (int x = 0; x < currentParent.getChildren().size(); ++x) {
            try {
                this.createTreeFromComponent((Container)currentParent.getChildren().get(x).getContents(), currentParent.getChildren().get(x));
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    protected void addChildren(Object[] add, DOMNode addTo) {
        this.addChildren(new ArrayList<Object>(Arrays.asList(add)), addTo);
    }

    protected void addChildren(ArrayList<Object> add, DOMNode addTo) {
        addTo.addChildren(add);
    }

    protected void addChild(Object add, DOMNode addTo) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(add);
        addTo.addChildren(l);
    }

    protected DOMNode find(Object toFind, DOMNode current) {
        if (this.head.contains(toFind)) {
            return this.head;
        }
        return this.searchFor(toFind, current);
    }

    private DOMNode searchFor(Object toFind, DOMNode current) {
        for (DOMNode c : current.getChildren()) {
            if (!c.contains(toFind)) continue;
            return c;
        }
        Iterator<DOMNode> iterator = current.getChildren().iterator();
        if (iterator.hasNext()) {
            DOMNode c;
            c = iterator.next();
            return this.searchFor(toFind, c);
        }
        return null;
    }

    protected DOMNode find(Object toFind) {
        return this.searchFor(toFind, this.head);
    }

    protected Object output(OUTPUT_TYPE t) {
        switch (t) {
            case CONSOLE: {
                this.output(this.head, 0);
                break;
            }
            case FILE: {
                try {
                    PrintWriter p = new PrintWriter("domtree.txt");
                    this.output(this.head, 0, p);
                    p.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
            case RETURN: {
                return this.output(this.head, 0, new StringBuilder());
            }
            case ARRAY: {
                return this.output(this.head, new ArrayList<DOMNode>());
            }
        }
        return null;
    }

    protected ArrayList<DOMNode> output(DOMNode current, ArrayList<DOMNode> arrayList) {
        if (current == null) {
            return null;
        }
        arrayList.add(current);
        for (DOMNode d : current.getChildren()) {
            this.output(d, arrayList);
        }
        return arrayList;
    }

    protected String output(DOMNode current, int tabCount, StringBuilder ret) {
        for (int x = 0; x < tabCount; ++x) {
            ret.append("\t");
        }
        ret.append(current + "\n");
        ++tabCount;
        for (DOMNode d : current.getChildren()) {
            this.output(d, tabCount, ret);
        }
        return ret.toString();
    }

    protected void output(DOMNode current, int tabCount) {
        for (int x = 0; x < tabCount; ++x) {
            System.out.print("\t");
        }
        System.out.println(current);
        ++tabCount;
        for (DOMNode d : current.getChildren()) {
            this.output(d, tabCount);
        }
    }

    protected void output(DOMNode current, int tabCount, PrintWriter p) {
        for (int x = 0; x < tabCount; ++x) {
            p.write("\t");
        }
        p.write(current.toString() + "\n");
        ++tabCount;
        for (DOMNode d : current.getChildren()) {
            this.output(d, tabCount, p);
        }
    }

    protected JTree getJTree() {
        if (this.jtree == null) {
            this.convertToJTree();
        }
        return this.jtree;
    }

    protected void removeDuplicates() {
        DOMNode rootPane = this.findInstanceOf(this.head, new JLayeredPane().getClass());
        this.removeGlassPane();
        this.removeDuplicates(rootPane, ((Component)rootPane.getContents()).getSize());
    }

    private void removeDuplicates(DOMNode current, Dimension currentDim) {
        ArrayList<DOMNode> temp = current.getChildren();
        for (int x = 0; x < temp.size(); ++x) {
            this.removeDuplicates(current.getChildren().get(x), currentDim);
        }
        if (((Component)current.getContents()).getSize().equals(currentDim) && current.getChildren().size() > 0) {
            for (DOMNode d : current.getChildren()) {
                current.getParent().addChildren(d);
            }
            current.getParent().remove(current);
            current = current.getParent();
        } else {
            currentDim = ((Component)current.getContents()).getSize();
        }
    }

    private void removeGlassPane() {
        this.removeGlassPane(this.head);
    }

    private void removeGlassPane(DOMNode current) {
        if (current.verboseToString().indexOf("glassPane") > 0) {
            for (DOMNode d : current.getChildren()) {
                current.getParent().addChildren(d);
            }
            current.getParent().remove(current);
            return;
        }
        for (DOMNode d : current.getChildren()) {
            this.removeGlassPane(d);
        }
    }

    private void addTags() {
        this.addTags(this.head);
    }

    private void addTags(DOMNode current) {
        current.setIDTag(this.manager.getCurrentID());
        for (DOMNode childDomNode : current.getChildren()) {
            this.addTags(childDomNode);
        }
    }

    protected void convertToJTree() {
        DOMNode first = this.head;
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(first);
        this.buildTree(first.getChildren().get(0), top, 0);
        this.jtree = new JTree(top);
        this.jtree.addTreeSelectionListener(this);
        AbstractAction locationAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DOMNode node = (DOMNode)((DefaultMutableTreeNode)DOMTree.this.jtree.getLastSelectedPathComponent()).getUserObject();
                Container c = (Container)node.getContents();
                JOptionPane.showMessageDialog(null, "Location: (" + c.getX() + ", " + c.getY() + ")\nDimensions: (" + c.getWidth() + ", " + c.getHeight() + ")");
            }
        };
        this.jtree.getInputMap().put(KeyStroke.getKeyStroke('l'), "location");
        this.jtree.getActionMap().put("location", locationAction);
    }

    public void updateTree() {
        ((DefaultTreeModel)this.jtree.getModel()).nodeChanged(this.head);
    }

    protected String getClassName(Object o) {
        return o.getClass().getName().replace("javax.swing.", "");
    }

    protected void buildTree(DOMNode current, DefaultMutableTreeNode category, int index) {
        if (current.getChildren().size() > 0) {
            DefaultMutableTreeNode temp = category;
            category = new DefaultMutableTreeNode(current);
            temp.add(category);
        } else {
            category.add(new DefaultMutableTreeNode(current));
        }
        for (DOMNode d : current.getChildren()) {
            this.buildTree(d, category, index);
        }
    }

    protected DOMNode findInstanceOf(DOMNode current, Object c) {
        if (current == null) {
            return null;
        }
        if (current.getContents().getClass().equals(c)) {
            return current;
        }
        for (DOMNode d : current.getChildren()) {
            current = this.findInstanceOf(d, c);
        }
        return current;
    }

    protected DOMNode findElementByID(String ID) {
        int id = Integer.parseInt(ID.replaceAll("[a-zA-z]", ""));
        return this.findElementByID(this.head, id);
    }

    private DOMNode findElementByID(DOMNode current, int ID) {
        ArrayList<DOMNode> children = current.getChildren();
        for (DOMNode domNode : children) {
            if (domNode.getIDTag() == ID) {
                return domNode;
            }
            current = this.findElementByID(domNode, ID);
            if (current == null || current.getIDTag() != ID) continue;
            return current;
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jtree.getLastSelectedPathComponent();
            Object o = ((DOMNode)node.getUserObject()).getContents();
            JComponent comp = (JComponent)o;
            GUIUtility.clearAndDraw(comp, Color.RED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return (String)this.output(OUTPUT_TYPE.RETURN);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateTree();
        this.jtree.revalidate();
        this.jtree.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.updateTree();
        this.jtree.revalidate();
        this.jtree.repaint();
    }

    public class IDManager {
        private int currentID = 0;

        public int getCurrentID() {
            return ++this.currentID;
        }
    }

    public static enum OUTPUT_TYPE {
        CONSOLE,
        FILE,
        RETURN,
        ARRAY;

    }
}

