/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.BindPair;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.RhsGoalTest;
import edu.cmu.pact.miss.RhsState;
import java.util.Vector;

public class RhsExhaustiveGoalTest
extends RhsGoalTest {
    private boolean useAllFOAs;
    private Instruction instruction = null;
    RhsState lastState = null;

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public RhsState getLastState() {
        return this.lastState;
    }

    public void setLastState(RhsState theLastState) {
        this.lastState = theLastState;
    }

    public RhsExhaustiveGoalTest(Instruction instruction) {
        this.setInstruction(instruction);
    }

    public RhsExhaustiveGoalTest(Instruction instruction, boolean useAllFOAsFlag) {
        this.setInstruction(instruction);
        this.setUseAllFOAs(useAllFOAsFlag);
    }

    @Override
    public boolean isGoalState(Object object) {
        RhsState rhsState = (RhsState)object;
        boolean isGoalState = this.getInstruction().getName().equals("DONE") ? true : rhsState.hasValidOperations(this.getInstruction());
        if (isGoalState && this.useAllFOAs) {
            boolean[] foaUsed = new boolean[this.getInstruction().numFocusOfAttention() - 1];
            Vector expList = rhsState.getExpList();
            for (BindPair e : expList) {
                if (e.getExp() == null) continue;
                Vector args = e.getExp().getArgs();
                for (String s : args) {
                    int index = Integer.parseInt(s.substring(4));
                    if (index >= foaUsed.length) continue;
                    foaUsed[index] = true;
                }
            }
            for (int i = 0; i < foaUsed.length; ++i) {
                if (foaUsed[i]) continue;
                isGoalState = false;
            }
        }
        if (isGoalState) {
            this.setLastState(rhsState);
        } else if (trace.getDebugCode("rhs")) {
            trace.out("rhs", "goalTest failed on " + rhsState + " for " + this.getInstruction());
        }
        return isGoalState;
    }

    public void setUseAllFOAs(boolean b) {
        this.useAllFOAs = b;
    }
}

