/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.SimStRete;
import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.SimSt;
import java.awt.Point;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Rule
implements Serializable {
    public static final String DONE_NAME = "DONE";
    private static final String DONE_SELECTION = "done";
    private static final String DONE_ACTION = "ButtonPressed";
    private static final String DONE_INPUT = "-1";
    public static final String NONAME = "unnamed";
    public static final String UNLABELED_SKILL = "unlabeled-skill";
    public static final String NOT_STRING = "(not (";
    private String WME_PATH_LEFT_ARROW = "<-";
    private int numFoA;
    private String name;
    private String selection;
    private String action;
    private String input;
    private int uses = 0;
    private int acceptedUses = 0;
    public static int count = 0;
    public int identity;
    private Hashtable<String, Point> selectionUses = new Hashtable();
    private ArrayList rhsOp = new ArrayList();
    private ArrayList lhsPath = new ArrayList();
    private ArrayList lhsTopologicalConsts = new ArrayList();
    private ArrayList lhsFeatures = new ArrayList();
    private final String SPECIAL_TUTOR_FACT = "?special-tutor-fact-correct";
    private final String STF_WME = "(special-tutor-fact-correct)";
    private final String SLOTS_EXCLUDE = "\\(description .+?\\)|\\(done .+?\\)|\\(subgoals .*?\\)|\\(turn .*?\\)|\\(position .+?\\)|\\(row-number .+?\\)|\\(column-number .+?\\)|\\(table-number .+?\\)";
    private final String HINT_MSG = "(hint-message (construct-message [ enter ?input ]))";
    private final String DONE_HINT_MSG = "(hint-message (construct-message [ press DONE button ]))";
    private final String SELECTION = "?selection";
    private final String INPUTVAR = "?input";
    static String format = "MMMMMMMMM dd, yyyy KK:mm:ss a";
    static SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.US);
    static String dateCreated = dateFormat.format(new Date());
    public static final String RULE_PREAMBLE_1 = ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\n;; Jess Production Rules for a Cognitive Tutor\n;;\n;; This file was automatically generated by a Simulated Student.\n;; Date of creation: " + dateCreated + "\n;;\n;; PSLC/CTAT Simulated Student Project, 2005, 2006\n;; Carnegie Mellon University\n;;\n\n;; Removing a following line will jeopardize the tutor's model tracing\n;; capability\n;; \n;; You may need to add similar statements if you wish to add your own\n;; predicates and operator symbols.  See\n;; http://herzberg.ca.sandia.gov/jess/docs/70/extending.html for details\n;; \n";
    private static final String OUTPUT_PREFIX = "?output";
    protected Vector factFeatures;
    private String DEFRULE = "defrule";
    private String JESS_ARROW = "=>";
    private String problemVar = null;
    final int FOA_NILL = 1;
    final int FOA_NOT_NILL = -1;
    final int FOA_BOTH = 0;

    boolean isDoneRule() {
        return this.getName().toUpperCase().equals(DONE_NAME);
    }

    public int getNumFoA() {
        return this.numFoA;
    }

    public void setNumFoA(int numFoa) {
        this.numFoA = numFoa;
    }

    String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    private String getSelection() {
        return this.selection;
    }

    private void setSelection(String selection) {
        this.selection = selection;
    }

    private String getAction() {
        return this.action;
    }

    private void setAction(String action) {
        this.action = action;
    }

    private String getInput() {
        return this.input;
    }

    private void setInput(String input) {
        this.input = input;
    }

    private int getInputVal() {
        return Integer.parseInt(this.input);
    }

    public int getUses() {
        return this.uses;
    }

    public int getAcceptedUses() {
        return this.acceptedUses;
    }

    public double getAcceptedRatio() {
        if (this.uses == 0) {
            return 0.0;
        }
        return (double)this.acceptedUses / (double)this.uses;
    }

    public double getSelectionAcceptRatio(Vector foas) {
        if (foas == null) {
            return 0.5;
        }
        String foaString = "";
        for (int i = 0; i < foas.size(); ++i) {
            foaString = foaString + foas.get(i);
        }
        Point pair = this.selectionUses.get(foaString);
        if (pair == null) {
            return 0.5;
        }
        return pair.getX() / pair.getY();
    }

    public void addAcceptedUse(Vector foas) {
        ++this.uses;
        ++this.acceptedUses;
        String foaString = "";
        for (int i = 0; i < foas.size(); ++i) {
            foaString = foaString + foas.get(i);
        }
        Point pair = this.selectionUses.get(foaString);
        if (pair == null) {
            pair = new Point(1, 1);
        } else {
            ++pair.x;
            ++pair.y;
        }
        this.selectionUses.put(foaString, pair);
    }

    public void addRejectedUse(Vector foas) {
        ++this.uses;
        String foaString = "";
        for (int i = 0; i < foas.size(); ++i) {
            foaString = foaString + foas.get(i);
        }
        Point pair = this.selectionUses.get(foaString);
        if (pair == null) {
            pair = new Point(0, 1);
        } else {
            ++pair.y;
        }
        this.selectionUses.put(foaString, pair);
    }

    public ArrayList getRhsOp() {
        return this.rhsOp;
    }

    private void addRhsOp(String op) {
        this.rhsOp.add(op);
    }

    ArrayList getLhsPath() {
        return this.lhsPath;
    }

    private void addLhsPath(String lhsPath) {
        lhsPath = lhsPath.replace("(value )", "(value nil)");
        this.lhsPath.add(lhsPath);
    }

    ArrayList getLhsTopologicalConsts() {
        return this.lhsTopologicalConsts;
    }

    private void addLhsTopologicalConsts(String constraint) {
        this.lhsTopologicalConsts.add(constraint);
    }

    private void setLhsTopologicalConsts(String constraints) {
        StringTokenizer tokenizer = new StringTokenizer(constraints, "|");
        while (tokenizer.hasMoreTokens()) {
            this.addLhsTopologicalConsts(tokenizer.nextToken());
        }
    }

    private void resetLhsFeatures() {
        this.lhsFeatures = new ArrayList();
    }

    ArrayList getLhsFeatures() {
        return this.lhsFeatures;
    }

    private void addLhsFeatures(String[] lhsFeatures) {
        this.lhsFeatures.add(lhsFeatures);
    }

    void setFeatures(Vector features) {
        this.resetLhsFeatures();
        for (int i = 0; i < features.size(); ++i) {
            Vector feature = (Vector)features.get(i);
            String[] featureSyms = new String[feature.size()];
            for (int j = 0; j < feature.size(); ++j) {
                featureSyms[j] = (String)feature.get(j);
            }
            this.addLhsFeatures(featureSyms);
        }
    }

    public Rule(String name, List lhs, List rhsOp) {
        this(name, new Vector(lhs), null, null, new Vector(rhsOp), "");
    }

    public Rule(String name, Vector lhsPath, Vector lhsFeatures, Vector featuresToTestAsFacts, Vector rhsOps, String action) {
        int i;
        this.identity = count++;
        this.setName(name);
        this.setAction(action);
        this.factFeatures = featuresToTestAsFacts;
        if (lhsPath != null) {
            for (i = 0; i < lhsPath.size(); ++i) {
                int index;
                String wmePath = (String)lhsPath.get(i);
                if (i == lhsPath.size() - 1 && (index = wmePath.indexOf(124)) > 0) {
                    String constraints = wmePath.substring(index + 1);
                    this.setLhsTopologicalConsts(constraints);
                    wmePath = wmePath.substring(0, index);
                }
                if (trace.getDebugCode("miss-rule")) {
                    trace.out("miss-rule", "Rule [" + name + "]: wmePath = " + wmePath);
                }
                this.addLhsPath(wmePath);
            }
        }
        if (rhsOps != null) {
            for (i = 0; i < rhsOps.size(); ++i) {
                this.addRhsOp((String)rhsOps.get(i));
            }
        }
        if (lhsFeatures != null) {
            for (i = 0; i < lhsFeatures.size(); ++i) {
                this.addLhsFeatures((String[])lhsFeatures.get(i));
            }
        }
    }

    public static boolean isDoneAction(String selection, String action, String input) {
        return selection.toUpperCase().equals(DONE_SELECTION.toUpperCase()) && action.toUpperCase().equals(DONE_ACTION.toUpperCase()) && input.toUpperCase().equals(DONE_INPUT);
    }

    public String toString(Vector<Instruction> instructions, SimStRete ssRete) {
        this.problemVar = null;
        String saiVal = null;
        String saiJessVar = null;
        if (!this.isDoneRule()) {
            String saiOp = "";
            if (this.getRhsOp().size() > 0) {
                saiOp = (String)this.getRhsOp().get(this.getRhsOp().size() - 1);
            }
            saiVal = saiOp.split(" ")[1];
        }
        String saiPath = (String)this.getLhsPath().get(this.getLhsPath().size() - 1);
        String[] saiPathNode = saiPath.split("\n");
        String saiWmeNode = saiPathNode[saiPathNode.length - 1];
        saiJessVar = saiWmeNode.split(" ")[0];
        String jessRule = "(" + this.DEFRULE + " " + this.getName() + "\n\n";
        jessRule = jessRule + this.printWmePaths(saiVal, instructions, ssRete);
        jessRule = jessRule + this.printTopologicalConditions() + "\n";
        jessRule = jessRule + this.printFeatureConditions(this.numFoA) + "\n";
        jessRule = jessRule + this.JESS_ARROW + "\n\n";
        jessRule = jessRule + this.printOperators(saiJessVar, saiVal) + "\n";
        jessRule = jessRule + ")\n";
        if (!this.isDoneRule()) {
            jessRule = jessRule.replaceAll(saiVal.substring(1), "?input".substring(1));
        }
        return jessRule;
    }

    private String getWmeNameFromWmePath(String wmePath) {
        String[] path = wmePath.split("\n");
        String lastLine = path[path.length - 1];
        Pattern p = Pattern.compile("\\(name .*?\\)", 32);
        Matcher m = p.matcher(lastLine);
        String foaPattern = "";
        while (m.find()) {
            foaPattern = m.group(0);
        }
        foaPattern = foaPattern.replaceAll("\\(|\\)", "");
        return foaPattern.split(" ")[1];
    }

    private String printWmePaths(String saiVal, Vector<Instruction> instructions, SimStRete ssRete) {
        String str = "";
        int no = 0;
        int seedNum = this.getLhsPath().size() - (this.isDoneRule() ? 0 : 1);
        for (int i = 0; i < seedNum; ++i) {
            String line = this.updateIntermediateValuesButLast((String)this.getLhsPath().get(i));
            ++no;
            line = this.processNameSlotValue(line, i);
            str = str + line + "\n";
        }
        str = str.replaceAll("MAIN::", "");
        str = str.replaceAll("\\(description .+?\\)|\\(done .+?\\)|\\(subgoals .*?\\)|\\(turn .*?\\)|\\(position .+?\\)|\\(row-number .+?\\)|\\(column-number .+?\\)|\\(table-number .+?\\)", "");
        str = str.replaceAll("\\<Fact-.+?\\>", "?");
        if (!this.isDoneRule()) {
            String selectionWme = this.replaceValName((String)this.getLhsPath().get(no), saiVal + "&nil");
            selectionWme = selectionWme.replaceAll("MAIN::", "");
            selectionWme = selectionWme.replaceAll("\\(name .+?\\)", "");
            selectionWme = selectionWme.replaceAll("\\(description .+?\\)|\\(done .+?\\)|\\(subgoals .*?\\)|\\(turn .*?\\)|\\(position .+?\\)|\\(row-number .+?\\)|\\(column-number .+?\\)|\\(table-number .+?\\)", "");
            selectionWme = this.assertNameBinding(selectionWme);
            str = str + selectionWme + "\n";
        }
        this.problemVar = str.split(" ")[0];
        return str;
    }

    private String processNameSlotValue(String line, int foaIndex) {
        int lastWmeIndex = line.lastIndexOf(this.WME_PATH_LEFT_ARROW);
        String successorWME = line.substring(0, lastWmeIndex);
        String targetWME = line.substring(lastWmeIndex);
        String foaString = "?foa" + foaIndex;
        targetWME = targetWME.replaceAll("\\(name .+?\\)", "(name " + foaString + ")");
        successorWME = successorWME.replaceAll("\\(name .+?\\)", "");
        return successorWME + targetWME;
    }

    private String replaceValName(String path, int id, int foaValueConstraint, String wmeNilValue) {
        String result = this.updateIntermediateValuesButLast(path);
        return result;
    }

    private String replaceValName(String path, String saiVal) {
        path = this.updateIntermediateValues(path);
        return Rule.replaceLast(path, "\\(value .+?\\)", "(value " + saiVal + ")");
    }

    protected String updateIntermediateValuesButLast(String path) {
        String returnPath = "";
        String[] line = path.split("\n");
        for (int i = 0; i < line.length - 1; ++i) {
            String anyVal = "(value ?)";
            String tmp = line[i].replaceFirst("\\(value .+?\\)", anyVal);
            returnPath = returnPath + tmp + "\n";
        }
        String lastLine = line[line.length - 1];
        if ((lastLine = lastLine.replaceFirst("\"", "")).contains("&nil")) {
            lastLine = lastLine.replace("&nil\"", "&nil");
        } else if (lastLine.contains("&~nil")) {
            lastLine = lastLine.replace("&~nil\"", "&~nil");
        } else if (lastLine.contains("val4\"")) {
            lastLine = lastLine.replaceFirst("val4\"", "val4");
        } else if (lastLine.contains("val3\"")) {
            lastLine = lastLine.replaceFirst("val3\"", "val3");
        } else if (lastLine.contains("val2\"")) {
            lastLine = lastLine.replaceFirst("val2\"", "val2");
        } else if (lastLine.contains("val1\"")) {
            lastLine = lastLine.replaceFirst("val1\"", "val1");
        } else if (lastLine.contains("val0\"")) {
            lastLine = lastLine.replaceFirst("val0\"", "val0");
        } else {
            lastLine = lastLine.replace("\\", "");
            lastLine = Rule.replaceLast(lastLine, "\"", "");
        }
        returnPath = returnPath + lastLine + "\n";
        return returnPath;
    }

    protected String updateIntermediateValues(String path) {
        String returnPath = "";
        String[] line = path.split("\n");
        for (int i = 0; i < line.length; ++i) {
            String anyVal = "(value ?)";
            String tmp = line[i].replaceFirst("\\(value .+?\\)", anyVal);
            returnPath = returnPath + tmp + "\n";
        }
        return returnPath;
    }

    private String assertNameBinding(String selectionWme) {
        return Rule.replaceLast(selectionWme, "\\(value", "(name ?selection) (value");
    }

    private String getWmeNameFromInstruction(String instructionLine) {
        String[] tmp = instructionLine.split("\\|");
        return tmp[1];
    }

    private String printTopologicalConditions() {
        String str = "";
        for (int i = 0; i < this.getLhsTopologicalConsts().size(); ++i) {
            str = str + "(test " + (String)this.getLhsTopologicalConsts().get(i) + ")\n";
        }
        return str;
    }

    private String printFeatureConditions(int numFoA) {
        String str;
        if (this.getLhsFeatures().isEmpty()) {
            str = ";; No feature conditions found...\n";
        } else {
            ArrayList lhsFeatures = this.getLhsFeatures();
            boolean disjunctive = lhsFeatures.size() > 1;
            str = disjunctive ? "(or\n" : "";
            for (int i = 0; i < lhsFeatures.size(); ++i) {
                boolean conjunctive;
                String[] features = (String[])lhsFeatures.get(i);
                boolean bl = conjunctive = disjunctive && features.length > 1;
                if (conjunctive) {
                    str = str + "  (and\n";
                }
                for (int j = 0; j < features.length; ++j) {
                    String pattern;
                    String condition = features[j];
                    String convertedCondition = this.replaceConditionVar(condition, numFoA);
                    boolean matchAsFact = this.isFactCondition(condition);
                    if (matchAsFact) {
                        String wmeName = Rule.getNameFromCondition(condition);
                        pattern = this.makeWMEPattern(wmeName, this.getArgs(convertedCondition), convertedCondition.indexOf(NOT_STRING) != -1);
                    } else {
                        pattern = "(test " + convertedCondition + ")\n";
                    }
                    str = str + (conjunctive ? "    " : (disjunctive ? "  " : "")) + pattern;
                }
                if (!conjunctive) continue;
                str = str + "  )\n";
            }
            if (disjunctive) {
                str = str + ")\n";
            }
        }
        return str;
    }

    private String getArgs(String convertedCondition) {
        int argEndIndex = convertedCondition.lastIndexOf(")");
        int notIndex = convertedCondition.indexOf(NOT_STRING);
        int argStartIndex = notIndex == -1 ? convertedCondition.indexOf(" ") + 1 : convertedCondition.indexOf(" ", notIndex + NOT_STRING.length()) + 1;
        return convertedCondition.substring(argStartIndex, argEndIndex);
    }

    private String makeWMEPattern(String predicateName, String args, boolean isNegation) {
        FeaturePredicate p = this.getFactFeatureByName(predicateName);
        Vector argNames = p.getArgNames();
        String pattern = isNegation ? NOT_STRING : "(";
        pattern = pattern + predicateName;
        String[] argsArray = args.split(" ");
        for (int argNum = 0; argNum < argNames.size(); ++argNum) {
            pattern = pattern + " (" + argNames.get(argNum) + " " + argsArray[argNum] + ")";
        }
        if (isNegation) {
            pattern = pattern + ")";
        }
        pattern = pattern + ")\n";
        return pattern;
    }

    private FeaturePredicate getFactFeatureByName(String predicateName) {
        if (this.factFeatures == null) {
            return null;
        }
        for (FeaturePredicate curPred : this.factFeatures) {
            if (!curPred.getName().equals(predicateName)) continue;
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Predicate found " + predicateName);
            }
            return curPred;
        }
        return null;
    }

    private boolean isFactCondition(String condition) {
        if (this.factFeatures.size() == 0) {
            return false;
        }
        String predicateName = Rule.getNameFromCondition(condition);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "NAME IS: " + predicateName);
        }
        return this.getFactFeatureByName(predicateName) != null;
    }

    private static String getNameFromCondition(String condition) {
        int notIndex = condition.indexOf(NOT_STRING);
        int leftParenIndex = condition.indexOf("(");
        int nameStartIndex = notIndex == -1 ? leftParenIndex + 1 : notIndex + NOT_STRING.length();
        int nameEndIndex = condition.indexOf(" ", nameStartIndex);
        return condition.substring(nameStartIndex, nameEndIndex);
    }

    private String replaceConditionVar(String condition, int numFoA) {
        String newCond = "";
        String[] terms = condition.split(" ");
        for (int i = 0; i < terms.length; ++i) {
            int outputCount = 0;
            if (terms[i].startsWith("?")) {
                int valN = terms[i].charAt(1) - 65;
                if (valN < numFoA) {
                    terms[i] = "?val" + valN;
                } else {
                    if (valN >= numFoA + outputCount) {
                        ++outputCount;
                    }
                    terms[i] = OUTPUT_PREFIX + (valN - numFoA);
                }
            }
            newCond = newCond + terms[i] + " ";
        }
        return newCond;
    }

    private String printTutorFactPath() {
        return "?special-tutor-fact-correct <- (special-tutor-fact-correct)\n";
    }

    private String printOperators(String saiJessVar, String input) {
        String str = "";
        if (!this.isDoneRule()) {
            for (int i = 0; i < this.getRhsOp().size(); ++i) {
                str = str + (String)this.getRhsOp().get(i) + "\n";
            }
        }
        str = str + this.printHereIsTheListOfFoas();
        if (!this.isDoneRule()) {
            str = str + this.printPredictSpecialInput(input);
            str = str + "(modify " + saiJessVar + " (value ?*sInput*))\n";
            str = str + "(construct-message \"[ Enter\" ?input \".]\")\n";
        } else {
            str = str + this.printPredictSpecialInput(input);
            str = str + "(modify " + this.problemVar + " (done TRUE))\n";
        }
        return str;
    }

    private String printHereIsTheListOfFoas() {
        int seedNum = this.getLhsPath().size() - (this.isDoneRule() ? 0 : 1);
        String str = "(here-is-the-list-of-foas";
        for (int i = 0; i < seedNum; ++i) {
            str = str + " ?foa" + i;
        }
        str = str + ")\n";
        return str;
    }

    private String printPredictSpecialInput(String input) {
        String selectionStr = this.isDoneRule() ? DONE_SELECTION : "?selection";
        String actionStr = this.isDoneRule() ? DONE_ACTION : this.getAction();
        String inputStr = this.isDoneRule() ? DONE_INPUT : input;
        String str = "(" + SimSt.getPredictObservableActionName() + " ";
        str = str + selectionStr + " ";
        str = str + actionStr + " ";
        str = str + inputStr + " ";
        str = str + ")\n";
        return str;
    }

    private String printModifyTutorFact(String input) {
        String str = "(modify ?special-tutor-fact-correct\n";
        String selectionStr = this.isDoneRule() ? DONE_SELECTION : "?selection";
        str = str + "  (selection " + selectionStr + ")\n";
        String actionStr = this.isDoneRule() ? DONE_ACTION : this.getAction();
        str = str + "  (action " + actionStr + ")\n";
        String inputStr = this.isDoneRule() ? DONE_INPUT : input;
        str = str + "  (input " + inputStr + ")\n";
        String hintStr = this.isDoneRule() ? "(hint-message (construct-message [ press DONE button ]))" : "(hint-message (construct-message [ enter ?input ]))";
        str = str + "  " + hintStr + ")\n";
        return str;
    }

    public static String getRuleBaseName(String ruleName) {
        int ampersandIndex = ruleName.indexOf("&");
        return ampersandIndex == -1 ? ruleName : ruleName.substring(0, ampersandIndex);
    }

    public static String replaceLast(String input, String regex, String replacement) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (!matcher.find()) {
            return input;
        }
        int lastMatchStart = 0;
        do {
            lastMatchStart = matcher.start();
        } while (matcher.find());
        matcher.find(lastMatchStart);
        StringBuffer sb = new StringBuffer(input.length());
        matcher.appendReplacement(sb, replacement);
        matcher.appendTail(sb);
        return sb.toString();
    }

    int getFoaValueConstraint(int i, Vector<Instruction> instrunctions, SimStRete ssRete) {
        int returnValue = -1;
        boolean firstIteration = true;
        for (Instruction inst : instrunctions) {
            int curValue;
            String currentValue = inst.getValues().get(i + 1).toString();
            int n = curValue = SimStRete.isNilVal(currentValue) ? 1 : -1;
            if (firstIteration) {
                returnValue = curValue;
                firstIteration = false;
                continue;
            }
            if (returnValue == curValue) continue;
            returnValue = 0;
            break;
        }
        return returnValue;
    }

    private String foaConstraintValueToPrint(int value, String wmeNilValue) {
        String returnValue = value == 1 ? "&" + wmeNilValue : (value == -1 ? "&~" + wmeNilValue : "");
        return returnValue;
    }
}

