/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.console.controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import edu.cmu.pact.miss.MetaTutor.APlusHintMessagesManager;
import edu.cmu.pact.miss.MissControllerExternal;
import edu.cmu.pact.miss.PeerLearning.GameShow.Contestant;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowWrapper;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.PeerLearning.SimStPLE;
import edu.cmu.pact.miss.PeerLearning.SimStPLEWrapper;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.WebStartFileDownloader;
import edu.cmu.pact.miss.console.view.MissConsole;
import edu.cmu.pact.miss.storage.StorageClient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jess.JessException;
import pact.CommWidgets.TutorWrapper;

public class MissController
implements MissControllerExternal {
    SimSt simSt;
    private SimStLogger logger;
    private MissConsole missConsole;
    private StorageClient storageClient;
    private APlusHintMessagesManager aPlusHintMessagesManager;
    private CTAT_Launcher ctatLauncher;
    public static final String FILE_MENU = "File";
    public static final String NEW_PROBLEM = "New Problem";
    public static final String LOAD_WME_TYPE = "Load WME Types";
    public static final String INIT_WME = "Initialize WMEs";
    public static final String LOAD_PREDICATE = "Load Feature Predicates";
    public static final String LOAD_OPERATOR = "Load Operators";
    public static final String LOAD_INSTRUCTIONS = "Load Instructions";
    public static final String SAVE_INSTRUCTIONS = "Save Instructions";
    public static final String PROD_SYS_MENU = "Prod.System";
    public static final String TEST_MODEL_ON = "Test Current Model on...";
    public static final String DEBUG_MENU = "Debugging...";
    public static final String HIBERNATE_SS = "Hibernate Sim.St";
    public static final String WAKEUP_SS = "Wakeup Sim.St";
    public static final String INSTRUCTIONS_FILE_NAME = "instructions.txt";
    private JFileChooser fileChooser = new JFileChooser();
    public static final String PRESERVE_PR = "preserve_pr";
    private SimStPLE simStPLE = null;
    private boolean PLEon = false;
    private boolean batchMode = false;
    private boolean contestMode = false;
    Integer whatToDoWithExistingPrFile = null;
    static final int OPEN = 1;
    static final int SAVE = 2;
    private String[] ssValidationProblemSet;
    private String[] ssValidationTestSet;
    private String ssValidationOutput;
    private int ssValidationNumIteration;
    private boolean ssBatchMode = false;
    private boolean ssFixedLearningMode = false;
    private boolean ssContest = false;
    private boolean ssShuffleRunMode = false;
    private boolean ssAnalysisOfFitnessWilkinsburg = false;
    private boolean ssRunValidation = false;
    private boolean ssValidateStepsInBRD = false;
    private boolean ssLogStudentsLearning = false;
    private boolean simStPleOn = false;

    @Override
    public SimSt getSimSt() {
        return this.simSt;
    }

    @Override
    public MissConsole getMissConsole() {
        return this.missConsole;
    }

    void setMissConsole(MissConsole missConsole) {
        this.missConsole = missConsole;
    }

    public SimStLogger getLogger() {
        return this.logger;
    }

    public StorageClient getStorageClient() {
        return this.storageClient;
    }

    public void setStorageClient(StorageClient storageClient) {
        this.storageClient = storageClient;
    }

    @Override
    public APlusHintMessagesManager getAPlusHintMessagesManager() {
        return this.aPlusHintMessagesManager;
    }

    @Override
    public void setAPlusHintMessagesManager(APlusHintMessagesManager aPlusHintMessagesManager) {
        this.aPlusHintMessagesManager = aPlusHintMessagesManager;
    }

    public BR_Controller getBrController() {
        return this.getCtatLauncher().getFocusedController();
    }

    JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    @Override
    public String getDefaultRuleSetName() {
        return "simSt";
    }

    @Override
    public SimStPLE getSimStPLE() {
        return this.simStPLE;
    }

    public void setSimStPLE(SimStPLE simStPLE) {
        this.simStPLE = simStPLE;
    }

    @Override
    public boolean isPLEon() {
        return this.PLEon;
    }

    public void setPLEon(boolean eon) {
        this.PLEon = eon;
    }

    public MissController(BR_Controller brController) {
        this(brController, "");
    }

    public void SimStudentSelected() {
    }

    public MissController(CTAT_Launcher ctatLauncher, String preservePr) {
        this.ctatLauncher = ctatLauncher;
        this.initMissController(this.getBrController(), preservePr);
    }

    public MissController(BR_Controller brController, String preservePr) {
        this.initMissController(brController, preservePr);
    }

    protected void initMissController(BR_Controller brController, String preservePr) {
        this.logger = new SimStLogger(brController);
        this.simSt = new SimSt(this);
        this.missConsole = new MissConsole(this, brController);
        this.getSimSt().initBKwithMissConsole();
        PreferencesModel pm = this.getPreferencesModel();
        String dir = pm.getStringValue("Miss FileChooser Path");
        if (dir != null) {
            this.fileChooserSetCurrentDir(dir);
        }
        this.storageClient = new StorageClient();
    }

    public void reset() {
    }

    @Override
    public void dealWithAnyExistingPrFile() {
        String prFileName = this.getSimSt().getPrFileName();
        File prFile = new File(this.getSimSt().getProjectDir(), prFileName);
        if (prFile.exists()) {
            boolean deletePrFile;
            if (trace.getDebugCode("ss")) {
                trace.out("ss", "Running in Contest Mode: " + this.isSsContest());
            }
            if (this.getBrController().isClArgumentSetToProtectProdRules() || this.isSsContest()) {
                if (trace.getDebugCode("gusmiss")) {
                    trace.out("gusmiss", "initializeSimStInteractive: preserve is true");
                }
                deletePrFile = false;
            } else {
                if (trace.getDebugCode("gusmiss")) {
                    trace.out("gusmiss", "initializeSimStInteractive: preserve is false");
                }
                if (!this.getBrController().isDeletePrFile()) {
                    int buttonPressed;
                    if (trace.getDebugCode("gusmiss")) {
                        trace.out("gusmiss", "initializeSimStInteractive: delete is false");
                    }
                    if ((buttonPressed = this.askWhatToDoWithExistingPrFile(prFile, this.getSimSt().getPrFileName())) == 0) {
                        File backupFile = this.chooseFileByDialog(1);
                        prFile.renameTo(backupFile);
                        if (trace.getDebugCode("miss")) {
                            trace.out("miss", "The file " + prFileName + " has been renamed to " + backupFile);
                        }
                    }
                    deletePrFile = buttonPressed == 1;
                } else {
                    if (trace.getDebugCode("gusmiss")) {
                        trace.out("gusmiss", "initializeSimStInteractive: protect is false");
                    }
                    deletePrFile = true;
                }
            }
            if (deletePrFile) {
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "deleting PR file");
                }
                this.deleteFile(prFile);
            }
        }
    }

    private void deleteFile(String dir, String fileName) {
        File file = new File(dir, fileName);
        this.deleteFile(file);
    }

    private void deleteFile(File file) {
        if (file.exists()) {
            System.out.println("deleting a file!");
            file.delete();
        }
    }

    @Override
    public void activate(boolean newStatus) {
        this.getMissConsole().setVisible(newStatus);
        String msg = "Miss Controller " + (newStatus ? "" : "de") + "activated!!";
        if (trace.getDebugCode("miss")) {
            trace.out("miss", msg);
        }
    }

    public void hibernateSimSt(boolean hibernate) {
        this.getSimSt().setMissHibernating(hibernate);
        this.getMissConsole().switchMissHibernationMenu(hibernate);
    }

    @Override
    public boolean isMissHibernating() {
        return this.getSimSt().isMissHibernating();
    }

    @Override
    public void startNewProblem() {
        this.getSimSt().startNewProblem();
    }

    @Override
    public void startStateCreated(ProblemNode startProblemNode) {
        this.getSimSt().startStateCreated(startProblemNode);
    }

    public void setConsoleCurrentProblemName(String name) {
        this.getMissConsole().setCurrentProblemName(name);
    }

    public void addConsoleProblemList(String name) {
        this.getMissConsole().addProblemList(name);
    }

    @Override
    public boolean isFocusOfAttentionSpecified() {
        return this.getSimSt().isFocusOfAttentionSpecified();
    }

    @Override
    public void askSpecifyFocusOfAttention() {
        this.getMissConsole().message("Please specify Focus Of Attention.");
        if (trace.getDebugCode("gusIL")) {
            trace.out("gusIL", "Please specify Focus Of Attention.");
        }
    }

    @Override
    public void toggleFocusOfAttention(Object widget) {
        this.getSimSt().toggleFocusOfAttention(widget);
    }

    @Override
    public void stepDemonstrated(ProblemNode state, Vector selection, Vector action, Vector input, ProblemEdge edge) {
        this.getSimSt().stepDemonstrated(state, selection, action, input, edge, null);
    }

    @Override
    public void skillNameSet(String name, ProblemNode state) {
        this.getSimSt().changeInstructionName(name, state);
    }

    public void updateConsoleSkillNameList(Vector skillNames) {
        this.getMissConsole().updateSkillNameList(skillNames);
    }

    public void setNumStepDemonstrated(int n) {
        this.getMissConsole().setNumStepsDemonstrated(n);
    }

    public void consoleSetNumProductionRules(int n) {
        this.getMissConsole().setNumProductionRules(n);
    }

    public void rollBackState(ProblemNode state) {
    }

    @Override
    public void ssShuffleRunInBatch(String[] trainingSet, String[] testSet, String output, int numIteration) {
        this.getSimSt().ssShuffleRunInBatch(trainingSet, testSet, output, numIteration);
    }

    @Override
    public boolean isBatchModeOn() {
        return this.batchMode;
    }

    @Override
    public void runSimStInBatchMode(String[] trainingSet, String[] testSet, String output) {
        this.batchMode = true;
        this.getSimSt().ssRunInBatchMode(trainingSet, testSet, output);
    }

    @Override
    public boolean isContestOn() {
        return this.contestMode;
    }

    @Override
    public void runSimStInContestMode() {
        this.contestMode = true;
        this.getSimSt().ssRunInContestMode();
    }

    @Override
    public void setOpCached(boolean flag) {
        this.getSimSt().setOpCached(flag);
    }

    @Override
    public void setFoilLogDir(String foilLogDir) {
        this.getSimSt().setFoilLogDir(foilLogDir);
    }

    public void setFoilMaxTuples(String foilMaxTuples) {
        this.getSimSt().setFoilMaxTuples(foilMaxTuples);
    }

    @Override
    public void setPrAgeDir(String prAgeDir) {
        this.getSimSt().setPrAgeDir(prAgeDir);
    }

    @Override
    public void setSsBatchMode(boolean flag) {
        this.getSimSt().setSsBatchMode(flag);
    }

    @Override
    public void setSsFixedLearningMode(boolean flag) {
        this.getSimSt().setSsFixedLearningMode(flag);
    }

    @Override
    public void setSsMetaTutorMode(boolean flag) {
        if (this.getSimSt() != null) {
            this.getSimSt().setSsMetaTutorMode(flag);
        }
        this.aPlusHintMessagesManager = new APlusHintMessagesManager(this.getCtatLauncher());
    }

    @Override
    public void setSsQuizProblemAbstractorClass(String quizProblemAbstractor) {
        this.getSimSt().setSsQuizProblemAbstractor(quizProblemAbstractor);
    }

    @Override
    public void setSsCondition(String ssCondition) {
        this.getSimSt().setSsCondition(ssCondition);
    }

    @Override
    public void setSsFoaGetterClass(String foaGetter) {
        this.getSimSt().setSsFoaGetter(foaGetter);
    }

    public void setSsProlbemAssesorClass(String paClass) {
        this.getSimSt().setProblemAssessor(paClass);
    }

    @Override
    public void setSsSelectionOrderGetterClass(String selectionGetter) {
        this.getSimSt().setSsSelectionGetter(selectionGetter);
    }

    @Override
    public void setSsSaiConverterClass(String saiConverter) {
        this.getSimSt().setSsSaiConverter(saiConverter);
    }

    @Override
    public void setSsInterfaceElementGetterClass(String interfaceElementGetter) {
        this.getSimSt().setSsInterfaceElementGetter(interfaceElementGetter);
    }

    @Override
    public void setSsHeuristicBasedIDS(boolean flag) {
        this.getSimSt().setSsHeuristicBasedIDS(flag);
    }

    @Override
    public void setSsFoaClickDisabled(boolean flag) {
        this.getSimSt().setSsFoaClickDisabled(flag);
    }

    @Override
    public void setSsInputCheckerClass(String foaGetter) {
        this.getSimSt().setSsInputChecker(foaGetter);
    }

    @Override
    public void setSsSkillNameGetterClass(String skillNameGetter) {
        this.getSimSt().setSsSkillNameGetter(skillNameGetter);
    }

    @Override
    public void setSsPathOrderingClass(String className) {
        this.getSimSt().setSsPathOrderer(className);
    }

    @Override
    public void setSsMemoryWindowSize(String memoryWindowSize) {
        this.getSimSt().setMemoryWindowSize(Integer.parseInt(memoryWindowSize));
    }

    @Override
    public void setSsLearningLogFile(String learningLogFile) {
        this.getSimSt().setLearningLogFile(learningLogFile);
    }

    @Override
    public void setSsLearnCltErrorActions(boolean flag) {
        this.getSimSt().setLearnCltErrorActions(flag);
    }

    @Override
    public void setSsLearnBuggyActions(boolean flag) {
        this.getSimSt().setLearnBuggyActions(flag);
    }

    @Override
    public void setSsLearnCorrectActions(boolean flag) {
        this.getSimSt().setLearnCorrectActions(flag);
    }

    @Override
    public void setSsVerifyNumFoA(boolean flag) {
        if (trace.getDebugCode("nlexc")) {
            trace.out("nlexc", "setSsIsBootstrapping called!");
        }
        this.getSimSt().setVerifyNumFoA(flag);
    }

    @Override
    public void setSsFeaturePredicateFile(String featurePredcatesFile) {
        this.getSimSt().setFeaturePredicateFile(featurePredcatesFile);
    }

    @Override
    public void setSsMaxSearchDepth(int i) {
        this.getSimSt().setMaxSearchDepth(i);
    }

    @Override
    public void setSsOperatorFile(String operatorFilePath) {
        this.getSimSt().setOperatorFile(operatorFilePath);
    }

    @Override
    public void setSsUserDefSymbols(String userDefSymbols) {
        this.getSimSt().setUserDefSymbols(userDefSymbols);
    }

    @Override
    public void setSsPredictObservableActionName(String dn) {
        this.getSimSt();
        SimSt.setPredictObservableActionName(dn);
    }

    @Override
    public void setSsMemoryWindowOverRules(boolean flag) {
        this.getSimSt().setMemoryWindowOverIndividualRules(flag);
    }

    @Override
    public void setForceToUpdateModel(boolean flag) {
        this.getSimSt().setForceToUpdateModel(flag);
    }

    @Override
    public void setSsFoaSearch(boolean flag) {
        this.getSimSt().setSsFoaSearch(flag);
    }

    @Override
    public void setClArgumentSetToProtectProdRules(boolean flag) {
        this.getBrController().setClArgumentSetToProtectProdRules(flag);
    }

    @Override
    public void setSsDeletePrFile(boolean flag) {
        this.getBrController().setDeletePrFile(flag);
    }

    @Override
    public void setSsSearchTimeOutDuration(String longDuration) {
        this.getSimSt().setTimeoutDuration(Long.parseLong(longDuration));
    }

    public void setSsInactiveInterfaceTimeOutDuration(String longDuration) {
        this.getSimSt().setInactiveInterfaceTimeoutDuration(Long.parseLong(longDuration));
    }

    @Override
    public void setSsTutorServerTimeOutDuration(String longDuration) {
        this.getSimSt().setServerTimeoutDuration(Long.parseLong(longDuration));
    }

    @Override
    public void setSsLogging(boolean flag) {
        this.getSimSt().setLoggingEnabled(flag);
    }

    @Override
    public void setSsLocalLogging(boolean flag) {
        this.getSimSt().setLocalLoggingEnabled(flag);
    }

    @Override
    public void setSsDummyContest(boolean flag) {
        this.getSimSt().setDummyContestResponse(flag);
    }

    @Override
    public void setSsContestServer(String server) {
        Contestant.setContestServer(server);
    }

    @Override
    public void setSsContestPort(int port) {
        Contestant.setContestPort(port);
    }

    @Override
    public void setSsUserID(String userID) {
        this.getSimSt().setUserID(userID);
        this.getBrController().getLogger().setAnonymizedStudentName(userID);
    }

    @Override
    public void setSsSimStName(String name) {
        this.getSimSt();
        SimSt.setSimStName(name);
    }

    @Override
    public void setSsSimStImage(String img) {
        this.getSimSt().setSimStImage(img);
    }

    @Override
    public void setSimStProblemsPerQuizSection(int num) {
        this.getSimSt().setSimStProblemsPerQuizSection(num);
    }

    @Override
    public void setSimStLogURL(String logURL) {
        SimStLogger.log_url = logURL;
    }

    @Override
    public void ssUseDecomposition() {
        this.getSimSt().setDecomposeInput(true);
    }

    @Override
    public void setSsRuleActivationTestMethod(String ssRuleActivationTestMethod) {
        this.getSimSt().setRuleActivationTestMethod(ssRuleActivationTestMethod);
    }

    public void setSsQuizGradingMethod(String ssQuizGradingMethod) {
        this.getSimSt().setQuizGradingMethod(ssQuizGradingMethod);
    }

    public void setSsPackageName(String ssPackageName) {
        this.getSimSt().setPackageName(ssPackageName);
    }

    public void setSsPrValidationMethod(String ssPrValidationMethod) {
        this.getSimSt().setPrValidationMethod(ssPrValidationMethod);
    }

    public void setSsModelTracingValidationOutcome(String ssModelTracingValidationOutcome) {
        this.getSimSt().setModelTracingValidationOutcomeMethod(ssModelTracingValidationOutcome);
    }

    @Override
    public void setSsHintMethod(String ssRuleActivationTestMethod) {
        this.getSimSt().setHintMethod(ssRuleActivationTestMethod);
    }

    @Override
    public void setSsNumBadInputRetries(int numRetries) {
        this.getSimSt().setSsNumBadInputRetries(numRetries);
    }

    @Override
    public void setSsUseTutalk(String param) {
        this.getSimSt().setUseTutalk(param);
    }

    @Override
    public void setSsIntroVideo(String name) {
        SimStPLE.setVideoIntroductionName(name);
    }

    @Override
    public void setSsOverview(String name) {
        SimStPLE.setOverviewPageName(name);
    }

    @Override
    public void setSsCLQuizReqMode() {
        if (this.getSimSt() != null) {
            this.getSimSt().setSSCLQuizReqMode(true);
        }
    }

    @Override
    public void setSsSelfExplainMode() {
        if (this.getSimSt() != null) {
            this.getSimSt().setSSSelfExplainMode(true);
        }
    }

    public String getSimStWmeTypeFile() {
        return this.getSimSt().getWmeTypeFile();
    }

    @Override
    public void setSimStWmeTypeFile() {
        this.getMissConsole().message("Select a file that contains WME types...");
        File file = this.chooseFileByDialog(1);
        if (file == null) {
            return;
        }
        String fileName = file.getAbsolutePath();
        this.getSimSt().setWmeTypeFile(fileName);
        this.setConsoleWmeTypeFileLabel(fileName);
    }

    public void setConsoleWmeTypeFileLabel(String label) {
        if (this.getMissConsole() != null) {
            this.getMissConsole().setWmeTypeFileLabel(label);
        }
    }

    public String getSimStInitStateFile() {
        return this.getSimSt().getInitStateFile();
    }

    @Override
    public void setSimStInitStateFile() {
        this.getMissConsole().message("Select a file that contains the initial WME definitions...");
        File file = this.chooseFileByDialog(1);
        if (file == null) {
            return;
        }
        String fileName = file.getAbsolutePath();
        this.getSimSt().setInitStateFile(fileName);
        this.setConsoleInitWmeFileLabel(fileName);
    }

    public void setConsoleInitWmeFileLabel(String label) {
        this.getMissConsole().setInitWmeFileLabel(label);
    }

    @Override
    public void readSimStPredicateSymbols() {
        String msg = "Select a file to read predicate symbols...";
        this.getMissConsole().message(msg);
        File file = this.chooseFileByDialog(1);
        if (file == null) {
            msg = msg + "no file selected.";
            this.getMissConsole().message(msg);
            return;
        }
        String fileName = file.getAbsolutePath();
        msg = msg + "done\nRead predicates from " + fileName + "...";
        this.getMissConsole().message(msg);
        this.getSimSt().readPredicateSymbols(fileName);
        this.consoleDisplayPredicates(this.getSimSt().getPredicates());
        msg = msg + "done";
        this.getMissConsole().message(msg);
    }

    public void consoleDisplayPredicates(Vector predicates) {
        if (this.getMissConsole() != null) {
            this.getMissConsole().displayPredicates(predicates);
        }
    }

    @Override
    public void readSimStOperators() {
        String msg = "Select a file to read operator symbols...";
        this.getMissConsole().message(msg);
        File file = this.chooseFileByDialog(1);
        if (file == null) {
            msg = msg + "no file selected.";
            this.getMissConsole().message(msg);
            return;
        }
        String fileName = file.getAbsolutePath();
        msg = msg + "done\nRead operator symbols from " + fileName + "...";
        this.getMissConsole().message(msg);
        this.getSimSt().readRhsOpList(fileName);
        this.consoleDisplayOperators(this.getSimSt().getRhsOpList());
        msg = msg + "done";
        this.getMissConsole().message(msg);
    }

    public void consoleDisplayOperators(Vector ops) {
        this.getMissConsole().displayOperators(ops);
    }

    @Override
    public void saveInstructions() {
        String msg = "Select location to save demonstrated steps...";
        this.getMissConsole().message(msg);
        File file = this.chooseFileByDialog(2);
        if (file == null) {
            msg = msg + "no file selected.";
            this.getMissConsole().message(msg);
            return;
        }
        String fileName = file.getAbsolutePath();
        msg = msg + "done\nSaved work to " + fileName + "...";
        this.getMissConsole().message(msg);
        this.getSimSt().saveInstructions(file);
        msg = msg + "done";
        this.getMissConsole().message(msg);
    }

    public void autoSaveInstructions() {
        String msg = "";
        String fileName = INSTRUCTIONS_FILE_NAME;
        if (this.getSimSt() != null && this.getSimSt().getUserID() != null) {
            fileName = "instructions-" + this.getSimSt().getUserID() + ".txt";
        }
        msg = msg + "done\nSaved work to " + fileName + "...";
        this.getMissConsole().message(msg);
        File instructionsFile = null;
        File wmeTypeFile = null;
        wmeTypeFile = new File(new File(".").getAbsolutePath(), "wmeTypes.clp");
        if (wmeTypeFile != null && wmeTypeFile.isAbsolute() && wmeTypeFile.exists()) {
            instructionsFile = new File(fileName);
            this.getSimSt().saveInstructions(instructionsFile);
        } else {
            try {
                instructionsFile = new File(WebStartFileDownloader.SimStWebStartDir + fileName);
                this.getSimSt().saveInstructions(instructionsFile);
                this.storageClient.storeFile("instructions-" + this.getSimSt().getUserID() + ".txt", instructionsFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        msg = msg + "done";
        this.getMissConsole().message(msg);
    }

    @Override
    public void loadInstructions() {
        String msg = "Select file to load previously demonstrated steps...";
        this.getMissConsole().message(msg);
        File file = this.chooseFileByDialog(1);
        if (file == null) {
            msg = msg + "no file selected.";
            this.getMissConsole().message(msg);
            return;
        }
        String fileName = file.getAbsolutePath();
        msg = msg + "done\nOpened work from " + fileName + "...";
        this.getMissConsole().message(msg);
        try {
            this.getSimSt().loadInstructions(file);
        }
        catch (Exception e) {
            this.getMissConsole().message("Error: Could not load instructions.");
            e.printStackTrace();
            this.logger.simStLogException(e);
            return;
        }
        msg = msg + "done";
        this.getMissConsole().message(msg);
    }

    public void autoLoadInstructions() {
        String fileName = INSTRUCTIONS_FILE_NAME;
        if (this.getSimSt() != null && this.getSimSt().getUserID() != null) {
            fileName = "instructions-" + this.getSimSt().getUserID() + ".txt";
        }
        File file = new File(fileName);
        if (!this.getSimSt().isWebStartMode()) {
            if (file != null && file.exists()) {
                this.getBrController().setDeletePrFile(true);
                this.dealWithAnyExistingPrFile();
                try {
                    this.getSimSt().loadInstructions(file);
                }
                catch (Exception e) {
                    trace.out("Error reading instructions file.");
                    this.setClArgumentSetToProtectProdRules(false);
                    return;
                }
                this.setClArgumentSetToProtectProdRules(true);
            }
            if ((file == null || !file.exists() || this.getSimSt() != null && this.getSimSt().getInstructionCount() == 0) && (file = new File(fileName = "instructions-9_initial.txt")) != null && file.exists()) {
                this.getBrController().setDeletePrFile(true);
                this.dealWithAnyExistingPrFile();
                try {
                    if (trace.getDebugCode("miss")) {
                        trace.out("miss", "Loading instructions file: " + file);
                    }
                    this.getSimSt().loadInstructions(file);
                }
                catch (Exception e) {
                    trace.out("Error reading instructions file.");
                    e.printStackTrace();
                    this.setClArgumentSetToProtectProdRules(false);
                    return;
                }
                this.setClArgumentSetToProtectProdRules(true);
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "Exiting autoLoadInstructions");
                }
            }
        } else {
            boolean successful = false;
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Loading the file: " + fileName + "for user: " + this.getSimSt().getUserID());
            }
            try {
                successful = this.storageClient.retrieveFile(this.getSimSt().getUserID(), fileName, WebStartFileDownloader.SimStWebStartDir);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (successful) {
                file = new File(WebStartFileDownloader.SimStWebStartDir + fileName);
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "WebStart: Loading the file for the user: " + this.getSimSt().getUserID() + "  " + WebStartFileDownloader.SimStWebStartDir + fileName);
                }
                this.getBrController().setDeletePrFile(true);
                this.dealWithAnyExistingPrFile();
                try {
                    this.getSimSt().loadInstructions(file);
                }
                catch (Exception e) {
                    this.setClArgumentSetToProtectProdRules(false);
                    return;
                }
                this.setClArgumentSetToProtectProdRules(true);
            } else {
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "WebStart: Loading the default instructions file");
                }
                WebStartFileDownloader ff = new WebStartFileDownloader();
                String path = ff.findFile("instructions-9_initial.txt");
                this.getBrController().setDeletePrFile(true);
                this.dealWithAnyExistingPrFile();
                try {
                    this.getSimSt().loadInstructions(new File(path));
                }
                catch (Exception e) {
                    this.setClArgumentSetToProtectProdRules(false);
                    return;
                }
                this.setClArgumentSetToProtectProdRules(true);
            }
        }
    }

    public boolean loadInstDeSerialize() {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Inside loadInstnDeSerialize");
        }
        String fileName = "simst.ser";
        if (this.getSimSt() != null && this.getSimSt().getUserID() != null) {
            fileName = "simst-" + this.getSimSt().getUserID() + ".ser";
        }
        File serFile = new File(fileName);
        if (!this.getSimSt().isWebStartMode()) {
            if (serFile != null && serFile.exists()) {
                this.getBrController().setDeletePrFile(true);
                this.dealWithAnyExistingPrFile();
                this.getSimSt().loadInstnDeSerialize(serFile);
                this.setClArgumentSetToProtectProdRules(true);
                return true;
            }
            if ((serFile == null || !serFile.exists() || this.getSimSt() != null) && (serFile = new File(fileName = "simst.ser")) != null && serFile.exists()) {
                this.getBrController().setDeletePrFile(true);
                this.dealWithAnyExistingPrFile();
                this.getSimSt().loadInstnDeSerialize(serFile);
                this.setClArgumentSetToProtectProdRules(true);
                return true;
            }
        } else {
            SimSt simStObj;
            block11: {
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "Loading the instructions by deserializing using Webstart");
                }
                simStObj = null;
                try {
                    simStObj = (SimSt)this.storageClient.retrieveObject("simst-" + this.getSimSt().getUserID() + ".ser");
                }
                catch (IOException e) {
                    if (!trace.getDebugCode("rr")) break block11;
                    trace.err(e.getMessage());
                }
            }
            if (simStObj != null) {
                this.getBrController().setDeletePrFile(true);
                this.dealWithAnyExistingPrFile();
                this.getSimSt().loadInstnDeSerialize(simStObj);
                this.setClArgumentSetToProtectProdRules(true);
                return true;
            }
            WebStartFileDownloader ff = new WebStartFileDownloader();
            String path = ff.findFile("simst.ser");
            if (path != null) {
                this.getBrController().setDeletePrFile(true);
                this.dealWithAnyExistingPrFile();
                this.getSimSt().loadInstnDeSerialize(new File(path));
                this.setClArgumentSetToProtectProdRules(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public int askWhatToDoWithExistingPrFile(File prFile, String prFileName) {
        int doBackup = -1;
        String title = "Backup " + prFileName + "...";
        String[] message = new String[]{"There exists a production rule file (" + prFileName + ").", "Would you like to save a copy of this file?", "", "  Yes: Save a copy & delete a current file", "  No: Delete a current file", "  Cancel: Use a current file"};
        AbstractCtatWindow frame = this.getCtatLauncher().getActiveWindow();
        doBackup = JOptionPane.showConfirmDialog(frame, message, title, 1, 3);
        this.whatToDoWithExistingPrFile = doBackup;
        return this.whatToDoWithExistingPrFile;
    }

    public String getNumProductionRules() {
        return this.getMissConsole().getNumProductionRules().getText();
    }

    public void agePrFile(String pDir, String ageDir, String prFileName, int numRules, int numSteps) {
        boolean result;
        File prFile = new File(pDir, prFileName);
        String ageFileName = prFileName + "-R" + numRules + "S" + numSteps;
        String fullAgePath = pDir + "/" + ageDir;
        File ageFile = new File(fullAgePath, ageFileName).getAbsoluteFile();
        File fullAgePathFile = new File(fullAgePath).getAbsoluteFile();
        if (!fullAgePathFile.exists()) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Directory " + fullAgePath + " created.");
            }
            fullAgePathFile.mkdirs();
        }
        if (ageFile.exists()) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "#### MissController.agePrFile: target file exists " + ageFile);
            }
            ageFile.delete();
        }
        if (result = prFile.renameTo(ageFile)) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "File " + prFile + " has been preserved as " + ageFile);
            }
        } else if (trace.getDebugCode("miss")) {
            trace.out("miss", "!!" + prFile + " renaming failed (" + ageFile + ")");
        }
    }

    public ArrayList getMtRuleSeq() {
        return this.getBrController().getModelTracer().getMtRuleSeq();
    }

    public String getThisRuleName() {
        return this.getBrController().getModelTracer().getRete().getThisRuleName();
    }

    public Iterator getListActivations() {
        return this.getBrController().getModelTracer().getRete().listActivations();
    }

    @Override
    public void testProductionModelOn() {
        this.getSimSt().testProductionModelOn();
    }

    public void resetMT() {
        try {
            this.getBrController().getModelTracer().getRete().reset();
        }
        catch (JessException e) {
            e.printStackTrace();
            this.logger.simStLogException((Exception)((Object)e));
        }
    }

    public int runMT() {
        try {
            return this.getBrController().getModelTracer().getRete().run();
        }
        catch (JessException e) {
            e.printStackTrace();
            this.logger.simStLogException((Exception)((Object)e));
            return -1;
        }
    }

    public void reloadProductionRulesFile(File prFile) {
        this.getBrController().reloadProductionRulesFile(prFile);
    }

    File chooseFileByDialog(int mode) {
        int returnVal;
        File theFile = null;
        int n = returnVal = mode == 1 ? this.fileChooserShowOpenDialog() : this.fileChooserShowSaveDialog();
        if (returnVal == 0) {
            theFile = this.fileChooserGetSelectedFile();
        }
        return theFile;
    }

    public int fileChooserShowOpenDialog() {
        return this.getFileChooser().showOpenDialog(this.getMissConsole());
    }

    public int fileChooserShowSaveDialog() {
        return this.getFileChooser().showSaveDialog(this.getMissConsole());
    }

    public File fileChooserGetSelectedFile() {
        String path = this.fileChooserGetCurrentDir();
        PreferencesModel pm = this.getPreferencesModel();
        pm.setStringValue("Miss FileChooser Path", path);
        pm.saveToDisk();
        trace.out("FileChooserPath: " + path);
        return this.getFileChooser().getSelectedFile();
    }

    public String fileChooserGetCurrentDir() {
        return this.getFileChooser().getCurrentDirectory().getPath();
    }

    public void fileChooserSetCurrentDir(String dir) {
        this.getFileChooser().setCurrentDirectory(new File(dir));
    }

    public PreferencesModel getPreferencesModel() {
        return this.getBrController().getPreferencesModel();
    }

    public String getProjectDir() {
        String path = this.getBrController().getHomeDir();
        File file = Utils.getFileAsResource(path, this);
        return file.getAbsolutePath().replace('\\', '/');
    }

    public void pleNextProblem() {
        this.getSimStPLE().nextProblem();
    }

    public void pleQuizSimSt() {
        this.getSimStPLE().quizSimSt();
    }

    public void pleCurriculumBrowser() {
        this.getSimStPLE().showCurriculumBrowser();
    }

    public void pleExamplesSimSt() {
        this.getSimStPLE().examples();
    }

    public void pleUndoSimSt() {
        this.getSimStPLE().undo();
    }

    public void pleRestartProblemSimSt() {
        this.getSimStPLE().restartProblem();
    }

    void trace(String message) {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", message);
        }
    }

    public static void main(String[] args) {
        MissController controller = new MissController(new BR_Controller());
        controller.activate(true);
    }

    @Override
    public void setSsInteractiveLearning(boolean flag) {
        this.getSimSt().setIsInteractiveLearning(flag);
        this.getSimSt().setIsInteractiveLearningFlag(flag);
    }

    @Override
    public void setSsNonInteractiveLearning(boolean flag) {
        this.getSimSt().setIsNonInteractiveLearning(flag);
    }

    @Override
    public void setSsInteractiveLearningFlag(boolean flag) {
        this.getSimSt().setIsInteractiveLearningFlag(flag);
    }

    @Override
    public void setSsNonInteractiveLearningFlag(boolean flag) {
        this.getSimSt().setIsNonInteractiveLearningFlag(flag);
    }

    @Override
    public void setSsCacheOracleInquiry(boolean flag) {
        this.getSimSt().setSsCacheOracleInquiry(flag);
    }

    @Override
    public TutorWrapper createWrapper(boolean simStPleOnArg, boolean ssContestArg, TutorController controller) {
        TutorWrapper wrapper = null;
        wrapper = simStPleOnArg ? new SimStPLEWrapper((BR_Controller)controller) : new TutorWrapper(controller);
        if (ssContestArg) {
            wrapper = new GameShowWrapper((BR_Controller)controller);
        }
        return wrapper;
    }

    @Override
    public void requestEnterNewProblem() {
        this.getSimStPLE().requestEnterNewProblem();
    }

    @Override
    public void checkCompletedStartState() {
        this.getSimStPLE().checkCompletedStartState();
    }

    @Override
    public boolean isFoaGetterDefined() {
        return this.getSimSt().isFoaGetterDefined();
    }

    @Override
    public boolean isFoaSearch() {
        return this.getSimSt().isFoaSearch();
    }

    @Override
    public void setTitle(JFrame activeWindow) {
        this.getSimStPLE().setTitle(activeWindow);
    }

    private CTAT_Launcher getCtatLauncher() {
        if (this.ctatLauncher instanceof CTAT_Launcher) {
            return this.ctatLauncher;
        }
        if (Utils.isRuntime()) {
            return null;
        }
        try {
            throw new IllegalStateException("MissController.getServer() called with ctatLauncher " + this.ctatLauncher);
        }
        catch (Exception e) {
            trace.errStack("Programming error: " + e, e);
            return null;
        }
    }

    private String[] getArgvParameter(String[] argv, int keyIndex) {
        ArrayList<String> paramList = new ArrayList<String>();
        for (int i = keyIndex + 1; i < argv.length; ++i) {
            if (argv[i].length() < 1) continue;
            if (argv[i].charAt(0) == '-') break;
            paramList.add(argv[i]);
        }
        String[] getArgvParameter = null;
        if (!paramList.isEmpty()) {
            getArgvParameter = new String[paramList.size()];
            for (int i = 0; i < paramList.size(); ++i) {
                getArgvParameter[i] = (String)paramList.get(i);
            }
        }
        return getArgvParameter;
    }

    @Override
    public void parseArgv(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            String key;
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "argv[" + i + "] = " + argv[i]);
            }
            if ((key = argv[i]).length() < 1 || key.charAt(0) != '-') continue;
            try {
                String keyStem = key.substring(1);
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "keyStem=" + keyStem);
                }
                String[] parameter = this.getArgvParameter(argv, i);
                if (!keyStem.startsWith("ss")) continue;
                if (keyStem.equalsIgnoreCase("ssMetaTutorMode")) {
                    this.setSsMetaTutorMode(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssQuizProblemAbstractor")) {
                    this.setSsQuizProblemAbstractorClass(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssBatchMode")) {
                    this.setSsBatchMode(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssFixedLearningMode")) {
                    this.setSsFixedLearningMode(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssContest")) {
                    this.setSsContest(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssInteractiveLearning")) {
                    this.setSsInteractiveLearning(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssNonInteractiveLearning")) {
                    this.setSsNonInteractiveLearning(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssIlSignalNegative")) {
                    this.setSsIlSignalNegative(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssIlSignalPositive")) {
                    this.setSsIlSignalPositive(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssCondition")) {
                    this.setSsCondition(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssConstraintFile")) {
                    this.setSSConstraintFile(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssDecomposerFile")) {
                    this.setSSDecomposerFile(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssDecomposeInput")) {
                    this.ssUseDecomposition();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssDoNotSaveRules")) {
                    this.ssDoNotSaveRules();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssFeaturePredicateFile")) {
                    this.setSsFeaturePredicateFile(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssFoaGetterClass")) {
                    this.setSsFoaGetterClass(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssProblemAccessorClass")) {
                    this.setSsProlbemAssesorClass(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSelectionOrderGetterClass")) {
                    this.setSsSelectionOrderGetterClass(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssClSolverTutorSAIConverter")) {
                    this.setSsSaiConverterClass(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssInterfaceElementGetterClass")) {
                    this.setSsInterfaceElementGetterClass(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssFoaClickDisabled")) {
                    this.setSsFoaClickDisabled(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssInputCheckerClass")) {
                    this.setSsInputCheckerClass(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSkillNameGetterClass")) {
                    this.setSsSkillNameGetterClass(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssFoaSearch")) {
                    this.setSsFoaSearch(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssPathOrderingClass")) {
                    this.setSsPathOrderingClass(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssCacheOracleInquiry")) {
                    this.setSsCacheOracleInquiry(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssHeuristicBasedIDS")) {
                    this.setSsHeuristicBasedIDS(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssPreservePrFile")) {
                    this.setSsPreservePrFile(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssDeletePrFile")) {
                    this.setSsDeletePrFile(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssQuizGradingMethod")) {
                    this.setSsQuizGradingMethod(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssRuleActivationTestMethod")) {
                    this.setSsRuleActivationTestMethod(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssHintMethod")) {
                    this.setSsHintMethod(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssFoilLogDir")) {
                    this.setSsFoilLogDir(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssFoilMaxTuples")) {
                    this.setSsFoilMaxTuples(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ss2014FractionAdditionAdhoc")) {
                    this.setSs2014FractionAdditionAdhoc(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssForceToUpdateModel")) {
                    this.setSsForceToUpdateModel(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssInputMatcher")) {
                    this.setSsInputMatcher(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssTypeChecker")) {
                    this.setSsTypeChecker(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssValidSkillChecker")) {
                    this.setSsValidSkillChecker(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLearningLogFile")) {
                    this.setSsLearningLogFile(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLearnCorrectActions")) {
                    this.setSsLearnCorrectActions(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLearnCltErrorActions")) {
                    this.setSsLearnCltErrorActions(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLearnBuggyActions")) {
                    this.setSsLearnBuggyActions(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLearningRuleFiringLogged")) {
                    this.ssLearningRuleFiringLogged();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssMemoryWindowOverRules")) {
                    this.setSsMemoryWindowOverRules(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssNumBadInputRetries")) {
                    this.setSsNumBadInputRetries(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssNoOpCache")) {
                    this.setSsOpCached(false);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSetFpCacheCapacity")) {
                    this.setSsFpCacheCapacity(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssNumIteration")) {
                    this.setSsValidationNumIteration(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssMaxSearchDepth")) {
                    this.setSsMaxSearchDepth(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssOperatorFile")) {
                    this.setSsOperatorFile(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssProjectDir")) {
                    this.setSsProjectDir(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssPackageName")) {
                    this.setSsPackageName(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssValidationMethod")) {
                    this.setSsPrValidationMethod(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssModelTracingValidationOutcome")) {
                    this.setSsModelTracingValidationOutcome(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssPrAgeDir")) {
                    this.setSsPrAgeDir(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssProblemSet")) {
                    this.setSsValidationProblemSet(parameter);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssRunValidation")) {
                    this.setSsRunValidation(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssVerifyNumFoA")) {
                    this.setSsVerifyNumFoA(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssShuffleValidation")) {
                    this.setSsShuffleRunMode(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssTestSet")) {
                    this.setSsValidationTestSet(parameter);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssTestOutput")) {
                    this.setSsValidationOutput(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssUserDefSymbols")) {
                    this.setSsUserDefSymbols(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssPredictObservableActionName")) {
                    this.setSsPredictObservableActionName(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSetMemoryWindowSize")) {
                    this.setSsMemoryWindowSize(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSearchTimeOutDuration")) {
                    this.ssSearchTimeOutDuration(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssTutorServerTimeOutDuration")) {
                    this.ssTutorServerTimeOutDuration(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSetInactiveInterfaceTimeout")) {
                    this.ssInactiveInterfaceTimeOutDuration(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssNoAutoOrderFOA")) {
                    this.ssAutoOrderFOAOff();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLearnNoLabel")) {
                    if (trace.getDebugCode("ss")) {
                        trace.out("ss", "Setting ssLearnNoLabel in SingleSessionLauncher");
                    }
                    this.setSsLearnNoLabel();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLogAgendaRuleFiring")) {
                    this.ssLogAgendaRuleFiring();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLogPriorRuleActivationsOnTraining")) {
                    this.ssLogPriorRuleActivationsOnTraining();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssTestOnLastTrainingOnly")) {
                    this.ssTestOnLastTrainingOnly();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssCheckWilkinsburgBadBrd")) {
                    this.ssCheckWilkinsburgBadBrd();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSetMaxNumTraining")) {
                    this.ssSetMaxNumTraining(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSetMaxNumTest")) {
                    this.ssSetMaxNumTest(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSwitchLearningStrategyAfter")) {
                    this.ssSwitchLearningStrategyAfter(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssTestProductionModelNoTest")) {
                    this.ssSetTestProductionModelNoTest(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssAnalysisOfFitnessWilkinsburg")) {
                    this.ssAnalysisOfFitnessWilkinsburg();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLogStudentsLearning")) {
                    this.ssLogStudentsLearning();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssValidateStepsInBRD")) {
                    this.setSsValidateStepsInBRD();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssDontShowAllRaWhenTutored")) {
                    this.ssDontShowAllRaWhenTutored();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssClSolverTutorHost")) {
                    this.ssSetClSolverTutorHost(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssRunInPLE")) {
                    this.setSimStPleOn(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLogging")) {
                    this.setSimStLogging(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLocalLogging")) {
                    this.setSimStLocalLogging(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssDummyContest")) {
                    this.setSimStDummyContest(true);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssContestServer")) {
                    this.setSimStContestServer(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssContestPort")) {
                    this.setSimStContestPort(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssUserID")) {
                    this.setSimStUserId(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSimStName")) {
                    this.setSsSimStName(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSimStImage")) {
                    this.setSsSimStImage(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssProblemsPerQuizSection")) {
                    this.setSimStProblemsPerQuizSection(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLogURL")) {
                    this.setSimStLogURL(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssCLQuizReqMode")) {
                    this.setSsCLQuizReqMode();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssSelfExplainMode")) {
                    this.setSsSelfExplainMode();
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssIntroVideo")) {
                    this.setSsIntroVideo(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssLoadPrefsFile")) {
                    this.setSsPrefsFile(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssOverviewPage")) {
                    this.setSsOverview(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssActivationList")) {
                    this.setSsActivationList(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssTutalkParams")) {
                    this.setSsTutalkParams(parameter[0]);
                    continue;
                }
                if (keyStem.equalsIgnoreCase("ssGeneralWMEPaths")) {
                    this.setSsGeneralWmePaths();
                    continue;
                }
                throw new IllegalArgumentException("Unknown SimStudent command line argument: " + keyStem);
            }
            catch (IllegalArgumentException iae) {
                trace.err("Error on command line argument " + i + " '" + key + "': " + iae);
            }
        }
    }

    private void setSsValidationProblemSet(String[] problemSet) {
        this.ssValidationProblemSet = problemSet;
    }

    String[] getSsValidationProblemSet() {
        return this.ssValidationProblemSet;
    }

    private void setSsValidationTestSet(String[] testSet) {
        this.ssValidationTestSet = testSet;
    }

    public String[] getSsValidationTestSet() {
        return this.ssValidationTestSet;
    }

    private void setSsValidationOutput(String validationOutput) {
        this.ssValidationOutput = validationOutput;
    }

    public String getSsValidationOutput() {
        return this.ssValidationOutput;
    }

    private int getSsValidationNumIteration() {
        return this.ssValidationNumIteration;
    }

    private void setSsValidationNumIteration(String n) {
        this.ssValidationNumIteration = Integer.parseInt(n);
    }

    public boolean isSsBatchMode() {
        return this.ssBatchMode;
    }

    public boolean isSsFixedLearningMode() {
        return this.ssFixedLearningMode;
    }

    @Override
    public boolean isSsContest() {
        return this.ssContest;
    }

    private void setSsContest(boolean flag) {
        this.ssContest = flag;
    }

    private void ssDontShowAllRaWhenTutored() {
        this.getSimSt().setDontShowAllRA(true);
    }

    private void setSsIlSignalNegative(String flag) {
        this.getSimSt().setIlSignalNegative(new Boolean(flag));
    }

    private void setSsIlSignalPositive(String flag) {
        this.getSimSt().setIlSignalPositive(new Boolean(flag));
    }

    private void ssSetClSolverTutorHost(String clSolverTutorHost) {
        this.getSimSt().setClSolverTutorHost(clSolverTutorHost);
    }

    private boolean isSsShuffleRunMode() {
        return this.ssShuffleRunMode;
    }

    private void setSsShuffleRunMode(boolean flag) {
        this.ssShuffleRunMode = flag;
    }

    public boolean isSsRunValidation() {
        return this.ssRunValidation;
    }

    private void setSsRunValidation(boolean flag) {
        this.ssRunValidation = flag;
    }

    private void setSsInputMatcher(String inputMatcher) {
        this.getSimSt().setInputMatcher(inputMatcher);
    }

    private void setSsTypeChecker(String typeChecker) {
        this.getSimSt().setTypeChecker(typeChecker);
    }

    private void setSsValidSkillChecker(String validSkillChecker) {
        this.getSimSt().setSsValidSkillChecker(validSkillChecker);
    }

    private void ssLogAgendaRuleFiring() {
        this.getSimSt().setLogAgendaRuleFiring(true);
    }

    private void ssLogPriorRuleActivationsOnTraining() {
        this.getSimSt().setLogPriorRuleActivationsOnTraining(true);
    }

    private void ssLearningRuleFiringLogged() {
        this.getSimSt().setLearningRuleFiringLogged(true);
    }

    private void ssAnalysisOfFitnessWilkinsburg() {
        this.ssAnalysisOfFitnessWilkinsburg = true;
    }

    private void setSsValidateStepsInBRD() {
        this.ssValidateStepsInBRD = true;
    }

    private void runSsValidateStepsInBRD() {
        SimSt simSt = this.getSimSt();
        simSt.validateStepsInBRD(this.getSsValidationTestSet()[0], this.getSsValidationOutput());
    }

    private void ssLogStudentsLearning() {
        this.ssLogStudentsLearning = true;
    }

    private void ssCheckWilkinsburgBadBrd() {
        this.getSimSt().setCheckWilkinsburgBadBrdFile(true);
    }

    private void setSSDecomposerFile(String fileName) {
        this.getSimSt().setDecomposerFile(fileName);
    }

    private void setSSConstraintFile(String fileName) {
        this.getSimSt().setConstraintFile(fileName);
    }

    private void ssDoNotSaveRules() {
        this.getSimSt().setArchivingProductionRules(false);
    }

    private void ssSwitchLearningStrategyAfter(String num) {
        this.getSimSt().setSwitchLearningStrategy(true);
        this.getSimSt().setSwitchLearningStrategyAfter(Integer.parseInt(num));
    }

    private void ssSetMaxNumTest(String num) {
        this.getSimSt().setMaxNumTest(Integer.parseInt(num));
    }

    private void ssSetMaxNumTraining(String num) {
        this.getSimSt().setMaxNumTraining(Integer.parseInt(num));
    }

    private void setSsFpCacheCapacity(String num) {
        this.getSimSt().setFpCacheCapacty(Integer.parseInt(num));
    }

    private void ssSetTestProductionModelNoTest(boolean b) {
        this.getSimSt().setTestProductionModelNoTest(b);
    }

    private void ssTestOnLastTrainingOnly() {
        this.getSimSt().setTestOnLastTrainingOnly(true);
    }

    private void ssAutoOrderFOAOff() {
        this.getSimSt().setAutoOrderFOA(false);
    }

    private void setSsLearnNoLabel() {
        this.getSimSt().setSsLearnNoLabel(true);
    }

    public void runSimStValidationTest() {
        this.getSimSt().testProductionModelOn(this.getSsValidationTestSet(), this.getSsValidationOutput());
    }

    private void runSimStShuffleMode() {
        this.ssShuffleRunInBatch(this.getSsValidationProblemSet(), this.getSsValidationTestSet(), this.getSsValidationOutput(), this.getSsValidationNumIteration());
    }

    private void runSsAnalysisOfFitnessWilkinsburg() {
        SimSt simSt = this.getSimSt();
        simSt.analysisOfFitnessWilkinsburg(this.getSsValidationProblemSet()[0], this.getSsValidationOutput());
    }

    private void runSsLogStudentsLearning() {
        SimSt simSt = this.getSimSt();
        simSt.ssLogStudentsLearning(this.getSsValidationProblemSet()[0], this.getSsValidationOutput());
    }

    private void runSimStInBatchMode() {
        this.runSimStInBatchMode(this.getSsValidationProblemSet(), this.getSsValidationTestSet(), this.getSsValidationOutput());
    }

    private void setSsOpCached(boolean flag) {
        this.setOpCached(flag);
    }

    private void setSsProjectDir(String projectDir) {
        if (projectDir.startsWith("SimStAlgebra")) {
            projectDir = System.getProperty("user.home") + System.getProperty("file.separator") + "Public" + System.getProperty("file.separator") + projectDir;
            SimSt.setProjectDir(projectDir);
            this.setProjectDir(projectDir);
        } else {
            SimSt.setProjectDir(projectDir);
            this.setProjectDir(projectDir);
        }
    }

    private void setSsFoilLogDir(String foilLogDir) {
        this.setFoilLogDir(foilLogDir);
    }

    private void setSsFoilMaxTuples(String foilMaxTuples) {
        this.setFoilMaxTuples(foilMaxTuples);
    }

    private void setSsPrAgeDir(String prAgeDir) {
        this.setPrAgeDir(prAgeDir);
    }

    private void setSs2014FractionAdditionAdhoc(boolean flag) {
        if (this.getSimSt() != null) {
            this.getSimSt().setSs2014FractionAdditionAdhoc(flag);
        }
    }

    public void setSsNumBadInputRetries(String num) {
        this.setSsNumBadInputRetries(Integer.parseInt(num));
    }

    public void setSsPrefsFile(String filename) {
        File brPrefsFile = new File(new File(".").getAbsolutePath(), filename);
        if (brPrefsFile != null && brPrefsFile.exists() && brPrefsFile.isAbsolute()) {
            trace.out("miss", "Loading the prefs file locally:  " + filename);
            this.getBrController().getPreferencesModel().setPreferenceFile(filename);
            this.getBrController().getPreferencesModel().loadFromDisk();
        } else {
            WebStartFileDownloader finder = new WebStartFileDownloader();
            String file = finder.findFile(filename);
            trace.out("miss", "Loading the prefs file:  " + file);
            this.getBrController().getPreferencesModel().setPreferenceFile(file);
            this.getBrController().getPreferencesModel().loadFromDisk();
        }
    }

    public void setSsActivationList(String name) {
        SimSt.setActivationListType(name);
    }

    private void setSsTutalkParams(String flag) {
        this.setSsUseTutalk(flag);
    }

    public void setSsGeneralWmePaths() {
        this.getSimSt().setLearnGeneralWmePaths();
    }

    private void setSsMaxSearchDepth(String num) {
        this.setSsMaxSearchDepth(Integer.parseInt(num));
    }

    private void ssSearchTimeOutDuration(String longDuration) {
        this.setSsSearchTimeOutDuration(longDuration);
    }

    private void ssInactiveInterfaceTimeOutDuration(String longDuration) {
        this.setSsInactiveInterfaceTimeOutDuration(longDuration);
    }

    private void ssTutorServerTimeOutDuration(String longDuration) {
        this.setSsTutorServerTimeOutDuration(longDuration);
    }

    private void setSimStLogging(boolean flag) {
        this.setSsLogging(flag);
    }

    private void setSimStDummyContest(boolean flag) {
        this.setSsDummyContest(flag);
    }

    private void setSimStContestServer(String address) {
        this.setSsContestServer(address);
    }

    private void setSimStContestPort(String port) {
        this.setSsContestPort(Integer.parseInt(port));
    }

    private void setSimStLocalLogging(boolean flag) {
        this.setSsLocalLogging(flag);
    }

    private void setSsForceToUpdateModel(boolean flag) {
        this.setForceToUpdateModel(flag);
    }

    private void setSsCacheOracleInquiry(String flag) {
        this.setSsCacheOracleInquiry(!flag.equalsIgnoreCase("false"));
    }

    private void setSsPreservePrFile(boolean flag) {
        this.setClArgumentSetToProtectProdRules(flag);
    }

    private void setSsLearnCltErrorActions(String flag) {
        this.setSsLearnCltErrorActions(flag.equalsIgnoreCase("true"));
    }

    private void setSsLearnBuggyActions(String flag) {
        this.setSsLearnBuggyActions(flag.equalsIgnoreCase("true"));
    }

    private void setSsLearnCorrectActions(String flag) {
        this.setSsLearnCorrectActions(!flag.equalsIgnoreCase("false"));
    }

    private void setProjectDir(String pDir) {
    }

    public void setSimStProblemsPerQuizSection(String num) {
        this.setSimStProblemsPerQuizSection(Integer.parseInt(num));
    }

    private void setSimStPleOn(boolean flag) {
        this.simStPleOn = flag;
    }

    @Override
    public boolean isSimStPleOn() {
        return this.simStPleOn;
    }

    public void setSimStUserId(String userID) {
        this.setSsUserID(userID);
    }

    @Override
    public void runSimStNoTutorInterface() {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "runSimStNoTutorInterface...");
        }
        if (this.isSsRunValidation()) {
            this.getBrController().setModeSimStAndDestroyProdRules();
            this.runSimStValidationTest();
            System.exit(0);
        } else {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "ssBatchMode ON...");
            }
            this.getBrController().setModeSimStAndDestroyProdRules();
            this.runSimStInBatchMode();
            System.exit(0);
        }
    }
}

