/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.DoubleConst;
import edu.cmu.pact.miss.userDef.algebra.expression.ExpParseException;
import edu.cmu.pact.miss.userDef.algebra.expression.IntConst;
import edu.cmu.pact.miss.userDef.algebra.expression.Polynomial;
import edu.cmu.pact.miss.userDef.algebra.expression.SimpleTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Variable;

public class AlgExpParser {
    private static final int INTSTATE = 6;
    private static final int FLOATSTATE = 1;
    private static final int RIGHTPARENSTATE = 2;
    private static final int MULSTATE = 3;
    private static final int INITSTATE = 0;
    private static final int ADDSTATE = 4;
    private static final int DIVSTATE = 5;
    private static final int ERRORSTATE = -1;
    private static final int VARSTATE = 7;
    private static final int NEGSTATE = 8;
    private static final int LEFTPARENSTATE = 9;
    private static final int MULOPSTATE = 10;
    private static boolean debugFlag = false;

    public static String stateName(int i) {
        switch (i) {
            case -1: {
                return "ERRORSTATE";
            }
            case 0: {
                return "INITSTATE";
            }
            case 1: {
                return "FLOATSTATE";
            }
            case 2: {
                return "RIGHTPARENSTATE";
            }
            case 3: {
                return "MULSTATE";
            }
            case 4: {
                return "ADDSTATE";
            }
            case 5: {
                return "DIVSTATE";
            }
            case 6: {
                return "INTSTATE";
            }
            case 7: {
                return "VARSTATE";
            }
            case 8: {
                return "NEGSTATE";
            }
            case 9: {
                return "LEFTPARENSTATE";
            }
            case 10: {
                return "MULOPSTATE";
            }
        }
        return "OOPS_STATE";
    }

    public static int charCount(String s, char c) {
        char[] ca = s.toCharArray();
        int chCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (ca[i] != c) continue;
            ++chCount;
        }
        return chCount;
    }

    public static void debugPrintln(String s) {
        if (debugFlag) {
            System.out.println("(gustavo): " + s);
        }
    }

    public static boolean member(String s, String[] coll) {
        for (int i = 0; i < coll.length; ++i) {
            if (!s.equals(coll[i])) continue;
            return true;
        }
        return false;
    }

    public static String cancelDoubleMinus(String s) {
        String res = s.replaceAll("--", "+");
        if (res.charAt(0) == '+') {
            res = res.substring(1);
        }
        res = res.replaceAll("\\(\\+", "(");
        return res;
    }

    public static AlgExp parse(String s) throws ExpParseException {
        if (s.length() < 1 || s.substring(0, 1).equals("*") || s.substring(0, 1).equals("/")) {
            return null;
        }
        s = AlgExpParser.cancelDoubleMinus(s);
        if ((s = s.toLowerCase()).equals("-")) {
            return AlgExp.NEGONE;
        }
        char[] exp = s.toCharArray();
        int curState = 0;
        int leftLength = 0;
        int rightStart = 0;
        int rightLength = 0;
        int parenCount = 0;
        int stringStart = 0;
        int stringEnd = exp.length;
        int stringLength = exp.length;
        char lastOp = '+';
        boolean isPoly = false;
        boolean isComplex = false;
        boolean hasParens = false;
        if (AlgExpParser.IsSurroundedByParens(exp, stringStart, stringEnd - 1)) {
            ++stringStart;
            --stringEnd;
            stringLength -= 2;
            hasParens = true;
        }
        block7: for (int charIndex = stringStart; charIndex < stringEnd; ++charIndex) {
            int nextState;
            char curChar = exp[charIndex];
            if (curChar == '(') {
                ++parenCount;
            }
            if (curChar == ')') {
                --parenCount;
            }
            curState = nextState = AlgExpParser.transition(curState, curChar, parenCount);
            switch (nextState) {
                case -1: {
                    throw new ExpParseException(s + " " + curChar);
                }
                case 4: {
                    lastOp = '+';
                    isPoly = true;
                    isComplex = true;
                    if (curChar == '+') {
                        leftLength = charIndex - stringStart;
                        rightStart = charIndex + 1;
                        rightLength = stringLength - leftLength - 1;
                        continue block7;
                    }
                    leftLength = charIndex - stringStart;
                    rightStart = charIndex;
                    rightLength = stringLength - leftLength;
                    continue block7;
                }
                case 5: {
                    if (isPoly || parenCount != 0) continue block7;
                    lastOp = '/';
                    leftLength = charIndex - stringStart;
                    rightStart = charIndex + 1;
                    rightLength = stringLength - leftLength - 1;
                    isComplex = true;
                    continue block7;
                }
                case 3: {
                    isComplex = true;
                    if (!isPoly && parenCount == 1 && curChar == '(') {
                        lastOp = '*';
                        leftLength = charIndex - stringStart;
                        rightStart = charIndex;
                        rightLength = stringLength - leftLength;
                    }
                    if (!isPoly && parenCount == 0) {
                        lastOp = '*';
                        if (curChar == '*') {
                            leftLength = charIndex - stringStart;
                            rightStart = charIndex + 1;
                            rightLength = stringLength - leftLength - 1;
                        } else {
                            leftLength = charIndex - stringStart;
                            rightStart = charIndex;
                            rightLength = stringLength - leftLength;
                        }
                    }
                    if (curChar != '(') continue block7;
                    curState = 9;
                    continue block7;
                }
                case 10: {
                    AlgExpParser.debugPrintln("MULOPSTATE entered");
                    isComplex = true;
                    if (curChar == '(') {
                        curState = 9;
                    }
                    if (isPoly || parenCount != 0) continue block7;
                    lastOp = '*';
                    if (curChar == '*') {
                        leftLength = charIndex - stringStart;
                        rightStart = charIndex + 1;
                        rightLength = stringLength - leftLength - 1;
                        continue block7;
                    }
                    leftLength = charIndex - stringStart;
                    rightStart = charIndex;
                    rightLength = stringLength - leftLength;
                }
            }
        }
        if (parenCount != 0) {
            throw new ExpParseException(s);
        }
        if (isComplex) {
            String leftStr = new String(exp, stringStart, leftLength);
            String rightStr = new String(exp, rightStart, rightLength);
            AlgExpParser.debugPrintln("   [" + s + "] --> [" + leftStr + "|" + rightStr + "]    lastOp = '" + lastOp + "'");
            AlgExp leftOperand = AlgExpParser.parse(leftStr);
            AlgExp rightOperand = AlgExpParser.parse(rightStr);
            return AlgExpParser.makeExp(lastOp, leftOperand, rightOperand, hasParens);
        }
        if (curState == 6) {
            return new IntConst(Integer.parseInt(s.substring(stringStart, stringEnd)));
        }
        if (curState == 1) {
            return new DoubleConst(Double.parseDouble(s.substring(stringStart, stringEnd)));
        }
        if (curState == 7) {
            return new Variable(s.substring(stringStart, stringEnd));
        }
        throw new ExpParseException(s);
    }

    private static int transition(int startState, char c, int parenCount) {
        switch (startState) {
            case 0: {
                if (c >= '0' && c <= '9') {
                    return 6;
                }
                if (c >= 'a' && c <= 'z') {
                    return 7;
                }
                if (c == '-') {
                    return 8;
                }
                if (c == '.') {
                    return 1;
                }
                if (c == '(') {
                    return 9;
                }
            }
            case 9: {
                if (c == ')' && parenCount == 0) {
                    return 2;
                }
                return 9;
            }
            case 6: {
                if (c >= '0' && c <= '9') {
                    return 6;
                }
                if (c >= 'a' && c <= 'z') {
                    return 3;
                }
                if (c == '(') {
                    return 3;
                }
                if (c == '-') {
                    return 4;
                }
                if (c == '.') {
                    return 1;
                }
                if (c == ')') {
                    return 2;
                }
                if (c == '+') {
                    return 4;
                }
                if (c == '/') {
                    return 5;
                }
                if (c == '*') {
                    return 10;
                }
                return -1;
            }
            case 1: {
                if (c >= '0' && c <= '9') {
                    return 1;
                }
                if (c >= 'a' && c <= 'z') {
                    return 3;
                }
                if (c == '(') {
                    return 3;
                }
                if (c == '-') {
                    return 4;
                }
                if (c == '+') {
                    return 4;
                }
                if (c == '/') {
                    return 5;
                }
                if (c == ')') {
                    return 2;
                }
                if (c == '*') {
                    return 10;
                }
                return -1;
            }
            case 8: {
                if (c >= '0' && c <= '9') {
                    return 6;
                }
                if (c >= 'a' && c <= 'z') {
                    return 3;
                }
                if (c == '(') {
                    return 3;
                }
                if (c == '.') {
                    return 1;
                }
                return -1;
            }
            case 7: {
                if (c >= '0' && c <= '9') {
                    return 3;
                }
                if (c >= 'a' && c <= 'z') {
                    return 3;
                }
                if (c == '(') {
                    return 3;
                }
                if (c == '-') {
                    return 4;
                }
                if (c == ')') {
                    return 2;
                }
                if (c == '+') {
                    return 4;
                }
                if (c == '/') {
                    return 5;
                }
                if (c == '*') {
                    return 10;
                }
                return -1;
            }
            case 2: {
                if (c >= '0' && c <= '9') {
                    return 3;
                }
                if (c >= 'a' && c <= 'z') {
                    return 3;
                }
                if (c == '(') {
                    return 3;
                }
                if (c == '-') {
                    return 4;
                }
                if (c == ')') {
                    return 2;
                }
                if (c == '+') {
                    return 4;
                }
                if (c == '/') {
                    return 5;
                }
                if (c == '*') {
                    return 10;
                }
                return -1;
            }
            case 4: {
                if (c >= '0' && c <= '9') {
                    return 6;
                }
                if (c >= 'a' && c <= 'z') {
                    return 7;
                }
                if (c == '.') {
                    return 1;
                }
                if (c == '(') {
                    return 9;
                }
                if (c == '-') {
                    return 6;
                }
                if (c == '/') {
                    return 5;
                }
            }
            case 5: {
                if (c >= '0' && c <= '9') {
                    return 6;
                }
                if (c >= 'a' && c <= 'z') {
                    return 7;
                }
                if (c == '.') {
                    return 1;
                }
                if (c == '(') {
                    return 9;
                }
                if (c == '-') {
                    return 8;
                }
                if (c == '+') {
                    return 4;
                }
                if (c == '/') {
                    return 5;
                }
            }
            case 3: {
                if (c >= '0' && c <= '9') {
                    return 6;
                }
                if (c >= 'a' && c <= 'z') {
                    return 3;
                }
                if (c == '.') {
                    return 1;
                }
                if (c == '(') {
                    return 9;
                }
                if (c == '-') {
                    return 4;
                }
                if (c == '+') {
                    return 4;
                }
                if (c == '/') {
                    return 5;
                }
                if (c == '*') {
                    return 10;
                }
                return -1;
            }
            case 10: {
                if (c >= '0' && c <= '9') {
                    return 6;
                }
                if (c >= 'a' && c <= 'z') {
                    return 7;
                }
                if (c == '.') {
                    return 1;
                }
                if (c == '(') {
                    return 9;
                }
                if (c != '-') break;
                return 8;
            }
        }
        return -1;
    }

    private static boolean IsSurroundedByParens(char[] exp, int startIndex, int endIndex) {
        if (exp.length == 0 || exp[startIndex] != '(' || exp[endIndex] != ')') {
            return false;
        }
        int parenCount = 1;
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            if (exp[i] == '(') {
                ++parenCount;
            }
            if (exp[i] == ')') {
                --parenCount;
            }
            if (parenCount != 0 || i == endIndex) continue;
            return false;
        }
        return true;
    }

    private static AlgExp makeExp(char lastOp, AlgExp leftOperand, AlgExp rightOperand, boolean hasParens) throws ExpParseException {
        switch (lastOp) {
            case '+': {
                Polynomial result = new Polynomial(leftOperand, rightOperand);
                result.setParenBit(hasParens);
                return result;
            }
            case '*': {
                if (leftOperand.isConstant() && rightOperand.isVariable()) {
                    SimpleTerm result = new SimpleTerm(leftOperand, rightOperand);
                    result.setParenBit(hasParens);
                    return result;
                }
                if (leftOperand.isVariable() && rightOperand.isConstant()) {
                    SimpleTerm result = new SimpleTerm(rightOperand, leftOperand);
                    result.setParenBit(hasParens);
                    return result;
                }
                ComplexTerm result = new ComplexTerm(leftOperand, rightOperand);
                result.setParenBit(hasParens);
                return result;
            }
            case '/': {
                if (leftOperand.isConstant() && rightOperand.isConstant()) {
                    ConstantFraction result = new ConstantFraction(leftOperand, rightOperand);
                    result.setParenBit(hasParens);
                    return result;
                }
                if (leftOperand instanceof SimpleTerm && !leftOperand.hasParens() && rightOperand.isConstant()) {
                    SimpleTerm t = (SimpleTerm)leftOperand;
                    SimpleTerm result = new SimpleTerm(new ConstantFraction((AlgExp)t.getConstant(), rightOperand), t.getVariable());
                    result.setParenBit(hasParens);
                    return result;
                }
                ComplexFraction result = new ComplexFraction(leftOperand, rightOperand);
                result.setParenBit(hasParens);
                return result;
            }
        }
        throw new ExpParseException(String.valueOf(lastOp));
    }
}

