/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.Polynomial;
import edu.cmu.pact.miss.userDef.algebra.expression.SimpleTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Variable;
import java.util.HashSet;
import java.util.Set;

public abstract class Constant
extends AlgExp {
    protected double value;

    public abstract double getVal();

    public Constant() {
        this.isSimple = true;
        this.isConstant = true;
        this.isMonomial = true;
    }

    @Override
    public AlgExp div(Variable v) {
        return this.mul(v.invert());
    }

    @Override
    public AlgExp div(ConstantFraction f) {
        return this.mul(f.invert());
    }

    @Override
    public AlgExp div(SimpleTerm t) {
        AlgExp coefficient = this.div(t.getConstant());
        return coefficient.mul(t.getVariable().invert());
    }

    @Override
    public AlgExp div(Polynomial e) {
        return this.mul(e.invert());
    }

    @Override
    public AlgExp div(ComplexTerm ct) {
        return this.mul(ct.invert());
    }

    @Override
    public AlgExp div(ComplexFraction cf) {
        return this.mul(cf.invert());
    }

    @Override
    public AlgExp add(Variable v) {
        return v.add(this);
    }

    @Override
    public AlgExp add(ConstantFraction f) {
        return f.add(this);
    }

    @Override
    public AlgExp add(SimpleTerm t) {
        return t.add(this);
    }

    @Override
    public AlgExp add(Polynomial e) {
        return e.add(this);
    }

    @Override
    public AlgExp add(ComplexTerm ct) {
        return ct.add(this);
    }

    @Override
    public AlgExp add(ComplexFraction cf) {
        return cf.add(this);
    }

    @Override
    public AlgExp mul(Variable v) {
        return v.mul(this);
    }

    @Override
    public AlgExp mul(ConstantFraction f) {
        return f.mul(this);
    }

    @Override
    public AlgExp mul(SimpleTerm t) {
        return t.mul(this);
    }

    @Override
    public AlgExp mul(Polynomial e) {
        return e.mul(this);
    }

    @Override
    public AlgExp mul(ComplexTerm ct) {
        return ct.mul(this);
    }

    @Override
    public AlgExp mul(ComplexFraction cf) {
        return cf.mul(this);
    }

    @Override
    public AlgExp invert() {
        return new ConstantFraction(AlgExp.ONE, (AlgExp)this);
    }

    @Override
    public boolean equals(ConstantFraction f) {
        return f.equals(this);
    }

    @Override
    public boolean equals(SimpleTerm t) {
        return t.equals(this);
    }

    @Override
    public boolean equals(Polynomial e) {
        return e.equals(this);
    }

    @Override
    public boolean equals(ComplexTerm ct) {
        return ct.equals(this);
    }

    @Override
    public boolean equals(ComplexFraction cf) {
        return cf.equals(this);
    }

    @Override
    public boolean equals(Variable v) {
        return false;
    }

    @Override
    public boolean hasVariable(String varName) {
        return false;
    }

    @Override
    public Set getAllVars() {
        return new HashSet();
    }
}

