/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.weak;

import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ExpParseException;
import java.util.Vector;

public class NumOpNum
extends EqFeaturePredicate {
    public NumOpNum() {
        this.setArity(1);
        this.setName("num-op-num");
        this.setReturnValueType(1);
        this.setArgValueType(new int[]{1});
    }

    @Override
    public String apply(Vector args) {
        String expString = (String)args.get(0);
        if (expString == null) {
            return null;
        }
        if (!NumOpNum.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (!exp.isSimple()) {
                for (int x = 0; x < expString.length(); ++x) {
                    if (!Character.isDigit(expString.charAt(x))) continue;
                    boolean operatorFound = false;
                    boolean term2Found = false;
                    String number = "";
                    number = number + expString.charAt(x);
                    while (this.isValidChar(expString, x + 1)) {
                        number = number + expString.charAt(++x);
                    }
                    int i = x + 1;
                    if (this.isValidOperator(expString, i)) {
                        number = number + expString.charAt(i);
                        operatorFound = true;
                    }
                    while (this.isValidChar(expString, i + 1)) {
                        number = number + expString.charAt(++i);
                        term2Found = true;
                    }
                    if (!operatorFound || !term2Found) continue;
                    return number;
                }
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isValidChar(String exp, int index) {
        if (index >= exp.length()) {
            return false;
        }
        return Character.isDigit(exp.charAt(index));
    }

    private boolean isValidOperator(String exp, int index) {
        if (index >= exp.length()) {
            return false;
        }
        if (exp.charAt(index) == '+') {
            return true;
        }
        return exp.charAt(index) == '-';
    }
}

