/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.oldpredicates;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.userDef.oldpredicates.AlgebraExpPoly;
import edu.cmu.pact.miss.userDef.oldpredicates.AlgebraExpTerm;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;
import mylib.MathLib;

public abstract class AlgebraExp {
    protected boolean containsDecimals;
    private String op;
    private AlgebraExp firstTerm;
    private AlgebraExp secondTerm;
    private String exp = null;
    private static final String OPEN_P = "OPEN_P";
    private static final String PARSE_POLYNOMIAL = "PARSE_POLYNOMIAL";

    public abstract boolean isTerm();

    public abstract boolean isPolynomial();

    public abstract boolean isValidPolynomial();

    String getOp() {
        return this.op;
    }

    void setOp(String op) {
        this.op = op;
    }

    AlgebraExp getFirstTerm() {
        return this.firstTerm;
    }

    void setFirstTerm(AlgebraExp firstTerm) {
        this.firstTerm = firstTerm;
    }

    AlgebraExp getSecondTerm() {
        return this.secondTerm;
    }

    void setSecondTerm(AlgebraExp secondTerm) {
        this.secondTerm = secondTerm;
    }

    String getExp() {
        return this.exp;
    }

    void setExp(String exp) {
        this.exp = exp;
    }

    abstract String getVarName();

    boolean isSimpleTerm() {
        return this.isTerm() && !this.isParenQuanity();
    }

    boolean isSimpleFraction() {
        return this.isFraction() && this.getNumerator().isSimpleTerm() && this.getDenominator().isSimpleTerm();
    }

    abstract String getCoefficient();

    public boolean isDecimal() {
        return this.containsDecimals;
    }

    public Vector getAllVars() {
        Vector<String> variables = new Vector<String>();
        if (this.isConstTerm()) {
            return null;
        }
        if (this.isTerm()) {
            variables.add(this.getVarName());
        } else {
            String upperCaseExp = this.firstTerm.toString().toUpperCase() + this.op + this.secondTerm.toString().toUpperCase();
            for (int charIndex = 0; charIndex < upperCaseExp.length(); ++charIndex) {
                char curChar = upperCaseExp.charAt(charIndex);
                if ('A' > curChar || 'Z' < curChar) continue;
                variables.add(String.valueOf(curChar));
            }
        }
        return variables;
    }

    public Vector getTerms() {
        Vector<String> terms = new Vector<String>();
        if (this.isTerm()) {
            terms.add(this.toString());
            return terms;
        }
        terms.addAll(this.firstTerm.getTerms());
        if (this.secondTerm != null) {
            terms.addAll(this.secondTerm.getTerms());
        }
        return terms;
    }

    public int countUnboundConstants() {
        int firstTermValue = 0;
        int secondTermValue = 0;
        if (this.isConstTerm()) {
            if (this.secondTerm == null) {
                return 1;
            }
            if (this.isFraction()) {
                return 1;
            }
        } else if (this.isTerm()) {
            return 0;
        }
        if (!this.firstTerm.isParenQuanity()) {
            firstTermValue = this.firstTerm.countUnboundConstants();
        }
        if (!this.secondTerm.isParenQuanity()) {
            secondTermValue = this.secondTerm.countUnboundConstants();
        }
        return firstTermValue + secondTermValue;
    }

    public AlgebraExp getFactor() {
        int gcd2;
        if (this.isDecimal()) {
            return null;
        }
        if (this.isSimpleTerm()) {
            if (this.isVarTerm()) {
                try {
                    return AlgebraExp.parseExp(this.getCoefficient());
                }
                catch (ParseException e) {
                    return null;
                }
            }
            return this;
        }
        if (this.firstTerm.isSimpleTerm() && this.secondTerm.isSimpleTerm()) {
            int const2;
            int const1 = this.firstTerm.isVarTerm() ? Integer.parseInt(this.firstTerm.getCoefficient().toString()) : Integer.parseInt(this.firstTerm.toString());
            int gcd = MathLib.gcd((int)const1, (int)(const2 = this.secondTerm.isVarTerm() ? Integer.parseInt(this.secondTerm.getCoefficient().toString()) : Integer.parseInt(this.secondTerm.toString())));
            if (gcd == 1) {
                return null;
            }
            try {
                return AlgebraExp.parseExp(String.valueOf(gcd));
            }
            catch (ParseException e) {
                return null;
            }
        }
        AlgebraExp factorOne = this.firstTerm.getFactor();
        if (factorOne == null) {
            return null;
        }
        AlgebraExp factorTwo = this.secondTerm.getFactor();
        if (factorTwo == null) {
            return null;
        }
        int gcd1 = Integer.parseInt(factorOne.toString());
        int gcd = MathLib.gcd((int)gcd1, (int)(gcd2 = Integer.parseInt(factorTwo.toString())));
        if (gcd == 1) {
            return null;
        }
        try {
            return AlgebraExp.parseExp(String.valueOf(gcd));
        }
        catch (ParseException e) {
            return null;
        }
    }

    String getCoefficient_obsolete() {
        String coefficient = null;
        if (this.isTerm()) {
            coefficient = this.getVarName().equals("") ? this.getExp() : this.getExp().substring(0, this.getExp().length() - 1);
            if (coefficient.equals("")) {
                coefficient = "1";
            } else if (coefficient.equals("-")) {
                coefficient = "-1";
            }
        }
        return coefficient;
    }

    public static AlgebraExp parseExp(String exp) throws ParseException {
        Stack<String> parseState = new Stack<String>();
        int i = 0;
        char c = ' ';
        String lastOp = null;
        int lastOpIndex = -1;
        while (i < exp.length()) {
            if ((c = (char)exp.charAt(i++)) == '(') {
                parseState.push(OPEN_P);
                continue;
            }
            if (c == ')') {
                if (!AlgebraExp.isParseStateAt(parseState, OPEN_P)) {
                    throw new ParseException(exp, i);
                }
                parseState.pop();
                continue;
            }
            if (c == '*' || c == '/') {
                if (AlgebraExp.isParseStateAt(parseState, OPEN_P)) continue;
                lastOp = String.valueOf(c);
                lastOpIndex = i - 1;
                continue;
            }
            if (c != '+' && c != 45 || !parseState.empty() || i <= 1) continue;
            parseState.push(PARSE_POLYNOMIAL);
            break;
        }
        if (AlgebraExp.isParseStateAt(parseState, PARSE_POLYNOMIAL)) {
            AlgebraExp secondTerm = c == '+' ? AlgebraExp.parseExp(exp.substring(i)) : AlgebraExp.parseExp(exp.substring(i - 1));
            return new AlgebraExpPoly("+", AlgebraExp.parseExp(exp.substring(0, i - 1)), secondTerm);
        }
        if (i == exp.length()) {
            if (lastOp != null) {
                String firstTerm = exp.substring(0, lastOpIndex);
                String secondTerm = exp.substring(lastOpIndex + 1);
                AlgebraExpPoly expPoly = new AlgebraExpPoly(lastOp, AlgebraExp.parseExp(firstTerm), AlgebraExp.parseExp(secondTerm));
                return expPoly;
            }
            if (AlgebraExp.isSurroundedByParenthesis(exp)) {
                return AlgebraExp.parseExp(exp.substring(1, exp.length() - 1));
            }
            return new AlgebraExpTerm(exp);
        }
        return null;
    }

    private static boolean isParseStateAt(Stack stack, String state) {
        return !stack.empty() && stack.peek().equals(state);
    }

    private static boolean isSurroundedByParenthesis(String exp) {
        return !exp.equals("") && exp.charAt(0) == '(' && exp.charAt(exp.length() - 1) == ')';
    }

    abstract boolean equals(AlgebraExp var1);

    public boolean comesBefore(AlgebraExp exp) {
        boolean comesBefore = false;
        if (this.isTerm()) {
            if (exp.isTerm()) {
                String v1 = this.getVarName();
                String v2 = exp.getVarName();
                if (v2 == null) {
                    // empty if block
                }
                comesBefore = v1.equals("") ? v2.equals("") : (v2 != null && !v2.equals("") ? v1.compareToIgnoreCase(v2) < 0 : true);
            } else {
                comesBefore = true;
            }
        } else if (exp.isTerm() && !exp.isVarTerm()) {
            comesBefore = true;
        }
        return comesBefore;
    }

    public boolean isSameType(AlgebraExp term) {
        String v1 = this.getVarName();
        String v2 = term.getVarName();
        return v1.equals(v2);
    }

    abstract boolean isConstTerm();

    abstract boolean isVarTerm();

    abstract boolean isZero();

    public abstract AlgebraExp evalArithmetic();

    public abstract AlgebraExp addTerm(AlgebraExp var1);

    public abstract AlgebraExp multTerm(AlgebraExp var1);

    public abstract AlgebraExp divTerm(AlgebraExp var1);

    public AlgebraExp evalArithmeticAdd(AlgebraExp t1, AlgebraExp t2) {
        AlgebraExp newTerm = null;
        if (t1.toString().equals("0")) {
            newTerm = t2;
        } else if (t2.toString().equals("0")) {
            newTerm = t1;
        } else if (t1.isSimpleTerm() && t2.isSimpleTerm() && t1.isSameType(t2)) {
            newTerm = t1.addTerm(t2);
        } else {
            if (t1.isSimpleFraction() && t2.isSimpleFraction()) {
                return t1.addTerm(t2);
            }
            newTerm = t1.comesBefore(t2) ? new AlgebraExpPoly("+", t1, t2) : new AlgebraExpPoly("+", t2, t1);
        }
        return newTerm;
    }

    public AlgebraExp Invert() {
        if (this.isZero()) {
            return null;
        }
        try {
            return AlgebraExp.parseExp("1/" + this);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public AlgebraExp evalArithmeticMult(AlgebraExp t1, AlgebraExp t2) {
        AlgebraExp newTerm = null;
        newTerm = t1.isTerm() ? t2.multTerm(t1) : (t2.isTerm() ? t1.multTerm(t2) : (t1.comesBefore(t2) ? new AlgebraExpPoly("*", t1, t2) : new AlgebraExpPoly("*", t2, t1)));
        return newTerm;
    }

    public AlgebraExp evalArithmeticDiv(AlgebraExp t1, AlgebraExp t2) {
        AlgebraExp newTerm = null;
        newTerm = t2.isTerm() && !t2.isZero() ? t1.divTerm(t2) : new AlgebraExpPoly("/", t1, t2);
        return newTerm;
    }

    AlgebraExp removeFirstVarTerm() {
        AlgebraExp firstVarTerm = this.getFirstVarTerm();
        return firstVarTerm != null ? this.removeTerm(firstVarTerm) : null;
    }

    AlgebraExp removeLastConstTerm() {
        AlgebraExp lastConstTerm = this.getLastConstTerm();
        return lastConstTerm != null ? this.removeTerm(lastConstTerm) : null;
    }

    AlgebraExp removeLastTerm() {
        AlgebraExp lastTerm = this.getLastTerm();
        return lastTerm != null ? this.removeTerm(lastTerm) : null;
    }

    AlgebraExp removeTerm(AlgebraExp term) {
        if (this.isPolynomial() && this.getOp().equals("+")) {
            if (this.getFirstTerm().equals(term)) {
                return this.getSecondTerm();
            }
            AlgebraExp term2 = this.getSecondTerm().removeTerm(term);
            return term2 != null ? new AlgebraExpPoly("+", this.getFirstTerm(), term2) : this.getFirstTerm();
        }
        return this.equals(term) ? null : this;
    }

    AlgebraExp inverseTerm() {
        AlgebraExpTerm termOne = new AlgebraExpTerm("1");
        return termOne.divTerm(this);
    }

    AlgebraExp replaceTerm(AlgebraExp oldTerm, AlgebraExp newTerm) {
        if (newTerm == null) {
            return this;
        }
        if (this == oldTerm) {
            return newTerm;
        }
        if (this.getFirstTerm() == oldTerm) {
            if (this.getOp().equals("+") && newTerm.isZero()) {
                return this.getSecondTerm();
            }
            return new AlgebraExpPoly(this.getOp(), newTerm, this.getSecondTerm());
        }
        AlgebraExp new2 = this.getSecondTerm().replaceTerm(oldTerm, newTerm);
        if (this.getOp() == null || new2 == null) {
            trace.out("missalgebra", "AlgebraExp.replaceTerm(" + oldTerm + "," + newTerm + ")");
            trace.out("missalgebra", "NullPointerException on " + this);
            return null;
        }
        if (this.getOp().equals("+") && new2.isZero()) {
            return this.getFirstTerm();
        }
        return new AlgebraExpPoly(this.getOp(), this.getFirstTerm(), new2);
    }

    AlgebraExp lookupSameTypeTerm(String op, AlgebraExp term) {
        if (this.isTerm()) {
            return this.isSameType(term) ? this : null;
        }
        if (this.getFirstTerm().isSameType(term)) {
            return this.getFirstTerm();
        }
        if (this.getOp().equals(op) && this.getSecondTerm() != null) {
            return this.getSecondTerm().lookupSameTypeTerm(op, term);
        }
        return null;
    }

    AlgebraExp getLastTerm() {
        if (this.isPolynomial() && this.getOp().equals("+")) {
            AlgebraExp lastTerm = this.getSecondTerm().getLastTerm();
            return lastTerm != null ? lastTerm : this.getSecondTerm();
        }
        return null;
    }

    AlgebraExp getLastConstTerm() {
        return this.getLastConstTerm(null);
    }

    AlgebraExp getLastConstTerm(AlgebraExp term) {
        if (this.isPolynomial() && this.getOp().equals("+")) {
            return this.getFirstTerm().isConstTerm() ? this.getSecondTerm().getLastConstTerm(this.getFirstTerm()) : this.getSecondTerm().getLastConstTerm(term);
        }
        return this.isTerm() && this.isConstTerm() ? this : term;
    }

    AlgebraExp getFirstVarTerm() {
        if (this.isAddition()) {
            return this.getFirstTerm().isVarTerm() ? this.getFirstTerm() : this.getSecondTerm().getFirstVarTerm();
        }
        if (this.isTerm()) {
            return this.isVarTerm() ? this : null;
        }
        return null;
    }

    public boolean hasUncombindedVariables() {
        Vector variables;
        if (this.isTerm()) {
            return false;
        }
        boolean firstTermParens = this.firstTerm.isParenQuanity();
        boolean secondTermParens = this.secondTerm.isParenQuanity();
        if (!firstTermParens && !secondTermParens) {
            Vector variables2 = this.getAllVars();
            if (variables2 == null) {
                return false;
            }
            return AlgebraExp.hasDuplicates(variables2);
        }
        boolean firstTermValue = firstTermParens ? false : ((variables = this.firstTerm.getAllVars()) == null ? false : AlgebraExp.hasDuplicates(variables));
        boolean secondTermValue = secondTermParens ? false : ((variables = this.secondTerm.getAllVars()) == null ? false : AlgebraExp.hasDuplicates(variables));
        return firstTermValue || secondTermValue;
    }

    public static boolean hasDuplicates(Vector v) {
        HashSet s = new HashSet();
        for (int vectorIndex = 0; vectorIndex < v.size(); ++vectorIndex) {
            if (s.add(v.get(vectorIndex))) continue;
            return true;
        }
        return false;
    }

    public boolean isParenQuanity() {
        return this.toString().matches("([0-9]|-)+([.][0-9]+)?[*]?[(].*[)]");
    }

    public boolean isFraction() {
        String op = this.getOp();
        return op != null && op.equals("/");
    }

    AlgebraExp getNumerator() {
        return this.getFirstTerm();
    }

    AlgebraExp getDenominator() {
        return this.getSecondTerm();
    }

    public boolean isAddition() {
        String op = this.getOp();
        return op != null && op.equals("+");
    }

    public boolean isMultiplication() {
        String op = this.getOp();
        return op != null && op.equals("*");
    }

    public String parseTree() {
        trace.out("missalgebra", "AlgebraExp.parseTree() called...");
        return null;
    }
}

