/*
 * Decompiled with CFR 0.152.
 */
package org.tiling.scheduling.examples.iterators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.tiling.scheduling.ScheduleIterator;

public class CompositeIterator
implements ScheduleIterator {
    private List orderedTimes = new ArrayList();
    private List orderedIterators = new ArrayList();

    public CompositeIterator(ScheduleIterator[] scheduleIterators) {
        for (int i = 0; i < scheduleIterators.length; ++i) {
            this.insert(scheduleIterators[i]);
        }
    }

    private void insert(ScheduleIterator scheduleIterator) {
        Date time = scheduleIterator.next();
        if (time == null) {
            return;
        }
        int index = Collections.binarySearch(this.orderedTimes, time);
        if (index < 0) {
            index = -index - 1;
        }
        this.orderedTimes.add(index, time);
        this.orderedIterators.add(index, scheduleIterator);
    }

    @Override
    public synchronized Date next() {
        Date next = null;
        while (!this.orderedTimes.isEmpty() && (next == null || next.equals((Date)this.orderedTimes.get(0)))) {
            next = (Date)this.orderedTimes.remove(0);
            this.insert((ScheduleIterator)this.orderedIterators.remove(0));
        }
        return next;
    }
}

