/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets.InputMethodFramework;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import pact.CommWidgets.InputMethodFramework.CompositeIterator;
import pact.CommWidgets.InputMethodFramework.LWTextComponent;

public class ActiveClient
extends LWTextComponent
implements InputMethodListener,
InputMethodRequests {
    private AttributedString composedTextString = null;
    private AttributedCharacterIterator composedText = null;
    private TextHitInfo caret = null;
    private static final AttributedCharacterIterator.Attribute[] IM_ATTRIBUTES = new AttributedCharacterIterator.Attribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT};
    private static final AttributedCharacterIterator EMPTY_TEXT = new AttributedString("").getIterator();

    public ActiveClient(String name) {
        super(name, true);
        this.enableInputMethods(true);
        this.addInputMethodListener(this);
    }

    public ActiveClient(int height, int width) {
        super(height, width, true);
        this.enableInputMethods(true);
        this.addInputMethodListener(this);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this;
    }

    @Override
    public void setFontSize(int size) {
        super.setFontSize(size);
        if (this.composedTextString != null) {
            this.composedTextString.addAttribute(TextAttribute.FONT, this.getFont());
        }
    }

    @Override
    public AttributedCharacterIterator getDisplayText() {
        if (this.composedText == null) {
            return super.getDisplayText();
        }
        return new CompositeIterator(super.getDisplayText(), this.composedText);
    }

    @Override
    public TextHitInfo getCaret() {
        if (this.composedText == null) {
            return super.getCaret();
        }
        if (this.caret == null) {
            return null;
        }
        return this.caret.getOffsetHit(this.getCommittedTextLength());
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        int committedCharacterCount = event.getCommittedCharacterCount();
        AttributedCharacterIterator text = event.getText();
        this.composedText = null;
        if (text != null) {
            int toCopy = committedCharacterCount;
            char c = text.first();
            while (toCopy-- > 0) {
                this.insertCharacter(c);
                c = text.next();
            }
            if (text.getEndIndex() - (text.getBeginIndex() + committedCharacterCount) > 0) {
                this.composedTextString = new AttributedString(text, text.getBeginIndex() + committedCharacterCount, text.getEndIndex(), IM_ATTRIBUTES);
                this.composedTextString.addAttribute(TextAttribute.FONT, this.getFont());
                this.composedText = this.composedTextString.getIterator();
            }
        }
        event.consume();
        this.invalidateTextLayout();
        this.caret = event.getCaret();
        this.repaint();
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        this.caret = event.getCaret();
        event.consume();
        this.repaint();
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        Rectangle rectangle;
        if (offset == null) {
            rectangle = this.getCaretRectangle();
        } else {
            TextHitInfo globalOffset = offset.getOffsetHit(this.getCommittedTextLength());
            rectangle = this.getCaretRectangle(globalOffset);
        }
        Point location = this.getLocationOnScreen();
        rectangle.translate(location.x, location.y);
        return rectangle;
    }

    @Override
    public TextHitInfo getLocationOffset(int x, int y) {
        Point location = this.getLocationOnScreen();
        Point textOrigin = this.getTextOrigin();
        TextLayout textLayout = this.getTextLayout();
        if (textLayout != null && textLayout.getBounds().contains(x -= location.x + textOrigin.x, y -= location.y + textOrigin.y)) {
            return textLayout.hitTestChar(x, y).getOffsetHit(-this.getCommittedTextLength());
        }
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        return this.getCommittedTextLength();
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        return this.getCommittedText(beginIndex, endIndex);
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return EMPTY_TEXT;
    }
}

